/*
 * Copyright (C) 2014 Sony Computer Entertainment Inc.
 */

#ifndef CanvasBuffer_h
#define CanvasBuffer_h

#include <WebCore/OpenGLManx.h>
#include <canvas.h>

namespace WebKit {

class CanvasBuffer {
public:
    CanvasBuffer();
    ~CanvasBuffer();

    void initialize(int width, int height);
    void terminate();

    void activateAsFrameBuffer();
    void activateAsCanvas(sce::Canvas::Id);

    int width() const { return m_width; }
    int height() const { return m_height; }

    void rotateBuffers();

private:
    int m_width;
    int m_height;
    GLuint m_fbo;

    static const int NumBuffers = 2;
    struct {
        GLuint tex;
        void* reg;
    } m_buffers[NumBuffers];
    int m_currentBufferIndex;
};

}

#endif // CanvasBuffer_h
