/*
 * Copyright (C) 2014 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SigreTexture_h
#define SigreTexture_h

#if USE(ACCELERATED_COMPOSITING) && USE(ACAGI)

#include "IntRect.h"
#include <tilebackend/tilebackend.h>
#include <wtf/PassRefPtr.h>
#include <wtf/ThreadSafeRefCounted.h>

namespace WebCore {

class SigreTexture : public ThreadSafeRefCounted<SigreTexture> {
public:
    typedef tilebackend::Texture Texture;
    typedef tilebackend::PoolInterface Allocator;

    static PassRefPtr<SigreTexture> create(Allocator*, IntSize textureSize);
    static PassRefPtr<SigreTexture> duplicate(PassRefPtr<SigreTexture>);
    ~SigreTexture();

    bool isValid() const { return m_texture.buffer; }
    IntSize textureSize() const { return IntSize(m_texture.width, m_texture.height); }
    Texture texture() const { return m_texture; }

    void updateContents(const void* srcData, const IntRect& targetRect, const IntPoint& sourceOffset, int bytesPerLine);
private:
    explicit SigreTexture(Allocator*, IntSize textureSize);

    Allocator* m_allocator;
    Texture m_texture;
};

}

#endif // USE(ACCELERATED_COMPOSITING) && USE(ACAGI)

#endif
