/*
    Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies)
    Copyright (C) 2014 Sony Computer Entertainment Inc.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef PlatformLayerAcagi_h
#define PlatformLayerAcagi_h

#include "AcagiCompositor.h"
#include "TransformationMatrix.h"

namespace WebCore {

class PlatformLayerAcagi {
public:
    class Client {
    public:
        virtual ~Client() { }
        virtual void setPlatformLayerNeedsDisplay() = 0;
    };

    PlatformLayerAcagi() : m_client(0) { }
    virtual ~PlatformLayerAcagi() { }
    virtual void compositeContents(AcagiCompositor*, const FloatRect&, const TransformationMatrix& modelViewMatrix = TransformationMatrix(), float opacity = 1.0) = 0;
    virtual void swapBuffers() { }
    virtual void drawBorder(AcagiCompositor* compositor, const Color& color, float borderWidth, const FloatRect& targetRect, const TransformationMatrix& transform)
    {
        compositor->drawBorder(color, borderWidth, targetRect, transform);
    }
    void setClient(PlatformLayerAcagi::Client* client)
    {
        m_client = client;
    }

protected:
    PlatformLayerAcagi::Client* client() { return m_client; }

private:
    PlatformLayerAcagi::Client* m_client;
};

};

#endif // PlatformLayerAcagi_h
