/*
 * Copyright (C) 2013 Sony Computer Entertainment Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "config.h"
#include "ResourceRequest.h"

#include <curl/curl.h>
#include <manx/NetworkProfile.h>

namespace WebCore {

unsigned initializeMaximumHTTPConnectionCountPerHost()
{
#if LIBCURL_VERSION_NUM >= 0x071E00 // After libcurl 7.30.0
    // libcurl can control all requests from WebCore.
    // So the limitation is not necessary.
    return 10000;
#else
    return Manx::NetworkProfile::get(Manx::NetPropsMaximumHTTPConnectionCountPerHost);
#endif
}

}
