description(

"This test checks the behavior of the ToInt32 and ToUInt32 conversions defined in the ecma spec." +"\n"
 + "This tests the following permutations of values:" +"\n"
   + "CONVERT(SIGN * VALUE * 2^EXP)" +"\n"
 + "where:" +"\n"
   + "CONVERT = ToInt32|ToUInt32 (using either '>> 0' or '>> 0')" +"\n"
   + "SIGN = 1|-1" +"\n"
   + "VALUE = 1|3|5|0x40000001|0x80000001|0x100000001|0x7FFFFFFF|0xFFFFFFFF|0x1FFFFFFFF|0x10000000100001" +"\n"
   + "(-55 >= EXP >= 33)" +"\n"
 + "Also test the special value +/-0, +/-Inf, and NaN (also testig signed NaN)" +"\n"
);

shouldBe("2.7755575615628914e-17 >> 0", "0");
shouldBe("-2.7755575615628914e-17 >> 0", "0");
shouldBe("2.7755575615628914e-17 >>> 0", "0");
shouldBe("-2.7755575615628914e-17 >>> 0", "0");
shouldBe("5.551115123125783e-17 >> 0", "0");
shouldBe("-5.551115123125783e-17 >> 0", "0");
shouldBe("5.551115123125783e-17 >>> 0", "0");
shouldBe("-5.551115123125783e-17 >>> 0", "0");
shouldBe("1.1102230246251565e-16 >> 0", "0");
shouldBe("-1.1102230246251565e-16 >> 0", "0");
shouldBe("1.1102230246251565e-16 >>> 0", "0");
shouldBe("-1.1102230246251565e-16 >>> 0", "0");
shouldBe("2.220446049250313e-16 >> 0", "0");
shouldBe("-2.220446049250313e-16 >> 0", "0");
shouldBe("2.220446049250313e-16 >>> 0", "0");
shouldBe("-2.220446049250313e-16 >>> 0", "0");
shouldBe("4.440892098500626e-16 >> 0", "0");
shouldBe("-4.440892098500626e-16 >> 0", "0");
shouldBe("4.440892098500626e-16 >>> 0", "0");
shouldBe("-4.440892098500626e-16 >>> 0", "0");
shouldBe("8.881784197001252e-16 >> 0", "0");
shouldBe("-8.881784197001252e-16 >> 0", "0");
shouldBe("8.881784197001252e-16 >>> 0", "0");
shouldBe("-8.881784197001252e-16 >>> 0", "0");
shouldBe("1.7763568394002505e-15 >> 0", "0");
shouldBe("-1.7763568394002505e-15 >> 0", "0");
shouldBe("1.7763568394002505e-15 >>> 0", "0");
shouldBe("-1.7763568394002505e-15 >>> 0", "0");
shouldBe("3.552713678800501e-15 >> 0", "0");
shouldBe("-3.552713678800501e-15 >> 0", "0");
shouldBe("3.552713678800501e-15 >>> 0", "0");
shouldBe("-3.552713678800501e-15 >>> 0", "0");
shouldBe("7.105427357601002e-15 >> 0", "0");
shouldBe("-7.105427357601002e-15 >> 0", "0");
shouldBe("7.105427357601002e-15 >>> 0", "0");
shouldBe("-7.105427357601002e-15 >>> 0", "0");
shouldBe("1.4210854715202004e-14 >> 0", "0");
shouldBe("-1.4210854715202004e-14 >> 0", "0");
shouldBe("1.4210854715202004e-14 >>> 0", "0");
shouldBe("-1.4210854715202004e-14 >>> 0", "0");
shouldBe("2.842170943040401e-14 >> 0", "0");
shouldBe("-2.842170943040401e-14 >> 0", "0");
shouldBe("2.842170943040401e-14 >>> 0", "0");
shouldBe("-2.842170943040401e-14 >>> 0", "0");
shouldBe("5.684341886080802e-14 >> 0", "0");
shouldBe("-5.684341886080802e-14 >> 0", "0");
shouldBe("5.684341886080802e-14 >>> 0", "0");
shouldBe("-5.684341886080802e-14 >>> 0", "0");
shouldBe("1.1368683772161603e-13 >> 0", "0");
shouldBe("-1.1368683772161603e-13 >> 0", "0");
shouldBe("1.1368683772161603e-13 >>> 0", "0");
shouldBe("-1.1368683772161603e-13 >>> 0", "0");
shouldBe("2.2737367544323206e-13 >> 0", "0");
shouldBe("-2.2737367544323206e-13 >> 0", "0");
shouldBe("2.2737367544323206e-13 >>> 0", "0");
shouldBe("-2.2737367544323206e-13 >>> 0", "0");
shouldBe("4.547473508864641e-13 >> 0", "0");
shouldBe("-4.547473508864641e-13 >> 0", "0");
shouldBe("4.547473508864641e-13 >>> 0", "0");
shouldBe("-4.547473508864641e-13 >>> 0", "0");
shouldBe("9.094947017729282e-13 >> 0", "0");
shouldBe("-9.094947017729282e-13 >> 0", "0");
shouldBe("9.094947017729282e-13 >>> 0", "0");
shouldBe("-9.094947017729282e-13 >>> 0", "0");
shouldBe("1.8189894035458565e-12 >> 0", "0");
shouldBe("-1.8189894035458565e-12 >> 0", "0");
shouldBe("1.8189894035458565e-12 >>> 0", "0");
shouldBe("-1.8189894035458565e-12 >>> 0", "0");
shouldBe("3.637978807091713e-12 >> 0", "0");
shouldBe("-3.637978807091713e-12 >> 0", "0");
shouldBe("3.637978807091713e-12 >>> 0", "0");
shouldBe("-3.637978807091713e-12 >>> 0", "0");
shouldBe("7.275957614183426e-12 >> 0", "0");
shouldBe("-7.275957614183426e-12 >> 0", "0");
shouldBe("7.275957614183426e-12 >>> 0", "0");
shouldBe("-7.275957614183426e-12 >>> 0", "0");
shouldBe("1.4551915228366852e-11 >> 0", "0");
shouldBe("-1.4551915228366852e-11 >> 0", "0");
shouldBe("1.4551915228366852e-11 >>> 0", "0");
shouldBe("-1.4551915228366852e-11 >>> 0", "0");
shouldBe("2.9103830456733704e-11 >> 0", "0");
shouldBe("-2.9103830456733704e-11 >> 0", "0");
shouldBe("2.9103830456733704e-11 >>> 0", "0");
shouldBe("-2.9103830456733704e-11 >>> 0", "0");
shouldBe("5.820766091346741e-11 >> 0", "0");
shouldBe("-5.820766091346741e-11 >> 0", "0");
shouldBe("5.820766091346741e-11 >>> 0", "0");
shouldBe("-5.820766091346741e-11 >>> 0", "0");
shouldBe("1.1641532182693481e-10 >> 0", "0");
shouldBe("-1.1641532182693481e-10 >> 0", "0");
shouldBe("1.1641532182693481e-10 >>> 0", "0");
shouldBe("-1.1641532182693481e-10 >>> 0", "0");
shouldBe("2.3283064365386963e-10 >> 0", "0");
shouldBe("-2.3283064365386963e-10 >> 0", "0");
shouldBe("2.3283064365386963e-10 >>> 0", "0");
shouldBe("-2.3283064365386963e-10 >>> 0", "0");
shouldBe("4.656612873077393e-10 >> 0", "0");
shouldBe("-4.656612873077393e-10 >> 0", "0");
shouldBe("4.656612873077393e-10 >>> 0", "0");
shouldBe("-4.656612873077393e-10 >>> 0", "0");
shouldBe("9.313225746154785e-10 >> 0", "0");
shouldBe("-9.313225746154785e-10 >> 0", "0");
shouldBe("9.313225746154785e-10 >>> 0", "0");
shouldBe("-9.313225746154785e-10 >>> 0", "0");
shouldBe("1.862645149230957e-9 >> 0", "0");
shouldBe("-1.862645149230957e-9 >> 0", "0");
shouldBe("1.862645149230957e-9 >>> 0", "0");
shouldBe("-1.862645149230957e-9 >>> 0", "0");
shouldBe("3.725290298461914e-9 >> 0", "0");
shouldBe("-3.725290298461914e-9 >> 0", "0");
shouldBe("3.725290298461914e-9 >>> 0", "0");
shouldBe("-3.725290298461914e-9 >>> 0", "0");
shouldBe("7.450580596923828e-9 >> 0", "0");
shouldBe("-7.450580596923828e-9 >> 0", "0");
shouldBe("7.450580596923828e-9 >>> 0", "0");
shouldBe("-7.450580596923828e-9 >>> 0", "0");
shouldBe("1.4901161193847656e-8 >> 0", "0");
shouldBe("-1.4901161193847656e-8 >> 0", "0");
shouldBe("1.4901161193847656e-8 >>> 0", "0");
shouldBe("-1.4901161193847656e-8 >>> 0", "0");
shouldBe("2.9802322387695313e-8 >> 0", "0");
shouldBe("-2.9802322387695313e-8 >> 0", "0");
shouldBe("2.9802322387695313e-8 >>> 0", "0");
shouldBe("-2.9802322387695313e-8 >>> 0", "0");
shouldBe("5.960464477539063e-8 >> 0", "0");
shouldBe("-5.960464477539063e-8 >> 0", "0");
shouldBe("5.960464477539063e-8 >>> 0", "0");
shouldBe("-5.960464477539063e-8 >>> 0", "0");
shouldBe("1.1920928955078125e-7 >> 0", "0");
shouldBe("-1.1920928955078125e-7 >> 0", "0");
shouldBe("1.1920928955078125e-7 >>> 0", "0");
shouldBe("-1.1920928955078125e-7 >>> 0", "0");
shouldBe("2.384185791015625e-7 >> 0", "0");
shouldBe("-2.384185791015625e-7 >> 0", "0");
shouldBe("2.384185791015625e-7 >>> 0", "0");
shouldBe("-2.384185791015625e-7 >>> 0", "0");
shouldBe("4.76837158203125e-7 >> 0", "0");
shouldBe("-4.76837158203125e-7 >> 0", "0");
shouldBe("4.76837158203125e-7 >>> 0", "0");
shouldBe("-4.76837158203125e-7 >>> 0", "0");
shouldBe("9.5367431640625e-7 >> 0", "0");
shouldBe("-9.5367431640625e-7 >> 0", "0");
shouldBe("9.5367431640625e-7 >>> 0", "0");
shouldBe("-9.5367431640625e-7 >>> 0", "0");
shouldBe("0.0000019073486328125 >> 0", "0");
shouldBe("-0.0000019073486328125 >> 0", "0");
shouldBe("0.0000019073486328125 >>> 0", "0");
shouldBe("-0.0000019073486328125 >>> 0", "0");
shouldBe("0.000003814697265625 >> 0", "0");
shouldBe("-0.000003814697265625 >> 0", "0");
shouldBe("0.000003814697265625 >>> 0", "0");
shouldBe("-0.000003814697265625 >>> 0", "0");
shouldBe("0.00000762939453125 >> 0", "0");
shouldBe("-0.00000762939453125 >> 0", "0");
shouldBe("0.00000762939453125 >>> 0", "0");
shouldBe("-0.00000762939453125 >>> 0", "0");
shouldBe("0.0000152587890625 >> 0", "0");
shouldBe("-0.0000152587890625 >> 0", "0");
shouldBe("0.0000152587890625 >>> 0", "0");
shouldBe("-0.0000152587890625 >>> 0", "0");
shouldBe("0.000030517578125 >> 0", "0");
shouldBe("-0.000030517578125 >> 0", "0");
shouldBe("0.000030517578125 >>> 0", "0");
shouldBe("-0.000030517578125 >>> 0", "0");
shouldBe("0.00006103515625 >> 0", "0");
shouldBe("-0.00006103515625 >> 0", "0");
shouldBe("0.00006103515625 >>> 0", "0");
shouldBe("-0.00006103515625 >>> 0", "0");
shouldBe("0.0001220703125 >> 0", "0");
shouldBe("-0.0001220703125 >> 0", "0");
shouldBe("0.0001220703125 >>> 0", "0");
shouldBe("-0.0001220703125 >>> 0", "0");
shouldBe("0.000244140625 >> 0", "0");
shouldBe("-0.000244140625 >> 0", "0");
shouldBe("0.000244140625 >>> 0", "0");
shouldBe("-0.000244140625 >>> 0", "0");
shouldBe("0.00048828125 >> 0", "0");
shouldBe("-0.00048828125 >> 0", "0");
shouldBe("0.00048828125 >>> 0", "0");
shouldBe("-0.00048828125 >>> 0", "0");
shouldBe("0.0009765625 >> 0", "0");
shouldBe("-0.0009765625 >> 0", "0");
shouldBe("0.0009765625 >>> 0", "0");
shouldBe("-0.0009765625 >>> 0", "0");
shouldBe("0.001953125 >> 0", "0");
shouldBe("-0.001953125 >> 0", "0");
shouldBe("0.001953125 >>> 0", "0");
shouldBe("-0.001953125 >>> 0", "0");
shouldBe("0.00390625 >> 0", "0");
shouldBe("-0.00390625 >> 0", "0");
shouldBe("0.00390625 >>> 0", "0");
shouldBe("-0.00390625 >>> 0", "0");
shouldBe("0.0078125 >> 0", "0");
shouldBe("-0.0078125 >> 0", "0");
shouldBe("0.0078125 >>> 0", "0");
shouldBe("-0.0078125 >>> 0", "0");
shouldBe("0.015625 >> 0", "0");
shouldBe("-0.015625 >> 0", "0");
shouldBe("0.015625 >>> 0", "0");
shouldBe("-0.015625 >>> 0", "0");
shouldBe("0.03125 >> 0", "0");
shouldBe("-0.03125 >> 0", "0");
shouldBe("0.03125 >>> 0", "0");
shouldBe("-0.03125 >>> 0", "0");
shouldBe("0.0625 >> 0", "0");
shouldBe("-0.0625 >> 0", "0");
shouldBe("0.0625 >>> 0", "0");
shouldBe("-0.0625 >>> 0", "0");
shouldBe("0.125 >> 0", "0");
shouldBe("-0.125 >> 0", "0");
shouldBe("0.125 >>> 0", "0");
shouldBe("-0.125 >>> 0", "0");
shouldBe("0.25 >> 0", "0");
shouldBe("-0.25 >> 0", "0");
shouldBe("0.25 >>> 0", "0");
shouldBe("-0.25 >>> 0", "0");
shouldBe("0.5 >> 0", "0");
shouldBe("-0.5 >> 0", "0");
shouldBe("0.5 >>> 0", "0");
shouldBe("-0.5 >>> 0", "0");
shouldBe("1 >> 0", "1");
shouldBe("-1 >> 0", "-1");
shouldBe("1 >>> 0", "1");
shouldBe("-1 >>> 0", "4294967295");
shouldBe("2 >> 0", "2");
shouldBe("-2 >> 0", "-2");
shouldBe("2 >>> 0", "2");
shouldBe("-2 >>> 0", "4294967294");
shouldBe("4 >> 0", "4");
shouldBe("-4 >> 0", "-4");
shouldBe("4 >>> 0", "4");
shouldBe("-4 >>> 0", "4294967292");
shouldBe("8 >> 0", "8");
shouldBe("-8 >> 0", "-8");
shouldBe("8 >>> 0", "8");
shouldBe("-8 >>> 0", "4294967288");
shouldBe("16 >> 0", "16");
shouldBe("-16 >> 0", "-16");
shouldBe("16 >>> 0", "16");
shouldBe("-16 >>> 0", "4294967280");
shouldBe("32 >> 0", "32");
shouldBe("-32 >> 0", "-32");
shouldBe("32 >>> 0", "32");
shouldBe("-32 >>> 0", "4294967264");
shouldBe("64 >> 0", "64");
shouldBe("-64 >> 0", "-64");
shouldBe("64 >>> 0", "64");
shouldBe("-64 >>> 0", "4294967232");
shouldBe("128 >> 0", "128");
shouldBe("-128 >> 0", "-128");
shouldBe("128 >>> 0", "128");
shouldBe("-128 >>> 0", "4294967168");
shouldBe("256 >> 0", "256");
shouldBe("-256 >> 0", "-256");
shouldBe("256 >>> 0", "256");
shouldBe("-256 >>> 0", "4294967040");
shouldBe("512 >> 0", "512");
shouldBe("-512 >> 0", "-512");
shouldBe("512 >>> 0", "512");
shouldBe("-512 >>> 0", "4294966784");
shouldBe("1024 >> 0", "1024");
shouldBe("-1024 >> 0", "-1024");
shouldBe("1024 >>> 0", "1024");
shouldBe("-1024 >>> 0", "4294966272");
shouldBe("2048 >> 0", "2048");
shouldBe("-2048 >> 0", "-2048");
shouldBe("2048 >>> 0", "2048");
shouldBe("-2048 >>> 0", "4294965248");
shouldBe("4096 >> 0", "4096");
shouldBe("-4096 >> 0", "-4096");
shouldBe("4096 >>> 0", "4096");
shouldBe("-4096 >>> 0", "4294963200");
shouldBe("8192 >> 0", "8192");
shouldBe("-8192 >> 0", "-8192");
shouldBe("8192 >>> 0", "8192");
shouldBe("-8192 >>> 0", "4294959104");
shouldBe("16384 >> 0", "16384");
shouldBe("-16384 >> 0", "-16384");
shouldBe("16384 >>> 0", "16384");
shouldBe("-16384 >>> 0", "4294950912");
shouldBe("32768 >> 0", "32768");
shouldBe("-32768 >> 0", "-32768");
shouldBe("32768 >>> 0", "32768");
shouldBe("-32768 >>> 0", "4294934528");
shouldBe("65536 >> 0", "65536");
shouldBe("-65536 >> 0", "-65536");
shouldBe("65536 >>> 0", "65536");
shouldBe("-65536 >>> 0", "4294901760");
shouldBe("131072 >> 0", "131072");
shouldBe("-131072 >> 0", "-131072");
shouldBe("131072 >>> 0", "131072");
shouldBe("-131072 >>> 0", "4294836224");
shouldBe("262144 >> 0", "262144");
shouldBe("-262144 >> 0", "-262144");
shouldBe("262144 >>> 0", "262144");
shouldBe("-262144 >>> 0", "4294705152");
shouldBe("524288 >> 0", "524288");
shouldBe("-524288 >> 0", "-524288");
shouldBe("524288 >>> 0", "524288");
shouldBe("-524288 >>> 0", "4294443008");
shouldBe("1048576 >> 0", "1048576");
shouldBe("-1048576 >> 0", "-1048576");
shouldBe("1048576 >>> 0", "1048576");
shouldBe("-1048576 >>> 0", "4293918720");
shouldBe("2097152 >> 0", "2097152");
shouldBe("-2097152 >> 0", "-2097152");
shouldBe("2097152 >>> 0", "2097152");
shouldBe("-2097152 >>> 0", "4292870144");
shouldBe("4194304 >> 0", "4194304");
shouldBe("-4194304 >> 0", "-4194304");
shouldBe("4194304 >>> 0", "4194304");
shouldBe("-4194304 >>> 0", "4290772992");
shouldBe("8388608 >> 0", "8388608");
shouldBe("-8388608 >> 0", "-8388608");
shouldBe("8388608 >>> 0", "8388608");
shouldBe("-8388608 >>> 0", "4286578688");
shouldBe("16777216 >> 0", "16777216");
shouldBe("-16777216 >> 0", "-16777216");
shouldBe("16777216 >>> 0", "16777216");
shouldBe("-16777216 >>> 0", "4278190080");
shouldBe("33554432 >> 0", "33554432");
shouldBe("-33554432 >> 0", "-33554432");
shouldBe("33554432 >>> 0", "33554432");
shouldBe("-33554432 >>> 0", "4261412864");
shouldBe("67108864 >> 0", "67108864");
shouldBe("-67108864 >> 0", "-67108864");
shouldBe("67108864 >>> 0", "67108864");
shouldBe("-67108864 >>> 0", "4227858432");
shouldBe("134217728 >> 0", "134217728");
shouldBe("-134217728 >> 0", "-134217728");
shouldBe("134217728 >>> 0", "134217728");
shouldBe("-134217728 >>> 0", "4160749568");
shouldBe("268435456 >> 0", "268435456");
shouldBe("-268435456 >> 0", "-268435456");
shouldBe("268435456 >>> 0", "268435456");
shouldBe("-268435456 >>> 0", "4026531840");
shouldBe("536870912 >> 0", "536870912");
shouldBe("-536870912 >> 0", "-536870912");
shouldBe("536870912 >>> 0", "536870912");
shouldBe("-536870912 >>> 0", "3758096384");
shouldBe("1073741824 >> 0", "1073741824");
shouldBe("-1073741824 >> 0", "-1073741824");
shouldBe("1073741824 >>> 0", "1073741824");
shouldBe("-1073741824 >>> 0", "3221225472");
shouldBe("2147483648 >> 0", "-2147483648");
shouldBe("-2147483648 >> 0", "-2147483648");
shouldBe("2147483648 >>> 0", "2147483648");
shouldBe("-2147483648 >>> 0", "2147483648");
shouldBe("4294967296 >> 0", "0");
shouldBe("-4294967296 >> 0", "0");
shouldBe("4294967296 >>> 0", "0");
shouldBe("-4294967296 >>> 0", "0");
shouldBe("8.326672684688674e-17 >> 0", "0");
shouldBe("-8.326672684688674e-17 >> 0", "0");
shouldBe("8.326672684688674e-17 >>> 0", "0");
shouldBe("-8.326672684688674e-17 >>> 0", "0");
shouldBe("1.6653345369377348e-16 >> 0", "0");
shouldBe("-1.6653345369377348e-16 >> 0", "0");
shouldBe("1.6653345369377348e-16 >>> 0", "0");
shouldBe("-1.6653345369377348e-16 >>> 0", "0");
shouldBe("3.3306690738754696e-16 >> 0", "0");
shouldBe("-3.3306690738754696e-16 >> 0", "0");
shouldBe("3.3306690738754696e-16 >>> 0", "0");
shouldBe("-3.3306690738754696e-16 >>> 0", "0");
shouldBe("6.661338147750939e-16 >> 0", "0");
shouldBe("-6.661338147750939e-16 >> 0", "0");
shouldBe("6.661338147750939e-16 >>> 0", "0");
shouldBe("-6.661338147750939e-16 >>> 0", "0");
shouldBe("1.3322676295501878e-15 >> 0", "0");
shouldBe("-1.3322676295501878e-15 >> 0", "0");
shouldBe("1.3322676295501878e-15 >>> 0", "0");
shouldBe("-1.3322676295501878e-15 >>> 0", "0");
shouldBe("2.6645352591003757e-15 >> 0", "0");
shouldBe("-2.6645352591003757e-15 >> 0", "0");
shouldBe("2.6645352591003757e-15 >>> 0", "0");
shouldBe("-2.6645352591003757e-15 >>> 0", "0");
shouldBe("5.329070518200751e-15 >> 0", "0");
shouldBe("-5.329070518200751e-15 >> 0", "0");
shouldBe("5.329070518200751e-15 >>> 0", "0");
shouldBe("-5.329070518200751e-15 >>> 0", "0");
shouldBe("1.0658141036401503e-14 >> 0", "0");
shouldBe("-1.0658141036401503e-14 >> 0", "0");
shouldBe("1.0658141036401503e-14 >>> 0", "0");
shouldBe("-1.0658141036401503e-14 >>> 0", "0");
shouldBe("2.1316282072803006e-14 >> 0", "0");
shouldBe("-2.1316282072803006e-14 >> 0", "0");
shouldBe("2.1316282072803006e-14 >>> 0", "0");
shouldBe("-2.1316282072803006e-14 >>> 0", "0");
shouldBe("4.263256414560601e-14 >> 0", "0");
shouldBe("-4.263256414560601e-14 >> 0", "0");
shouldBe("4.263256414560601e-14 >>> 0", "0");
shouldBe("-4.263256414560601e-14 >>> 0", "0");
shouldBe("8.526512829121202e-14 >> 0", "0");
shouldBe("-8.526512829121202e-14 >> 0", "0");
shouldBe("8.526512829121202e-14 >>> 0", "0");
shouldBe("-8.526512829121202e-14 >>> 0", "0");
shouldBe("1.7053025658242404e-13 >> 0", "0");
shouldBe("-1.7053025658242404e-13 >> 0", "0");
shouldBe("1.7053025658242404e-13 >>> 0", "0");
shouldBe("-1.7053025658242404e-13 >>> 0", "0");
shouldBe("3.410605131648481e-13 >> 0", "0");
shouldBe("-3.410605131648481e-13 >> 0", "0");
shouldBe("3.410605131648481e-13 >>> 0", "0");
shouldBe("-3.410605131648481e-13 >>> 0", "0");
shouldBe("6.821210263296962e-13 >> 0", "0");
shouldBe("-6.821210263296962e-13 >> 0", "0");
shouldBe("6.821210263296962e-13 >>> 0", "0");
shouldBe("-6.821210263296962e-13 >>> 0", "0");
shouldBe("1.3642420526593924e-12 >> 0", "0");
shouldBe("-1.3642420526593924e-12 >> 0", "0");
shouldBe("1.3642420526593924e-12 >>> 0", "0");
shouldBe("-1.3642420526593924e-12 >>> 0", "0");
shouldBe("2.7284841053187847e-12 >> 0", "0");
shouldBe("-2.7284841053187847e-12 >> 0", "0");
shouldBe("2.7284841053187847e-12 >>> 0", "0");
shouldBe("-2.7284841053187847e-12 >>> 0", "0");
shouldBe("5.4569682106375694e-12 >> 0", "0");
shouldBe("-5.4569682106375694e-12 >> 0", "0");
shouldBe("5.4569682106375694e-12 >>> 0", "0");
shouldBe("-5.4569682106375694e-12 >>> 0", "0");
shouldBe("1.0913936421275139e-11 >> 0", "0");
shouldBe("-1.0913936421275139e-11 >> 0", "0");
shouldBe("1.0913936421275139e-11 >>> 0", "0");
shouldBe("-1.0913936421275139e-11 >>> 0", "0");
shouldBe("2.1827872842550278e-11 >> 0", "0");
shouldBe("-2.1827872842550278e-11 >> 0", "0");
shouldBe("2.1827872842550278e-11 >>> 0", "0");
shouldBe("-2.1827872842550278e-11 >>> 0", "0");
shouldBe("4.3655745685100555e-11 >> 0", "0");
shouldBe("-4.3655745685100555e-11 >> 0", "0");
shouldBe("4.3655745685100555e-11 >>> 0", "0");
shouldBe("-4.3655745685100555e-11 >>> 0", "0");
shouldBe("8.731149137020111e-11 >> 0", "0");
shouldBe("-8.731149137020111e-11 >> 0", "0");
shouldBe("8.731149137020111e-11 >>> 0", "0");
shouldBe("-8.731149137020111e-11 >>> 0", "0");
shouldBe("1.7462298274040222e-10 >> 0", "0");
shouldBe("-1.7462298274040222e-10 >> 0", "0");
shouldBe("1.7462298274040222e-10 >>> 0", "0");
shouldBe("-1.7462298274040222e-10 >>> 0", "0");
shouldBe("3.4924596548080444e-10 >> 0", "0");
shouldBe("-3.4924596548080444e-10 >> 0", "0");
shouldBe("3.4924596548080444e-10 >>> 0", "0");
shouldBe("-3.4924596548080444e-10 >>> 0", "0");
shouldBe("6.984919309616089e-10 >> 0", "0");
shouldBe("-6.984919309616089e-10 >> 0", "0");
shouldBe("6.984919309616089e-10 >>> 0", "0");
shouldBe("-6.984919309616089e-10 >>> 0", "0");
shouldBe("1.3969838619232178e-9 >> 0", "0");
shouldBe("-1.3969838619232178e-9 >> 0", "0");
shouldBe("1.3969838619232178e-9 >>> 0", "0");
shouldBe("-1.3969838619232178e-9 >>> 0", "0");
shouldBe("2.7939677238464355e-9 >> 0", "0");
shouldBe("-2.7939677238464355e-9 >> 0", "0");
shouldBe("2.7939677238464355e-9 >>> 0", "0");
shouldBe("-2.7939677238464355e-9 >>> 0", "0");
shouldBe("5.587935447692871e-9 >> 0", "0");
shouldBe("-5.587935447692871e-9 >> 0", "0");
shouldBe("5.587935447692871e-9 >>> 0", "0");
shouldBe("-5.587935447692871e-9 >>> 0", "0");
shouldBe("1.1175870895385742e-8 >> 0", "0");
shouldBe("-1.1175870895385742e-8 >> 0", "0");
shouldBe("1.1175870895385742e-8 >>> 0", "0");
shouldBe("-1.1175870895385742e-8 >>> 0", "0");
shouldBe("2.2351741790771484e-8 >> 0", "0");
shouldBe("-2.2351741790771484e-8 >> 0", "0");
shouldBe("2.2351741790771484e-8 >>> 0", "0");
shouldBe("-2.2351741790771484e-8 >>> 0", "0");
shouldBe("4.470348358154297e-8 >> 0", "0");
shouldBe("-4.470348358154297e-8 >> 0", "0");
shouldBe("4.470348358154297e-8 >>> 0", "0");
shouldBe("-4.470348358154297e-8 >>> 0", "0");
shouldBe("8.940696716308594e-8 >> 0", "0");
shouldBe("-8.940696716308594e-8 >> 0", "0");
shouldBe("8.940696716308594e-8 >>> 0", "0");
shouldBe("-8.940696716308594e-8 >>> 0", "0");
shouldBe("1.7881393432617188e-7 >> 0", "0");
shouldBe("-1.7881393432617188e-7 >> 0", "0");
shouldBe("1.7881393432617188e-7 >>> 0", "0");
shouldBe("-1.7881393432617188e-7 >>> 0", "0");
shouldBe("3.5762786865234375e-7 >> 0", "0");
shouldBe("-3.5762786865234375e-7 >> 0", "0");
shouldBe("3.5762786865234375e-7 >>> 0", "0");
shouldBe("-3.5762786865234375e-7 >>> 0", "0");
shouldBe("7.152557373046875e-7 >> 0", "0");
shouldBe("-7.152557373046875e-7 >> 0", "0");
shouldBe("7.152557373046875e-7 >>> 0", "0");
shouldBe("-7.152557373046875e-7 >>> 0", "0");
shouldBe("0.000001430511474609375 >> 0", "0");
shouldBe("-0.000001430511474609375 >> 0", "0");
shouldBe("0.000001430511474609375 >>> 0", "0");
shouldBe("-0.000001430511474609375 >>> 0", "0");
shouldBe("0.00000286102294921875 >> 0", "0");
shouldBe("-0.00000286102294921875 >> 0", "0");
shouldBe("0.00000286102294921875 >>> 0", "0");
shouldBe("-0.00000286102294921875 >>> 0", "0");
shouldBe("0.0000057220458984375 >> 0", "0");
shouldBe("-0.0000057220458984375 >> 0", "0");
shouldBe("0.0000057220458984375 >>> 0", "0");
shouldBe("-0.0000057220458984375 >>> 0", "0");
shouldBe("0.000011444091796875 >> 0", "0");
shouldBe("-0.000011444091796875 >> 0", "0");
shouldBe("0.000011444091796875 >>> 0", "0");
shouldBe("-0.000011444091796875 >>> 0", "0");
shouldBe("0.00002288818359375 >> 0", "0");
shouldBe("-0.00002288818359375 >> 0", "0");
shouldBe("0.00002288818359375 >>> 0", "0");
shouldBe("-0.00002288818359375 >>> 0", "0");
shouldBe("0.0000457763671875 >> 0", "0");
shouldBe("-0.0000457763671875 >> 0", "0");
shouldBe("0.0000457763671875 >>> 0", "0");
shouldBe("-0.0000457763671875 >>> 0", "0");
shouldBe("0.000091552734375 >> 0", "0");
shouldBe("-0.000091552734375 >> 0", "0");
shouldBe("0.000091552734375 >>> 0", "0");
shouldBe("-0.000091552734375 >>> 0", "0");
shouldBe("0.00018310546875 >> 0", "0");
shouldBe("-0.00018310546875 >> 0", "0");
shouldBe("0.00018310546875 >>> 0", "0");
shouldBe("-0.00018310546875 >>> 0", "0");
shouldBe("0.0003662109375 >> 0", "0");
shouldBe("-0.0003662109375 >> 0", "0");
shouldBe("0.0003662109375 >>> 0", "0");
shouldBe("-0.0003662109375 >>> 0", "0");
shouldBe("0.000732421875 >> 0", "0");
shouldBe("-0.000732421875 >> 0", "0");
shouldBe("0.000732421875 >>> 0", "0");
shouldBe("-0.000732421875 >>> 0", "0");
shouldBe("0.00146484375 >> 0", "0");
shouldBe("-0.00146484375 >> 0", "0");
shouldBe("0.00146484375 >>> 0", "0");
shouldBe("-0.00146484375 >>> 0", "0");
shouldBe("0.0029296875 >> 0", "0");
shouldBe("-0.0029296875 >> 0", "0");
shouldBe("0.0029296875 >>> 0", "0");
shouldBe("-0.0029296875 >>> 0", "0");
shouldBe("0.005859375 >> 0", "0");
shouldBe("-0.005859375 >> 0", "0");
shouldBe("0.005859375 >>> 0", "0");
shouldBe("-0.005859375 >>> 0", "0");
shouldBe("0.01171875 >> 0", "0");
shouldBe("-0.01171875 >> 0", "0");
shouldBe("0.01171875 >>> 0", "0");
shouldBe("-0.01171875 >>> 0", "0");
shouldBe("0.0234375 >> 0", "0");
shouldBe("-0.0234375 >> 0", "0");
shouldBe("0.0234375 >>> 0", "0");
shouldBe("-0.0234375 >>> 0", "0");
shouldBe("0.046875 >> 0", "0");
shouldBe("-0.046875 >> 0", "0");
shouldBe("0.046875 >>> 0", "0");
shouldBe("-0.046875 >>> 0", "0");
shouldBe("0.09375 >> 0", "0");
shouldBe("-0.09375 >> 0", "0");
shouldBe("0.09375 >>> 0", "0");
shouldBe("-0.09375 >>> 0", "0");
shouldBe("0.1875 >> 0", "0");
shouldBe("-0.1875 >> 0", "0");
shouldBe("0.1875 >>> 0", "0");
shouldBe("-0.1875 >>> 0", "0");
shouldBe("0.375 >> 0", "0");
shouldBe("-0.375 >> 0", "0");
shouldBe("0.375 >>> 0", "0");
shouldBe("-0.375 >>> 0", "0");
shouldBe("0.75 >> 0", "0");
shouldBe("-0.75 >> 0", "0");
shouldBe("0.75 >>> 0", "0");
shouldBe("-0.75 >>> 0", "0");
shouldBe("1.5 >> 0", "1");
shouldBe("-1.5 >> 0", "-1");
shouldBe("1.5 >>> 0", "1");
shouldBe("-1.5 >>> 0", "4294967295");
shouldBe("3 >> 0", "3");
shouldBe("-3 >> 0", "-3");
shouldBe("3 >>> 0", "3");
shouldBe("-3 >>> 0", "4294967293");
shouldBe("6 >> 0", "6");
shouldBe("-6 >> 0", "-6");
shouldBe("6 >>> 0", "6");
shouldBe("-6 >>> 0", "4294967290");
shouldBe("12 >> 0", "12");
shouldBe("-12 >> 0", "-12");
shouldBe("12 >>> 0", "12");
shouldBe("-12 >>> 0", "4294967284");
shouldBe("24 >> 0", "24");
shouldBe("-24 >> 0", "-24");
shouldBe("24 >>> 0", "24");
shouldBe("-24 >>> 0", "4294967272");
shouldBe("48 >> 0", "48");
shouldBe("-48 >> 0", "-48");
shouldBe("48 >>> 0", "48");
shouldBe("-48 >>> 0", "4294967248");
shouldBe("96 >> 0", "96");
shouldBe("-96 >> 0", "-96");
shouldBe("96 >>> 0", "96");
shouldBe("-96 >>> 0", "4294967200");
shouldBe("192 >> 0", "192");
shouldBe("-192 >> 0", "-192");
shouldBe("192 >>> 0", "192");
shouldBe("-192 >>> 0", "4294967104");
shouldBe("384 >> 0", "384");
shouldBe("-384 >> 0", "-384");
shouldBe("384 >>> 0", "384");
shouldBe("-384 >>> 0", "4294966912");
shouldBe("768 >> 0", "768");
shouldBe("-768 >> 0", "-768");
shouldBe("768 >>> 0", "768");
shouldBe("-768 >>> 0", "4294966528");
shouldBe("1536 >> 0", "1536");
shouldBe("-1536 >> 0", "-1536");
shouldBe("1536 >>> 0", "1536");
shouldBe("-1536 >>> 0", "4294965760");
shouldBe("3072 >> 0", "3072");
shouldBe("-3072 >> 0", "-3072");
shouldBe("3072 >>> 0", "3072");
shouldBe("-3072 >>> 0", "4294964224");
shouldBe("6144 >> 0", "6144");
shouldBe("-6144 >> 0", "-6144");
shouldBe("6144 >>> 0", "6144");
shouldBe("-6144 >>> 0", "4294961152");
shouldBe("12288 >> 0", "12288");
shouldBe("-12288 >> 0", "-12288");
shouldBe("12288 >>> 0", "12288");
shouldBe("-12288 >>> 0", "4294955008");
shouldBe("24576 >> 0", "24576");
shouldBe("-24576 >> 0", "-24576");
shouldBe("24576 >>> 0", "24576");
shouldBe("-24576 >>> 0", "4294942720");
shouldBe("49152 >> 0", "49152");
shouldBe("-49152 >> 0", "-49152");
shouldBe("49152 >>> 0", "49152");
shouldBe("-49152 >>> 0", "4294918144");
shouldBe("98304 >> 0", "98304");
shouldBe("-98304 >> 0", "-98304");
shouldBe("98304 >>> 0", "98304");
shouldBe("-98304 >>> 0", "4294868992");
shouldBe("196608 >> 0", "196608");
shouldBe("-196608 >> 0", "-196608");
shouldBe("196608 >>> 0", "196608");
shouldBe("-196608 >>> 0", "4294770688");
shouldBe("393216 >> 0", "393216");
shouldBe("-393216 >> 0", "-393216");
shouldBe("393216 >>> 0", "393216");
shouldBe("-393216 >>> 0", "4294574080");
shouldBe("786432 >> 0", "786432");
shouldBe("-786432 >> 0", "-786432");
shouldBe("786432 >>> 0", "786432");
shouldBe("-786432 >>> 0", "4294180864");
shouldBe("1572864 >> 0", "1572864");
shouldBe("-1572864 >> 0", "-1572864");
shouldBe("1572864 >>> 0", "1572864");
shouldBe("-1572864 >>> 0", "4293394432");
shouldBe("3145728 >> 0", "3145728");
shouldBe("-3145728 >> 0", "-3145728");
shouldBe("3145728 >>> 0", "3145728");
shouldBe("-3145728 >>> 0", "4291821568");
shouldBe("6291456 >> 0", "6291456");
shouldBe("-6291456 >> 0", "-6291456");
shouldBe("6291456 >>> 0", "6291456");
shouldBe("-6291456 >>> 0", "4288675840");
shouldBe("12582912 >> 0", "12582912");
shouldBe("-12582912 >> 0", "-12582912");
shouldBe("12582912 >>> 0", "12582912");
shouldBe("-12582912 >>> 0", "4282384384");
shouldBe("25165824 >> 0", "25165824");
shouldBe("-25165824 >> 0", "-25165824");
shouldBe("25165824 >>> 0", "25165824");
shouldBe("-25165824 >>> 0", "4269801472");
shouldBe("50331648 >> 0", "50331648");
shouldBe("-50331648 >> 0", "-50331648");
shouldBe("50331648 >>> 0", "50331648");
shouldBe("-50331648 >>> 0", "4244635648");
shouldBe("100663296 >> 0", "100663296");
shouldBe("-100663296 >> 0", "-100663296");
shouldBe("100663296 >>> 0", "100663296");
shouldBe("-100663296 >>> 0", "4194304000");
shouldBe("201326592 >> 0", "201326592");
shouldBe("-201326592 >> 0", "-201326592");
shouldBe("201326592 >>> 0", "201326592");
shouldBe("-201326592 >>> 0", "4093640704");
shouldBe("402653184 >> 0", "402653184");
shouldBe("-402653184 >> 0", "-402653184");
shouldBe("402653184 >>> 0", "402653184");
shouldBe("-402653184 >>> 0", "3892314112");
shouldBe("805306368 >> 0", "805306368");
shouldBe("-805306368 >> 0", "-805306368");
shouldBe("805306368 >>> 0", "805306368");
shouldBe("-805306368 >>> 0", "3489660928");
shouldBe("1610612736 >> 0", "1610612736");
shouldBe("-1610612736 >> 0", "-1610612736");
shouldBe("1610612736 >>> 0", "1610612736");
shouldBe("-1610612736 >>> 0", "2684354560");
shouldBe("3221225472 >> 0", "-1073741824");
shouldBe("-3221225472 >> 0", "1073741824");
shouldBe("3221225472 >>> 0", "3221225472");
shouldBe("-3221225472 >>> 0", "1073741824");
shouldBe("6442450944 >> 0", "-2147483648");
shouldBe("-6442450944 >> 0", "-2147483648");
shouldBe("6442450944 >>> 0", "2147483648");
shouldBe("-6442450944 >>> 0", "2147483648");
shouldBe("12884901888 >> 0", "0");
shouldBe("-12884901888 >> 0", "0");
shouldBe("12884901888 >>> 0", "0");
shouldBe("-12884901888 >>> 0", "0");
shouldBe("1.3877787807814457e-16 >> 0", "0");
shouldBe("-1.3877787807814457e-16 >> 0", "0");
shouldBe("1.3877787807814457e-16 >>> 0", "0");
shouldBe("-1.3877787807814457e-16 >>> 0", "0");
shouldBe("2.7755575615628914e-16 >> 0", "0");
shouldBe("-2.7755575615628914e-16 >> 0", "0");
shouldBe("2.7755575615628914e-16 >>> 0", "0");
shouldBe("-2.7755575615628914e-16 >>> 0", "0");
shouldBe("5.551115123125783e-16 >> 0", "0");
shouldBe("-5.551115123125783e-16 >> 0", "0");
shouldBe("5.551115123125783e-16 >>> 0", "0");
shouldBe("-5.551115123125783e-16 >>> 0", "0");
shouldBe("1.1102230246251565e-15 >> 0", "0");
shouldBe("-1.1102230246251565e-15 >> 0", "0");
shouldBe("1.1102230246251565e-15 >>> 0", "0");
shouldBe("-1.1102230246251565e-15 >>> 0", "0");
shouldBe("2.220446049250313e-15 >> 0", "0");
shouldBe("-2.220446049250313e-15 >> 0", "0");
shouldBe("2.220446049250313e-15 >>> 0", "0");
shouldBe("-2.220446049250313e-15 >>> 0", "0");
shouldBe("4.440892098500626e-15 >> 0", "0");
shouldBe("-4.440892098500626e-15 >> 0", "0");
shouldBe("4.440892098500626e-15 >>> 0", "0");
shouldBe("-4.440892098500626e-15 >>> 0", "0");
shouldBe("8.881784197001252e-15 >> 0", "0");
shouldBe("-8.881784197001252e-15 >> 0", "0");
shouldBe("8.881784197001252e-15 >>> 0", "0");
shouldBe("-8.881784197001252e-15 >>> 0", "0");
shouldBe("1.7763568394002505e-14 >> 0", "0");
shouldBe("-1.7763568394002505e-14 >> 0", "0");
shouldBe("1.7763568394002505e-14 >>> 0", "0");
shouldBe("-1.7763568394002505e-14 >>> 0", "0");
shouldBe("3.552713678800501e-14 >> 0", "0");
shouldBe("-3.552713678800501e-14 >> 0", "0");
shouldBe("3.552713678800501e-14 >>> 0", "0");
shouldBe("-3.552713678800501e-14 >>> 0", "0");
shouldBe("7.105427357601002e-14 >> 0", "0");
shouldBe("-7.105427357601002e-14 >> 0", "0");
shouldBe("7.105427357601002e-14 >>> 0", "0");
shouldBe("-7.105427357601002e-14 >>> 0", "0");
shouldBe("1.4210854715202004e-13 >> 0", "0");
shouldBe("-1.4210854715202004e-13 >> 0", "0");
shouldBe("1.4210854715202004e-13 >>> 0", "0");
shouldBe("-1.4210854715202004e-13 >>> 0", "0");
shouldBe("2.8421709430404007e-13 >> 0", "0");
shouldBe("-2.8421709430404007e-13 >> 0", "0");
shouldBe("2.8421709430404007e-13 >>> 0", "0");
shouldBe("-2.8421709430404007e-13 >>> 0", "0");
shouldBe("5.684341886080801e-13 >> 0", "0");
shouldBe("-5.684341886080801e-13 >> 0", "0");
shouldBe("5.684341886080801e-13 >>> 0", "0");
shouldBe("-5.684341886080801e-13 >>> 0", "0");
shouldBe("1.1368683772161603e-12 >> 0", "0");
shouldBe("-1.1368683772161603e-12 >> 0", "0");
shouldBe("1.1368683772161603e-12 >>> 0", "0");
shouldBe("-1.1368683772161603e-12 >>> 0", "0");
shouldBe("2.2737367544323206e-12 >> 0", "0");
shouldBe("-2.2737367544323206e-12 >> 0", "0");
shouldBe("2.2737367544323206e-12 >>> 0", "0");
shouldBe("-2.2737367544323206e-12 >>> 0", "0");
shouldBe("4.547473508864641e-12 >> 0", "0");
shouldBe("-4.547473508864641e-12 >> 0", "0");
shouldBe("4.547473508864641e-12 >>> 0", "0");
shouldBe("-4.547473508864641e-12 >>> 0", "0");
shouldBe("9.094947017729282e-12 >> 0", "0");
shouldBe("-9.094947017729282e-12 >> 0", "0");
shouldBe("9.094947017729282e-12 >>> 0", "0");
shouldBe("-9.094947017729282e-12 >>> 0", "0");
shouldBe("1.8189894035458565e-11 >> 0", "0");
shouldBe("-1.8189894035458565e-11 >> 0", "0");
shouldBe("1.8189894035458565e-11 >>> 0", "0");
shouldBe("-1.8189894035458565e-11 >>> 0", "0");
shouldBe("3.637978807091713e-11 >> 0", "0");
shouldBe("-3.637978807091713e-11 >> 0", "0");
shouldBe("3.637978807091713e-11 >>> 0", "0");
shouldBe("-3.637978807091713e-11 >>> 0", "0");
shouldBe("7.275957614183426e-11 >> 0", "0");
shouldBe("-7.275957614183426e-11 >> 0", "0");
shouldBe("7.275957614183426e-11 >>> 0", "0");
shouldBe("-7.275957614183426e-11 >>> 0", "0");
shouldBe("1.4551915228366852e-10 >> 0", "0");
shouldBe("-1.4551915228366852e-10 >> 0", "0");
shouldBe("1.4551915228366852e-10 >>> 0", "0");
shouldBe("-1.4551915228366852e-10 >>> 0", "0");
shouldBe("2.9103830456733704e-10 >> 0", "0");
shouldBe("-2.9103830456733704e-10 >> 0", "0");
shouldBe("2.9103830456733704e-10 >>> 0", "0");
shouldBe("-2.9103830456733704e-10 >>> 0", "0");
shouldBe("5.820766091346741e-10 >> 0", "0");
shouldBe("-5.820766091346741e-10 >> 0", "0");
shouldBe("5.820766091346741e-10 >>> 0", "0");
shouldBe("-5.820766091346741e-10 >>> 0", "0");
shouldBe("1.1641532182693481e-9 >> 0", "0");
shouldBe("-1.1641532182693481e-9 >> 0", "0");
shouldBe("1.1641532182693481e-9 >>> 0", "0");
shouldBe("-1.1641532182693481e-9 >>> 0", "0");
shouldBe("2.3283064365386963e-9 >> 0", "0");
shouldBe("-2.3283064365386963e-9 >> 0", "0");
shouldBe("2.3283064365386963e-9 >>> 0", "0");
shouldBe("-2.3283064365386963e-9 >>> 0", "0");
shouldBe("4.6566128730773926e-9 >> 0", "0");
shouldBe("-4.6566128730773926e-9 >> 0", "0");
shouldBe("4.6566128730773926e-9 >>> 0", "0");
shouldBe("-4.6566128730773926e-9 >>> 0", "0");
shouldBe("9.313225746154785e-9 >> 0", "0");
shouldBe("-9.313225746154785e-9 >> 0", "0");
shouldBe("9.313225746154785e-9 >>> 0", "0");
shouldBe("-9.313225746154785e-9 >>> 0", "0");
shouldBe("1.862645149230957e-8 >> 0", "0");
shouldBe("-1.862645149230957e-8 >> 0", "0");
shouldBe("1.862645149230957e-8 >>> 0", "0");
shouldBe("-1.862645149230957e-8 >>> 0", "0");
shouldBe("3.725290298461914e-8 >> 0", "0");
shouldBe("-3.725290298461914e-8 >> 0", "0");
shouldBe("3.725290298461914e-8 >>> 0", "0");
shouldBe("-3.725290298461914e-8 >>> 0", "0");
shouldBe("7.450580596923828e-8 >> 0", "0");
shouldBe("-7.450580596923828e-8 >> 0", "0");
shouldBe("7.450580596923828e-8 >>> 0", "0");
shouldBe("-7.450580596923828e-8 >>> 0", "0");
shouldBe("1.4901161193847656e-7 >> 0", "0");
shouldBe("-1.4901161193847656e-7 >> 0", "0");
shouldBe("1.4901161193847656e-7 >>> 0", "0");
shouldBe("-1.4901161193847656e-7 >>> 0", "0");
shouldBe("2.980232238769531e-7 >> 0", "0");
shouldBe("-2.980232238769531e-7 >> 0", "0");
shouldBe("2.980232238769531e-7 >>> 0", "0");
shouldBe("-2.980232238769531e-7 >>> 0", "0");
shouldBe("5.960464477539063e-7 >> 0", "0");
shouldBe("-5.960464477539063e-7 >> 0", "0");
shouldBe("5.960464477539063e-7 >>> 0", "0");
shouldBe("-5.960464477539063e-7 >>> 0", "0");
shouldBe("0.0000011920928955078125 >> 0", "0");
shouldBe("-0.0000011920928955078125 >> 0", "0");
shouldBe("0.0000011920928955078125 >>> 0", "0");
shouldBe("-0.0000011920928955078125 >>> 0", "0");
shouldBe("0.000002384185791015625 >> 0", "0");
shouldBe("-0.000002384185791015625 >> 0", "0");
shouldBe("0.000002384185791015625 >>> 0", "0");
shouldBe("-0.000002384185791015625 >>> 0", "0");
shouldBe("0.00000476837158203125 >> 0", "0");
shouldBe("-0.00000476837158203125 >> 0", "0");
shouldBe("0.00000476837158203125 >>> 0", "0");
shouldBe("-0.00000476837158203125 >>> 0", "0");
shouldBe("0.0000095367431640625 >> 0", "0");
shouldBe("-0.0000095367431640625 >> 0", "0");
shouldBe("0.0000095367431640625 >>> 0", "0");
shouldBe("-0.0000095367431640625 >>> 0", "0");
shouldBe("0.000019073486328125 >> 0", "0");
shouldBe("-0.000019073486328125 >> 0", "0");
shouldBe("0.000019073486328125 >>> 0", "0");
shouldBe("-0.000019073486328125 >>> 0", "0");
shouldBe("0.00003814697265625 >> 0", "0");
shouldBe("-0.00003814697265625 >> 0", "0");
shouldBe("0.00003814697265625 >>> 0", "0");
shouldBe("-0.00003814697265625 >>> 0", "0");
shouldBe("0.0000762939453125 >> 0", "0");
shouldBe("-0.0000762939453125 >> 0", "0");
shouldBe("0.0000762939453125 >>> 0", "0");
shouldBe("-0.0000762939453125 >>> 0", "0");
shouldBe("0.000152587890625 >> 0", "0");
shouldBe("-0.000152587890625 >> 0", "0");
shouldBe("0.000152587890625 >>> 0", "0");
shouldBe("-0.000152587890625 >>> 0", "0");
shouldBe("0.00030517578125 >> 0", "0");
shouldBe("-0.00030517578125 >> 0", "0");
shouldBe("0.00030517578125 >>> 0", "0");
shouldBe("-0.00030517578125 >>> 0", "0");
shouldBe("0.0006103515625 >> 0", "0");
shouldBe("-0.0006103515625 >> 0", "0");
shouldBe("0.0006103515625 >>> 0", "0");
shouldBe("-0.0006103515625 >>> 0", "0");
shouldBe("0.001220703125 >> 0", "0");
shouldBe("-0.001220703125 >> 0", "0");
shouldBe("0.001220703125 >>> 0", "0");
shouldBe("-0.001220703125 >>> 0", "0");
shouldBe("0.00244140625 >> 0", "0");
shouldBe("-0.00244140625 >> 0", "0");
shouldBe("0.00244140625 >>> 0", "0");
shouldBe("-0.00244140625 >>> 0", "0");
shouldBe("0.0048828125 >> 0", "0");
shouldBe("-0.0048828125 >> 0", "0");
shouldBe("0.0048828125 >>> 0", "0");
shouldBe("-0.0048828125 >>> 0", "0");
shouldBe("0.009765625 >> 0", "0");
shouldBe("-0.009765625 >> 0", "0");
shouldBe("0.009765625 >>> 0", "0");
shouldBe("-0.009765625 >>> 0", "0");
shouldBe("0.01953125 >> 0", "0");
shouldBe("-0.01953125 >> 0", "0");
shouldBe("0.01953125 >>> 0", "0");
shouldBe("-0.01953125 >>> 0", "0");
shouldBe("0.0390625 >> 0", "0");
shouldBe("-0.0390625 >> 0", "0");
shouldBe("0.0390625 >>> 0", "0");
shouldBe("-0.0390625 >>> 0", "0");
shouldBe("0.078125 >> 0", "0");
shouldBe("-0.078125 >> 0", "0");
shouldBe("0.078125 >>> 0", "0");
shouldBe("-0.078125 >>> 0", "0");
shouldBe("0.15625 >> 0", "0");
shouldBe("-0.15625 >> 0", "0");
shouldBe("0.15625 >>> 0", "0");
shouldBe("-0.15625 >>> 0", "0");
shouldBe("0.3125 >> 0", "0");
shouldBe("-0.3125 >> 0", "0");
shouldBe("0.3125 >>> 0", "0");
shouldBe("-0.3125 >>> 0", "0");
shouldBe("0.625 >> 0", "0");
shouldBe("-0.625 >> 0", "0");
shouldBe("0.625 >>> 0", "0");
shouldBe("-0.625 >>> 0", "0");
shouldBe("1.25 >> 0", "1");
shouldBe("-1.25 >> 0", "-1");
shouldBe("1.25 >>> 0", "1");
shouldBe("-1.25 >>> 0", "4294967295");
shouldBe("2.5 >> 0", "2");
shouldBe("-2.5 >> 0", "-2");
shouldBe("2.5 >>> 0", "2");
shouldBe("-2.5 >>> 0", "4294967294");
shouldBe("5 >> 0", "5");
shouldBe("-5 >> 0", "-5");
shouldBe("5 >>> 0", "5");
shouldBe("-5 >>> 0", "4294967291");
shouldBe("10 >> 0", "10");
shouldBe("-10 >> 0", "-10");
shouldBe("10 >>> 0", "10");
shouldBe("-10 >>> 0", "4294967286");
shouldBe("20 >> 0", "20");
shouldBe("-20 >> 0", "-20");
shouldBe("20 >>> 0", "20");
shouldBe("-20 >>> 0", "4294967276");
shouldBe("40 >> 0", "40");
shouldBe("-40 >> 0", "-40");
shouldBe("40 >>> 0", "40");
shouldBe("-40 >>> 0", "4294967256");
shouldBe("80 >> 0", "80");
shouldBe("-80 >> 0", "-80");
shouldBe("80 >>> 0", "80");
shouldBe("-80 >>> 0", "4294967216");
shouldBe("160 >> 0", "160");
shouldBe("-160 >> 0", "-160");
shouldBe("160 >>> 0", "160");
shouldBe("-160 >>> 0", "4294967136");
shouldBe("320 >> 0", "320");
shouldBe("-320 >> 0", "-320");
shouldBe("320 >>> 0", "320");
shouldBe("-320 >>> 0", "4294966976");
shouldBe("640 >> 0", "640");
shouldBe("-640 >> 0", "-640");
shouldBe("640 >>> 0", "640");
shouldBe("-640 >>> 0", "4294966656");
shouldBe("1280 >> 0", "1280");
shouldBe("-1280 >> 0", "-1280");
shouldBe("1280 >>> 0", "1280");
shouldBe("-1280 >>> 0", "4294966016");
shouldBe("2560 >> 0", "2560");
shouldBe("-2560 >> 0", "-2560");
shouldBe("2560 >>> 0", "2560");
shouldBe("-2560 >>> 0", "4294964736");
shouldBe("5120 >> 0", "5120");
shouldBe("-5120 >> 0", "-5120");
shouldBe("5120 >>> 0", "5120");
shouldBe("-5120 >>> 0", "4294962176");
shouldBe("10240 >> 0", "10240");
shouldBe("-10240 >> 0", "-10240");
shouldBe("10240 >>> 0", "10240");
shouldBe("-10240 >>> 0", "4294957056");
shouldBe("20480 >> 0", "20480");
shouldBe("-20480 >> 0", "-20480");
shouldBe("20480 >>> 0", "20480");
shouldBe("-20480 >>> 0", "4294946816");
shouldBe("40960 >> 0", "40960");
shouldBe("-40960 >> 0", "-40960");
shouldBe("40960 >>> 0", "40960");
shouldBe("-40960 >>> 0", "4294926336");
shouldBe("81920 >> 0", "81920");
shouldBe("-81920 >> 0", "-81920");
shouldBe("81920 >>> 0", "81920");
shouldBe("-81920 >>> 0", "4294885376");
shouldBe("163840 >> 0", "163840");
shouldBe("-163840 >> 0", "-163840");
shouldBe("163840 >>> 0", "163840");
shouldBe("-163840 >>> 0", "4294803456");
shouldBe("327680 >> 0", "327680");
shouldBe("-327680 >> 0", "-327680");
shouldBe("327680 >>> 0", "327680");
shouldBe("-327680 >>> 0", "4294639616");
shouldBe("655360 >> 0", "655360");
shouldBe("-655360 >> 0", "-655360");
shouldBe("655360 >>> 0", "655360");
shouldBe("-655360 >>> 0", "4294311936");
shouldBe("1310720 >> 0", "1310720");
shouldBe("-1310720 >> 0", "-1310720");
shouldBe("1310720 >>> 0", "1310720");
shouldBe("-1310720 >>> 0", "4293656576");
shouldBe("2621440 >> 0", "2621440");
shouldBe("-2621440 >> 0", "-2621440");
shouldBe("2621440 >>> 0", "2621440");
shouldBe("-2621440 >>> 0", "4292345856");
shouldBe("5242880 >> 0", "5242880");
shouldBe("-5242880 >> 0", "-5242880");
shouldBe("5242880 >>> 0", "5242880");
shouldBe("-5242880 >>> 0", "4289724416");
shouldBe("10485760 >> 0", "10485760");
shouldBe("-10485760 >> 0", "-10485760");
shouldBe("10485760 >>> 0", "10485760");
shouldBe("-10485760 >>> 0", "4284481536");
shouldBe("20971520 >> 0", "20971520");
shouldBe("-20971520 >> 0", "-20971520");
shouldBe("20971520 >>> 0", "20971520");
shouldBe("-20971520 >>> 0", "4273995776");
shouldBe("41943040 >> 0", "41943040");
shouldBe("-41943040 >> 0", "-41943040");
shouldBe("41943040 >>> 0", "41943040");
shouldBe("-41943040 >>> 0", "4253024256");
shouldBe("83886080 >> 0", "83886080");
shouldBe("-83886080 >> 0", "-83886080");
shouldBe("83886080 >>> 0", "83886080");
shouldBe("-83886080 >>> 0", "4211081216");
shouldBe("167772160 >> 0", "167772160");
shouldBe("-167772160 >> 0", "-167772160");
shouldBe("167772160 >>> 0", "167772160");
shouldBe("-167772160 >>> 0", "4127195136");
shouldBe("335544320 >> 0", "335544320");
shouldBe("-335544320 >> 0", "-335544320");
shouldBe("335544320 >>> 0", "335544320");
shouldBe("-335544320 >>> 0", "3959422976");
shouldBe("671088640 >> 0", "671088640");
shouldBe("-671088640 >> 0", "-671088640");
shouldBe("671088640 >>> 0", "671088640");
shouldBe("-671088640 >>> 0", "3623878656");
shouldBe("1342177280 >> 0", "1342177280");
shouldBe("-1342177280 >> 0", "-1342177280");
shouldBe("1342177280 >>> 0", "1342177280");
shouldBe("-1342177280 >>> 0", "2952790016");
shouldBe("2684354560 >> 0", "-1610612736");
shouldBe("-2684354560 >> 0", "1610612736");
shouldBe("2684354560 >>> 0", "2684354560");
shouldBe("-2684354560 >>> 0", "1610612736");
shouldBe("5368709120 >> 0", "1073741824");
shouldBe("-5368709120 >> 0", "-1073741824");
shouldBe("5368709120 >>> 0", "1073741824");
shouldBe("-5368709120 >>> 0", "3221225472");
shouldBe("10737418240 >> 0", "-2147483648");
shouldBe("-10737418240 >> 0", "-2147483648");
shouldBe("10737418240 >>> 0", "2147483648");
shouldBe("-10737418240 >>> 0", "2147483648");
shouldBe("21474836480 >> 0", "0");
shouldBe("-21474836480 >> 0", "0");
shouldBe("21474836480 >>> 0", "0");
shouldBe("-21474836480 >>> 0", "0");
shouldBe("2.980232241545089e-8 >> 0", "0");
shouldBe("-2.980232241545089e-8 >> 0", "0");
shouldBe("2.980232241545089e-8 >>> 0", "0");
shouldBe("-2.980232241545089e-8 >>> 0", "0");
shouldBe("5.960464483090178e-8 >> 0", "0");
shouldBe("-5.960464483090178e-8 >> 0", "0");
shouldBe("5.960464483090178e-8 >>> 0", "0");
shouldBe("-5.960464483090178e-8 >>> 0", "0");
shouldBe("1.1920928966180355e-7 >> 0", "0");
shouldBe("-1.1920928966180355e-7 >> 0", "0");
shouldBe("1.1920928966180355e-7 >>> 0", "0");
shouldBe("-1.1920928966180355e-7 >>> 0", "0");
shouldBe("2.384185793236071e-7 >> 0", "0");
shouldBe("-2.384185793236071e-7 >> 0", "0");
shouldBe("2.384185793236071e-7 >>> 0", "0");
shouldBe("-2.384185793236071e-7 >>> 0", "0");
shouldBe("4.768371586472142e-7 >> 0", "0");
shouldBe("-4.768371586472142e-7 >> 0", "0");
shouldBe("4.768371586472142e-7 >>> 0", "0");
shouldBe("-4.768371586472142e-7 >>> 0", "0");
shouldBe("9.536743172944284e-7 >> 0", "0");
shouldBe("-9.536743172944284e-7 >> 0", "0");
shouldBe("9.536743172944284e-7 >>> 0", "0");
shouldBe("-9.536743172944284e-7 >>> 0", "0");
shouldBe("0.000001907348634588857 >> 0", "0");
shouldBe("-0.000001907348634588857 >> 0", "0");
shouldBe("0.000001907348634588857 >>> 0", "0");
shouldBe("-0.000001907348634588857 >>> 0", "0");
shouldBe("0.000003814697269177714 >> 0", "0");
shouldBe("-0.000003814697269177714 >> 0", "0");
shouldBe("0.000003814697269177714 >>> 0", "0");
shouldBe("-0.000003814697269177714 >>> 0", "0");
shouldBe("0.000007629394538355427 >> 0", "0");
shouldBe("-0.000007629394538355427 >> 0", "0");
shouldBe("0.000007629394538355427 >>> 0", "0");
shouldBe("-0.000007629394538355427 >>> 0", "0");
shouldBe("0.000015258789076710855 >> 0", "0");
shouldBe("-0.000015258789076710855 >> 0", "0");
shouldBe("0.000015258789076710855 >>> 0", "0");
shouldBe("-0.000015258789076710855 >>> 0", "0");
shouldBe("0.00003051757815342171 >> 0", "0");
shouldBe("-0.00003051757815342171 >> 0", "0");
shouldBe("0.00003051757815342171 >>> 0", "0");
shouldBe("-0.00003051757815342171 >>> 0", "0");
shouldBe("0.00006103515630684342 >> 0", "0");
shouldBe("-0.00006103515630684342 >> 0", "0");
shouldBe("0.00006103515630684342 >>> 0", "0");
shouldBe("-0.00006103515630684342 >>> 0", "0");
shouldBe("0.00012207031261368684 >> 0", "0");
shouldBe("-0.00012207031261368684 >> 0", "0");
shouldBe("0.00012207031261368684 >>> 0", "0");
shouldBe("-0.00012207031261368684 >>> 0", "0");
shouldBe("0.0002441406252273737 >> 0", "0");
shouldBe("-0.0002441406252273737 >> 0", "0");
shouldBe("0.0002441406252273737 >>> 0", "0");
shouldBe("-0.0002441406252273737 >>> 0", "0");
shouldBe("0.0004882812504547474 >> 0", "0");
shouldBe("-0.0004882812504547474 >> 0", "0");
shouldBe("0.0004882812504547474 >>> 0", "0");
shouldBe("-0.0004882812504547474 >>> 0", "0");
shouldBe("0.0009765625009094947 >> 0", "0");
shouldBe("-0.0009765625009094947 >> 0", "0");
shouldBe("0.0009765625009094947 >>> 0", "0");
shouldBe("-0.0009765625009094947 >>> 0", "0");
shouldBe("0.0019531250018189894 >> 0", "0");
shouldBe("-0.0019531250018189894 >> 0", "0");
shouldBe("0.0019531250018189894 >>> 0", "0");
shouldBe("-0.0019531250018189894 >>> 0", "0");
shouldBe("0.003906250003637979 >> 0", "0");
shouldBe("-0.003906250003637979 >> 0", "0");
shouldBe("0.003906250003637979 >>> 0", "0");
shouldBe("-0.003906250003637979 >>> 0", "0");
shouldBe("0.007812500007275958 >> 0", "0");
shouldBe("-0.007812500007275958 >> 0", "0");
shouldBe("0.007812500007275958 >>> 0", "0");
shouldBe("-0.007812500007275958 >>> 0", "0");
shouldBe("0.015625000014551915 >> 0", "0");
shouldBe("-0.015625000014551915 >> 0", "0");
shouldBe("0.015625000014551915 >>> 0", "0");
shouldBe("-0.015625000014551915 >>> 0", "0");
shouldBe("0.03125000002910383 >> 0", "0");
shouldBe("-0.03125000002910383 >> 0", "0");
shouldBe("0.03125000002910383 >>> 0", "0");
shouldBe("-0.03125000002910383 >>> 0", "0");
shouldBe("0.06250000005820766 >> 0", "0");
shouldBe("-0.06250000005820766 >> 0", "0");
shouldBe("0.06250000005820766 >>> 0", "0");
shouldBe("-0.06250000005820766 >>> 0", "0");
shouldBe("0.12500000011641532 >> 0", "0");
shouldBe("-0.12500000011641532 >> 0", "0");
shouldBe("0.12500000011641532 >>> 0", "0");
shouldBe("-0.12500000011641532 >>> 0", "0");
shouldBe("0.25000000023283064 >> 0", "0");
shouldBe("-0.25000000023283064 >> 0", "0");
shouldBe("0.25000000023283064 >>> 0", "0");
shouldBe("-0.25000000023283064 >>> 0", "0");
shouldBe("0.5000000004656613 >> 0", "0");
shouldBe("-0.5000000004656613 >> 0", "0");
shouldBe("0.5000000004656613 >>> 0", "0");
shouldBe("-0.5000000004656613 >>> 0", "0");
shouldBe("1.0000000009313226 >> 0", "1");
shouldBe("-1.0000000009313226 >> 0", "-1");
shouldBe("1.0000000009313226 >>> 0", "1");
shouldBe("-1.0000000009313226 >>> 0", "4294967295");
shouldBe("2.000000001862645 >> 0", "2");
shouldBe("-2.000000001862645 >> 0", "-2");
shouldBe("2.000000001862645 >>> 0", "2");
shouldBe("-2.000000001862645 >>> 0", "4294967294");
shouldBe("4.00000000372529 >> 0", "4");
shouldBe("-4.00000000372529 >> 0", "-4");
shouldBe("4.00000000372529 >>> 0", "4");
shouldBe("-4.00000000372529 >>> 0", "4294967292");
shouldBe("8.00000000745058 >> 0", "8");
shouldBe("-8.00000000745058 >> 0", "-8");
shouldBe("8.00000000745058 >>> 0", "8");
shouldBe("-8.00000000745058 >>> 0", "4294967288");
shouldBe("16.00000001490116 >> 0", "16");
shouldBe("-16.00000001490116 >> 0", "-16");
shouldBe("16.00000001490116 >>> 0", "16");
shouldBe("-16.00000001490116 >>> 0", "4294967280");
shouldBe("32.00000002980232 >> 0", "32");
shouldBe("-32.00000002980232 >> 0", "-32");
shouldBe("32.00000002980232 >>> 0", "32");
shouldBe("-32.00000002980232 >>> 0", "4294967264");
shouldBe("64.00000005960464 >> 0", "64");
shouldBe("-64.00000005960464 >> 0", "-64");
shouldBe("64.00000005960464 >>> 0", "64");
shouldBe("-64.00000005960464 >>> 0", "4294967232");
shouldBe("128.0000001192093 >> 0", "128");
shouldBe("-128.0000001192093 >> 0", "-128");
shouldBe("128.0000001192093 >>> 0", "128");
shouldBe("-128.0000001192093 >>> 0", "4294967168");
shouldBe("256.0000002384186 >> 0", "256");
shouldBe("-256.0000002384186 >> 0", "-256");
shouldBe("256.0000002384186 >>> 0", "256");
shouldBe("-256.0000002384186 >>> 0", "4294967040");
shouldBe("512.0000004768372 >> 0", "512");
shouldBe("-512.0000004768372 >> 0", "-512");
shouldBe("512.0000004768372 >>> 0", "512");
shouldBe("-512.0000004768372 >>> 0", "4294966784");
shouldBe("1024.0000009536743 >> 0", "1024");
shouldBe("-1024.0000009536743 >> 0", "-1024");
shouldBe("1024.0000009536743 >>> 0", "1024");
shouldBe("-1024.0000009536743 >>> 0", "4294966272");
shouldBe("2048.0000019073486 >> 0", "2048");
shouldBe("-2048.0000019073486 >> 0", "-2048");
shouldBe("2048.0000019073486 >>> 0", "2048");
shouldBe("-2048.0000019073486 >>> 0", "4294965248");
shouldBe("4096.000003814697 >> 0", "4096");
shouldBe("-4096.000003814697 >> 0", "-4096");
shouldBe("4096.000003814697 >>> 0", "4096");
shouldBe("-4096.000003814697 >>> 0", "4294963200");
shouldBe("8192.000007629395 >> 0", "8192");
shouldBe("-8192.000007629395 >> 0", "-8192");
shouldBe("8192.000007629395 >>> 0", "8192");
shouldBe("-8192.000007629395 >>> 0", "4294959104");
shouldBe("16384.00001525879 >> 0", "16384");
shouldBe("-16384.00001525879 >> 0", "-16384");
shouldBe("16384.00001525879 >>> 0", "16384");
shouldBe("-16384.00001525879 >>> 0", "4294950912");
shouldBe("32768.00003051758 >> 0", "32768");
shouldBe("-32768.00003051758 >> 0", "-32768");
shouldBe("32768.00003051758 >>> 0", "32768");
shouldBe("-32768.00003051758 >>> 0", "4294934528");
shouldBe("65536.00006103516 >> 0", "65536");
shouldBe("-65536.00006103516 >> 0", "-65536");
shouldBe("65536.00006103516 >>> 0", "65536");
shouldBe("-65536.00006103516 >>> 0", "4294901760");
shouldBe("131072.0001220703 >> 0", "131072");
shouldBe("-131072.0001220703 >> 0", "-131072");
shouldBe("131072.0001220703 >>> 0", "131072");
shouldBe("-131072.0001220703 >>> 0", "4294836224");
shouldBe("262144.0002441406 >> 0", "262144");
shouldBe("-262144.0002441406 >> 0", "-262144");
shouldBe("262144.0002441406 >>> 0", "262144");
shouldBe("-262144.0002441406 >>> 0", "4294705152");
shouldBe("524288.0004882813 >> 0", "524288");
shouldBe("-524288.0004882813 >> 0", "-524288");
shouldBe("524288.0004882813 >>> 0", "524288");
shouldBe("-524288.0004882813 >>> 0", "4294443008");
shouldBe("1048576.0009765625 >> 0", "1048576");
shouldBe("-1048576.0009765625 >> 0", "-1048576");
shouldBe("1048576.0009765625 >>> 0", "1048576");
shouldBe("-1048576.0009765625 >>> 0", "4293918720");
shouldBe("2097152.001953125 >> 0", "2097152");
shouldBe("-2097152.001953125 >> 0", "-2097152");
shouldBe("2097152.001953125 >>> 0", "2097152");
shouldBe("-2097152.001953125 >>> 0", "4292870144");
shouldBe("4194304.00390625 >> 0", "4194304");
shouldBe("-4194304.00390625 >> 0", "-4194304");
shouldBe("4194304.00390625 >>> 0", "4194304");
shouldBe("-4194304.00390625 >>> 0", "4290772992");
shouldBe("8388608.0078125 >> 0", "8388608");
shouldBe("-8388608.0078125 >> 0", "-8388608");
shouldBe("8388608.0078125 >>> 0", "8388608");
shouldBe("-8388608.0078125 >>> 0", "4286578688");
shouldBe("16777216.015625 >> 0", "16777216");
shouldBe("-16777216.015625 >> 0", "-16777216");
shouldBe("16777216.015625 >>> 0", "16777216");
shouldBe("-16777216.015625 >>> 0", "4278190080");
shouldBe("33554432.03125 >> 0", "33554432");
shouldBe("-33554432.03125 >> 0", "-33554432");
shouldBe("33554432.03125 >>> 0", "33554432");
shouldBe("-33554432.03125 >>> 0", "4261412864");
shouldBe("67108864.0625 >> 0", "67108864");
shouldBe("-67108864.0625 >> 0", "-67108864");
shouldBe("67108864.0625 >>> 0", "67108864");
shouldBe("-67108864.0625 >>> 0", "4227858432");
shouldBe("134217728.125 >> 0", "134217728");
shouldBe("-134217728.125 >> 0", "-134217728");
shouldBe("134217728.125 >>> 0", "134217728");
shouldBe("-134217728.125 >>> 0", "4160749568");
shouldBe("268435456.25 >> 0", "268435456");
shouldBe("-268435456.25 >> 0", "-268435456");
shouldBe("268435456.25 >>> 0", "268435456");
shouldBe("-268435456.25 >>> 0", "4026531840");
shouldBe("536870912.5 >> 0", "536870912");
shouldBe("-536870912.5 >> 0", "-536870912");
shouldBe("536870912.5 >>> 0", "536870912");
shouldBe("-536870912.5 >>> 0", "3758096384");
shouldBe("1073741825 >> 0", "1073741825");
shouldBe("-1073741825 >> 0", "-1073741825");
shouldBe("1073741825 >>> 0", "1073741825");
shouldBe("-1073741825 >>> 0", "3221225471");
shouldBe("2147483650 >> 0", "-2147483646");
shouldBe("-2147483650 >> 0", "2147483646");
shouldBe("2147483650 >>> 0", "2147483650");
shouldBe("-2147483650 >>> 0", "2147483646");
shouldBe("4294967300 >> 0", "4");
shouldBe("-4294967300 >> 0", "-4");
shouldBe("4294967300 >>> 0", "4");
shouldBe("-4294967300 >>> 0", "4294967292");
shouldBe("8589934600 >> 0", "8");
shouldBe("-8589934600 >> 0", "-8");
shouldBe("8589934600 >>> 0", "8");
shouldBe("-8589934600 >>> 0", "4294967288");
shouldBe("17179869200 >> 0", "16");
shouldBe("-17179869200 >> 0", "-16");
shouldBe("17179869200 >>> 0", "16");
shouldBe("-17179869200 >>> 0", "4294967280");
shouldBe("34359738400 >> 0", "32");
shouldBe("-34359738400 >> 0", "-32");
shouldBe("34359738400 >>> 0", "32");
shouldBe("-34359738400 >>> 0", "4294967264");
shouldBe("68719476800 >> 0", "64");
shouldBe("-68719476800 >> 0", "-64");
shouldBe("68719476800 >>> 0", "64");
shouldBe("-68719476800 >>> 0", "4294967232");
shouldBe("137438953600 >> 0", "128");
shouldBe("-137438953600 >> 0", "-128");
shouldBe("137438953600 >>> 0", "128");
shouldBe("-137438953600 >>> 0", "4294967168");
shouldBe("274877907200 >> 0", "256");
shouldBe("-274877907200 >> 0", "-256");
shouldBe("274877907200 >>> 0", "256");
shouldBe("-274877907200 >>> 0", "4294967040");
shouldBe("549755814400 >> 0", "512");
shouldBe("-549755814400 >> 0", "-512");
shouldBe("549755814400 >>> 0", "512");
shouldBe("-549755814400 >>> 0", "4294966784");
shouldBe("1099511628800 >> 0", "1024");
shouldBe("-1099511628800 >> 0", "-1024");
shouldBe("1099511628800 >>> 0", "1024");
shouldBe("-1099511628800 >>> 0", "4294966272");
shouldBe("2199023257600 >> 0", "2048");
shouldBe("-2199023257600 >> 0", "-2048");
shouldBe("2199023257600 >>> 0", "2048");
shouldBe("-2199023257600 >>> 0", "4294965248");
shouldBe("4398046515200 >> 0", "4096");
shouldBe("-4398046515200 >> 0", "-4096");
shouldBe("4398046515200 >>> 0", "4096");
shouldBe("-4398046515200 >>> 0", "4294963200");
shouldBe("8796093030400 >> 0", "8192");
shouldBe("-8796093030400 >> 0", "-8192");
shouldBe("8796093030400 >>> 0", "8192");
shouldBe("-8796093030400 >>> 0", "4294959104");
shouldBe("17592186060800 >> 0", "16384");
shouldBe("-17592186060800 >> 0", "-16384");
shouldBe("17592186060800 >>> 0", "16384");
shouldBe("-17592186060800 >>> 0", "4294950912");
shouldBe("35184372121600 >> 0", "32768");
shouldBe("-35184372121600 >> 0", "-32768");
shouldBe("35184372121600 >>> 0", "32768");
shouldBe("-35184372121600 >>> 0", "4294934528");
shouldBe("70368744243200 >> 0", "65536");
shouldBe("-70368744243200 >> 0", "-65536");
shouldBe("70368744243200 >>> 0", "65536");
shouldBe("-70368744243200 >>> 0", "4294901760");
shouldBe("140737488486400 >> 0", "131072");
shouldBe("-140737488486400 >> 0", "-131072");
shouldBe("140737488486400 >>> 0", "131072");
shouldBe("-140737488486400 >>> 0", "4294836224");
shouldBe("281474976972800 >> 0", "262144");
shouldBe("-281474976972800 >> 0", "-262144");
shouldBe("281474976972800 >>> 0", "262144");
shouldBe("-281474976972800 >>> 0", "4294705152");
shouldBe("562949953945600 >> 0", "524288");
shouldBe("-562949953945600 >> 0", "-524288");
shouldBe("562949953945600 >>> 0", "524288");
shouldBe("-562949953945600 >>> 0", "4294443008");
shouldBe("1125899907891200 >> 0", "1048576");
shouldBe("-1125899907891200 >> 0", "-1048576");
shouldBe("1125899907891200 >>> 0", "1048576");
shouldBe("-1125899907891200 >>> 0", "4293918720");
shouldBe("2251799815782400 >> 0", "2097152");
shouldBe("-2251799815782400 >> 0", "-2097152");
shouldBe("2251799815782400 >>> 0", "2097152");
shouldBe("-2251799815782400 >>> 0", "4292870144");
shouldBe("4503599631564800 >> 0", "4194304");
shouldBe("-4503599631564800 >> 0", "-4194304");
shouldBe("4503599631564800 >>> 0", "4194304");
shouldBe("-4503599631564800 >>> 0", "4290772992");
shouldBe("9007199263129600 >> 0", "8388608");
shouldBe("-9007199263129600 >> 0", "-8388608");
shouldBe("9007199263129600 >>> 0", "8388608");
shouldBe("-9007199263129600 >>> 0", "4286578688");
shouldBe("18014398526259200 >> 0", "16777216");
shouldBe("-18014398526259200 >> 0", "-16777216");
shouldBe("18014398526259200 >>> 0", "16777216");
shouldBe("-18014398526259200 >>> 0", "4278190080");
shouldBe("36028797052518400 >> 0", "33554432");
shouldBe("-36028797052518400 >> 0", "-33554432");
shouldBe("36028797052518400 >>> 0", "33554432");
shouldBe("-36028797052518400 >>> 0", "4261412864");
shouldBe("72057594105036800 >> 0", "67108864");
shouldBe("-72057594105036800 >> 0", "-67108864");
shouldBe("72057594105036800 >>> 0", "67108864");
shouldBe("-72057594105036800 >>> 0", "4227858432");
shouldBe("144115188210073600 >> 0", "134217728");
shouldBe("-144115188210073600 >> 0", "-134217728");
shouldBe("144115188210073600 >>> 0", "134217728");
shouldBe("-144115188210073600 >>> 0", "4160749568");
shouldBe("288230376420147200 >> 0", "268435456");
shouldBe("-288230376420147200 >> 0", "-268435456");
shouldBe("288230376420147200 >>> 0", "268435456");
shouldBe("-288230376420147200 >>> 0", "4026531840");
shouldBe("576460752840294400 >> 0", "536870912");
shouldBe("-576460752840294400 >> 0", "-536870912");
shouldBe("576460752840294400 >>> 0", "536870912");
shouldBe("-576460752840294400 >>> 0", "3758096384");
shouldBe("1152921505680588800 >> 0", "1073741824");
shouldBe("-1152921505680588800 >> 0", "-1073741824");
shouldBe("1152921505680588800 >>> 0", "1073741824");
shouldBe("-1152921505680588800 >>> 0", "3221225472");
shouldBe("2305843011361177600 >> 0", "-2147483648");
shouldBe("-2305843011361177600 >> 0", "-2147483648");
shouldBe("2305843011361177600 >>> 0", "2147483648");
shouldBe("-2305843011361177600 >>> 0", "2147483648");
shouldBe("4611686022722355000 >> 0", "0");
shouldBe("-4611686022722355000 >> 0", "0");
shouldBe("4611686022722355000 >>> 0", "0");
shouldBe("-4611686022722355000 >>> 0", "0");
shouldBe("5.96046448031462e-8 >> 0", "0");
shouldBe("-5.96046448031462e-8 >> 0", "0");
shouldBe("5.96046448031462e-8 >>> 0", "0");
shouldBe("-5.96046448031462e-8 >>> 0", "0");
shouldBe("1.192092896062924e-7 >> 0", "0");
shouldBe("-1.192092896062924e-7 >> 0", "0");
shouldBe("1.192092896062924e-7 >>> 0", "0");
shouldBe("-1.192092896062924e-7 >>> 0", "0");
shouldBe("2.384185792125848e-7 >> 0", "0");
shouldBe("-2.384185792125848e-7 >> 0", "0");
shouldBe("2.384185792125848e-7 >>> 0", "0");
shouldBe("-2.384185792125848e-7 >>> 0", "0");
shouldBe("4.768371584251696e-7 >> 0", "0");
shouldBe("-4.768371584251696e-7 >> 0", "0");
shouldBe("4.768371584251696e-7 >>> 0", "0");
shouldBe("-4.768371584251696e-7 >>> 0", "0");
shouldBe("9.536743168503392e-7 >> 0", "0");
shouldBe("-9.536743168503392e-7 >> 0", "0");
shouldBe("9.536743168503392e-7 >>> 0", "0");
shouldBe("-9.536743168503392e-7 >>> 0", "0");
shouldBe("0.0000019073486337006784 >> 0", "0");
shouldBe("-0.0000019073486337006784 >> 0", "0");
shouldBe("0.0000019073486337006784 >>> 0", "0");
shouldBe("-0.0000019073486337006784 >>> 0", "0");
shouldBe("0.000003814697267401357 >> 0", "0");
shouldBe("-0.000003814697267401357 >> 0", "0");
shouldBe("0.000003814697267401357 >>> 0", "0");
shouldBe("-0.000003814697267401357 >>> 0", "0");
shouldBe("0.000007629394534802714 >> 0", "0");
shouldBe("-0.000007629394534802714 >> 0", "0");
shouldBe("0.000007629394534802714 >>> 0", "0");
shouldBe("-0.000007629394534802714 >>> 0", "0");
shouldBe("0.000015258789069605427 >> 0", "0");
shouldBe("-0.000015258789069605427 >> 0", "0");
shouldBe("0.000015258789069605427 >>> 0", "0");
shouldBe("-0.000015258789069605427 >>> 0", "0");
shouldBe("0.000030517578139210855 >> 0", "0");
shouldBe("-0.000030517578139210855 >> 0", "0");
shouldBe("0.000030517578139210855 >>> 0", "0");
shouldBe("-0.000030517578139210855 >>> 0", "0");
shouldBe("0.00006103515627842171 >> 0", "0");
shouldBe("-0.00006103515627842171 >> 0", "0");
shouldBe("0.00006103515627842171 >>> 0", "0");
shouldBe("-0.00006103515627842171 >>> 0", "0");
shouldBe("0.00012207031255684342 >> 0", "0");
shouldBe("-0.00012207031255684342 >> 0", "0");
shouldBe("0.00012207031255684342 >>> 0", "0");
shouldBe("-0.00012207031255684342 >>> 0", "0");
shouldBe("0.00024414062511368684 >> 0", "0");
shouldBe("-0.00024414062511368684 >> 0", "0");
shouldBe("0.00024414062511368684 >>> 0", "0");
shouldBe("-0.00024414062511368684 >>> 0", "0");
shouldBe("0.0004882812502273737 >> 0", "0");
shouldBe("-0.0004882812502273737 >> 0", "0");
shouldBe("0.0004882812502273737 >>> 0", "0");
shouldBe("-0.0004882812502273737 >>> 0", "0");
shouldBe("0.0009765625004547474 >> 0", "0");
shouldBe("-0.0009765625004547474 >> 0", "0");
shouldBe("0.0009765625004547474 >>> 0", "0");
shouldBe("-0.0009765625004547474 >>> 0", "0");
shouldBe("0.0019531250009094947 >> 0", "0");
shouldBe("-0.0019531250009094947 >> 0", "0");
shouldBe("0.0019531250009094947 >>> 0", "0");
shouldBe("-0.0019531250009094947 >>> 0", "0");
shouldBe("0.003906250001818989 >> 0", "0");
shouldBe("-0.003906250001818989 >> 0", "0");
shouldBe("0.003906250001818989 >>> 0", "0");
shouldBe("-0.003906250001818989 >>> 0", "0");
shouldBe("0.007812500003637979 >> 0", "0");
shouldBe("-0.007812500003637979 >> 0", "0");
shouldBe("0.007812500003637979 >>> 0", "0");
shouldBe("-0.007812500003637979 >>> 0", "0");
shouldBe("0.015625000007275958 >> 0", "0");
shouldBe("-0.015625000007275958 >> 0", "0");
shouldBe("0.015625000007275958 >>> 0", "0");
shouldBe("-0.015625000007275958 >>> 0", "0");
shouldBe("0.031250000014551915 >> 0", "0");
shouldBe("-0.031250000014551915 >> 0", "0");
shouldBe("0.031250000014551915 >>> 0", "0");
shouldBe("-0.031250000014551915 >>> 0", "0");
shouldBe("0.06250000002910383 >> 0", "0");
shouldBe("-0.06250000002910383 >> 0", "0");
shouldBe("0.06250000002910383 >>> 0", "0");
shouldBe("-0.06250000002910383 >>> 0", "0");
shouldBe("0.12500000005820766 >> 0", "0");
shouldBe("-0.12500000005820766 >> 0", "0");
shouldBe("0.12500000005820766 >>> 0", "0");
shouldBe("-0.12500000005820766 >>> 0", "0");
shouldBe("0.2500000001164153 >> 0", "0");
shouldBe("-0.2500000001164153 >> 0", "0");
shouldBe("0.2500000001164153 >>> 0", "0");
shouldBe("-0.2500000001164153 >>> 0", "0");
shouldBe("0.5000000002328306 >> 0", "0");
shouldBe("-0.5000000002328306 >> 0", "0");
shouldBe("0.5000000002328306 >>> 0", "0");
shouldBe("-0.5000000002328306 >>> 0", "0");
shouldBe("1.0000000004656613 >> 0", "1");
shouldBe("-1.0000000004656613 >> 0", "-1");
shouldBe("1.0000000004656613 >>> 0", "1");
shouldBe("-1.0000000004656613 >>> 0", "4294967295");
shouldBe("2.0000000009313226 >> 0", "2");
shouldBe("-2.0000000009313226 >> 0", "-2");
shouldBe("2.0000000009313226 >>> 0", "2");
shouldBe("-2.0000000009313226 >>> 0", "4294967294");
shouldBe("4.000000001862645 >> 0", "4");
shouldBe("-4.000000001862645 >> 0", "-4");
shouldBe("4.000000001862645 >>> 0", "4");
shouldBe("-4.000000001862645 >>> 0", "4294967292");
shouldBe("8.00000000372529 >> 0", "8");
shouldBe("-8.00000000372529 >> 0", "-8");
shouldBe("8.00000000372529 >>> 0", "8");
shouldBe("-8.00000000372529 >>> 0", "4294967288");
shouldBe("16.00000000745058 >> 0", "16");
shouldBe("-16.00000000745058 >> 0", "-16");
shouldBe("16.00000000745058 >>> 0", "16");
shouldBe("-16.00000000745058 >>> 0", "4294967280");
shouldBe("32.00000001490116 >> 0", "32");
shouldBe("-32.00000001490116 >> 0", "-32");
shouldBe("32.00000001490116 >>> 0", "32");
shouldBe("-32.00000001490116 >>> 0", "4294967264");
shouldBe("64.00000002980232 >> 0", "64");
shouldBe("-64.00000002980232 >> 0", "-64");
shouldBe("64.00000002980232 >>> 0", "64");
shouldBe("-64.00000002980232 >>> 0", "4294967232");
shouldBe("128.00000005960464 >> 0", "128");
shouldBe("-128.00000005960464 >> 0", "-128");
shouldBe("128.00000005960464 >>> 0", "128");
shouldBe("-128.00000005960464 >>> 0", "4294967168");
shouldBe("256.0000001192093 >> 0", "256");
shouldBe("-256.0000001192093 >> 0", "-256");
shouldBe("256.0000001192093 >>> 0", "256");
shouldBe("-256.0000001192093 >>> 0", "4294967040");
shouldBe("512.0000002384186 >> 0", "512");
shouldBe("-512.0000002384186 >> 0", "-512");
shouldBe("512.0000002384186 >>> 0", "512");
shouldBe("-512.0000002384186 >>> 0", "4294966784");
shouldBe("1024.0000004768372 >> 0", "1024");
shouldBe("-1024.0000004768372 >> 0", "-1024");
shouldBe("1024.0000004768372 >>> 0", "1024");
shouldBe("-1024.0000004768372 >>> 0", "4294966272");
shouldBe("2048.0000009536743 >> 0", "2048");
shouldBe("-2048.0000009536743 >> 0", "-2048");
shouldBe("2048.0000009536743 >>> 0", "2048");
shouldBe("-2048.0000009536743 >>> 0", "4294965248");
shouldBe("4096.000001907349 >> 0", "4096");
shouldBe("-4096.000001907349 >> 0", "-4096");
shouldBe("4096.000001907349 >>> 0", "4096");
shouldBe("-4096.000001907349 >>> 0", "4294963200");
shouldBe("8192.000003814697 >> 0", "8192");
shouldBe("-8192.000003814697 >> 0", "-8192");
shouldBe("8192.000003814697 >>> 0", "8192");
shouldBe("-8192.000003814697 >>> 0", "4294959104");
shouldBe("16384.000007629395 >> 0", "16384");
shouldBe("-16384.000007629395 >> 0", "-16384");
shouldBe("16384.000007629395 >>> 0", "16384");
shouldBe("-16384.000007629395 >>> 0", "4294950912");
shouldBe("32768.00001525879 >> 0", "32768");
shouldBe("-32768.00001525879 >> 0", "-32768");
shouldBe("32768.00001525879 >>> 0", "32768");
shouldBe("-32768.00001525879 >>> 0", "4294934528");
shouldBe("65536.00003051758 >> 0", "65536");
shouldBe("-65536.00003051758 >> 0", "-65536");
shouldBe("65536.00003051758 >>> 0", "65536");
shouldBe("-65536.00003051758 >>> 0", "4294901760");
shouldBe("131072.00006103516 >> 0", "131072");
shouldBe("-131072.00006103516 >> 0", "-131072");
shouldBe("131072.00006103516 >>> 0", "131072");
shouldBe("-131072.00006103516 >>> 0", "4294836224");
shouldBe("262144.0001220703 >> 0", "262144");
shouldBe("-262144.0001220703 >> 0", "-262144");
shouldBe("262144.0001220703 >>> 0", "262144");
shouldBe("-262144.0001220703 >>> 0", "4294705152");
shouldBe("524288.0002441406 >> 0", "524288");
shouldBe("-524288.0002441406 >> 0", "-524288");
shouldBe("524288.0002441406 >>> 0", "524288");
shouldBe("-524288.0002441406 >>> 0", "4294443008");
shouldBe("1048576.0004882813 >> 0", "1048576");
shouldBe("-1048576.0004882813 >> 0", "-1048576");
shouldBe("1048576.0004882813 >>> 0", "1048576");
shouldBe("-1048576.0004882813 >>> 0", "4293918720");
shouldBe("2097152.0009765625 >> 0", "2097152");
shouldBe("-2097152.0009765625 >> 0", "-2097152");
shouldBe("2097152.0009765625 >>> 0", "2097152");
shouldBe("-2097152.0009765625 >>> 0", "4292870144");
shouldBe("4194304.001953125 >> 0", "4194304");
shouldBe("-4194304.001953125 >> 0", "-4194304");
shouldBe("4194304.001953125 >>> 0", "4194304");
shouldBe("-4194304.001953125 >>> 0", "4290772992");
shouldBe("8388608.00390625 >> 0", "8388608");
shouldBe("-8388608.00390625 >> 0", "-8388608");
shouldBe("8388608.00390625 >>> 0", "8388608");
shouldBe("-8388608.00390625 >>> 0", "4286578688");
shouldBe("16777216.0078125 >> 0", "16777216");
shouldBe("-16777216.0078125 >> 0", "-16777216");
shouldBe("16777216.0078125 >>> 0", "16777216");
shouldBe("-16777216.0078125 >>> 0", "4278190080");
shouldBe("33554432.015625 >> 0", "33554432");
shouldBe("-33554432.015625 >> 0", "-33554432");
shouldBe("33554432.015625 >>> 0", "33554432");
shouldBe("-33554432.015625 >>> 0", "4261412864");
shouldBe("67108864.03125 >> 0", "67108864");
shouldBe("-67108864.03125 >> 0", "-67108864");
shouldBe("67108864.03125 >>> 0", "67108864");
shouldBe("-67108864.03125 >>> 0", "4227858432");
shouldBe("134217728.0625 >> 0", "134217728");
shouldBe("-134217728.0625 >> 0", "-134217728");
shouldBe("134217728.0625 >>> 0", "134217728");
shouldBe("-134217728.0625 >>> 0", "4160749568");
shouldBe("268435456.125 >> 0", "268435456");
shouldBe("-268435456.125 >> 0", "-268435456");
shouldBe("268435456.125 >>> 0", "268435456");
shouldBe("-268435456.125 >>> 0", "4026531840");
shouldBe("536870912.25 >> 0", "536870912");
shouldBe("-536870912.25 >> 0", "-536870912");
shouldBe("536870912.25 >>> 0", "536870912");
shouldBe("-536870912.25 >>> 0", "3758096384");
shouldBe("1073741824.5 >> 0", "1073741824");
shouldBe("-1073741824.5 >> 0", "-1073741824");
shouldBe("1073741824.5 >>> 0", "1073741824");
shouldBe("-1073741824.5 >>> 0", "3221225472");
shouldBe("2147483649 >> 0", "-2147483647");
shouldBe("-2147483649 >> 0", "2147483647");
shouldBe("2147483649 >>> 0", "2147483649");
shouldBe("-2147483649 >>> 0", "2147483647");
shouldBe("4294967298 >> 0", "2");
shouldBe("-4294967298 >> 0", "-2");
shouldBe("4294967298 >>> 0", "2");
shouldBe("-4294967298 >>> 0", "4294967294");
shouldBe("8589934596 >> 0", "4");
shouldBe("-8589934596 >> 0", "-4");
shouldBe("8589934596 >>> 0", "4");
shouldBe("-8589934596 >>> 0", "4294967292");
shouldBe("17179869192 >> 0", "8");
shouldBe("-17179869192 >> 0", "-8");
shouldBe("17179869192 >>> 0", "8");
shouldBe("-17179869192 >>> 0", "4294967288");
shouldBe("34359738384 >> 0", "16");
shouldBe("-34359738384 >> 0", "-16");
shouldBe("34359738384 >>> 0", "16");
shouldBe("-34359738384 >>> 0", "4294967280");
shouldBe("68719476768 >> 0", "32");
shouldBe("-68719476768 >> 0", "-32");
shouldBe("68719476768 >>> 0", "32");
shouldBe("-68719476768 >>> 0", "4294967264");
shouldBe("137438953536 >> 0", "64");
shouldBe("-137438953536 >> 0", "-64");
shouldBe("137438953536 >>> 0", "64");
shouldBe("-137438953536 >>> 0", "4294967232");
shouldBe("274877907072 >> 0", "128");
shouldBe("-274877907072 >> 0", "-128");
shouldBe("274877907072 >>> 0", "128");
shouldBe("-274877907072 >>> 0", "4294967168");
shouldBe("549755814144 >> 0", "256");
shouldBe("-549755814144 >> 0", "-256");
shouldBe("549755814144 >>> 0", "256");
shouldBe("-549755814144 >>> 0", "4294967040");
shouldBe("1099511628288 >> 0", "512");
shouldBe("-1099511628288 >> 0", "-512");
shouldBe("1099511628288 >>> 0", "512");
shouldBe("-1099511628288 >>> 0", "4294966784");
shouldBe("2199023256576 >> 0", "1024");
shouldBe("-2199023256576 >> 0", "-1024");
shouldBe("2199023256576 >>> 0", "1024");
shouldBe("-2199023256576 >>> 0", "4294966272");
shouldBe("4398046513152 >> 0", "2048");
shouldBe("-4398046513152 >> 0", "-2048");
shouldBe("4398046513152 >>> 0", "2048");
shouldBe("-4398046513152 >>> 0", "4294965248");
shouldBe("8796093026304 >> 0", "4096");
shouldBe("-8796093026304 >> 0", "-4096");
shouldBe("8796093026304 >>> 0", "4096");
shouldBe("-8796093026304 >>> 0", "4294963200");
shouldBe("17592186052608 >> 0", "8192");
shouldBe("-17592186052608 >> 0", "-8192");
shouldBe("17592186052608 >>> 0", "8192");
shouldBe("-17592186052608 >>> 0", "4294959104");
shouldBe("35184372105216 >> 0", "16384");
shouldBe("-35184372105216 >> 0", "-16384");
shouldBe("35184372105216 >>> 0", "16384");
shouldBe("-35184372105216 >>> 0", "4294950912");
shouldBe("70368744210432 >> 0", "32768");
shouldBe("-70368744210432 >> 0", "-32768");
shouldBe("70368744210432 >>> 0", "32768");
shouldBe("-70368744210432 >>> 0", "4294934528");
shouldBe("140737488420864 >> 0", "65536");
shouldBe("-140737488420864 >> 0", "-65536");
shouldBe("140737488420864 >>> 0", "65536");
shouldBe("-140737488420864 >>> 0", "4294901760");
shouldBe("281474976841728 >> 0", "131072");
shouldBe("-281474976841728 >> 0", "-131072");
shouldBe("281474976841728 >>> 0", "131072");
shouldBe("-281474976841728 >>> 0", "4294836224");
shouldBe("562949953683456 >> 0", "262144");
shouldBe("-562949953683456 >> 0", "-262144");
shouldBe("562949953683456 >>> 0", "262144");
shouldBe("-562949953683456 >>> 0", "4294705152");
shouldBe("1125899907366912 >> 0", "524288");
shouldBe("-1125899907366912 >> 0", "-524288");
shouldBe("1125899907366912 >>> 0", "524288");
shouldBe("-1125899907366912 >>> 0", "4294443008");
shouldBe("2251799814733824 >> 0", "1048576");
shouldBe("-2251799814733824 >> 0", "-1048576");
shouldBe("2251799814733824 >>> 0", "1048576");
shouldBe("-2251799814733824 >>> 0", "4293918720");
shouldBe("4503599629467648 >> 0", "2097152");
shouldBe("-4503599629467648 >> 0", "-2097152");
shouldBe("4503599629467648 >>> 0", "2097152");
shouldBe("-4503599629467648 >>> 0", "4292870144");
shouldBe("9007199258935296 >> 0", "4194304");
shouldBe("-9007199258935296 >> 0", "-4194304");
shouldBe("9007199258935296 >>> 0", "4194304");
shouldBe("-9007199258935296 >>> 0", "4290772992");
shouldBe("18014398517870590 >> 0", "8388608");
shouldBe("-18014398517870590 >> 0", "-8388608");
shouldBe("18014398517870590 >>> 0", "8388608");
shouldBe("-18014398517870590 >>> 0", "4286578688");
shouldBe("36028797035741180 >> 0", "16777216");
shouldBe("-36028797035741180 >> 0", "-16777216");
shouldBe("36028797035741180 >>> 0", "16777216");
shouldBe("-36028797035741180 >>> 0", "4278190080");
shouldBe("72057594071482370 >> 0", "33554432");
shouldBe("-72057594071482370 >> 0", "-33554432");
shouldBe("72057594071482370 >>> 0", "33554432");
shouldBe("-72057594071482370 >>> 0", "4261412864");
shouldBe("144115188142964740 >> 0", "67108864");
shouldBe("-144115188142964740 >> 0", "-67108864");
shouldBe("144115188142964740 >>> 0", "67108864");
shouldBe("-144115188142964740 >>> 0", "4227858432");
shouldBe("288230376285929500 >> 0", "134217728");
shouldBe("-288230376285929500 >> 0", "-134217728");
shouldBe("288230376285929500 >>> 0", "134217728");
shouldBe("-288230376285929500 >>> 0", "4160749568");
shouldBe("576460752571859000 >> 0", "268435456");
shouldBe("-576460752571859000 >> 0", "-268435456");
shouldBe("576460752571859000 >>> 0", "268435456");
shouldBe("-576460752571859000 >>> 0", "4026531840");
shouldBe("1152921505143718000 >> 0", "536870912");
shouldBe("-1152921505143718000 >> 0", "-536870912");
shouldBe("1152921505143718000 >>> 0", "536870912");
shouldBe("-1152921505143718000 >>> 0", "3758096384");
shouldBe("2305843010287436000 >> 0", "1073741824");
shouldBe("-2305843010287436000 >> 0", "-1073741824");
shouldBe("2305843010287436000 >>> 0", "1073741824");
shouldBe("-2305843010287436000 >>> 0", "3221225472");
shouldBe("4611686020574872000 >> 0", "-2147483648");
shouldBe("-4611686020574872000 >> 0", "-2147483648");
shouldBe("4611686020574872000 >>> 0", "2147483648");
shouldBe("-4611686020574872000 >>> 0", "2147483648");
shouldBe("9223372041149743000 >> 0", "0");
shouldBe("-9223372041149743000 >> 0", "0");
shouldBe("9223372041149743000 >>> 0", "0");
shouldBe("-9223372041149743000 >>> 0", "0");
shouldBe("1.1920928957853683e-7 >> 0", "0");
shouldBe("-1.1920928957853683e-7 >> 0", "0");
shouldBe("1.1920928957853683e-7 >>> 0", "0");
shouldBe("-1.1920928957853683e-7 >>> 0", "0");
shouldBe("2.3841857915707365e-7 >> 0", "0");
shouldBe("-2.3841857915707365e-7 >> 0", "0");
shouldBe("2.3841857915707365e-7 >>> 0", "0");
shouldBe("-2.3841857915707365e-7 >>> 0", "0");
shouldBe("4.768371583141473e-7 >> 0", "0");
shouldBe("-4.768371583141473e-7 >> 0", "0");
shouldBe("4.768371583141473e-7 >>> 0", "0");
shouldBe("-4.768371583141473e-7 >>> 0", "0");
shouldBe("9.536743166282946e-7 >> 0", "0");
shouldBe("-9.536743166282946e-7 >> 0", "0");
shouldBe("9.536743166282946e-7 >>> 0", "0");
shouldBe("-9.536743166282946e-7 >>> 0", "0");
shouldBe("0.000001907348633256589 >> 0", "0");
shouldBe("-0.000001907348633256589 >> 0", "0");
shouldBe("0.000001907348633256589 >>> 0", "0");
shouldBe("-0.000001907348633256589 >>> 0", "0");
shouldBe("0.000003814697266513178 >> 0", "0");
shouldBe("-0.000003814697266513178 >> 0", "0");
shouldBe("0.000003814697266513178 >>> 0", "0");
shouldBe("-0.000003814697266513178 >>> 0", "0");
shouldBe("0.000007629394533026357 >> 0", "0");
shouldBe("-0.000007629394533026357 >> 0", "0");
shouldBe("0.000007629394533026357 >>> 0", "0");
shouldBe("-0.000007629394533026357 >>> 0", "0");
shouldBe("0.000015258789066052714 >> 0", "0");
shouldBe("-0.000015258789066052714 >> 0", "0");
shouldBe("0.000015258789066052714 >>> 0", "0");
shouldBe("-0.000015258789066052714 >>> 0", "0");
shouldBe("0.00003051757813210543 >> 0", "0");
shouldBe("-0.00003051757813210543 >> 0", "0");
shouldBe("0.00003051757813210543 >>> 0", "0");
shouldBe("-0.00003051757813210543 >>> 0", "0");
shouldBe("0.00006103515626421085 >> 0", "0");
shouldBe("-0.00006103515626421085 >> 0", "0");
shouldBe("0.00006103515626421085 >>> 0", "0");
shouldBe("-0.00006103515626421085 >>> 0", "0");
shouldBe("0.0001220703125284217 >> 0", "0");
shouldBe("-0.0001220703125284217 >> 0", "0");
shouldBe("0.0001220703125284217 >>> 0", "0");
shouldBe("-0.0001220703125284217 >>> 0", "0");
shouldBe("0.0002441406250568434 >> 0", "0");
shouldBe("-0.0002441406250568434 >> 0", "0");
shouldBe("0.0002441406250568434 >>> 0", "0");
shouldBe("-0.0002441406250568434 >>> 0", "0");
shouldBe("0.0004882812501136868 >> 0", "0");
shouldBe("-0.0004882812501136868 >> 0", "0");
shouldBe("0.0004882812501136868 >>> 0", "0");
shouldBe("-0.0004882812501136868 >>> 0", "0");
shouldBe("0.0009765625002273737 >> 0", "0");
shouldBe("-0.0009765625002273737 >> 0", "0");
shouldBe("0.0009765625002273737 >>> 0", "0");
shouldBe("-0.0009765625002273737 >>> 0", "0");
shouldBe("0.0019531250004547474 >> 0", "0");
shouldBe("-0.0019531250004547474 >> 0", "0");
shouldBe("0.0019531250004547474 >>> 0", "0");
shouldBe("-0.0019531250004547474 >>> 0", "0");
shouldBe("0.003906250000909495 >> 0", "0");
shouldBe("-0.003906250000909495 >> 0", "0");
shouldBe("0.003906250000909495 >>> 0", "0");
shouldBe("-0.003906250000909495 >>> 0", "0");
shouldBe("0.00781250000181899 >> 0", "0");
shouldBe("-0.00781250000181899 >> 0", "0");
shouldBe("0.00781250000181899 >>> 0", "0");
shouldBe("-0.00781250000181899 >>> 0", "0");
shouldBe("0.01562500000363798 >> 0", "0");
shouldBe("-0.01562500000363798 >> 0", "0");
shouldBe("0.01562500000363798 >>> 0", "0");
shouldBe("-0.01562500000363798 >>> 0", "0");
shouldBe("0.03125000000727596 >> 0", "0");
shouldBe("-0.03125000000727596 >> 0", "0");
shouldBe("0.03125000000727596 >>> 0", "0");
shouldBe("-0.03125000000727596 >>> 0", "0");
shouldBe("0.06250000001455192 >> 0", "0");
shouldBe("-0.06250000001455192 >> 0", "0");
shouldBe("0.06250000001455192 >>> 0", "0");
shouldBe("-0.06250000001455192 >>> 0", "0");
shouldBe("0.12500000002910383 >> 0", "0");
shouldBe("-0.12500000002910383 >> 0", "0");
shouldBe("0.12500000002910383 >>> 0", "0");
shouldBe("-0.12500000002910383 >>> 0", "0");
shouldBe("0.25000000005820766 >> 0", "0");
shouldBe("-0.25000000005820766 >> 0", "0");
shouldBe("0.25000000005820766 >>> 0", "0");
shouldBe("-0.25000000005820766 >>> 0", "0");
shouldBe("0.5000000001164153 >> 0", "0");
shouldBe("-0.5000000001164153 >> 0", "0");
shouldBe("0.5000000001164153 >>> 0", "0");
shouldBe("-0.5000000001164153 >>> 0", "0");
shouldBe("1.0000000002328306 >> 0", "1");
shouldBe("-1.0000000002328306 >> 0", "-1");
shouldBe("1.0000000002328306 >>> 0", "1");
shouldBe("-1.0000000002328306 >>> 0", "4294967295");
shouldBe("2.0000000004656613 >> 0", "2");
shouldBe("-2.0000000004656613 >> 0", "-2");
shouldBe("2.0000000004656613 >>> 0", "2");
shouldBe("-2.0000000004656613 >>> 0", "4294967294");
shouldBe("4.000000000931323 >> 0", "4");
shouldBe("-4.000000000931323 >> 0", "-4");
shouldBe("4.000000000931323 >>> 0", "4");
shouldBe("-4.000000000931323 >>> 0", "4294967292");
shouldBe("8.000000001862645 >> 0", "8");
shouldBe("-8.000000001862645 >> 0", "-8");
shouldBe("8.000000001862645 >>> 0", "8");
shouldBe("-8.000000001862645 >>> 0", "4294967288");
shouldBe("16.00000000372529 >> 0", "16");
shouldBe("-16.00000000372529 >> 0", "-16");
shouldBe("16.00000000372529 >>> 0", "16");
shouldBe("-16.00000000372529 >>> 0", "4294967280");
shouldBe("32.00000000745058 >> 0", "32");
shouldBe("-32.00000000745058 >> 0", "-32");
shouldBe("32.00000000745058 >>> 0", "32");
shouldBe("-32.00000000745058 >>> 0", "4294967264");
shouldBe("64.00000001490116 >> 0", "64");
shouldBe("-64.00000001490116 >> 0", "-64");
shouldBe("64.00000001490116 >>> 0", "64");
shouldBe("-64.00000001490116 >>> 0", "4294967232");
shouldBe("128.00000002980232 >> 0", "128");
shouldBe("-128.00000002980232 >> 0", "-128");
shouldBe("128.00000002980232 >>> 0", "128");
shouldBe("-128.00000002980232 >>> 0", "4294967168");
shouldBe("256.00000005960464 >> 0", "256");
shouldBe("-256.00000005960464 >> 0", "-256");
shouldBe("256.00000005960464 >>> 0", "256");
shouldBe("-256.00000005960464 >>> 0", "4294967040");
shouldBe("512.0000001192093 >> 0", "512");
shouldBe("-512.0000001192093 >> 0", "-512");
shouldBe("512.0000001192093 >>> 0", "512");
shouldBe("-512.0000001192093 >>> 0", "4294966784");
shouldBe("1024.0000002384186 >> 0", "1024");
shouldBe("-1024.0000002384186 >> 0", "-1024");
shouldBe("1024.0000002384186 >>> 0", "1024");
shouldBe("-1024.0000002384186 >>> 0", "4294966272");
shouldBe("2048.000000476837 >> 0", "2048");
shouldBe("-2048.000000476837 >> 0", "-2048");
shouldBe("2048.000000476837 >>> 0", "2048");
shouldBe("-2048.000000476837 >>> 0", "4294965248");
shouldBe("4096.000000953674 >> 0", "4096");
shouldBe("-4096.000000953674 >> 0", "-4096");
shouldBe("4096.000000953674 >>> 0", "4096");
shouldBe("-4096.000000953674 >>> 0", "4294963200");
shouldBe("8192.000001907349 >> 0", "8192");
shouldBe("-8192.000001907349 >> 0", "-8192");
shouldBe("8192.000001907349 >>> 0", "8192");
shouldBe("-8192.000001907349 >>> 0", "4294959104");
shouldBe("16384.000003814697 >> 0", "16384");
shouldBe("-16384.000003814697 >> 0", "-16384");
shouldBe("16384.000003814697 >>> 0", "16384");
shouldBe("-16384.000003814697 >>> 0", "4294950912");
shouldBe("32768.000007629395 >> 0", "32768");
shouldBe("-32768.000007629395 >> 0", "-32768");
shouldBe("32768.000007629395 >>> 0", "32768");
shouldBe("-32768.000007629395 >>> 0", "4294934528");
shouldBe("65536.00001525879 >> 0", "65536");
shouldBe("-65536.00001525879 >> 0", "-65536");
shouldBe("65536.00001525879 >>> 0", "65536");
shouldBe("-65536.00001525879 >>> 0", "4294901760");
shouldBe("131072.00003051758 >> 0", "131072");
shouldBe("-131072.00003051758 >> 0", "-131072");
shouldBe("131072.00003051758 >>> 0", "131072");
shouldBe("-131072.00003051758 >>> 0", "4294836224");
shouldBe("262144.00006103516 >> 0", "262144");
shouldBe("-262144.00006103516 >> 0", "-262144");
shouldBe("262144.00006103516 >>> 0", "262144");
shouldBe("-262144.00006103516 >>> 0", "4294705152");
shouldBe("524288.0001220703 >> 0", "524288");
shouldBe("-524288.0001220703 >> 0", "-524288");
shouldBe("524288.0001220703 >>> 0", "524288");
shouldBe("-524288.0001220703 >>> 0", "4294443008");
shouldBe("1048576.0002441406 >> 0", "1048576");
shouldBe("-1048576.0002441406 >> 0", "-1048576");
shouldBe("1048576.0002441406 >>> 0", "1048576");
shouldBe("-1048576.0002441406 >>> 0", "4293918720");
shouldBe("2097152.0004882813 >> 0", "2097152");
shouldBe("-2097152.0004882813 >> 0", "-2097152");
shouldBe("2097152.0004882813 >>> 0", "2097152");
shouldBe("-2097152.0004882813 >>> 0", "4292870144");
shouldBe("4194304.0009765625 >> 0", "4194304");
shouldBe("-4194304.0009765625 >> 0", "-4194304");
shouldBe("4194304.0009765625 >>> 0", "4194304");
shouldBe("-4194304.0009765625 >>> 0", "4290772992");
shouldBe("8388608.001953125 >> 0", "8388608");
shouldBe("-8388608.001953125 >> 0", "-8388608");
shouldBe("8388608.001953125 >>> 0", "8388608");
shouldBe("-8388608.001953125 >>> 0", "4286578688");
shouldBe("16777216.00390625 >> 0", "16777216");
shouldBe("-16777216.00390625 >> 0", "-16777216");
shouldBe("16777216.00390625 >>> 0", "16777216");
shouldBe("-16777216.00390625 >>> 0", "4278190080");
shouldBe("33554432.0078125 >> 0", "33554432");
shouldBe("-33554432.0078125 >> 0", "-33554432");
shouldBe("33554432.0078125 >>> 0", "33554432");
shouldBe("-33554432.0078125 >>> 0", "4261412864");
shouldBe("67108864.015625 >> 0", "67108864");
shouldBe("-67108864.015625 >> 0", "-67108864");
shouldBe("67108864.015625 >>> 0", "67108864");
shouldBe("-67108864.015625 >>> 0", "4227858432");
shouldBe("134217728.03125 >> 0", "134217728");
shouldBe("-134217728.03125 >> 0", "-134217728");
shouldBe("134217728.03125 >>> 0", "134217728");
shouldBe("-134217728.03125 >>> 0", "4160749568");
shouldBe("268435456.0625 >> 0", "268435456");
shouldBe("-268435456.0625 >> 0", "-268435456");
shouldBe("268435456.0625 >>> 0", "268435456");
shouldBe("-268435456.0625 >>> 0", "4026531840");
shouldBe("536870912.125 >> 0", "536870912");
shouldBe("-536870912.125 >> 0", "-536870912");
shouldBe("536870912.125 >>> 0", "536870912");
shouldBe("-536870912.125 >>> 0", "3758096384");
shouldBe("1073741824.25 >> 0", "1073741824");
shouldBe("-1073741824.25 >> 0", "-1073741824");
shouldBe("1073741824.25 >>> 0", "1073741824");
shouldBe("-1073741824.25 >>> 0", "3221225472");
shouldBe("2147483648.5 >> 0", "-2147483648");
shouldBe("-2147483648.5 >> 0", "-2147483648");
shouldBe("2147483648.5 >>> 0", "2147483648");
shouldBe("-2147483648.5 >>> 0", "2147483648");
shouldBe("4294967297 >> 0", "1");
shouldBe("-4294967297 >> 0", "-1");
shouldBe("4294967297 >>> 0", "1");
shouldBe("-4294967297 >>> 0", "4294967295");
shouldBe("8589934594 >> 0", "2");
shouldBe("-8589934594 >> 0", "-2");
shouldBe("8589934594 >>> 0", "2");
shouldBe("-8589934594 >>> 0", "4294967294");
shouldBe("17179869188 >> 0", "4");
shouldBe("-17179869188 >> 0", "-4");
shouldBe("17179869188 >>> 0", "4");
shouldBe("-17179869188 >>> 0", "4294967292");
shouldBe("34359738376 >> 0", "8");
shouldBe("-34359738376 >> 0", "-8");
shouldBe("34359738376 >>> 0", "8");
shouldBe("-34359738376 >>> 0", "4294967288");
shouldBe("68719476752 >> 0", "16");
shouldBe("-68719476752 >> 0", "-16");
shouldBe("68719476752 >>> 0", "16");
shouldBe("-68719476752 >>> 0", "4294967280");
shouldBe("137438953504 >> 0", "32");
shouldBe("-137438953504 >> 0", "-32");
shouldBe("137438953504 >>> 0", "32");
shouldBe("-137438953504 >>> 0", "4294967264");
shouldBe("274877907008 >> 0", "64");
shouldBe("-274877907008 >> 0", "-64");
shouldBe("274877907008 >>> 0", "64");
shouldBe("-274877907008 >>> 0", "4294967232");
shouldBe("549755814016 >> 0", "128");
shouldBe("-549755814016 >> 0", "-128");
shouldBe("549755814016 >>> 0", "128");
shouldBe("-549755814016 >>> 0", "4294967168");
shouldBe("1099511628032 >> 0", "256");
shouldBe("-1099511628032 >> 0", "-256");
shouldBe("1099511628032 >>> 0", "256");
shouldBe("-1099511628032 >>> 0", "4294967040");
shouldBe("2199023256064 >> 0", "512");
shouldBe("-2199023256064 >> 0", "-512");
shouldBe("2199023256064 >>> 0", "512");
shouldBe("-2199023256064 >>> 0", "4294966784");
shouldBe("4398046512128 >> 0", "1024");
shouldBe("-4398046512128 >> 0", "-1024");
shouldBe("4398046512128 >>> 0", "1024");
shouldBe("-4398046512128 >>> 0", "4294966272");
shouldBe("8796093024256 >> 0", "2048");
shouldBe("-8796093024256 >> 0", "-2048");
shouldBe("8796093024256 >>> 0", "2048");
shouldBe("-8796093024256 >>> 0", "4294965248");
shouldBe("17592186048512 >> 0", "4096");
shouldBe("-17592186048512 >> 0", "-4096");
shouldBe("17592186048512 >>> 0", "4096");
shouldBe("-17592186048512 >>> 0", "4294963200");
shouldBe("35184372097024 >> 0", "8192");
shouldBe("-35184372097024 >> 0", "-8192");
shouldBe("35184372097024 >>> 0", "8192");
shouldBe("-35184372097024 >>> 0", "4294959104");
shouldBe("70368744194048 >> 0", "16384");
shouldBe("-70368744194048 >> 0", "-16384");
shouldBe("70368744194048 >>> 0", "16384");
shouldBe("-70368744194048 >>> 0", "4294950912");
shouldBe("140737488388096 >> 0", "32768");
shouldBe("-140737488388096 >> 0", "-32768");
shouldBe("140737488388096 >>> 0", "32768");
shouldBe("-140737488388096 >>> 0", "4294934528");
shouldBe("281474976776192 >> 0", "65536");
shouldBe("-281474976776192 >> 0", "-65536");
shouldBe("281474976776192 >>> 0", "65536");
shouldBe("-281474976776192 >>> 0", "4294901760");
shouldBe("562949953552384 >> 0", "131072");
shouldBe("-562949953552384 >> 0", "-131072");
shouldBe("562949953552384 >>> 0", "131072");
shouldBe("-562949953552384 >>> 0", "4294836224");
shouldBe("1125899907104768 >> 0", "262144");
shouldBe("-1125899907104768 >> 0", "-262144");
shouldBe("1125899907104768 >>> 0", "262144");
shouldBe("-1125899907104768 >>> 0", "4294705152");
shouldBe("2251799814209536 >> 0", "524288");
shouldBe("-2251799814209536 >> 0", "-524288");
shouldBe("2251799814209536 >>> 0", "524288");
shouldBe("-2251799814209536 >>> 0", "4294443008");
shouldBe("4503599628419072 >> 0", "1048576");
shouldBe("-4503599628419072 >> 0", "-1048576");
shouldBe("4503599628419072 >>> 0", "1048576");
shouldBe("-4503599628419072 >>> 0", "4293918720");
shouldBe("9007199256838144 >> 0", "2097152");
shouldBe("-9007199256838144 >> 0", "-2097152");
shouldBe("9007199256838144 >>> 0", "2097152");
shouldBe("-9007199256838144 >>> 0", "4292870144");
shouldBe("18014398513676290 >> 0", "4194304");
shouldBe("-18014398513676290 >> 0", "-4194304");
shouldBe("18014398513676290 >>> 0", "4194304");
shouldBe("-18014398513676290 >>> 0", "4290772992");
shouldBe("36028797027352580 >> 0", "8388608");
shouldBe("-36028797027352580 >> 0", "-8388608");
shouldBe("36028797027352580 >>> 0", "8388608");
shouldBe("-36028797027352580 >>> 0", "4286578688");
shouldBe("72057594054705150 >> 0", "16777216");
shouldBe("-72057594054705150 >> 0", "-16777216");
shouldBe("72057594054705150 >>> 0", "16777216");
shouldBe("-72057594054705150 >>> 0", "4278190080");
shouldBe("144115188109410300 >> 0", "33554432");
shouldBe("-144115188109410300 >> 0", "-33554432");
shouldBe("144115188109410300 >>> 0", "33554432");
shouldBe("-144115188109410300 >>> 0", "4261412864");
shouldBe("288230376218820600 >> 0", "67108864");
shouldBe("-288230376218820600 >> 0", "-67108864");
shouldBe("288230376218820600 >>> 0", "67108864");
shouldBe("-288230376218820600 >>> 0", "4227858432");
shouldBe("576460752437641200 >> 0", "134217728");
shouldBe("-576460752437641200 >> 0", "-134217728");
shouldBe("576460752437641200 >>> 0", "134217728");
shouldBe("-576460752437641200 >>> 0", "4160749568");
shouldBe("1152921504875282400 >> 0", "268435456");
shouldBe("-1152921504875282400 >> 0", "-268435456");
shouldBe("1152921504875282400 >>> 0", "268435456");
shouldBe("-1152921504875282400 >>> 0", "4026531840");
shouldBe("2305843009750565000 >> 0", "536870912");
shouldBe("-2305843009750565000 >> 0", "-536870912");
shouldBe("2305843009750565000 >>> 0", "536870912");
shouldBe("-2305843009750565000 >>> 0", "3758096384");
shouldBe("4611686019501130000 >> 0", "1073741824");
shouldBe("-4611686019501130000 >> 0", "-1073741824");
shouldBe("4611686019501130000 >>> 0", "1073741824");
shouldBe("-4611686019501130000 >>> 0", "3221225472");
shouldBe("9223372039002260000 >> 0", "-2147483648");
shouldBe("-9223372039002260000 >> 0", "-2147483648");
shouldBe("9223372039002260000 >>> 0", "2147483648");
shouldBe("-9223372039002260000 >>> 0", "2147483648");
shouldBe("18446744078004520000 >> 0", "0");
shouldBe("-18446744078004520000 >> 0", "0");
shouldBe("18446744078004520000 >>> 0", "0");
shouldBe("-18446744078004520000 >>> 0", "0");
shouldBe("5.960464474763505e-8 >> 0", "0");
shouldBe("-5.960464474763505e-8 >> 0", "0");
shouldBe("5.960464474763505e-8 >>> 0", "0");
shouldBe("-5.960464474763505e-8 >>> 0", "0");
shouldBe("1.192092894952701e-7 >> 0", "0");
shouldBe("-1.192092894952701e-7 >> 0", "0");
shouldBe("1.192092894952701e-7 >>> 0", "0");
shouldBe("-1.192092894952701e-7 >>> 0", "0");
shouldBe("2.384185789905402e-7 >> 0", "0");
shouldBe("-2.384185789905402e-7 >> 0", "0");
shouldBe("2.384185789905402e-7 >>> 0", "0");
shouldBe("-2.384185789905402e-7 >>> 0", "0");
shouldBe("4.768371579810804e-7 >> 0", "0");
shouldBe("-4.768371579810804e-7 >> 0", "0");
shouldBe("4.768371579810804e-7 >>> 0", "0");
shouldBe("-4.768371579810804e-7 >>> 0", "0");
shouldBe("9.536743159621608e-7 >> 0", "0");
shouldBe("-9.536743159621608e-7 >> 0", "0");
shouldBe("9.536743159621608e-7 >>> 0", "0");
shouldBe("-9.536743159621608e-7 >>> 0", "0");
shouldBe("0.0000019073486319243216 >> 0", "0");
shouldBe("-0.0000019073486319243216 >> 0", "0");
shouldBe("0.0000019073486319243216 >>> 0", "0");
shouldBe("-0.0000019073486319243216 >>> 0", "0");
shouldBe("0.000003814697263848643 >> 0", "0");
shouldBe("-0.000003814697263848643 >> 0", "0");
shouldBe("0.000003814697263848643 >>> 0", "0");
shouldBe("-0.000003814697263848643 >>> 0", "0");
shouldBe("0.000007629394527697286 >> 0", "0");
shouldBe("-0.000007629394527697286 >> 0", "0");
shouldBe("0.000007629394527697286 >>> 0", "0");
shouldBe("-0.000007629394527697286 >>> 0", "0");
shouldBe("0.000015258789055394573 >> 0", "0");
shouldBe("-0.000015258789055394573 >> 0", "0");
shouldBe("0.000015258789055394573 >>> 0", "0");
shouldBe("-0.000015258789055394573 >>> 0", "0");
shouldBe("0.000030517578110789145 >> 0", "0");
shouldBe("-0.000030517578110789145 >> 0", "0");
shouldBe("0.000030517578110789145 >>> 0", "0");
shouldBe("-0.000030517578110789145 >>> 0", "0");
shouldBe("0.00006103515622157829 >> 0", "0");
shouldBe("-0.00006103515622157829 >> 0", "0");
shouldBe("0.00006103515622157829 >>> 0", "0");
shouldBe("-0.00006103515622157829 >>> 0", "0");
shouldBe("0.00012207031244315658 >> 0", "0");
shouldBe("-0.00012207031244315658 >> 0", "0");
shouldBe("0.00012207031244315658 >>> 0", "0");
shouldBe("-0.00012207031244315658 >>> 0", "0");
shouldBe("0.00024414062488631316 >> 0", "0");
shouldBe("-0.00024414062488631316 >> 0", "0");
shouldBe("0.00024414062488631316 >>> 0", "0");
shouldBe("-0.00024414062488631316 >>> 0", "0");
shouldBe("0.0004882812497726263 >> 0", "0");
shouldBe("-0.0004882812497726263 >> 0", "0");
shouldBe("0.0004882812497726263 >>> 0", "0");
shouldBe("-0.0004882812497726263 >>> 0", "0");
shouldBe("0.0009765624995452526 >> 0", "0");
shouldBe("-0.0009765624995452526 >> 0", "0");
shouldBe("0.0009765624995452526 >>> 0", "0");
shouldBe("-0.0009765624995452526 >>> 0", "0");
shouldBe("0.0019531249990905053 >> 0", "0");
shouldBe("-0.0019531249990905053 >> 0", "0");
shouldBe("0.0019531249990905053 >>> 0", "0");
shouldBe("-0.0019531249990905053 >>> 0", "0");
shouldBe("0.0039062499981810106 >> 0", "0");
shouldBe("-0.0039062499981810106 >> 0", "0");
shouldBe("0.0039062499981810106 >>> 0", "0");
shouldBe("-0.0039062499981810106 >>> 0", "0");
shouldBe("0.007812499996362021 >> 0", "0");
shouldBe("-0.007812499996362021 >> 0", "0");
shouldBe("0.007812499996362021 >>> 0", "0");
shouldBe("-0.007812499996362021 >>> 0", "0");
shouldBe("0.015624999992724042 >> 0", "0");
shouldBe("-0.015624999992724042 >> 0", "0");
shouldBe("0.015624999992724042 >>> 0", "0");
shouldBe("-0.015624999992724042 >>> 0", "0");
shouldBe("0.031249999985448085 >> 0", "0");
shouldBe("-0.031249999985448085 >> 0", "0");
shouldBe("0.031249999985448085 >>> 0", "0");
shouldBe("-0.031249999985448085 >>> 0", "0");
shouldBe("0.06249999997089617 >> 0", "0");
shouldBe("-0.06249999997089617 >> 0", "0");
shouldBe("0.06249999997089617 >>> 0", "0");
shouldBe("-0.06249999997089617 >>> 0", "0");
shouldBe("0.12499999994179234 >> 0", "0");
shouldBe("-0.12499999994179234 >> 0", "0");
shouldBe("0.12499999994179234 >>> 0", "0");
shouldBe("-0.12499999994179234 >>> 0", "0");
shouldBe("0.24999999988358468 >> 0", "0");
shouldBe("-0.24999999988358468 >> 0", "0");
shouldBe("0.24999999988358468 >>> 0", "0");
shouldBe("-0.24999999988358468 >>> 0", "0");
shouldBe("0.49999999976716936 >> 0", "0");
shouldBe("-0.49999999976716936 >> 0", "0");
shouldBe("0.49999999976716936 >>> 0", "0");
shouldBe("-0.49999999976716936 >>> 0", "0");
shouldBe("0.9999999995343387 >> 0", "0");
shouldBe("-0.9999999995343387 >> 0", "0");
shouldBe("0.9999999995343387 >>> 0", "0");
shouldBe("-0.9999999995343387 >>> 0", "0");
shouldBe("1.9999999990686774 >> 0", "1");
shouldBe("-1.9999999990686774 >> 0", "-1");
shouldBe("1.9999999990686774 >>> 0", "1");
shouldBe("-1.9999999990686774 >>> 0", "4294967295");
shouldBe("3.999999998137355 >> 0", "3");
shouldBe("-3.999999998137355 >> 0", "-3");
shouldBe("3.999999998137355 >>> 0", "3");
shouldBe("-3.999999998137355 >>> 0", "4294967293");
shouldBe("7.99999999627471 >> 0", "7");
shouldBe("-7.99999999627471 >> 0", "-7");
shouldBe("7.99999999627471 >>> 0", "7");
shouldBe("-7.99999999627471 >>> 0", "4294967289");
shouldBe("15.99999999254942 >> 0", "15");
shouldBe("-15.99999999254942 >> 0", "-15");
shouldBe("15.99999999254942 >>> 0", "15");
shouldBe("-15.99999999254942 >>> 0", "4294967281");
shouldBe("31.99999998509884 >> 0", "31");
shouldBe("-31.99999998509884 >> 0", "-31");
shouldBe("31.99999998509884 >>> 0", "31");
shouldBe("-31.99999998509884 >>> 0", "4294967265");
shouldBe("63.99999997019768 >> 0", "63");
shouldBe("-63.99999997019768 >> 0", "-63");
shouldBe("63.99999997019768 >>> 0", "63");
shouldBe("-63.99999997019768 >>> 0", "4294967233");
shouldBe("127.99999994039536 >> 0", "127");
shouldBe("-127.99999994039536 >> 0", "-127");
shouldBe("127.99999994039536 >>> 0", "127");
shouldBe("-127.99999994039536 >>> 0", "4294967169");
shouldBe("255.9999998807907 >> 0", "255");
shouldBe("-255.9999998807907 >> 0", "-255");
shouldBe("255.9999998807907 >>> 0", "255");
shouldBe("-255.9999998807907 >>> 0", "4294967041");
shouldBe("511.9999997615814 >> 0", "511");
shouldBe("-511.9999997615814 >> 0", "-511");
shouldBe("511.9999997615814 >>> 0", "511");
shouldBe("-511.9999997615814 >>> 0", "4294966785");
shouldBe("1023.9999995231628 >> 0", "1023");
shouldBe("-1023.9999995231628 >> 0", "-1023");
shouldBe("1023.9999995231628 >>> 0", "1023");
shouldBe("-1023.9999995231628 >>> 0", "4294966273");
shouldBe("2047.9999990463257 >> 0", "2047");
shouldBe("-2047.9999990463257 >> 0", "-2047");
shouldBe("2047.9999990463257 >>> 0", "2047");
shouldBe("-2047.9999990463257 >>> 0", "4294965249");
shouldBe("4095.9999980926514 >> 0", "4095");
shouldBe("-4095.9999980926514 >> 0", "-4095");
shouldBe("4095.9999980926514 >>> 0", "4095");
shouldBe("-4095.9999980926514 >>> 0", "4294963201");
shouldBe("8191.999996185303 >> 0", "8191");
shouldBe("-8191.999996185303 >> 0", "-8191");
shouldBe("8191.999996185303 >>> 0", "8191");
shouldBe("-8191.999996185303 >>> 0", "4294959105");
shouldBe("16383.999992370605 >> 0", "16383");
shouldBe("-16383.999992370605 >> 0", "-16383");
shouldBe("16383.999992370605 >>> 0", "16383");
shouldBe("-16383.999992370605 >>> 0", "4294950913");
shouldBe("32767.99998474121 >> 0", "32767");
shouldBe("-32767.99998474121 >> 0", "-32767");
shouldBe("32767.99998474121 >>> 0", "32767");
shouldBe("-32767.99998474121 >>> 0", "4294934529");
shouldBe("65535.99996948242 >> 0", "65535");
shouldBe("-65535.99996948242 >> 0", "-65535");
shouldBe("65535.99996948242 >>> 0", "65535");
shouldBe("-65535.99996948242 >>> 0", "4294901761");
shouldBe("131071.99993896484 >> 0", "131071");
shouldBe("-131071.99993896484 >> 0", "-131071");
shouldBe("131071.99993896484 >>> 0", "131071");
shouldBe("-131071.99993896484 >>> 0", "4294836225");
shouldBe("262143.9998779297 >> 0", "262143");
shouldBe("-262143.9998779297 >> 0", "-262143");
shouldBe("262143.9998779297 >>> 0", "262143");
shouldBe("-262143.9998779297 >>> 0", "4294705153");
shouldBe("524287.9997558594 >> 0", "524287");
shouldBe("-524287.9997558594 >> 0", "-524287");
shouldBe("524287.9997558594 >>> 0", "524287");
shouldBe("-524287.9997558594 >>> 0", "4294443009");
shouldBe("1048575.9995117188 >> 0", "1048575");
shouldBe("-1048575.9995117188 >> 0", "-1048575");
shouldBe("1048575.9995117188 >>> 0", "1048575");
shouldBe("-1048575.9995117188 >>> 0", "4293918721");
shouldBe("2097151.9990234375 >> 0", "2097151");
shouldBe("-2097151.9990234375 >> 0", "-2097151");
shouldBe("2097151.9990234375 >>> 0", "2097151");
shouldBe("-2097151.9990234375 >>> 0", "4292870145");
shouldBe("4194303.998046875 >> 0", "4194303");
shouldBe("-4194303.998046875 >> 0", "-4194303");
shouldBe("4194303.998046875 >>> 0", "4194303");
shouldBe("-4194303.998046875 >>> 0", "4290772993");
shouldBe("8388607.99609375 >> 0", "8388607");
shouldBe("-8388607.99609375 >> 0", "-8388607");
shouldBe("8388607.99609375 >>> 0", "8388607");
shouldBe("-8388607.99609375 >>> 0", "4286578689");
shouldBe("16777215.9921875 >> 0", "16777215");
shouldBe("-16777215.9921875 >> 0", "-16777215");
shouldBe("16777215.9921875 >>> 0", "16777215");
shouldBe("-16777215.9921875 >>> 0", "4278190081");
shouldBe("33554431.984375 >> 0", "33554431");
shouldBe("-33554431.984375 >> 0", "-33554431");
shouldBe("33554431.984375 >>> 0", "33554431");
shouldBe("-33554431.984375 >>> 0", "4261412865");
shouldBe("67108863.96875 >> 0", "67108863");
shouldBe("-67108863.96875 >> 0", "-67108863");
shouldBe("67108863.96875 >>> 0", "67108863");
shouldBe("-67108863.96875 >>> 0", "4227858433");
shouldBe("134217727.9375 >> 0", "134217727");
shouldBe("-134217727.9375 >> 0", "-134217727");
shouldBe("134217727.9375 >>> 0", "134217727");
shouldBe("-134217727.9375 >>> 0", "4160749569");
shouldBe("268435455.875 >> 0", "268435455");
shouldBe("-268435455.875 >> 0", "-268435455");
shouldBe("268435455.875 >>> 0", "268435455");
shouldBe("-268435455.875 >>> 0", "4026531841");
shouldBe("536870911.75 >> 0", "536870911");
shouldBe("-536870911.75 >> 0", "-536870911");
shouldBe("536870911.75 >>> 0", "536870911");
shouldBe("-536870911.75 >>> 0", "3758096385");
shouldBe("1073741823.5 >> 0", "1073741823");
shouldBe("-1073741823.5 >> 0", "-1073741823");
shouldBe("1073741823.5 >>> 0", "1073741823");
shouldBe("-1073741823.5 >>> 0", "3221225473");
shouldBe("2147483647 >> 0", "2147483647");
shouldBe("-2147483647 >> 0", "-2147483647");
shouldBe("2147483647 >>> 0", "2147483647");
shouldBe("-2147483647 >>> 0", "2147483649");
shouldBe("4294967294 >> 0", "-2");
shouldBe("-4294967294 >> 0", "2");
shouldBe("4294967294 >>> 0", "4294967294");
shouldBe("-4294967294 >>> 0", "2");
shouldBe("8589934588 >> 0", "-4");
shouldBe("-8589934588 >> 0", "4");
shouldBe("8589934588 >>> 0", "4294967292");
shouldBe("-8589934588 >>> 0", "4");
shouldBe("17179869176 >> 0", "-8");
shouldBe("-17179869176 >> 0", "8");
shouldBe("17179869176 >>> 0", "4294967288");
shouldBe("-17179869176 >>> 0", "8");
shouldBe("34359738352 >> 0", "-16");
shouldBe("-34359738352 >> 0", "16");
shouldBe("34359738352 >>> 0", "4294967280");
shouldBe("-34359738352 >>> 0", "16");
shouldBe("68719476704 >> 0", "-32");
shouldBe("-68719476704 >> 0", "32");
shouldBe("68719476704 >>> 0", "4294967264");
shouldBe("-68719476704 >>> 0", "32");
shouldBe("137438953408 >> 0", "-64");
shouldBe("-137438953408 >> 0", "64");
shouldBe("137438953408 >>> 0", "4294967232");
shouldBe("-137438953408 >>> 0", "64");
shouldBe("274877906816 >> 0", "-128");
shouldBe("-274877906816 >> 0", "128");
shouldBe("274877906816 >>> 0", "4294967168");
shouldBe("-274877906816 >>> 0", "128");
shouldBe("549755813632 >> 0", "-256");
shouldBe("-549755813632 >> 0", "256");
shouldBe("549755813632 >>> 0", "4294967040");
shouldBe("-549755813632 >>> 0", "256");
shouldBe("1099511627264 >> 0", "-512");
shouldBe("-1099511627264 >> 0", "512");
shouldBe("1099511627264 >>> 0", "4294966784");
shouldBe("-1099511627264 >>> 0", "512");
shouldBe("2199023254528 >> 0", "-1024");
shouldBe("-2199023254528 >> 0", "1024");
shouldBe("2199023254528 >>> 0", "4294966272");
shouldBe("-2199023254528 >>> 0", "1024");
shouldBe("4398046509056 >> 0", "-2048");
shouldBe("-4398046509056 >> 0", "2048");
shouldBe("4398046509056 >>> 0", "4294965248");
shouldBe("-4398046509056 >>> 0", "2048");
shouldBe("8796093018112 >> 0", "-4096");
shouldBe("-8796093018112 >> 0", "4096");
shouldBe("8796093018112 >>> 0", "4294963200");
shouldBe("-8796093018112 >>> 0", "4096");
shouldBe("17592186036224 >> 0", "-8192");
shouldBe("-17592186036224 >> 0", "8192");
shouldBe("17592186036224 >>> 0", "4294959104");
shouldBe("-17592186036224 >>> 0", "8192");
shouldBe("35184372072448 >> 0", "-16384");
shouldBe("-35184372072448 >> 0", "16384");
shouldBe("35184372072448 >>> 0", "4294950912");
shouldBe("-35184372072448 >>> 0", "16384");
shouldBe("70368744144896 >> 0", "-32768");
shouldBe("-70368744144896 >> 0", "32768");
shouldBe("70368744144896 >>> 0", "4294934528");
shouldBe("-70368744144896 >>> 0", "32768");
shouldBe("140737488289792 >> 0", "-65536");
shouldBe("-140737488289792 >> 0", "65536");
shouldBe("140737488289792 >>> 0", "4294901760");
shouldBe("-140737488289792 >>> 0", "65536");
shouldBe("281474976579584 >> 0", "-131072");
shouldBe("-281474976579584 >> 0", "131072");
shouldBe("281474976579584 >>> 0", "4294836224");
shouldBe("-281474976579584 >>> 0", "131072");
shouldBe("562949953159168 >> 0", "-262144");
shouldBe("-562949953159168 >> 0", "262144");
shouldBe("562949953159168 >>> 0", "4294705152");
shouldBe("-562949953159168 >>> 0", "262144");
shouldBe("1125899906318336 >> 0", "-524288");
shouldBe("-1125899906318336 >> 0", "524288");
shouldBe("1125899906318336 >>> 0", "4294443008");
shouldBe("-1125899906318336 >>> 0", "524288");
shouldBe("2251799812636672 >> 0", "-1048576");
shouldBe("-2251799812636672 >> 0", "1048576");
shouldBe("2251799812636672 >>> 0", "4293918720");
shouldBe("-2251799812636672 >>> 0", "1048576");
shouldBe("4503599625273344 >> 0", "-2097152");
shouldBe("-4503599625273344 >> 0", "2097152");
shouldBe("4503599625273344 >>> 0", "4292870144");
shouldBe("-4503599625273344 >>> 0", "2097152");
shouldBe("9007199250546688 >> 0", "-4194304");
shouldBe("-9007199250546688 >> 0", "4194304");
shouldBe("9007199250546688 >>> 0", "4290772992");
shouldBe("-9007199250546688 >>> 0", "4194304");
shouldBe("18014398501093376 >> 0", "-8388608");
shouldBe("-18014398501093376 >> 0", "8388608");
shouldBe("18014398501093376 >>> 0", "4286578688");
shouldBe("-18014398501093376 >>> 0", "8388608");
shouldBe("36028797002186750 >> 0", "-16777216");
shouldBe("-36028797002186750 >> 0", "16777216");
shouldBe("36028797002186750 >>> 0", "4278190080");
shouldBe("-36028797002186750 >>> 0", "16777216");
shouldBe("72057594004373500 >> 0", "-33554432");
shouldBe("-72057594004373500 >> 0", "33554432");
shouldBe("72057594004373500 >>> 0", "4261412864");
shouldBe("-72057594004373500 >>> 0", "33554432");
shouldBe("144115188008747000 >> 0", "-67108864");
shouldBe("-144115188008747000 >> 0", "67108864");
shouldBe("144115188008747000 >>> 0", "4227858432");
shouldBe("-144115188008747000 >>> 0", "67108864");
shouldBe("288230376017494000 >> 0", "-134217728");
shouldBe("-288230376017494000 >> 0", "134217728");
shouldBe("288230376017494000 >>> 0", "4160749568");
shouldBe("-288230376017494000 >>> 0", "134217728");
shouldBe("576460752034988000 >> 0", "-268435456");
shouldBe("-576460752034988000 >> 0", "268435456");
shouldBe("576460752034988000 >>> 0", "4026531840");
shouldBe("-576460752034988000 >>> 0", "268435456");
shouldBe("1152921504069976000 >> 0", "-536870912");
shouldBe("-1152921504069976000 >> 0", "536870912");
shouldBe("1152921504069976000 >>> 0", "3758096384");
shouldBe("-1152921504069976000 >>> 0", "536870912");
shouldBe("2305843008139952000 >> 0", "-1073741824");
shouldBe("-2305843008139952000 >> 0", "1073741824");
shouldBe("2305843008139952000 >>> 0", "3221225472");
shouldBe("-2305843008139952000 >>> 0", "1073741824");
shouldBe("4611686016279904000 >> 0", "-2147483648");
shouldBe("-4611686016279904000 >> 0", "-2147483648");
shouldBe("4611686016279904000 >>> 0", "2147483648");
shouldBe("-4611686016279904000 >>> 0", "2147483648");
shouldBe("9223372032559809000 >> 0", "0");
shouldBe("-9223372032559809000 >> 0", "0");
shouldBe("9223372032559809000 >>> 0", "0");
shouldBe("-9223372032559809000 >>> 0", "0");
shouldBe("1.1920928952302567e-7 >> 0", "0");
shouldBe("-1.1920928952302567e-7 >> 0", "0");
shouldBe("1.1920928952302567e-7 >>> 0", "0");
shouldBe("-1.1920928952302567e-7 >>> 0", "0");
shouldBe("2.3841857904605135e-7 >> 0", "0");
shouldBe("-2.3841857904605135e-7 >> 0", "0");
shouldBe("2.3841857904605135e-7 >>> 0", "0");
shouldBe("-2.3841857904605135e-7 >>> 0", "0");
shouldBe("4.768371580921027e-7 >> 0", "0");
shouldBe("-4.768371580921027e-7 >> 0", "0");
shouldBe("4.768371580921027e-7 >>> 0", "0");
shouldBe("-4.768371580921027e-7 >>> 0", "0");
shouldBe("9.536743161842054e-7 >> 0", "0");
shouldBe("-9.536743161842054e-7 >> 0", "0");
shouldBe("9.536743161842054e-7 >>> 0", "0");
shouldBe("-9.536743161842054e-7 >>> 0", "0");
shouldBe("0.0000019073486323684108 >> 0", "0");
shouldBe("-0.0000019073486323684108 >> 0", "0");
shouldBe("0.0000019073486323684108 >>> 0", "0");
shouldBe("-0.0000019073486323684108 >>> 0", "0");
shouldBe("0.0000038146972647368216 >> 0", "0");
shouldBe("-0.0000038146972647368216 >> 0", "0");
shouldBe("0.0000038146972647368216 >>> 0", "0");
shouldBe("-0.0000038146972647368216 >>> 0", "0");
shouldBe("0.000007629394529473643 >> 0", "0");
shouldBe("-0.000007629394529473643 >> 0", "0");
shouldBe("0.000007629394529473643 >>> 0", "0");
shouldBe("-0.000007629394529473643 >>> 0", "0");
shouldBe("0.000015258789058947286 >> 0", "0");
shouldBe("-0.000015258789058947286 >> 0", "0");
shouldBe("0.000015258789058947286 >>> 0", "0");
shouldBe("-0.000015258789058947286 >>> 0", "0");
shouldBe("0.000030517578117894573 >> 0", "0");
shouldBe("-0.000030517578117894573 >> 0", "0");
shouldBe("0.000030517578117894573 >>> 0", "0");
shouldBe("-0.000030517578117894573 >>> 0", "0");
shouldBe("0.000061035156235789145 >> 0", "0");
shouldBe("-0.000061035156235789145 >> 0", "0");
shouldBe("0.000061035156235789145 >>> 0", "0");
shouldBe("-0.000061035156235789145 >>> 0", "0");
shouldBe("0.00012207031247157829 >> 0", "0");
shouldBe("-0.00012207031247157829 >> 0", "0");
shouldBe("0.00012207031247157829 >>> 0", "0");
shouldBe("-0.00012207031247157829 >>> 0", "0");
shouldBe("0.00024414062494315658 >> 0", "0");
shouldBe("-0.00024414062494315658 >> 0", "0");
shouldBe("0.00024414062494315658 >>> 0", "0");
shouldBe("-0.00024414062494315658 >>> 0", "0");
shouldBe("0.00048828124988631316 >> 0", "0");
shouldBe("-0.00048828124988631316 >> 0", "0");
shouldBe("0.00048828124988631316 >>> 0", "0");
shouldBe("-0.00048828124988631316 >>> 0", "0");
shouldBe("0.0009765624997726263 >> 0", "0");
shouldBe("-0.0009765624997726263 >> 0", "0");
shouldBe("0.0009765624997726263 >>> 0", "0");
shouldBe("-0.0009765624997726263 >>> 0", "0");
shouldBe("0.0019531249995452526 >> 0", "0");
shouldBe("-0.0019531249995452526 >> 0", "0");
shouldBe("0.0019531249995452526 >>> 0", "0");
shouldBe("-0.0019531249995452526 >>> 0", "0");
shouldBe("0.0039062499990905053 >> 0", "0");
shouldBe("-0.0039062499990905053 >> 0", "0");
shouldBe("0.0039062499990905053 >>> 0", "0");
shouldBe("-0.0039062499990905053 >>> 0", "0");
shouldBe("0.007812499998181011 >> 0", "0");
shouldBe("-0.007812499998181011 >> 0", "0");
shouldBe("0.007812499998181011 >>> 0", "0");
shouldBe("-0.007812499998181011 >>> 0", "0");
shouldBe("0.015624999996362021 >> 0", "0");
shouldBe("-0.015624999996362021 >> 0", "0");
shouldBe("0.015624999996362021 >>> 0", "0");
shouldBe("-0.015624999996362021 >>> 0", "0");
shouldBe("0.031249999992724042 >> 0", "0");
shouldBe("-0.031249999992724042 >> 0", "0");
shouldBe("0.031249999992724042 >>> 0", "0");
shouldBe("-0.031249999992724042 >>> 0", "0");
shouldBe("0.062499999985448085 >> 0", "0");
shouldBe("-0.062499999985448085 >> 0", "0");
shouldBe("0.062499999985448085 >>> 0", "0");
shouldBe("-0.062499999985448085 >>> 0", "0");
shouldBe("0.12499999997089617 >> 0", "0");
shouldBe("-0.12499999997089617 >> 0", "0");
shouldBe("0.12499999997089617 >>> 0", "0");
shouldBe("-0.12499999997089617 >>> 0", "0");
shouldBe("0.24999999994179234 >> 0", "0");
shouldBe("-0.24999999994179234 >> 0", "0");
shouldBe("0.24999999994179234 >>> 0", "0");
shouldBe("-0.24999999994179234 >>> 0", "0");
shouldBe("0.4999999998835847 >> 0", "0");
shouldBe("-0.4999999998835847 >> 0", "0");
shouldBe("0.4999999998835847 >>> 0", "0");
shouldBe("-0.4999999998835847 >>> 0", "0");
shouldBe("0.9999999997671694 >> 0", "0");
shouldBe("-0.9999999997671694 >> 0", "0");
shouldBe("0.9999999997671694 >>> 0", "0");
shouldBe("-0.9999999997671694 >>> 0", "0");
shouldBe("1.9999999995343387 >> 0", "1");
shouldBe("-1.9999999995343387 >> 0", "-1");
shouldBe("1.9999999995343387 >>> 0", "1");
shouldBe("-1.9999999995343387 >>> 0", "4294967295");
shouldBe("3.9999999990686774 >> 0", "3");
shouldBe("-3.9999999990686774 >> 0", "-3");
shouldBe("3.9999999990686774 >>> 0", "3");
shouldBe("-3.9999999990686774 >>> 0", "4294967293");
shouldBe("7.999999998137355 >> 0", "7");
shouldBe("-7.999999998137355 >> 0", "-7");
shouldBe("7.999999998137355 >>> 0", "7");
shouldBe("-7.999999998137355 >>> 0", "4294967289");
shouldBe("15.99999999627471 >> 0", "15");
shouldBe("-15.99999999627471 >> 0", "-15");
shouldBe("15.99999999627471 >>> 0", "15");
shouldBe("-15.99999999627471 >>> 0", "4294967281");
shouldBe("31.99999999254942 >> 0", "31");
shouldBe("-31.99999999254942 >> 0", "-31");
shouldBe("31.99999999254942 >>> 0", "31");
shouldBe("-31.99999999254942 >>> 0", "4294967265");
shouldBe("63.99999998509884 >> 0", "63");
shouldBe("-63.99999998509884 >> 0", "-63");
shouldBe("63.99999998509884 >>> 0", "63");
shouldBe("-63.99999998509884 >>> 0", "4294967233");
shouldBe("127.99999997019768 >> 0", "127");
shouldBe("-127.99999997019768 >> 0", "-127");
shouldBe("127.99999997019768 >>> 0", "127");
shouldBe("-127.99999997019768 >>> 0", "4294967169");
shouldBe("255.99999994039536 >> 0", "255");
shouldBe("-255.99999994039536 >> 0", "-255");
shouldBe("255.99999994039536 >>> 0", "255");
shouldBe("-255.99999994039536 >>> 0", "4294967041");
shouldBe("511.9999998807907 >> 0", "511");
shouldBe("-511.9999998807907 >> 0", "-511");
shouldBe("511.9999998807907 >>> 0", "511");
shouldBe("-511.9999998807907 >>> 0", "4294966785");
shouldBe("1023.9999997615814 >> 0", "1023");
shouldBe("-1023.9999997615814 >> 0", "-1023");
shouldBe("1023.9999997615814 >>> 0", "1023");
shouldBe("-1023.9999997615814 >>> 0", "4294966273");
shouldBe("2047.9999995231628 >> 0", "2047");
shouldBe("-2047.9999995231628 >> 0", "-2047");
shouldBe("2047.9999995231628 >>> 0", "2047");
shouldBe("-2047.9999995231628 >>> 0", "4294965249");
shouldBe("4095.9999990463257 >> 0", "4095");
shouldBe("-4095.9999990463257 >> 0", "-4095");
shouldBe("4095.9999990463257 >>> 0", "4095");
shouldBe("-4095.9999990463257 >>> 0", "4294963201");
shouldBe("8191.999998092651 >> 0", "8191");
shouldBe("-8191.999998092651 >> 0", "-8191");
shouldBe("8191.999998092651 >>> 0", "8191");
shouldBe("-8191.999998092651 >>> 0", "4294959105");
shouldBe("16383.999996185303 >> 0", "16383");
shouldBe("-16383.999996185303 >> 0", "-16383");
shouldBe("16383.999996185303 >>> 0", "16383");
shouldBe("-16383.999996185303 >>> 0", "4294950913");
shouldBe("32767.999992370605 >> 0", "32767");
shouldBe("-32767.999992370605 >> 0", "-32767");
shouldBe("32767.999992370605 >>> 0", "32767");
shouldBe("-32767.999992370605 >>> 0", "4294934529");
shouldBe("65535.99998474121 >> 0", "65535");
shouldBe("-65535.99998474121 >> 0", "-65535");
shouldBe("65535.99998474121 >>> 0", "65535");
shouldBe("-65535.99998474121 >>> 0", "4294901761");
shouldBe("131071.99996948242 >> 0", "131071");
shouldBe("-131071.99996948242 >> 0", "-131071");
shouldBe("131071.99996948242 >>> 0", "131071");
shouldBe("-131071.99996948242 >>> 0", "4294836225");
shouldBe("262143.99993896484 >> 0", "262143");
shouldBe("-262143.99993896484 >> 0", "-262143");
shouldBe("262143.99993896484 >>> 0", "262143");
shouldBe("-262143.99993896484 >>> 0", "4294705153");
shouldBe("524287.9998779297 >> 0", "524287");
shouldBe("-524287.9998779297 >> 0", "-524287");
shouldBe("524287.9998779297 >>> 0", "524287");
shouldBe("-524287.9998779297 >>> 0", "4294443009");
shouldBe("1048575.9997558594 >> 0", "1048575");
shouldBe("-1048575.9997558594 >> 0", "-1048575");
shouldBe("1048575.9997558594 >>> 0", "1048575");
shouldBe("-1048575.9997558594 >>> 0", "4293918721");
shouldBe("2097151.9995117188 >> 0", "2097151");
shouldBe("-2097151.9995117188 >> 0", "-2097151");
shouldBe("2097151.9995117188 >>> 0", "2097151");
shouldBe("-2097151.9995117188 >>> 0", "4292870145");
shouldBe("4194303.9990234375 >> 0", "4194303");
shouldBe("-4194303.9990234375 >> 0", "-4194303");
shouldBe("4194303.9990234375 >>> 0", "4194303");
shouldBe("-4194303.9990234375 >>> 0", "4290772993");
shouldBe("8388607.998046875 >> 0", "8388607");
shouldBe("-8388607.998046875 >> 0", "-8388607");
shouldBe("8388607.998046875 >>> 0", "8388607");
shouldBe("-8388607.998046875 >>> 0", "4286578689");
shouldBe("16777215.99609375 >> 0", "16777215");
shouldBe("-16777215.99609375 >> 0", "-16777215");
shouldBe("16777215.99609375 >>> 0", "16777215");
shouldBe("-16777215.99609375 >>> 0", "4278190081");
shouldBe("33554431.9921875 >> 0", "33554431");
shouldBe("-33554431.9921875 >> 0", "-33554431");
shouldBe("33554431.9921875 >>> 0", "33554431");
shouldBe("-33554431.9921875 >>> 0", "4261412865");
shouldBe("67108863.984375 >> 0", "67108863");
shouldBe("-67108863.984375 >> 0", "-67108863");
shouldBe("67108863.984375 >>> 0", "67108863");
shouldBe("-67108863.984375 >>> 0", "4227858433");
shouldBe("134217727.96875 >> 0", "134217727");
shouldBe("-134217727.96875 >> 0", "-134217727");
shouldBe("134217727.96875 >>> 0", "134217727");
shouldBe("-134217727.96875 >>> 0", "4160749569");
shouldBe("268435455.9375 >> 0", "268435455");
shouldBe("-268435455.9375 >> 0", "-268435455");
shouldBe("268435455.9375 >>> 0", "268435455");
shouldBe("-268435455.9375 >>> 0", "4026531841");
shouldBe("536870911.875 >> 0", "536870911");
shouldBe("-536870911.875 >> 0", "-536870911");
shouldBe("536870911.875 >>> 0", "536870911");
shouldBe("-536870911.875 >>> 0", "3758096385");
shouldBe("1073741823.75 >> 0", "1073741823");
shouldBe("-1073741823.75 >> 0", "-1073741823");
shouldBe("1073741823.75 >>> 0", "1073741823");
shouldBe("-1073741823.75 >>> 0", "3221225473");
shouldBe("2147483647.5 >> 0", "2147483647");
shouldBe("-2147483647.5 >> 0", "-2147483647");
shouldBe("2147483647.5 >>> 0", "2147483647");
shouldBe("-2147483647.5 >>> 0", "2147483649");
shouldBe("4294967295 >> 0", "-1");
shouldBe("-4294967295 >> 0", "1");
shouldBe("4294967295 >>> 0", "4294967295");
shouldBe("-4294967295 >>> 0", "1");
shouldBe("8589934590 >> 0", "-2");
shouldBe("-8589934590 >> 0", "2");
shouldBe("8589934590 >>> 0", "4294967294");
shouldBe("-8589934590 >>> 0", "2");
shouldBe("17179869180 >> 0", "-4");
shouldBe("-17179869180 >> 0", "4");
shouldBe("17179869180 >>> 0", "4294967292");
shouldBe("-17179869180 >>> 0", "4");
shouldBe("34359738360 >> 0", "-8");
shouldBe("-34359738360 >> 0", "8");
shouldBe("34359738360 >>> 0", "4294967288");
shouldBe("-34359738360 >>> 0", "8");
shouldBe("68719476720 >> 0", "-16");
shouldBe("-68719476720 >> 0", "16");
shouldBe("68719476720 >>> 0", "4294967280");
shouldBe("-68719476720 >>> 0", "16");
shouldBe("137438953440 >> 0", "-32");
shouldBe("-137438953440 >> 0", "32");
shouldBe("137438953440 >>> 0", "4294967264");
shouldBe("-137438953440 >>> 0", "32");
shouldBe("274877906880 >> 0", "-64");
shouldBe("-274877906880 >> 0", "64");
shouldBe("274877906880 >>> 0", "4294967232");
shouldBe("-274877906880 >>> 0", "64");
shouldBe("549755813760 >> 0", "-128");
shouldBe("-549755813760 >> 0", "128");
shouldBe("549755813760 >>> 0", "4294967168");
shouldBe("-549755813760 >>> 0", "128");
shouldBe("1099511627520 >> 0", "-256");
shouldBe("-1099511627520 >> 0", "256");
shouldBe("1099511627520 >>> 0", "4294967040");
shouldBe("-1099511627520 >>> 0", "256");
shouldBe("2199023255040 >> 0", "-512");
shouldBe("-2199023255040 >> 0", "512");
shouldBe("2199023255040 >>> 0", "4294966784");
shouldBe("-2199023255040 >>> 0", "512");
shouldBe("4398046510080 >> 0", "-1024");
shouldBe("-4398046510080 >> 0", "1024");
shouldBe("4398046510080 >>> 0", "4294966272");
shouldBe("-4398046510080 >>> 0", "1024");
shouldBe("8796093020160 >> 0", "-2048");
shouldBe("-8796093020160 >> 0", "2048");
shouldBe("8796093020160 >>> 0", "4294965248");
shouldBe("-8796093020160 >>> 0", "2048");
shouldBe("17592186040320 >> 0", "-4096");
shouldBe("-17592186040320 >> 0", "4096");
shouldBe("17592186040320 >>> 0", "4294963200");
shouldBe("-17592186040320 >>> 0", "4096");
shouldBe("35184372080640 >> 0", "-8192");
shouldBe("-35184372080640 >> 0", "8192");
shouldBe("35184372080640 >>> 0", "4294959104");
shouldBe("-35184372080640 >>> 0", "8192");
shouldBe("70368744161280 >> 0", "-16384");
shouldBe("-70368744161280 >> 0", "16384");
shouldBe("70368744161280 >>> 0", "4294950912");
shouldBe("-70368744161280 >>> 0", "16384");
shouldBe("140737488322560 >> 0", "-32768");
shouldBe("-140737488322560 >> 0", "32768");
shouldBe("140737488322560 >>> 0", "4294934528");
shouldBe("-140737488322560 >>> 0", "32768");
shouldBe("281474976645120 >> 0", "-65536");
shouldBe("-281474976645120 >> 0", "65536");
shouldBe("281474976645120 >>> 0", "4294901760");
shouldBe("-281474976645120 >>> 0", "65536");
shouldBe("562949953290240 >> 0", "-131072");
shouldBe("-562949953290240 >> 0", "131072");
shouldBe("562949953290240 >>> 0", "4294836224");
shouldBe("-562949953290240 >>> 0", "131072");
shouldBe("1125899906580480 >> 0", "-262144");
shouldBe("-1125899906580480 >> 0", "262144");
shouldBe("1125899906580480 >>> 0", "4294705152");
shouldBe("-1125899906580480 >>> 0", "262144");
shouldBe("2251799813160960 >> 0", "-524288");
shouldBe("-2251799813160960 >> 0", "524288");
shouldBe("2251799813160960 >>> 0", "4294443008");
shouldBe("-2251799813160960 >>> 0", "524288");
shouldBe("4503599626321920 >> 0", "-1048576");
shouldBe("-4503599626321920 >> 0", "1048576");
shouldBe("4503599626321920 >>> 0", "4293918720");
shouldBe("-4503599626321920 >>> 0", "1048576");
shouldBe("9007199252643840 >> 0", "-2097152");
shouldBe("-9007199252643840 >> 0", "2097152");
shouldBe("9007199252643840 >>> 0", "4292870144");
shouldBe("-9007199252643840 >>> 0", "2097152");
shouldBe("18014398505287680 >> 0", "-4194304");
shouldBe("-18014398505287680 >> 0", "4194304");
shouldBe("18014398505287680 >>> 0", "4290772992");
shouldBe("-18014398505287680 >>> 0", "4194304");
shouldBe("36028797010575360 >> 0", "-8388608");
shouldBe("-36028797010575360 >> 0", "8388608");
shouldBe("36028797010575360 >>> 0", "4286578688");
shouldBe("-36028797010575360 >>> 0", "8388608");
shouldBe("72057594021150720 >> 0", "-16777216");
shouldBe("-72057594021150720 >> 0", "16777216");
shouldBe("72057594021150720 >>> 0", "4278190080");
shouldBe("-72057594021150720 >>> 0", "16777216");
shouldBe("144115188042301440 >> 0", "-33554432");
shouldBe("-144115188042301440 >> 0", "33554432");
shouldBe("144115188042301440 >>> 0", "4261412864");
shouldBe("-144115188042301440 >>> 0", "33554432");
shouldBe("288230376084602880 >> 0", "-67108864");
shouldBe("-288230376084602880 >> 0", "67108864");
shouldBe("288230376084602880 >>> 0", "4227858432");
shouldBe("-288230376084602880 >>> 0", "67108864");
shouldBe("576460752169205760 >> 0", "-134217728");
shouldBe("-576460752169205760 >> 0", "134217728");
shouldBe("576460752169205760 >>> 0", "4160749568");
shouldBe("-576460752169205760 >>> 0", "134217728");
shouldBe("1152921504338411500 >> 0", "-268435456");
shouldBe("-1152921504338411500 >> 0", "268435456");
shouldBe("1152921504338411500 >>> 0", "4026531840");
shouldBe("-1152921504338411500 >>> 0", "268435456");
shouldBe("2305843008676823000 >> 0", "-536870912");
shouldBe("-2305843008676823000 >> 0", "536870912");
shouldBe("2305843008676823000 >>> 0", "3758096384");
shouldBe("-2305843008676823000 >>> 0", "536870912");
shouldBe("4611686017353646000 >> 0", "-1073741824");
shouldBe("-4611686017353646000 >> 0", "1073741824");
shouldBe("4611686017353646000 >>> 0", "3221225472");
shouldBe("-4611686017353646000 >>> 0", "1073741824");
shouldBe("9223372034707292000 >> 0", "-2147483648");
shouldBe("-9223372034707292000 >> 0", "-2147483648");
shouldBe("9223372034707292000 >>> 0", "2147483648");
shouldBe("-9223372034707292000 >>> 0", "2147483648");
shouldBe("18446744069414584000 >> 0", "0");
shouldBe("-18446744069414584000 >> 0", "0");
shouldBe("18446744069414584000 >>> 0", "0");
shouldBe("-18446744069414584000 >>> 0", "0");
shouldBe("2.3841857907380692e-7 >> 0", "0");
shouldBe("-2.3841857907380692e-7 >> 0", "0");
shouldBe("2.3841857907380692e-7 >>> 0", "0");
shouldBe("-2.3841857907380692e-7 >>> 0", "0");
shouldBe("4.7683715814761385e-7 >> 0", "0");
shouldBe("-4.7683715814761385e-7 >> 0", "0");
shouldBe("4.7683715814761385e-7 >>> 0", "0");
shouldBe("-4.7683715814761385e-7 >>> 0", "0");
shouldBe("9.536743162952277e-7 >> 0", "0");
shouldBe("-9.536743162952277e-7 >> 0", "0");
shouldBe("9.536743162952277e-7 >>> 0", "0");
shouldBe("-9.536743162952277e-7 >>> 0", "0");
shouldBe("0.0000019073486325904554 >> 0", "0");
shouldBe("-0.0000019073486325904554 >> 0", "0");
shouldBe("0.0000019073486325904554 >>> 0", "0");
shouldBe("-0.0000019073486325904554 >>> 0", "0");
shouldBe("0.000003814697265180911 >> 0", "0");
shouldBe("-0.000003814697265180911 >> 0", "0");
shouldBe("0.000003814697265180911 >>> 0", "0");
shouldBe("-0.000003814697265180911 >>> 0", "0");
shouldBe("0.000007629394530361822 >> 0", "0");
shouldBe("-0.000007629394530361822 >> 0", "0");
shouldBe("0.000007629394530361822 >>> 0", "0");
shouldBe("-0.000007629394530361822 >>> 0", "0");
shouldBe("0.000015258789060723643 >> 0", "0");
shouldBe("-0.000015258789060723643 >> 0", "0");
shouldBe("0.000015258789060723643 >>> 0", "0");
shouldBe("-0.000015258789060723643 >>> 0", "0");
shouldBe("0.000030517578121447286 >> 0", "0");
shouldBe("-0.000030517578121447286 >> 0", "0");
shouldBe("0.000030517578121447286 >>> 0", "0");
shouldBe("-0.000030517578121447286 >>> 0", "0");
shouldBe("0.00006103515624289457 >> 0", "0");
shouldBe("-0.00006103515624289457 >> 0", "0");
shouldBe("0.00006103515624289457 >>> 0", "0");
shouldBe("-0.00006103515624289457 >>> 0", "0");
shouldBe("0.00012207031248578915 >> 0", "0");
shouldBe("-0.00012207031248578915 >> 0", "0");
shouldBe("0.00012207031248578915 >>> 0", "0");
shouldBe("-0.00012207031248578915 >>> 0", "0");
shouldBe("0.0002441406249715783 >> 0", "0");
shouldBe("-0.0002441406249715783 >> 0", "0");
shouldBe("0.0002441406249715783 >>> 0", "0");
shouldBe("-0.0002441406249715783 >>> 0", "0");
shouldBe("0.0004882812499431566 >> 0", "0");
shouldBe("-0.0004882812499431566 >> 0", "0");
shouldBe("0.0004882812499431566 >>> 0", "0");
shouldBe("-0.0004882812499431566 >>> 0", "0");
shouldBe("0.0009765624998863132 >> 0", "0");
shouldBe("-0.0009765624998863132 >> 0", "0");
shouldBe("0.0009765624998863132 >>> 0", "0");
shouldBe("-0.0009765624998863132 >>> 0", "0");
shouldBe("0.0019531249997726263 >> 0", "0");
shouldBe("-0.0019531249997726263 >> 0", "0");
shouldBe("0.0019531249997726263 >>> 0", "0");
shouldBe("-0.0019531249997726263 >>> 0", "0");
shouldBe("0.0039062499995452526 >> 0", "0");
shouldBe("-0.0039062499995452526 >> 0", "0");
shouldBe("0.0039062499995452526 >>> 0", "0");
shouldBe("-0.0039062499995452526 >>> 0", "0");
shouldBe("0.007812499999090505 >> 0", "0");
shouldBe("-0.007812499999090505 >> 0", "0");
shouldBe("0.007812499999090505 >>> 0", "0");
shouldBe("-0.007812499999090505 >>> 0", "0");
shouldBe("0.01562499999818101 >> 0", "0");
shouldBe("-0.01562499999818101 >> 0", "0");
shouldBe("0.01562499999818101 >>> 0", "0");
shouldBe("-0.01562499999818101 >>> 0", "0");
shouldBe("0.03124999999636202 >> 0", "0");
shouldBe("-0.03124999999636202 >> 0", "0");
shouldBe("0.03124999999636202 >>> 0", "0");
shouldBe("-0.03124999999636202 >>> 0", "0");
shouldBe("0.06249999999272404 >> 0", "0");
shouldBe("-0.06249999999272404 >> 0", "0");
shouldBe("0.06249999999272404 >>> 0", "0");
shouldBe("-0.06249999999272404 >>> 0", "0");
shouldBe("0.12499999998544808 >> 0", "0");
shouldBe("-0.12499999998544808 >> 0", "0");
shouldBe("0.12499999998544808 >>> 0", "0");
shouldBe("-0.12499999998544808 >>> 0", "0");
shouldBe("0.24999999997089617 >> 0", "0");
shouldBe("-0.24999999997089617 >> 0", "0");
shouldBe("0.24999999997089617 >>> 0", "0");
shouldBe("-0.24999999997089617 >>> 0", "0");
shouldBe("0.49999999994179234 >> 0", "0");
shouldBe("-0.49999999994179234 >> 0", "0");
shouldBe("0.49999999994179234 >>> 0", "0");
shouldBe("-0.49999999994179234 >>> 0", "0");
shouldBe("0.9999999998835847 >> 0", "0");
shouldBe("-0.9999999998835847 >> 0", "0");
shouldBe("0.9999999998835847 >>> 0", "0");
shouldBe("-0.9999999998835847 >>> 0", "0");
shouldBe("1.9999999997671694 >> 0", "1");
shouldBe("-1.9999999997671694 >> 0", "-1");
shouldBe("1.9999999997671694 >>> 0", "1");
shouldBe("-1.9999999997671694 >>> 0", "4294967295");
shouldBe("3.9999999995343387 >> 0", "3");
shouldBe("-3.9999999995343387 >> 0", "-3");
shouldBe("3.9999999995343387 >>> 0", "3");
shouldBe("-3.9999999995343387 >>> 0", "4294967293");
shouldBe("7.999999999068677 >> 0", "7");
shouldBe("-7.999999999068677 >> 0", "-7");
shouldBe("7.999999999068677 >>> 0", "7");
shouldBe("-7.999999999068677 >>> 0", "4294967289");
shouldBe("15.999999998137355 >> 0", "15");
shouldBe("-15.999999998137355 >> 0", "-15");
shouldBe("15.999999998137355 >>> 0", "15");
shouldBe("-15.999999998137355 >>> 0", "4294967281");
shouldBe("31.99999999627471 >> 0", "31");
shouldBe("-31.99999999627471 >> 0", "-31");
shouldBe("31.99999999627471 >>> 0", "31");
shouldBe("-31.99999999627471 >>> 0", "4294967265");
shouldBe("63.99999999254942 >> 0", "63");
shouldBe("-63.99999999254942 >> 0", "-63");
shouldBe("63.99999999254942 >>> 0", "63");
shouldBe("-63.99999999254942 >>> 0", "4294967233");
shouldBe("127.99999998509884 >> 0", "127");
shouldBe("-127.99999998509884 >> 0", "-127");
shouldBe("127.99999998509884 >>> 0", "127");
shouldBe("-127.99999998509884 >>> 0", "4294967169");
shouldBe("255.99999997019768 >> 0", "255");
shouldBe("-255.99999997019768 >> 0", "-255");
shouldBe("255.99999997019768 >>> 0", "255");
shouldBe("-255.99999997019768 >>> 0", "4294967041");
shouldBe("511.99999994039536 >> 0", "511");
shouldBe("-511.99999994039536 >> 0", "-511");
shouldBe("511.99999994039536 >>> 0", "511");
shouldBe("-511.99999994039536 >>> 0", "4294966785");
shouldBe("1023.9999998807907 >> 0", "1023");
shouldBe("-1023.9999998807907 >> 0", "-1023");
shouldBe("1023.9999998807907 >>> 0", "1023");
shouldBe("-1023.9999998807907 >>> 0", "4294966273");
shouldBe("2047.9999997615814 >> 0", "2047");
shouldBe("-2047.9999997615814 >> 0", "-2047");
shouldBe("2047.9999997615814 >>> 0", "2047");
shouldBe("-2047.9999997615814 >>> 0", "4294965249");
shouldBe("4095.999999523163 >> 0", "4095");
shouldBe("-4095.999999523163 >> 0", "-4095");
shouldBe("4095.999999523163 >>> 0", "4095");
shouldBe("-4095.999999523163 >>> 0", "4294963201");
shouldBe("8191.999999046326 >> 0", "8191");
shouldBe("-8191.999999046326 >> 0", "-8191");
shouldBe("8191.999999046326 >>> 0", "8191");
shouldBe("-8191.999999046326 >>> 0", "4294959105");
shouldBe("16383.999998092651 >> 0", "16383");
shouldBe("-16383.999998092651 >> 0", "-16383");
shouldBe("16383.999998092651 >>> 0", "16383");
shouldBe("-16383.999998092651 >>> 0", "4294950913");
shouldBe("32767.999996185303 >> 0", "32767");
shouldBe("-32767.999996185303 >> 0", "-32767");
shouldBe("32767.999996185303 >>> 0", "32767");
shouldBe("-32767.999996185303 >>> 0", "4294934529");
shouldBe("65535.999992370605 >> 0", "65535");
shouldBe("-65535.999992370605 >> 0", "-65535");
shouldBe("65535.999992370605 >>> 0", "65535");
shouldBe("-65535.999992370605 >>> 0", "4294901761");
shouldBe("131071.99998474121 >> 0", "131071");
shouldBe("-131071.99998474121 >> 0", "-131071");
shouldBe("131071.99998474121 >>> 0", "131071");
shouldBe("-131071.99998474121 >>> 0", "4294836225");
shouldBe("262143.99996948242 >> 0", "262143");
shouldBe("-262143.99996948242 >> 0", "-262143");
shouldBe("262143.99996948242 >>> 0", "262143");
shouldBe("-262143.99996948242 >>> 0", "4294705153");
shouldBe("524287.99993896484 >> 0", "524287");
shouldBe("-524287.99993896484 >> 0", "-524287");
shouldBe("524287.99993896484 >>> 0", "524287");
shouldBe("-524287.99993896484 >>> 0", "4294443009");
shouldBe("1048575.9998779297 >> 0", "1048575");
shouldBe("-1048575.9998779297 >> 0", "-1048575");
shouldBe("1048575.9998779297 >>> 0", "1048575");
shouldBe("-1048575.9998779297 >>> 0", "4293918721");
shouldBe("2097151.9997558594 >> 0", "2097151");
shouldBe("-2097151.9997558594 >> 0", "-2097151");
shouldBe("2097151.9997558594 >>> 0", "2097151");
shouldBe("-2097151.9997558594 >>> 0", "4292870145");
shouldBe("4194303.9995117188 >> 0", "4194303");
shouldBe("-4194303.9995117188 >> 0", "-4194303");
shouldBe("4194303.9995117188 >>> 0", "4194303");
shouldBe("-4194303.9995117188 >>> 0", "4290772993");
shouldBe("8388607.9990234375 >> 0", "8388607");
shouldBe("-8388607.9990234375 >> 0", "-8388607");
shouldBe("8388607.9990234375 >>> 0", "8388607");
shouldBe("-8388607.9990234375 >>> 0", "4286578689");
shouldBe("16777215.998046875 >> 0", "16777215");
shouldBe("-16777215.998046875 >> 0", "-16777215");
shouldBe("16777215.998046875 >>> 0", "16777215");
shouldBe("-16777215.998046875 >>> 0", "4278190081");
shouldBe("33554431.99609375 >> 0", "33554431");
shouldBe("-33554431.99609375 >> 0", "-33554431");
shouldBe("33554431.99609375 >>> 0", "33554431");
shouldBe("-33554431.99609375 >>> 0", "4261412865");
shouldBe("67108863.9921875 >> 0", "67108863");
shouldBe("-67108863.9921875 >> 0", "-67108863");
shouldBe("67108863.9921875 >>> 0", "67108863");
shouldBe("-67108863.9921875 >>> 0", "4227858433");
shouldBe("134217727.984375 >> 0", "134217727");
shouldBe("-134217727.984375 >> 0", "-134217727");
shouldBe("134217727.984375 >>> 0", "134217727");
shouldBe("-134217727.984375 >>> 0", "4160749569");
shouldBe("268435455.96875 >> 0", "268435455");
shouldBe("-268435455.96875 >> 0", "-268435455");
shouldBe("268435455.96875 >>> 0", "268435455");
shouldBe("-268435455.96875 >>> 0", "4026531841");
shouldBe("536870911.9375 >> 0", "536870911");
shouldBe("-536870911.9375 >> 0", "-536870911");
shouldBe("536870911.9375 >>> 0", "536870911");
shouldBe("-536870911.9375 >>> 0", "3758096385");
shouldBe("1073741823.875 >> 0", "1073741823");
shouldBe("-1073741823.875 >> 0", "-1073741823");
shouldBe("1073741823.875 >>> 0", "1073741823");
shouldBe("-1073741823.875 >>> 0", "3221225473");
shouldBe("2147483647.75 >> 0", "2147483647");
shouldBe("-2147483647.75 >> 0", "-2147483647");
shouldBe("2147483647.75 >>> 0", "2147483647");
shouldBe("-2147483647.75 >>> 0", "2147483649");
shouldBe("4294967295.5 >> 0", "-1");
shouldBe("-4294967295.5 >> 0", "1");
shouldBe("4294967295.5 >>> 0", "4294967295");
shouldBe("-4294967295.5 >>> 0", "1");
shouldBe("8589934591 >> 0", "-1");
shouldBe("-8589934591 >> 0", "1");
shouldBe("8589934591 >>> 0", "4294967295");
shouldBe("-8589934591 >>> 0", "1");
shouldBe("17179869182 >> 0", "-2");
shouldBe("-17179869182 >> 0", "2");
shouldBe("17179869182 >>> 0", "4294967294");
shouldBe("-17179869182 >>> 0", "2");
shouldBe("34359738364 >> 0", "-4");
shouldBe("-34359738364 >> 0", "4");
shouldBe("34359738364 >>> 0", "4294967292");
shouldBe("-34359738364 >>> 0", "4");
shouldBe("68719476728 >> 0", "-8");
shouldBe("-68719476728 >> 0", "8");
shouldBe("68719476728 >>> 0", "4294967288");
shouldBe("-68719476728 >>> 0", "8");
shouldBe("137438953456 >> 0", "-16");
shouldBe("-137438953456 >> 0", "16");
shouldBe("137438953456 >>> 0", "4294967280");
shouldBe("-137438953456 >>> 0", "16");
shouldBe("274877906912 >> 0", "-32");
shouldBe("-274877906912 >> 0", "32");
shouldBe("274877906912 >>> 0", "4294967264");
shouldBe("-274877906912 >>> 0", "32");
shouldBe("549755813824 >> 0", "-64");
shouldBe("-549755813824 >> 0", "64");
shouldBe("549755813824 >>> 0", "4294967232");
shouldBe("-549755813824 >>> 0", "64");
shouldBe("1099511627648 >> 0", "-128");
shouldBe("-1099511627648 >> 0", "128");
shouldBe("1099511627648 >>> 0", "4294967168");
shouldBe("-1099511627648 >>> 0", "128");
shouldBe("2199023255296 >> 0", "-256");
shouldBe("-2199023255296 >> 0", "256");
shouldBe("2199023255296 >>> 0", "4294967040");
shouldBe("-2199023255296 >>> 0", "256");
shouldBe("4398046510592 >> 0", "-512");
shouldBe("-4398046510592 >> 0", "512");
shouldBe("4398046510592 >>> 0", "4294966784");
shouldBe("-4398046510592 >>> 0", "512");
shouldBe("8796093021184 >> 0", "-1024");
shouldBe("-8796093021184 >> 0", "1024");
shouldBe("8796093021184 >>> 0", "4294966272");
shouldBe("-8796093021184 >>> 0", "1024");
shouldBe("17592186042368 >> 0", "-2048");
shouldBe("-17592186042368 >> 0", "2048");
shouldBe("17592186042368 >>> 0", "4294965248");
shouldBe("-17592186042368 >>> 0", "2048");
shouldBe("35184372084736 >> 0", "-4096");
shouldBe("-35184372084736 >> 0", "4096");
shouldBe("35184372084736 >>> 0", "4294963200");
shouldBe("-35184372084736 >>> 0", "4096");
shouldBe("70368744169472 >> 0", "-8192");
shouldBe("-70368744169472 >> 0", "8192");
shouldBe("70368744169472 >>> 0", "4294959104");
shouldBe("-70368744169472 >>> 0", "8192");
shouldBe("140737488338944 >> 0", "-16384");
shouldBe("-140737488338944 >> 0", "16384");
shouldBe("140737488338944 >>> 0", "4294950912");
shouldBe("-140737488338944 >>> 0", "16384");
shouldBe("281474976677888 >> 0", "-32768");
shouldBe("-281474976677888 >> 0", "32768");
shouldBe("281474976677888 >>> 0", "4294934528");
shouldBe("-281474976677888 >>> 0", "32768");
shouldBe("562949953355776 >> 0", "-65536");
shouldBe("-562949953355776 >> 0", "65536");
shouldBe("562949953355776 >>> 0", "4294901760");
shouldBe("-562949953355776 >>> 0", "65536");
shouldBe("1125899906711552 >> 0", "-131072");
shouldBe("-1125899906711552 >> 0", "131072");
shouldBe("1125899906711552 >>> 0", "4294836224");
shouldBe("-1125899906711552 >>> 0", "131072");
shouldBe("2251799813423104 >> 0", "-262144");
shouldBe("-2251799813423104 >> 0", "262144");
shouldBe("2251799813423104 >>> 0", "4294705152");
shouldBe("-2251799813423104 >>> 0", "262144");
shouldBe("4503599626846208 >> 0", "-524288");
shouldBe("-4503599626846208 >> 0", "524288");
shouldBe("4503599626846208 >>> 0", "4294443008");
shouldBe("-4503599626846208 >>> 0", "524288");
shouldBe("9007199253692416 >> 0", "-1048576");
shouldBe("-9007199253692416 >> 0", "1048576");
shouldBe("9007199253692416 >>> 0", "4293918720");
shouldBe("-9007199253692416 >>> 0", "1048576");
shouldBe("18014398507384832 >> 0", "-2097152");
shouldBe("-18014398507384832 >> 0", "2097152");
shouldBe("18014398507384832 >>> 0", "4292870144");
shouldBe("-18014398507384832 >>> 0", "2097152");
shouldBe("36028797014769664 >> 0", "-4194304");
shouldBe("-36028797014769664 >> 0", "4194304");
shouldBe("36028797014769664 >>> 0", "4290772992");
shouldBe("-36028797014769664 >>> 0", "4194304");
shouldBe("72057594029539330 >> 0", "-8388608");
shouldBe("-72057594029539330 >> 0", "8388608");
shouldBe("72057594029539330 >>> 0", "4286578688");
shouldBe("-72057594029539330 >>> 0", "8388608");
shouldBe("144115188059078660 >> 0", "-16777216");
shouldBe("-144115188059078660 >> 0", "16777216");
shouldBe("144115188059078660 >>> 0", "4278190080");
shouldBe("-144115188059078660 >>> 0", "16777216");
shouldBe("288230376118157300 >> 0", "-33554432");
shouldBe("-288230376118157300 >> 0", "33554432");
shouldBe("288230376118157300 >>> 0", "4261412864");
shouldBe("-288230376118157300 >>> 0", "33554432");
shouldBe("576460752236314600 >> 0", "-67108864");
shouldBe("-576460752236314600 >> 0", "67108864");
shouldBe("576460752236314600 >>> 0", "4227858432");
shouldBe("-576460752236314600 >>> 0", "67108864");
shouldBe("1152921504472629200 >> 0", "-134217728");
shouldBe("-1152921504472629200 >> 0", "134217728");
shouldBe("1152921504472629200 >>> 0", "4160749568");
shouldBe("-1152921504472629200 >>> 0", "134217728");
shouldBe("2305843008945258500 >> 0", "-268435456");
shouldBe("-2305843008945258500 >> 0", "268435456");
shouldBe("2305843008945258500 >>> 0", "4026531840");
shouldBe("-2305843008945258500 >>> 0", "268435456");
shouldBe("4611686017890517000 >> 0", "-536870912");
shouldBe("-4611686017890517000 >> 0", "536870912");
shouldBe("4611686017890517000 >>> 0", "3758096384");
shouldBe("-4611686017890517000 >>> 0", "536870912");
shouldBe("9223372035781034000 >> 0", "-1073741824");
shouldBe("-9223372035781034000 >> 0", "1073741824");
shouldBe("9223372035781034000 >>> 0", "3221225472");
shouldBe("-9223372035781034000 >>> 0", "1073741824");
shouldBe("18446744071562068000 >> 0", "-2147483648");
shouldBe("-18446744071562068000 >> 0", "-2147483648");
shouldBe("18446744071562068000 >>> 0", "2147483648");
shouldBe("-18446744071562068000 >>> 0", "2147483648");
shouldBe("36893488143124136000 >> 0", "0");
shouldBe("-36893488143124136000 >> 0", "0");
shouldBe("36893488143124136000 >>> 0", "0");
shouldBe("-36893488143124136000 >>> 0", "0");
shouldBe("0.12500000002910386 >> 0", "0");
shouldBe("-0.12500000002910386 >> 0", "0");
shouldBe("0.12500000002910386 >>> 0", "0");
shouldBe("-0.12500000002910386 >>> 0", "0");
shouldBe("0.2500000000582077 >> 0", "0");
shouldBe("-0.2500000000582077 >> 0", "0");
shouldBe("0.2500000000582077 >>> 0", "0");
shouldBe("-0.2500000000582077 >>> 0", "0");
shouldBe("0.5000000001164154 >> 0", "0");
shouldBe("-0.5000000001164154 >> 0", "0");
shouldBe("0.5000000001164154 >>> 0", "0");
shouldBe("-0.5000000001164154 >>> 0", "0");
shouldBe("1.0000000002328309 >> 0", "1");
shouldBe("-1.0000000002328309 >> 0", "-1");
shouldBe("1.0000000002328309 >>> 0", "1");
shouldBe("-1.0000000002328309 >>> 0", "4294967295");
shouldBe("2.0000000004656617 >> 0", "2");
shouldBe("-2.0000000004656617 >> 0", "-2");
shouldBe("2.0000000004656617 >>> 0", "2");
shouldBe("-2.0000000004656617 >>> 0", "4294967294");
shouldBe("4.0000000009313235 >> 0", "4");
shouldBe("-4.0000000009313235 >> 0", "-4");
shouldBe("4.0000000009313235 >>> 0", "4");
shouldBe("-4.0000000009313235 >>> 0", "4294967292");
shouldBe("8.000000001862647 >> 0", "8");
shouldBe("-8.000000001862647 >> 0", "-8");
shouldBe("8.000000001862647 >>> 0", "8");
shouldBe("-8.000000001862647 >>> 0", "4294967288");
shouldBe("16.000000003725294 >> 0", "16");
shouldBe("-16.000000003725294 >> 0", "-16");
shouldBe("16.000000003725294 >>> 0", "16");
shouldBe("-16.000000003725294 >>> 0", "4294967280");
shouldBe("32.00000000745059 >> 0", "32");
shouldBe("-32.00000000745059 >> 0", "-32");
shouldBe("32.00000000745059 >>> 0", "32");
shouldBe("-32.00000000745059 >>> 0", "4294967264");
shouldBe("64.00000001490118 >> 0", "64");
shouldBe("-64.00000001490118 >> 0", "-64");
shouldBe("64.00000001490118 >>> 0", "64");
shouldBe("-64.00000001490118 >>> 0", "4294967232");
shouldBe("128.00000002980235 >> 0", "128");
shouldBe("-128.00000002980235 >> 0", "-128");
shouldBe("128.00000002980235 >>> 0", "128");
shouldBe("-128.00000002980235 >>> 0", "4294967168");
shouldBe("256.0000000596047 >> 0", "256");
shouldBe("-256.0000000596047 >> 0", "-256");
shouldBe("256.0000000596047 >>> 0", "256");
shouldBe("-256.0000000596047 >>> 0", "4294967040");
shouldBe("512.0000001192094 >> 0", "512");
shouldBe("-512.0000001192094 >> 0", "-512");
shouldBe("512.0000001192094 >>> 0", "512");
shouldBe("-512.0000001192094 >>> 0", "4294966784");
shouldBe("1024.0000002384188 >> 0", "1024");
shouldBe("-1024.0000002384188 >> 0", "-1024");
shouldBe("1024.0000002384188 >>> 0", "1024");
shouldBe("-1024.0000002384188 >>> 0", "4294966272");
shouldBe("2048.0000004768376 >> 0", "2048");
shouldBe("-2048.0000004768376 >> 0", "-2048");
shouldBe("2048.0000004768376 >>> 0", "2048");
shouldBe("-2048.0000004768376 >>> 0", "4294965248");
shouldBe("4096.000000953675 >> 0", "4096");
shouldBe("-4096.000000953675 >> 0", "-4096");
shouldBe("4096.000000953675 >>> 0", "4096");
shouldBe("-4096.000000953675 >>> 0", "4294963200");
shouldBe("8192.00000190735 >> 0", "8192");
shouldBe("-8192.00000190735 >> 0", "-8192");
shouldBe("8192.00000190735 >>> 0", "8192");
shouldBe("-8192.00000190735 >>> 0", "4294959104");
shouldBe("16384.0000038147 >> 0", "16384");
shouldBe("-16384.0000038147 >> 0", "-16384");
shouldBe("16384.0000038147 >>> 0", "16384");
shouldBe("-16384.0000038147 >>> 0", "4294950912");
shouldBe("32768.0000076294 >> 0", "32768");
shouldBe("-32768.0000076294 >> 0", "-32768");
shouldBe("32768.0000076294 >>> 0", "32768");
shouldBe("-32768.0000076294 >>> 0", "4294934528");
shouldBe("65536.0000152588 >> 0", "65536");
shouldBe("-65536.0000152588 >> 0", "-65536");
shouldBe("65536.0000152588 >>> 0", "65536");
shouldBe("-65536.0000152588 >>> 0", "4294901760");
shouldBe("131072.0000305176 >> 0", "131072");
shouldBe("-131072.0000305176 >> 0", "-131072");
shouldBe("131072.0000305176 >>> 0", "131072");
shouldBe("-131072.0000305176 >>> 0", "4294836224");
shouldBe("262144.0000610352 >> 0", "262144");
shouldBe("-262144.0000610352 >> 0", "-262144");
shouldBe("262144.0000610352 >>> 0", "262144");
shouldBe("-262144.0000610352 >>> 0", "4294705152");
shouldBe("524288.0001220704 >> 0", "524288");
shouldBe("-524288.0001220704 >> 0", "-524288");
shouldBe("524288.0001220704 >>> 0", "524288");
shouldBe("-524288.0001220704 >>> 0", "4294443008");
shouldBe("1048576.0002441409 >> 0", "1048576");
shouldBe("-1048576.0002441409 >> 0", "-1048576");
shouldBe("1048576.0002441409 >>> 0", "1048576");
shouldBe("-1048576.0002441409 >>> 0", "4293918720");
shouldBe("2097152.0004882817 >> 0", "2097152");
shouldBe("-2097152.0004882817 >> 0", "-2097152");
shouldBe("2097152.0004882817 >>> 0", "2097152");
shouldBe("-2097152.0004882817 >>> 0", "4292870144");
shouldBe("4194304.000976563 >> 0", "4194304");
shouldBe("-4194304.000976563 >> 0", "-4194304");
shouldBe("4194304.000976563 >>> 0", "4194304");
shouldBe("-4194304.000976563 >>> 0", "4290772992");
shouldBe("8388608.001953127 >> 0", "8388608");
shouldBe("-8388608.001953127 >> 0", "-8388608");
shouldBe("8388608.001953127 >>> 0", "8388608");
shouldBe("-8388608.001953127 >>> 0", "4286578688");
shouldBe("16777216.003906254 >> 0", "16777216");
shouldBe("-16777216.003906254 >> 0", "-16777216");
shouldBe("16777216.003906254 >>> 0", "16777216");
shouldBe("-16777216.003906254 >>> 0", "4278190080");
shouldBe("33554432.00781251 >> 0", "33554432");
shouldBe("-33554432.00781251 >> 0", "-33554432");
shouldBe("33554432.00781251 >>> 0", "33554432");
shouldBe("-33554432.00781251 >>> 0", "4261412864");
shouldBe("67108864.01562501 >> 0", "67108864");
shouldBe("-67108864.01562501 >> 0", "-67108864");
shouldBe("67108864.01562501 >>> 0", "67108864");
shouldBe("-67108864.01562501 >>> 0", "4227858432");
shouldBe("134217728.03125003 >> 0", "134217728");
shouldBe("-134217728.03125003 >> 0", "-134217728");
shouldBe("134217728.03125003 >>> 0", "134217728");
shouldBe("-134217728.03125003 >>> 0", "4160749568");
shouldBe("268435456.06250006 >> 0", "268435456");
shouldBe("-268435456.06250006 >> 0", "-268435456");
shouldBe("268435456.06250006 >>> 0", "268435456");
shouldBe("-268435456.06250006 >>> 0", "4026531840");
shouldBe("536870912.1250001 >> 0", "536870912");
shouldBe("-536870912.1250001 >> 0", "-536870912");
shouldBe("536870912.1250001 >>> 0", "536870912");
shouldBe("-536870912.1250001 >>> 0", "3758096384");
shouldBe("1073741824.2500002 >> 0", "1073741824");
shouldBe("-1073741824.2500002 >> 0", "-1073741824");
shouldBe("1073741824.2500002 >>> 0", "1073741824");
shouldBe("-1073741824.2500002 >>> 0", "3221225472");
shouldBe("2147483648.5000005 >> 0", "-2147483648");
shouldBe("-2147483648.5000005 >> 0", "-2147483648");
shouldBe("2147483648.5000005 >>> 0", "2147483648");
shouldBe("-2147483648.5000005 >>> 0", "2147483648");
shouldBe("4294967297.000001 >> 0", "1");
shouldBe("-4294967297.000001 >> 0", "-1");
shouldBe("4294967297.000001 >>> 0", "1");
shouldBe("-4294967297.000001 >>> 0", "4294967295");
shouldBe("8589934594.000002 >> 0", "2");
shouldBe("-8589934594.000002 >> 0", "-2");
shouldBe("8589934594.000002 >>> 0", "2");
shouldBe("-8589934594.000002 >>> 0", "4294967294");
shouldBe("17179869188.000004 >> 0", "4");
shouldBe("-17179869188.000004 >> 0", "-4");
shouldBe("17179869188.000004 >>> 0", "4");
shouldBe("-17179869188.000004 >>> 0", "4294967292");
shouldBe("34359738376.00001 >> 0", "8");
shouldBe("-34359738376.00001 >> 0", "-8");
shouldBe("34359738376.00001 >>> 0", "8");
shouldBe("-34359738376.00001 >>> 0", "4294967288");
shouldBe("68719476752.00002 >> 0", "16");
shouldBe("-68719476752.00002 >> 0", "-16");
shouldBe("68719476752.00002 >>> 0", "16");
shouldBe("-68719476752.00002 >>> 0", "4294967280");
shouldBe("137438953504.00003 >> 0", "32");
shouldBe("-137438953504.00003 >> 0", "-32");
shouldBe("137438953504.00003 >>> 0", "32");
shouldBe("-137438953504.00003 >>> 0", "4294967264");
shouldBe("274877907008.00006 >> 0", "64");
shouldBe("-274877907008.00006 >> 0", "-64");
shouldBe("274877907008.00006 >>> 0", "64");
shouldBe("-274877907008.00006 >>> 0", "4294967232");
shouldBe("549755814016.0001 >> 0", "128");
shouldBe("-549755814016.0001 >> 0", "-128");
shouldBe("549755814016.0001 >>> 0", "128");
shouldBe("-549755814016.0001 >>> 0", "4294967168");
shouldBe("1099511628032.0002 >> 0", "256");
shouldBe("-1099511628032.0002 >> 0", "-256");
shouldBe("1099511628032.0002 >>> 0", "256");
shouldBe("-1099511628032.0002 >>> 0", "4294967040");
shouldBe("2199023256064.0005 >> 0", "512");
shouldBe("-2199023256064.0005 >> 0", "-512");
shouldBe("2199023256064.0005 >>> 0", "512");
shouldBe("-2199023256064.0005 >>> 0", "4294966784");
shouldBe("4398046512128.001 >> 0", "1024");
shouldBe("-4398046512128.001 >> 0", "-1024");
shouldBe("4398046512128.001 >>> 0", "1024");
shouldBe("-4398046512128.001 >>> 0", "4294966272");
shouldBe("8796093024256.002 >> 0", "2048");
shouldBe("-8796093024256.002 >> 0", "-2048");
shouldBe("8796093024256.002 >>> 0", "2048");
shouldBe("-8796093024256.002 >>> 0", "4294965248");
shouldBe("17592186048512.004 >> 0", "4096");
shouldBe("-17592186048512.004 >> 0", "-4096");
shouldBe("17592186048512.004 >>> 0", "4096");
shouldBe("-17592186048512.004 >>> 0", "4294963200");
shouldBe("35184372097024.01 >> 0", "8192");
shouldBe("-35184372097024.01 >> 0", "-8192");
shouldBe("35184372097024.01 >>> 0", "8192");
shouldBe("-35184372097024.01 >>> 0", "4294959104");
shouldBe("70368744194048.02 >> 0", "16384");
shouldBe("-70368744194048.02 >> 0", "-16384");
shouldBe("70368744194048.02 >>> 0", "16384");
shouldBe("-70368744194048.02 >>> 0", "4294950912");
shouldBe("140737488388096.03 >> 0", "32768");
shouldBe("-140737488388096.03 >> 0", "-32768");
shouldBe("140737488388096.03 >>> 0", "32768");
shouldBe("-140737488388096.03 >>> 0", "4294934528");
shouldBe("281474976776192.06 >> 0", "65536");
shouldBe("-281474976776192.06 >> 0", "-65536");
shouldBe("281474976776192.06 >>> 0", "65536");
shouldBe("-281474976776192.06 >>> 0", "4294901760");
shouldBe("562949953552384.1 >> 0", "131072");
shouldBe("-562949953552384.1 >> 0", "-131072");
shouldBe("562949953552384.1 >>> 0", "131072");
shouldBe("-562949953552384.1 >>> 0", "4294836224");
shouldBe("1125899907104768.3 >> 0", "262144");
shouldBe("-1125899907104768.3 >> 0", "-262144");
shouldBe("1125899907104768.3 >>> 0", "262144");
shouldBe("-1125899907104768.3 >>> 0", "4294705152");
shouldBe("2251799814209536.5 >> 0", "524288");
shouldBe("-2251799814209536.5 >> 0", "-524288");
shouldBe("2251799814209536.5 >>> 0", "524288");
shouldBe("-2251799814209536.5 >>> 0", "4294443008");
shouldBe("4503599628419073 >> 0", "1048577");
shouldBe("-4503599628419073 >> 0", "-1048577");
shouldBe("4503599628419073 >>> 0", "1048577");
shouldBe("-4503599628419073 >>> 0", "4293918719");
shouldBe("9007199256838146 >> 0", "2097154");
shouldBe("-9007199256838146 >> 0", "-2097154");
shouldBe("9007199256838146 >>> 0", "2097154");
shouldBe("-9007199256838146 >>> 0", "4292870142");
shouldBe("18014398513676292 >> 0", "4194308");
shouldBe("-18014398513676292 >> 0", "-4194308");
shouldBe("18014398513676292 >>> 0", "4194308");
shouldBe("-18014398513676292 >>> 0", "4290772988");
shouldBe("36028797027352584 >> 0", "8388616");
shouldBe("-36028797027352584 >> 0", "-8388616");
shouldBe("36028797027352584 >>> 0", "8388616");
shouldBe("-36028797027352584 >>> 0", "4286578680");
shouldBe("72057594054705170 >> 0", "16777232");
shouldBe("-72057594054705170 >> 0", "-16777232");
shouldBe("72057594054705170 >>> 0", "16777232");
shouldBe("-72057594054705170 >>> 0", "4278190064");
shouldBe("144115188109410340 >> 0", "33554464");
shouldBe("-144115188109410340 >> 0", "-33554464");
shouldBe("144115188109410340 >>> 0", "33554464");
shouldBe("-144115188109410340 >>> 0", "4261412832");
shouldBe("288230376218820700 >> 0", "67108928");
shouldBe("-288230376218820700 >> 0", "-67108928");
shouldBe("288230376218820700 >>> 0", "67108928");
shouldBe("-288230376218820700 >>> 0", "4227858368");
shouldBe("576460752437641300 >> 0", "134217856");
shouldBe("-576460752437641300 >> 0", "-134217856");
shouldBe("576460752437641300 >>> 0", "134217856");
shouldBe("-576460752437641300 >>> 0", "4160749440");
shouldBe("1152921504875282700 >> 0", "268435712");
shouldBe("-1152921504875282700 >> 0", "-268435712");
shouldBe("1152921504875282700 >>> 0", "268435712");
shouldBe("-1152921504875282700 >>> 0", "4026531584");
shouldBe("2305843009750565400 >> 0", "536871424");
shouldBe("-2305843009750565400 >> 0", "-536871424");
shouldBe("2305843009750565400 >>> 0", "536871424");
shouldBe("-2305843009750565400 >>> 0", "3758095872");
shouldBe("4611686019501131000 >> 0", "1073742848");
shouldBe("-4611686019501131000 >> 0", "-1073742848");
shouldBe("4611686019501131000 >>> 0", "1073742848");
shouldBe("-4611686019501131000 >>> 0", "3221224448");
shouldBe("9223372039002262000 >> 0", "-2147481600");
shouldBe("-9223372039002262000 >> 0", "2147481600");
shouldBe("9223372039002262000 >>> 0", "2147485696");
shouldBe("-9223372039002262000 >>> 0", "2147481600");
shouldBe("18446744078004523000 >> 0", "4096");
shouldBe("-18446744078004523000 >> 0", "-4096");
shouldBe("18446744078004523000 >>> 0", "4096");
shouldBe("-18446744078004523000 >>> 0", "4294963200");
shouldBe("36893488156009050000 >> 0", "8192");
shouldBe("-36893488156009050000 >> 0", "-8192");
shouldBe("36893488156009050000 >>> 0", "8192");
shouldBe("-36893488156009050000 >>> 0", "4294959104");
shouldBe("73786976312018100000 >> 0", "16384");
shouldBe("-73786976312018100000 >> 0", "-16384");
shouldBe("73786976312018100000 >>> 0", "16384");
shouldBe("-73786976312018100000 >>> 0", "4294950912");
shouldBe("147573952624036200000 >> 0", "32768");
shouldBe("-147573952624036200000 >> 0", "-32768");
shouldBe("147573952624036200000 >>> 0", "32768");
shouldBe("-147573952624036200000 >>> 0", "4294934528");
shouldBe("295147905248072400000 >> 0", "65536");
shouldBe("-295147905248072400000 >> 0", "-65536");
shouldBe("295147905248072400000 >>> 0", "65536");
shouldBe("-295147905248072400000 >>> 0", "4294901760");
shouldBe("590295810496144700000 >> 0", "131072");
shouldBe("-590295810496144700000 >> 0", "-131072");
shouldBe("590295810496144700000 >>> 0", "131072");
shouldBe("-590295810496144700000 >>> 0", "4294836224");
shouldBe("1.1805916209922895e+21 >> 0", "262144");
shouldBe("-1.1805916209922895e+21 >> 0", "-262144");
shouldBe("1.1805916209922895e+21 >>> 0", "262144");
shouldBe("-1.1805916209922895e+21 >>> 0", "4294705152");
shouldBe("2.361183241984579e+21 >> 0", "524288");
shouldBe("-2.361183241984579e+21 >> 0", "-524288");
shouldBe("2.361183241984579e+21 >>> 0", "524288");
shouldBe("-2.361183241984579e+21 >>> 0", "4294443008");
shouldBe("4.722366483969158e+21 >> 0", "1048576");
shouldBe("-4.722366483969158e+21 >> 0", "-1048576");
shouldBe("4.722366483969158e+21 >>> 0", "1048576");
shouldBe("-4.722366483969158e+21 >>> 0", "4293918720");
shouldBe("9.444732967938316e+21 >> 0", "2097152");
shouldBe("-9.444732967938316e+21 >> 0", "-2097152");
shouldBe("9.444732967938316e+21 >>> 0", "2097152");
shouldBe("-9.444732967938316e+21 >>> 0", "4292870144");
shouldBe("1.888946593587663e+22 >> 0", "4194304");
shouldBe("-1.888946593587663e+22 >> 0", "-4194304");
shouldBe("1.888946593587663e+22 >>> 0", "4194304");
shouldBe("-1.888946593587663e+22 >>> 0", "4290772992");
shouldBe("3.777893187175326e+22 >> 0", "8388608");
shouldBe("-3.777893187175326e+22 >> 0", "-8388608");
shouldBe("3.777893187175326e+22 >>> 0", "8388608");
shouldBe("-3.777893187175326e+22 >>> 0", "4286578688");
shouldBe("7.555786374350653e+22 >> 0", "16777216");
shouldBe("-7.555786374350653e+22 >> 0", "-16777216");
shouldBe("7.555786374350653e+22 >>> 0", "16777216");
shouldBe("-7.555786374350653e+22 >>> 0", "4278190080");
shouldBe("1.5111572748701305e+23 >> 0", "33554432");
shouldBe("-1.5111572748701305e+23 >> 0", "-33554432");
shouldBe("1.5111572748701305e+23 >>> 0", "33554432");
shouldBe("-1.5111572748701305e+23 >>> 0", "4261412864");
shouldBe("3.022314549740261e+23 >> 0", "67108864");
shouldBe("-3.022314549740261e+23 >> 0", "-67108864");
shouldBe("3.022314549740261e+23 >>> 0", "67108864");
shouldBe("-3.022314549740261e+23 >>> 0", "4227858432");
shouldBe("6.044629099480522e+23 >> 0", "134217728");
shouldBe("-6.044629099480522e+23 >> 0", "-134217728");
shouldBe("6.044629099480522e+23 >>> 0", "134217728");
shouldBe("-6.044629099480522e+23 >>> 0", "4160749568");
shouldBe("1.2089258198961044e+24 >> 0", "268435456");
shouldBe("-1.2089258198961044e+24 >> 0", "-268435456");
shouldBe("1.2089258198961044e+24 >>> 0", "268435456");
shouldBe("-1.2089258198961044e+24 >>> 0", "4026531840");
shouldBe("2.417851639792209e+24 >> 0", "536870912");
shouldBe("-2.417851639792209e+24 >> 0", "-536870912");
shouldBe("2.417851639792209e+24 >>> 0", "536870912");
shouldBe("-2.417851639792209e+24 >>> 0", "3758096384");
shouldBe("4.835703279584418e+24 >> 0", "1073741824");
shouldBe("-4.835703279584418e+24 >> 0", "-1073741824");
shouldBe("4.835703279584418e+24 >>> 0", "1073741824");
shouldBe("-4.835703279584418e+24 >>> 0", "3221225472");
shouldBe("9.671406559168835e+24 >> 0", "-2147483648");
shouldBe("-9.671406559168835e+24 >> 0", "-2147483648");
shouldBe("9.671406559168835e+24 >>> 0", "2147483648");
shouldBe("-9.671406559168835e+24 >>> 0", "2147483648");
shouldBe("1.934281311833767e+25 >> 0", "0");
shouldBe("-1.934281311833767e+25 >> 0", "0");
shouldBe("1.934281311833767e+25 >>> 0", "0");
shouldBe("-1.934281311833767e+25 >>> 0", "0");
shouldBe("8589934592 >> 0", "0");
shouldBe("-8589934592 >> 0", "0");
shouldBe("8589934592 >>> 0", "0");
shouldBe("-8589934592 >>> 0", "0");
shouldBe("25769803776 >> 0", "0");
shouldBe("-25769803776 >> 0", "0");
shouldBe("25769803776 >>> 0", "0");
shouldBe("-25769803776 >>> 0", "0");
shouldBe("42949672960 >> 0", "0");
shouldBe("-42949672960 >> 0", "0");
shouldBe("42949672960 >>> 0", "0");
shouldBe("-42949672960 >>> 0", "0");
shouldBe("9223372045444710000 >> 0", "0");
shouldBe("-9223372045444710000 >> 0", "0");
shouldBe("9223372045444710000 >>> 0", "0");
shouldBe("-9223372045444710000 >>> 0", "0");
shouldBe("18446744082299486000 >> 0", "0");
shouldBe("-18446744082299486000 >> 0", "0");
shouldBe("18446744082299486000 >>> 0", "0");
shouldBe("-18446744082299486000 >>> 0", "0");
shouldBe("36893488156009040000 >> 0", "0");
shouldBe("-36893488156009040000 >> 0", "0");
shouldBe("36893488156009040000 >>> 0", "0");
shouldBe("-36893488156009040000 >>> 0", "0");
shouldBe("18446744065119617000 >> 0", "0");
shouldBe("-18446744065119617000 >> 0", "0");
shouldBe("18446744065119617000 >>> 0", "0");
shouldBe("-18446744065119617000 >>> 0", "0");
shouldBe("36893488138829170000 >> 0", "0");
shouldBe("-36893488138829170000 >> 0", "0");
shouldBe("36893488138829170000 >>> 0", "0");
shouldBe("-36893488138829170000 >>> 0", "0");
shouldBe("73786976286248270000 >> 0", "0");
shouldBe("-73786976286248270000 >> 0", "0");
shouldBe("73786976286248270000 >>> 0", "0");
shouldBe("-73786976286248270000 >>> 0", "0");
shouldBe("3.868562623667534e+25 >> 0", "0");
shouldBe("-3.868562623667534e+25 >> 0", "0");
shouldBe("3.868562623667534e+25 >>> 0", "0");
shouldBe("-3.868562623667534e+25 >>> 0", "0");

shouldBe("0 >> 0", "0");
shouldBe("-0 >> 0", "0");
shouldBe("1/0 >> 0", "0");
shouldBe("1/-0 >> 0", "0");
shouldBe("Number.NaN >> 0", "0");
shouldBe("Number.NaN*-1 >> 0", "0");

shouldBe("0 >>> 0", "0");
shouldBe("-0 >>> 0", "0");
shouldBe("1/0 >>> 0", "0");
shouldBe("1/-0 >>> 0", "0");
shouldBe("Number.NaN >>> 0", "0");
shouldBe("Number.NaN*-1 >>> 0", "0");
