/*
 * Copyright (C) 2014 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "ACProcessProxy.h"

#if ENABLE(MANX_AC_PROCESS)

#include "ACProcessCreationParameters.h"
#include "ACProcessMessages.h"
#include "ACProcessProxyMessages.h"
#include "CoordinatedLayerTreeHostMessages.h"
#include "NotImplemented.h"
#include "WebPage.h"
#include "WebProcess.h"
#include <acutil.h>

#define DBG_TRACE printf("%s %d\n", __PRETTY_FUNCTION__, __LINE__)
// #define DBG_TRACE

using namespace WebCore;

namespace WebKit {

ACProcessProxy& ACProcessProxy::shared()
{
    static ACProcessProxy& process = *new ACProcessProxy;
    return process;
}

ACProcessProxy::ACProcessProxy()
{
    connect();

    ACProcessCreationParameters parameters;
    const char* userID = getenv("WEBKIT_USER_ID");
    if (userID)
        parameters.userID = atoi(userID);
    send(Messages::ACProcess::InitializeACProcess(parameters), 0);
}

ACProcessProxy::~ACProcessProxy()
{
    notImplemented();
}

void ACProcessProxy::createLayerTreeHostProxy(uint64_t pageID)
{
    send(Messages::ACProcess::CreateLayerTreeHostProxy(pageID), pageID);
}

void ACProcessProxy::removeLayerTreeHostProxy(uint64_t pageID)
{
    send(Messages::ACProcess::RemoveLayerTreeHostProxy(pageID), pageID);
}

// ACProcess -> WebProcess

// ChildProcessProxy
void ACProcessProxy::getLaunchOptions(ProcessLauncher::LaunchOptions& launchOptions)
{
    char path[256];
    sce::ACUtil::getModuleLocation(path, sizeof(path));
    launchOptions.processType = ProcessLauncher::WebProcess;
    launchOptions.path = path;
}

void ACProcessProxy::connectionWillOpen(CoreIPC::Connection* connection)
{
    DBG_TRACE;
}

void ACProcessProxy::connectionWillClose(CoreIPC::Connection*)
{
    DBG_TRACE;
    notImplemented();
}
    
// CoreIPC::Connection::Client
void ACProcessProxy::didReceiveMessage(CoreIPC::Connection* connection, CoreIPC::MessageDecoder& decoder)
{
    if (dispatchMessage(connection, decoder))
        return;

#if 0 // No message defined.
    if (decoder.messageReceiverName() == Messages::ACProcessProxy::messageReceiverName()) {
        didReceiveACProcessProxyMessage(connection, decoder);
        return;
    }
#endif
}

void ACProcessProxy::didReceiveSyncMessage(CoreIPC::Connection*, CoreIPC::MessageDecoder&, OwnPtr<CoreIPC::MessageEncoder>&)
{
    notImplemented();
}

void ACProcessProxy::didClose(CoreIPC::Connection*)
{
    DBG_TRACE;
    exit(0); // FIXME:
    notImplemented();
}

void ACProcessProxy::didReceiveInvalidMessage(CoreIPC::Connection*, CoreIPC::StringReference messageReceiverName, CoreIPC::StringReference messageName)
{
    notImplemented();
}
    
// ResponsivenessTimer::Client
void ACProcessProxy::didBecomeUnresponsive(ResponsivenessTimer*)
{
    DBG_TRACE;
    notImplemented();
}

void ACProcessProxy::interactionOccurredWhileUnresponsive(ResponsivenessTimer*)
{
    DBG_TRACE;
    notImplemented();
}

void ACProcessProxy::didBecomeResponsive(ResponsivenessTimer*)
{
    DBG_TRACE;
    notImplemented();
}

// ProcessLauncher::Client
void ACProcessProxy::didFinishLaunching(ProcessLauncher* launcher, CoreIPC::Connection::Identifier connectionIdentifier)
{
    ChildProcessProxy::didFinishLaunching(launcher, connectionIdentifier);
}

}

#endif
