/*
 * Copyright (C) 2013 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SONY COMPUTER ENTERTAINMENT INC. ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL SONY COMPUTER ENTERTAINMENT INC.
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef InspectorServerManx_h
#define InspectorServerManx_h

#include "WebSocketServer.h"
#include "WebSocketServerClient.h"
#include <wtf/HashMap.h>
#include <wtf/text/WTFString.h>

namespace WebCore {

class InspectorClientManx;

class InspectorServerManx : public WebKit::WebSocketServer, public WebKit::WebSocketServerClient {
public:
    static InspectorServerManx& shared();

    // Registry to manage known pages.
    int registerClient(InspectorClientManx*);
    void unregisterClient(int clientId);
    void sendMessageOverConnection(unsigned clientIdForConnection, const String& message);

private:
    InspectorServerManx();
    ~InspectorServerManx();

    // WebSocketServerClient implementation. Events coming from remote connections.
    virtual void didReceiveUnrecognizedHTTPRequest(WebKit::WebSocketServerConnection*, PassRefPtr<WebKit::HTTPRequest>);
    virtual bool didReceiveWebSocketUpgradeHTTPRequest(WebKit::WebSocketServerConnection*, PassRefPtr<WebKit::HTTPRequest>);
    virtual void didEstablishWebSocketConnection(WebKit::WebSocketServerConnection*, PassRefPtr<WebKit::HTTPRequest>);
    virtual void didReceiveWebSocketMessage(WebKit::WebSocketServerConnection*, const String& message);
    virtual void didCloseWebSocketConnection(WebKit::WebSocketServerConnection*);

    String inspectorFrontendPath() const;
    String inspectorBasePath() const;
    bool platformResourceForPath(const String& path, Vector<char>& data, String& contentType);

    void closeConnection(InspectorClientManx*, WebKit::WebSocketServerConnection*);
    void updateServerState();

    unsigned m_nextAvailableClientId;
    HashMap<unsigned, InspectorClientManx*> m_clientMap;
    HashMap<unsigned, WebKit::WebSocketServerConnection*> m_connectionMap;
};

}

#endif // InspectorServerManx_h
