/*
 * Copyright 2010, The Android Open Source Project
 * Copyright (C) 2012 Samsung Electronics. All rights reserved.
 * Copyright (C) 2014 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef DeviceOrientationClientManx_h
#define DeviceOrientationClientManx_h

#include "DeviceOrientationClient.h"
#include "DeviceOrientationData.h"
#include <wtf/RefPtr.h>
#include <wtf/ThreadingPrimitives.h>

#if OS(PSP2)
#include <motion/motion.h>
#else
#error This platform is not supported.
#endif

namespace WebCore {

class DeviceOrientationClientManx : public WebCore::DeviceOrientationClient, public motion::OrientationProvider::Client {
public:
    DeviceOrientationClientManx();
    virtual ~DeviceOrientationClientManx();

    // DeviceClient interface
    virtual void startUpdating();
    virtual void stopUpdating();

    // DeviceOrientationClient interface
    virtual void setController(DeviceOrientationController*);
    virtual DeviceOrientationData* lastOrientation() const;
    virtual void deviceOrientationControllerDestroyed();

protected:
    void onUpdate(motion::OrientationData);
    static void handleDidChangeDeviceOrientationOnMainThread(void*);

private:
    DeviceOrientationController* m_controller;
    motion::OrientationProvider* m_provider;
    mutable WTF::Mutex m_mutex;
    mutable RefPtr<DeviceOrientationData> m_lastOrientation;
};

} // namespace WebCore

#endif // DeviceOrientationClientManx_h
