/*
 * Copyright (C) 2008 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "ContextMenuClientManx.h"

#include "ContextMenu.h"
#include "NotImplemented.h"
#include <stdio.h>

namespace WebCore {

ContextMenuClientManx::~ContextMenuClientManx()
{
}

void ContextMenuClientManx::contextMenuDestroyed()
{
    delete this;
}

#if USE(CROSS_PLATFORM_CONTEXT_MENUS)
PassOwnPtr<ContextMenu> ContextMenuClientManx::customizeMenu(PassOwnPtr<ContextMenu> menu)
{
    return menu;
}
#else
PlatformMenuDescription ContextMenuClientManx::getCustomMenuFromDefaultItems(ContextMenu* menu)
{
    return menu->releasePlatformDescription();
}
#endif

void ContextMenuClientManx::contextMenuItemSelected(ContextMenuItem*, const ContextMenu*)
{
    notImplemented();
}

void ContextMenuClientManx::downloadURL(const KURL&)
{
    notImplemented();
}

void ContextMenuClientManx::copyImageToClipboard(const HitTestResult&)
{
    notImplemented();
}

void ContextMenuClientManx::searchWithGoogle(const Frame*)
{
    notImplemented();
}

void ContextMenuClientManx::lookUpInDictionary(Frame*)
{
    notImplemented();
}

void ContextMenuClientManx::speak(const String&)
{
    notImplemented();
}

void ContextMenuClientManx::stopSpeaking()
{
    notImplemented();
}

bool ContextMenuClientManx::isSpeaking()
{
    notImplemented();
    return false;
}

}

