/*
 * Copyright (C) 2014 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SONY COMPUTER ENTERTAINMENT INC. ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL SONY COMPUTER ENTERTAINMENT INC.
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "MemcpyThread.h"

using namespace WebCore;

MemcpyThread::MemcpyThread(const char* threadName) : m_cond(m_mutex)
{
    m_threadId = createThread(MemcpyThread::run, reinterpret_cast<void*>(this), threadName);
}

void MemcpyThread::run(void* argument)
{
    reinterpret_cast<MemcpyThread*>(argument)->run();
}

void MemcpyThread::push(Argument& arg)
{
    if (!arg.isNull()) {
        MutexLocker lock(m_mutex);

        /* [SPEC] Continuous push before wait is illegal */
        if (!m_arg.isNull()) {
            ASSERT(0);
            return;
        }

        m_arg = arg;
        m_cond.signal();
    }
}

void MemcpyThread::wait()
{
    MutexLocker lock(m_mutex);
    while (!m_arg.isNull())
        m_cond.wait(m_mutex);
}

void MemcpyThread::run()
{
    Argument arg;
    while (1) {
        do {
            MutexLocker lock(m_mutex);
            while (m_arg.isNull())
                m_cond.wait(m_mutex);
            arg = m_arg;
        } while (0);

        memcpy(arg.dest, arg.src, arg.size);

        do {
            MutexLocker lock(m_mutex);
            m_arg.clear();
            m_cond.signal();
        } while (0);
    }
}
