/*
 Copyright (C) 2012 Nokia Corporation and/or its subsidiary(-ies)
 Copyright (C) 2014 Sony Computer Entertainment Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 Boston, MA 02110-1301, USA.
 */

#ifndef AcagiBackingStore_h
#define AcagiBackingStore_h

#if USE(ACCELERATED_COMPOSITING) && USE(ACAGI)

#include "AcagiCompositor.h"
#include "FloatRect.h"
#include "Image.h"
#include "PlatformLayerAcagi.h"
#include <wtf/RefPtr.h>

namespace WebCore {

class GraphicsLayer;

class AcagiBackingStore : public PlatformLayerAcagi, public RefCounted<AcagiBackingStore> {
public:
    virtual PassRefPtr<AcagiBitmapTexture> texture() const = 0;
    virtual void compositeContents(AcagiCompositor*, const FloatRect&, const TransformationMatrix&, float) = 0;
    virtual void drawRepaintCounter(AcagiCompositor*, int /* repaintCount */, const Color&, const FloatRect&, const TransformationMatrix&) { }
    virtual ~AcagiBackingStore() { }

protected:
    static unsigned calculateExposedTileEdges(const FloatRect& totalRect, const FloatRect& tileRect);
};

}
#endif

#endif // AcagiBackingStore_h
