/*
 * Copyright (C) 2011 Google Inc. All rights reserved.
 * Copyright (C) 2014 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef InspectorManxAgent_h
#define InspectorManxAgent_h

#if ENABLE(INSPECTOR) && PLATFORM(MANX) && OS(ORBIS)

#include "InspectorBaseAgent.h"
#include "InspectorFrontend.h"
#include <wtf/PassOwnPtr.h>
#include <wtf/RefPtr.h>

namespace WebCore {

class InspectorPageAgent;
class InspectorState;
class InstrumentingAgents;

typedef String ErrorString;

class InspectorManxAgent : public InspectorBaseAgent<InspectorManxAgent>, public InspectorBackendDispatcher::ManxCommandHandler {
    WTF_MAKE_NONCOPYABLE(InspectorManxAgent);
public:
    typedef Vector<OwnPtr<InspectorBaseAgentInterface> > InspectorAgents;

    static PassOwnPtr<InspectorManxAgent> create(InstrumentingAgents* instrumentingAgents, InspectorCompositeState* state, InspectorPageAgent* pageAgent);
    virtual ~InspectorManxAgent();

    virtual void getACMemoryInfo(ErrorString*, RefPtr<TypeBuilder::Manx::ACMemoryInfo>& out_result);

    virtual void setFrontend(InspectorFrontend*);
    virtual void clearFrontend();

private:
    InspectorManxAgent(InstrumentingAgents*, InspectorCompositeState*, InspectorPageAgent*);

    InspectorPageAgent* m_pageAgent;
    InspectorFrontend::Manx* m_frontend;
};

} // namespace WebCore

#endif // !ENABLE(INSPECTOR) && PLATFORM(MANX) && OS(ORBIS)
#endif // !defined(InspectorManxAgent_h)
