/*
 * Copyright (C) 2011 Google Inc. All rights reserved.
 * Copyright (C) 2014 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#if ENABLE(INSPECTOR) && PLATFORM(MANX) && OS(ORBIS)

#include "InspectorManxAgent.h"

#include "BindingVisitors.h"
#include "InspectorFrontend.h"
#include "InspectorPageAgent.h"
#include "InspectorState.h"
#include "InspectorValues.h"
#include "InstrumentingAgents.h"
#include "Page.h"
#include <wtf/ArrayBufferView.h>
#include <wtf/HashSet.h>
#include <wtf/NonCopyingSort.h>
#include <wtf/OwnPtr.h>
#include <wtf/PassOwnPtr.h>
#include <wtf/Vector.h>
#include <wtf/text/StringBuilder.h>
#include <wtf/text/StringImpl.h>
#include <wtf/text/WTFString.h>

namespace WebCore {

InspectorManxAgent::~InspectorManxAgent()
{
}

void InspectorManxAgent::getACMemoryInfo(ErrorString* errorString, RefPtr<TypeBuilder::Manx::ACMemoryInfo>& out_result)
{
    Page* page = m_pageAgent->page();
    const GLMemoryInfo& info = page->acMemoryInfo();
    out_result = TypeBuilder::Manx::ACMemoryInfo::create()
        .setHeap(info.heap)
        .setTexture(info.texture)
        .setSurfaces(info.surfaces)
        .setPrograms(info.programs)
        .setBuffers(info.buffers)
        .setCommandBuffers(info.commandBuffers)
        .setTotal(info.total)
        .setMaxAllowed(info.maxAllowed);
}

InspectorManxAgent::InspectorManxAgent(InstrumentingAgents* instrumentingAgents, InspectorCompositeState* state, InspectorPageAgent* pageAgent)
    : InspectorBaseAgent<InspectorManxAgent>("Manx", instrumentingAgents, state)
    , m_pageAgent(pageAgent)
    , m_frontend(0)
{
}

PassOwnPtr<InspectorManxAgent> InspectorManxAgent::create(InstrumentingAgents* instrumentingAgents, InspectorCompositeState* state, InspectorPageAgent* pageAgent)
{
    return adoptPtr(new InspectorManxAgent(instrumentingAgents, state, pageAgent));
}

void InspectorManxAgent::setFrontend(InspectorFrontend* frontend)
{
    ASSERT(!m_frontend);
    m_frontend = frontend->manx();
}

void InspectorManxAgent::clearFrontend()
{
    m_frontend = 0;
}

} // namespace WebCore

#endif // ENABLE(INSPECTOR) && PLATFORM(MANX) && OS(ORBIS)
