/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathExpression.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNode.h"
#include "JSXPathResult.h"
#include "XPathExpression.h"
#include "XPathResult.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSXPathExpressionTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExpressionConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathExpressionTable = { 2, 1, JSXPathExpressionTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSXPathExpressionConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathExpressionConstructorTable = { 1, 0, JSXPathExpressionConstructorTableValues, 0 };
const ClassInfo JSXPathExpressionConstructor::s_info = { "XPathExpressionConstructor", &Base::s_info, &JSXPathExpressionConstructorTable, 0, CREATE_METHOD_TABLE(JSXPathExpressionConstructor) };

JSXPathExpressionConstructor::JSXPathExpressionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSXPathExpressionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSXPathExpressionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSXPathExpressionConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathExpressionConstructor, JSDOMWrapper>(exec, &JSXPathExpressionConstructorTable, jsCast<JSXPathExpressionConstructor*>(cell), propertyName, slot);
}

bool JSXPathExpressionConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSXPathExpressionConstructor, JSDOMWrapper>(exec, &JSXPathExpressionConstructorTable, jsCast<JSXPathExpressionConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSXPathExpressionPrototypeTableValues[] =
{
    { "evaluate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXPathExpressionPrototypeFunctionEvaluate), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathExpressionPrototypeTable = { 2, 1, JSXPathExpressionPrototypeTableValues, 0 };
const ClassInfo JSXPathExpressionPrototype::s_info = { "XPathExpressionPrototype", &Base::s_info, &JSXPathExpressionPrototypeTable, 0, CREATE_METHOD_TABLE(JSXPathExpressionPrototype) };

JSObject* JSXPathExpressionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXPathExpression>(exec, globalObject);
}

bool JSXPathExpressionPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXPathExpressionPrototype* thisObject = jsCast<JSXPathExpressionPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSXPathExpressionPrototypeTable, thisObject, propertyName, slot);
}

bool JSXPathExpressionPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXPathExpressionPrototype* thisObject = jsCast<JSXPathExpressionPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSXPathExpressionPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSXPathExpression::s_info = { "XPathExpression", &Base::s_info, &JSXPathExpressionTable, 0 , CREATE_METHOD_TABLE(JSXPathExpression) };

JSXPathExpression::JSXPathExpression(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<XPathExpression> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSXPathExpression::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSXPathExpression::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSXPathExpressionPrototype::create(exec->vm(), globalObject, JSXPathExpressionPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSXPathExpression::destroy(JSC::JSCell* cell)
{
    JSXPathExpression* thisObject = static_cast<JSXPathExpression*>(cell);
    thisObject->JSXPathExpression::~JSXPathExpression();
}

JSXPathExpression::~JSXPathExpression()
{
    releaseImplIfNotNull();
}

bool JSXPathExpression::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXPathExpression* thisObject = jsCast<JSXPathExpression*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSXPathExpression, Base>(exec, &JSXPathExpressionTable, thisObject, propertyName, slot);
}

bool JSXPathExpression::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXPathExpression* thisObject = jsCast<JSXPathExpression*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSXPathExpression, Base>(exec, &JSXPathExpressionTable, thisObject, propertyName, descriptor);
}

JSValue jsXPathExpressionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathExpression* domObject = jsCast<JSXPathExpression*>(asObject(slotBase));
    return JSXPathExpression::getConstructor(exec, domObject->globalObject());
}

JSValue JSXPathExpression::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathExpressionConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXPathExpressionPrototypeFunctionEvaluate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXPathExpression::s_info))
        return throwVMTypeError(exec);
    JSXPathExpression* castedThis = jsCast<JSXPathExpression*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXPathExpression::s_info);
    XPathExpression* impl = static_cast<XPathExpression*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* contextNode(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned short type(toUInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    XPathResult* inResult(toXPathResult(exec->argument(2)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->evaluate(contextNode, type, inResult, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSXPathExpression* jsXPathExpression)
{
    if (jsXPathExpression->hasCustomProperties())
        return true;
    return false;
}

bool JSXPathExpressionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSXPathExpression* jsXPathExpression = jsCast<JSXPathExpression*>(handle.get().asCell());
    if (!isObservable(jsXPathExpression))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSXPathExpressionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSXPathExpression* jsXPathExpression = jsCast<JSXPathExpression*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsXPathExpression->impl(), jsXPathExpression);
    jsXPathExpression->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, XPathExpression* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXPathExpression>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XPathExpression.
    COMPILE_ASSERT(!__is_polymorphic(XPathExpression), XPathExpression_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<XPathExpression>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSXPathExpression>(exec, globalObject, impl);
}

XPathExpression* toXPathExpression(JSC::JSValue value)
{
    return value.inherits(&JSXPathExpression::s_info) ? jsCast<JSXPathExpression*>(asObject(value))->impl() : 0;
}

}
