/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathException.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include "XPathException.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSXPathExceptionTableValues[] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionCode), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionName), (intptr_t)0, NoIntrinsic },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionMessage), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathExceptionTable = { 10, 7, JSXPathExceptionTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSXPathExceptionConstructorTableValues[] =
{
    { "INVALID_EXPRESSION_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionINVALID_EXPRESSION_ERR), (intptr_t)0, NoIntrinsic },
    { "TYPE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionTYPE_ERR), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathExceptionConstructorTable = { 4, 3, JSXPathExceptionConstructorTableValues, 0 };
const ClassInfo JSXPathExceptionConstructor::s_info = { "XPathExceptionConstructor", &Base::s_info, &JSXPathExceptionConstructorTable, 0, CREATE_METHOD_TABLE(JSXPathExceptionConstructor) };

JSXPathExceptionConstructor::JSXPathExceptionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSXPathExceptionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSXPathExceptionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSXPathExceptionConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathExceptionConstructor, JSDOMWrapper>(exec, &JSXPathExceptionConstructorTable, jsCast<JSXPathExceptionConstructor*>(cell), propertyName, slot);
}

bool JSXPathExceptionConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSXPathExceptionConstructor, JSDOMWrapper>(exec, &JSXPathExceptionConstructorTable, jsCast<JSXPathExceptionConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSXPathExceptionPrototypeTableValues[] =
{
    { "INVALID_EXPRESSION_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionINVALID_EXPRESSION_ERR), (intptr_t)0, NoIntrinsic },
    { "TYPE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathExceptionTYPE_ERR), (intptr_t)0, NoIntrinsic },
    { "toString", DontDelete | DontEnum | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXPathExceptionPrototypeFunctionToString), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathExceptionPrototypeTable = { 8, 7, JSXPathExceptionPrototypeTableValues, 0 };
const ClassInfo JSXPathExceptionPrototype::s_info = { "XPathExceptionPrototype", &Base::s_info, &JSXPathExceptionPrototypeTable, 0, CREATE_METHOD_TABLE(JSXPathExceptionPrototype) };

JSObject* JSXPathExceptionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXPathException>(exec, globalObject);
}

bool JSXPathExceptionPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXPathExceptionPrototype* thisObject = jsCast<JSXPathExceptionPrototype*>(cell);
    return getStaticPropertySlot<JSXPathExceptionPrototype, JSObject>(exec, &JSXPathExceptionPrototypeTable, thisObject, propertyName, slot);
}

bool JSXPathExceptionPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXPathExceptionPrototype* thisObject = jsCast<JSXPathExceptionPrototype*>(object);
    return getStaticPropertyDescriptor<JSXPathExceptionPrototype, JSObject>(exec, &JSXPathExceptionPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSXPathException::s_info = { "XPathException", &Base::s_info, &JSXPathExceptionTable, 0 , CREATE_METHOD_TABLE(JSXPathException) };

JSXPathException::JSXPathException(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<XPathException> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSXPathException::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSXPathException::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSXPathExceptionPrototype::create(exec->vm(), globalObject, JSXPathExceptionPrototype::createStructure(globalObject->vm(), globalObject, globalObject->errorPrototype()));
}

void JSXPathException::destroy(JSC::JSCell* cell)
{
    JSXPathException* thisObject = static_cast<JSXPathException*>(cell);
    thisObject->JSXPathException::~JSXPathException();
}

JSXPathException::~JSXPathException()
{
    releaseImplIfNotNull();
}

bool JSXPathException::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXPathException* thisObject = jsCast<JSXPathException*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSXPathException, Base>(exec, &JSXPathExceptionTable, thisObject, propertyName, slot);
}

bool JSXPathException::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXPathException* thisObject = jsCast<JSXPathException*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSXPathException, Base>(exec, &JSXPathExceptionTable, thisObject, propertyName, descriptor);
}

JSValue jsXPathExceptionCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathException* castedThis = jsCast<JSXPathException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XPathException* impl = static_cast<XPathException*>(castedThis->impl());
    JSValue result = jsNumber(impl->code());
    return result;
}


JSValue jsXPathExceptionName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathException* castedThis = jsCast<JSXPathException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XPathException* impl = static_cast<XPathException*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsXPathExceptionMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathException* castedThis = jsCast<JSXPathException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XPathException* impl = static_cast<XPathException*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->message());
    return result;
}


JSValue jsXPathExceptionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathException* domObject = jsCast<JSXPathException*>(asObject(slotBase));
    return JSXPathException::getConstructor(exec, domObject->globalObject());
}

JSValue JSXPathException::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathExceptionConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXPathExceptionPrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXPathException::s_info))
        return throwVMTypeError(exec);
    JSXPathException* castedThis = jsCast<JSXPathException*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXPathException::s_info);
    XPathException* impl = static_cast<XPathException*>(castedThis->impl());

    JSC::JSValue result = jsStringWithCache(exec, impl->toString());
    return JSValue::encode(result);
}

// Constant getters

JSValue jsXPathExceptionINVALID_EXPRESSION_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(51));
}

JSValue jsXPathExceptionTYPE_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(52));
}

static inline bool isObservable(JSXPathException* jsXPathException)
{
    if (jsXPathException->hasCustomProperties())
        return true;
    return false;
}

bool JSXPathExceptionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSXPathException* jsXPathException = jsCast<JSXPathException*>(handle.get().asCell());
    if (!isObservable(jsXPathException))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSXPathExceptionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSXPathException* jsXPathException = jsCast<JSXPathException*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsXPathException->impl(), jsXPathException);
    jsXPathException->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, XPathException* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXPathException>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XPathException.
    COMPILE_ASSERT(!__is_polymorphic(XPathException), XPathException_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<XPathException>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSXPathException>(exec, globalObject, impl);
}

XPathException* toXPathException(JSC::JSValue value)
{
    return value.inherits(&JSXPathException::s_info) ? jsCast<JSXPathException*>(asObject(value))->impl() : 0;
}

}
