/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathEvaluator.h"

#include "ExceptionCode.h"
#include "JSCustomXPathNSResolver.h"
#include "JSDOMBinding.h"
#include "JSNode.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "XPathEvaluator.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSXPathEvaluatorTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathEvaluatorConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathEvaluatorTable = { 2, 1, JSXPathEvaluatorTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSXPathEvaluatorConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathEvaluatorConstructorTable = { 1, 0, JSXPathEvaluatorConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSXPathEvaluatorConstructor::constructJSXPathEvaluator(ExecState* exec)
{
    JSXPathEvaluatorConstructor* castedThis = jsCast<JSXPathEvaluatorConstructor*>(exec->callee());
    RefPtr<XPathEvaluator> object = XPathEvaluator::create();
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

const ClassInfo JSXPathEvaluatorConstructor::s_info = { "XPathEvaluatorConstructor", &Base::s_info, &JSXPathEvaluatorConstructorTable, 0, CREATE_METHOD_TABLE(JSXPathEvaluatorConstructor) };

JSXPathEvaluatorConstructor::JSXPathEvaluatorConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSXPathEvaluatorConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSXPathEvaluatorPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSXPathEvaluatorConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathEvaluatorConstructor, JSDOMWrapper>(exec, &JSXPathEvaluatorConstructorTable, jsCast<JSXPathEvaluatorConstructor*>(cell), propertyName, slot);
}

bool JSXPathEvaluatorConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSXPathEvaluatorConstructor, JSDOMWrapper>(exec, &JSXPathEvaluatorConstructorTable, jsCast<JSXPathEvaluatorConstructor*>(object), propertyName, descriptor);
}

ConstructType JSXPathEvaluatorConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSXPathEvaluator;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSXPathEvaluatorPrototypeTableValues[] =
{
    { "createExpression", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXPathEvaluatorPrototypeFunctionCreateExpression), (intptr_t)0, NoIntrinsic },
    { "createNSResolver", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXPathEvaluatorPrototypeFunctionCreateNSResolver), (intptr_t)0, NoIntrinsic },
    { "evaluate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXPathEvaluatorPrototypeFunctionEvaluate), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathEvaluatorPrototypeTable = { 8, 7, JSXPathEvaluatorPrototypeTableValues, 0 };
const ClassInfo JSXPathEvaluatorPrototype::s_info = { "XPathEvaluatorPrototype", &Base::s_info, &JSXPathEvaluatorPrototypeTable, 0, CREATE_METHOD_TABLE(JSXPathEvaluatorPrototype) };

JSObject* JSXPathEvaluatorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXPathEvaluator>(exec, globalObject);
}

bool JSXPathEvaluatorPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXPathEvaluatorPrototype* thisObject = jsCast<JSXPathEvaluatorPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSXPathEvaluatorPrototypeTable, thisObject, propertyName, slot);
}

bool JSXPathEvaluatorPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXPathEvaluatorPrototype* thisObject = jsCast<JSXPathEvaluatorPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSXPathEvaluatorPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSXPathEvaluator::s_info = { "XPathEvaluator", &Base::s_info, &JSXPathEvaluatorTable, 0 , CREATE_METHOD_TABLE(JSXPathEvaluator) };

JSXPathEvaluator::JSXPathEvaluator(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<XPathEvaluator> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSXPathEvaluator::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSXPathEvaluator::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSXPathEvaluatorPrototype::create(exec->vm(), globalObject, JSXPathEvaluatorPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSXPathEvaluator::destroy(JSC::JSCell* cell)
{
    JSXPathEvaluator* thisObject = static_cast<JSXPathEvaluator*>(cell);
    thisObject->JSXPathEvaluator::~JSXPathEvaluator();
}

JSXPathEvaluator::~JSXPathEvaluator()
{
    releaseImplIfNotNull();
}

bool JSXPathEvaluator::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXPathEvaluator* thisObject = jsCast<JSXPathEvaluator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSXPathEvaluator, Base>(exec, &JSXPathEvaluatorTable, thisObject, propertyName, slot);
}

bool JSXPathEvaluator::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXPathEvaluator* thisObject = jsCast<JSXPathEvaluator*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSXPathEvaluator, Base>(exec, &JSXPathEvaluatorTable, thisObject, propertyName, descriptor);
}

JSValue jsXPathEvaluatorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathEvaluator* domObject = jsCast<JSXPathEvaluator*>(asObject(slotBase));
    return JSXPathEvaluator::getConstructor(exec, domObject->globalObject());
}

JSValue JSXPathEvaluator::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathEvaluatorConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXPathEvaluatorPrototypeFunctionCreateExpression(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXPathEvaluator::s_info))
        return throwVMTypeError(exec);
    JSXPathEvaluator* castedThis = jsCast<JSXPathEvaluator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXPathEvaluator::s_info);
    XPathEvaluator* impl = static_cast<XPathEvaluator*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& expression(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(exec->argument(1));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, exec->argument(1));
        if (exec->hadException())
            return JSValue::encode(jsUndefined());
        resolver = customResolver.get();
    }

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createExpression(expression, resolver, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXPathEvaluatorPrototypeFunctionCreateNSResolver(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXPathEvaluator::s_info))
        return throwVMTypeError(exec);
    JSXPathEvaluator* castedThis = jsCast<JSXPathEvaluator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXPathEvaluator::s_info);
    XPathEvaluator* impl = static_cast<XPathEvaluator*>(castedThis->impl());
    Node* nodeResolver(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createNSResolver(nodeResolver)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXPathEvaluatorPrototypeFunctionEvaluate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXPathEvaluator::s_info))
        return throwVMTypeError(exec);
    JSXPathEvaluator* castedThis = jsCast<JSXPathEvaluator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXPathEvaluator::s_info);
    XPathEvaluator* impl = static_cast<XPathEvaluator*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& expression(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Node* contextNode(toNode(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(exec->argument(2));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, exec->argument(2));
        if (exec->hadException())
            return JSValue::encode(jsUndefined());
        resolver = customResolver.get();
    }
    unsigned short type(toUInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    XPathResult* inResult(toXPathResult(exec->argument(4)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->evaluate(expression, contextNode, resolver, type, inResult, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSXPathEvaluator* jsXPathEvaluator)
{
    if (jsXPathEvaluator->hasCustomProperties())
        return true;
    return false;
}

bool JSXPathEvaluatorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSXPathEvaluator* jsXPathEvaluator = jsCast<JSXPathEvaluator*>(handle.get().asCell());
    if (!isObservable(jsXPathEvaluator))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSXPathEvaluatorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSXPathEvaluator* jsXPathEvaluator = jsCast<JSXPathEvaluator*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsXPathEvaluator->impl(), jsXPathEvaluator);
    jsXPathEvaluator->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, XPathEvaluator* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXPathEvaluator>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XPathEvaluator.
    COMPILE_ASSERT(!__is_polymorphic(XPathEvaluator), XPathEvaluator_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<XPathEvaluator>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSXPathEvaluator>(exec, globalObject, impl);
}

XPathEvaluator* toXPathEvaluator(JSC::JSValue value)
{
    return value.inherits(&JSXPathEvaluator::s_info) ? jsCast<JSXPathEvaluator*>(asObject(value))->impl() : 0;
}

}
