/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWheelEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "JSDictionary.h"
#include "WheelEvent.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWheelEventTableValues[] =
{
    { "wheelDeltaX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDeltaX), (intptr_t)0, NoIntrinsic },
    { "wheelDeltaY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDeltaY), (intptr_t)0, NoIntrinsic },
    { "deltaMode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDeltaMode), (intptr_t)0, NoIntrinsic },
    { "wheelDelta", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDelta), (intptr_t)0, NoIntrinsic },
    { "webkitDirectionInvertedFromDevice", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWebkitDirectionInvertedFromDevice), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWheelEventTable = { 18, 15, JSWheelEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWheelEventConstructorTableValues[] =
{
    { "DOM_DELTA_PIXEL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDOM_DELTA_PIXEL), (intptr_t)0, NoIntrinsic },
    { "DOM_DELTA_LINE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDOM_DELTA_LINE), (intptr_t)0, NoIntrinsic },
    { "DOM_DELTA_PAGE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDOM_DELTA_PAGE), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWheelEventConstructorTable = { 9, 7, JSWheelEventConstructorTableValues, 0 };

COMPILE_ASSERT(0x00 == WheelEvent::DOM_DELTA_PIXEL, WheelEventEnumDOM_DELTA_PIXELIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x01 == WheelEvent::DOM_DELTA_LINE, WheelEventEnumDOM_DELTA_LINEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x02 == WheelEvent::DOM_DELTA_PAGE, WheelEventEnumDOM_DELTA_PAGEIsWrongUseDoNotCheckConstants);

EncodedJSValue JSC_HOST_CALL JSWheelEventConstructor::constructJSWheelEvent(ExecState* exec)
{
    JSWheelEventConstructor* jsConstructor = jsCast<JSWheelEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    WheelEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillWheelEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<WheelEvent> event = WheelEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillWheelEventInit(WheelEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillMouseEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("wheelDeltaX", eventInit.wheelDeltaX))
        return false;
    if (!dictionary.tryGetProperty("wheelDeltaY", eventInit.wheelDeltaY))
        return false;
    if (!dictionary.tryGetProperty("deltaMode", eventInit.deltaMode))
        return false;
    return true;
}

const ClassInfo JSWheelEventConstructor::s_info = { "WheelEventConstructor", &Base::s_info, &JSWheelEventConstructorTable, 0, CREATE_METHOD_TABLE(JSWheelEventConstructor) };

JSWheelEventConstructor::JSWheelEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWheelEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSWheelEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSWheelEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWheelEventConstructor, JSDOMWrapper>(exec, &JSWheelEventConstructorTable, jsCast<JSWheelEventConstructor*>(cell), propertyName, slot);
}

bool JSWheelEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWheelEventConstructor, JSDOMWrapper>(exec, &JSWheelEventConstructorTable, jsCast<JSWheelEventConstructor*>(object), propertyName, descriptor);
}

#if ENABLE(DOM4_EVENTS_CONSTRUCTOR)
ConstructType JSWheelEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSWheelEvent;
    return ConstructTypeHost;
}
#endif // ENABLE(DOM4_EVENTS_CONSTRUCTOR)

/* Hash table for prototype */

static const HashTableValue JSWheelEventPrototypeTableValues[] =
{
    { "DOM_DELTA_PIXEL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDOM_DELTA_PIXEL), (intptr_t)0, NoIntrinsic },
    { "DOM_DELTA_LINE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDOM_DELTA_LINE), (intptr_t)0, NoIntrinsic },
    { "DOM_DELTA_PAGE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDOM_DELTA_PAGE), (intptr_t)0, NoIntrinsic },
    { "initWebKitWheelEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWheelEventPrototypeFunctionInitWebKitWheelEvent), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWheelEventPrototypeTable = { 9, 7, JSWheelEventPrototypeTableValues, 0 };
const ClassInfo JSWheelEventPrototype::s_info = { "WheelEventPrototype", &Base::s_info, &JSWheelEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSWheelEventPrototype) };

JSObject* JSWheelEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWheelEvent>(exec, globalObject);
}

bool JSWheelEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWheelEventPrototype* thisObject = jsCast<JSWheelEventPrototype*>(cell);
    return getStaticPropertySlot<JSWheelEventPrototype, JSObject>(exec, &JSWheelEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSWheelEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWheelEventPrototype* thisObject = jsCast<JSWheelEventPrototype*>(object);
    return getStaticPropertyDescriptor<JSWheelEventPrototype, JSObject>(exec, &JSWheelEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSWheelEvent::s_info = { "WheelEvent", &Base::s_info, &JSWheelEventTable, 0 , CREATE_METHOD_TABLE(JSWheelEvent) };

JSWheelEvent::JSWheelEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WheelEvent> impl)
    : JSMouseEvent(structure, globalObject, impl)
{
}

void JSWheelEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSWheelEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWheelEventPrototype::create(exec->vm(), globalObject, JSWheelEventPrototype::createStructure(exec->vm(), globalObject, JSMouseEventPrototype::self(exec, globalObject)));
}

bool JSWheelEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWheelEvent* thisObject = jsCast<JSWheelEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWheelEvent, Base>(exec, &JSWheelEventTable, thisObject, propertyName, slot);
}

bool JSWheelEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWheelEvent* thisObject = jsCast<JSWheelEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWheelEvent, Base>(exec, &JSWheelEventTable, thisObject, propertyName, descriptor);
}

JSValue jsWheelEventWheelDeltaX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->wheelDeltaX());
    return result;
}


JSValue jsWheelEventWheelDeltaY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->wheelDeltaY());
    return result;
}


JSValue jsWheelEventDeltaMode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->deltaMode());
    return result;
}


JSValue jsWheelEventWheelDelta(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->wheelDelta());
    return result;
}


JSValue jsWheelEventWebkitDirectionInvertedFromDevice(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->webkitDirectionInvertedFromDevice());
    return result;
}


JSValue jsWheelEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWheelEvent* domObject = jsCast<JSWheelEvent*>(asObject(slotBase));
    return JSWheelEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSWheelEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWheelEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWheelEventPrototypeFunctionInitWebKitWheelEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWheelEvent::s_info))
        return throwVMTypeError(exec);
    JSWheelEvent* castedThis = jsCast<JSWheelEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWheelEvent::s_info);
    WheelEvent* impl = static_cast<WheelEvent*>(castedThis->impl());
    int wheelDeltaX(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int wheelDeltaY(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMWindow* view(toDOMWindow(exec->argument(2)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenX(toInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenY(toInt32(exec, exec->argument(4), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int clientX(toInt32(exec, exec->argument(5), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int clientY(toInt32(exec, exec->argument(6), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool ctrlKey(exec->argument(7).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool altKey(exec->argument(8).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool shiftKey(exec->argument(9).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool metaKey(exec->argument(10).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initWebKitWheelEvent(wheelDeltaX, wheelDeltaY, view, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsWheelEventDOM_DELTA_PIXEL(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00));
}

JSValue jsWheelEventDOM_DELTA_LINE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x01));
}

JSValue jsWheelEventDOM_DELTA_PAGE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x02));
}


}
