/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSS_DEVICE_ADAPTATION)

#include "JSWebKitCSSViewportRule.h"

#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "StylePropertySet.h"
#include "WebKitCSSViewportRule.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebKitCSSViewportRuleTableValues[] =
{
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSViewportRuleStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSViewportRuleConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSViewportRuleTable = { 4, 3, JSWebKitCSSViewportRuleTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebKitCSSViewportRuleConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSViewportRuleConstructorTable = { 1, 0, JSWebKitCSSViewportRuleConstructorTableValues, 0 };
const ClassInfo JSWebKitCSSViewportRuleConstructor::s_info = { "WebKitCSSViewportRuleConstructor", &Base::s_info, &JSWebKitCSSViewportRuleConstructorTable, 0, CREATE_METHOD_TABLE(JSWebKitCSSViewportRuleConstructor) };

JSWebKitCSSViewportRuleConstructor::JSWebKitCSSViewportRuleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitCSSViewportRuleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSWebKitCSSViewportRulePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSWebKitCSSViewportRuleConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitCSSViewportRuleConstructor, JSDOMWrapper>(exec, &JSWebKitCSSViewportRuleConstructorTable, jsCast<JSWebKitCSSViewportRuleConstructor*>(cell), propertyName, slot);
}

bool JSWebKitCSSViewportRuleConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitCSSViewportRuleConstructor, JSDOMWrapper>(exec, &JSWebKitCSSViewportRuleConstructorTable, jsCast<JSWebKitCSSViewportRuleConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitCSSViewportRulePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSViewportRulePrototypeTable = { 1, 0, JSWebKitCSSViewportRulePrototypeTableValues, 0 };
const ClassInfo JSWebKitCSSViewportRulePrototype::s_info = { "WebKitCSSViewportRulePrototype", &Base::s_info, &JSWebKitCSSViewportRulePrototypeTable, 0, CREATE_METHOD_TABLE(JSWebKitCSSViewportRulePrototype) };

JSObject* JSWebKitCSSViewportRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitCSSViewportRule>(exec, globalObject);
}

const ClassInfo JSWebKitCSSViewportRule::s_info = { "WebKitCSSViewportRule", &Base::s_info, &JSWebKitCSSViewportRuleTable, 0 , CREATE_METHOD_TABLE(JSWebKitCSSViewportRule) };

JSWebKitCSSViewportRule::JSWebKitCSSViewportRule(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitCSSViewportRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

void JSWebKitCSSViewportRule::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitCSSViewportRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitCSSViewportRulePrototype::create(exec->vm(), globalObject, JSWebKitCSSViewportRulePrototype::createStructure(exec->vm(), globalObject, JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSWebKitCSSViewportRule::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitCSSViewportRule* thisObject = jsCast<JSWebKitCSSViewportRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebKitCSSViewportRule, Base>(exec, &JSWebKitCSSViewportRuleTable, thisObject, propertyName, slot);
}

bool JSWebKitCSSViewportRule::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitCSSViewportRule* thisObject = jsCast<JSWebKitCSSViewportRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebKitCSSViewportRule, Base>(exec, &JSWebKitCSSViewportRuleTable, thisObject, propertyName, descriptor);
}

JSValue jsWebKitCSSViewportRuleStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitCSSViewportRule* castedThis = jsCast<JSWebKitCSSViewportRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSViewportRule* impl = static_cast<WebKitCSSViewportRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsWebKitCSSViewportRuleConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitCSSViewportRule* domObject = jsCast<JSWebKitCSSViewportRule*>(asObject(slotBase));
    return JSWebKitCSSViewportRule::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebKitCSSViewportRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitCSSViewportRuleConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(CSS_DEVICE_ADAPTATION)
