/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitCSSKeyframeRule.h"

#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "KURL.h"
#include "StylePropertySet.h"
#include "WebKitCSSKeyframeRule.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebKitCSSKeyframeRuleTableValues[] =
{
    { "keyText", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSKeyframeRuleKeyText), (intptr_t)setJSWebKitCSSKeyframeRuleKeyText, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSKeyframeRuleStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSKeyframeRuleConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSKeyframeRuleTable = { 9, 7, JSWebKitCSSKeyframeRuleTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebKitCSSKeyframeRuleConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSKeyframeRuleConstructorTable = { 1, 0, JSWebKitCSSKeyframeRuleConstructorTableValues, 0 };
const ClassInfo JSWebKitCSSKeyframeRuleConstructor::s_info = { "WebKitCSSKeyframeRuleConstructor", &Base::s_info, &JSWebKitCSSKeyframeRuleConstructorTable, 0, CREATE_METHOD_TABLE(JSWebKitCSSKeyframeRuleConstructor) };

JSWebKitCSSKeyframeRuleConstructor::JSWebKitCSSKeyframeRuleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitCSSKeyframeRuleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSWebKitCSSKeyframeRulePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSWebKitCSSKeyframeRuleConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitCSSKeyframeRuleConstructor, JSDOMWrapper>(exec, &JSWebKitCSSKeyframeRuleConstructorTable, jsCast<JSWebKitCSSKeyframeRuleConstructor*>(cell), propertyName, slot);
}

bool JSWebKitCSSKeyframeRuleConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitCSSKeyframeRuleConstructor, JSDOMWrapper>(exec, &JSWebKitCSSKeyframeRuleConstructorTable, jsCast<JSWebKitCSSKeyframeRuleConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitCSSKeyframeRulePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSKeyframeRulePrototypeTable = { 1, 0, JSWebKitCSSKeyframeRulePrototypeTableValues, 0 };
const ClassInfo JSWebKitCSSKeyframeRulePrototype::s_info = { "WebKitCSSKeyframeRulePrototype", &Base::s_info, &JSWebKitCSSKeyframeRulePrototypeTable, 0, CREATE_METHOD_TABLE(JSWebKitCSSKeyframeRulePrototype) };

JSObject* JSWebKitCSSKeyframeRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitCSSKeyframeRule>(exec, globalObject);
}

const ClassInfo JSWebKitCSSKeyframeRule::s_info = { "WebKitCSSKeyframeRule", &Base::s_info, &JSWebKitCSSKeyframeRuleTable, 0 , CREATE_METHOD_TABLE(JSWebKitCSSKeyframeRule) };

JSWebKitCSSKeyframeRule::JSWebKitCSSKeyframeRule(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitCSSKeyframeRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

void JSWebKitCSSKeyframeRule::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitCSSKeyframeRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitCSSKeyframeRulePrototype::create(exec->vm(), globalObject, JSWebKitCSSKeyframeRulePrototype::createStructure(exec->vm(), globalObject, JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSWebKitCSSKeyframeRule::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitCSSKeyframeRule* thisObject = jsCast<JSWebKitCSSKeyframeRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebKitCSSKeyframeRule, Base>(exec, &JSWebKitCSSKeyframeRuleTable, thisObject, propertyName, slot);
}

bool JSWebKitCSSKeyframeRule::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitCSSKeyframeRule* thisObject = jsCast<JSWebKitCSSKeyframeRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebKitCSSKeyframeRule, Base>(exec, &JSWebKitCSSKeyframeRuleTable, thisObject, propertyName, descriptor);
}

JSValue jsWebKitCSSKeyframeRuleKeyText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitCSSKeyframeRule* castedThis = jsCast<JSWebKitCSSKeyframeRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSKeyframeRule* impl = static_cast<WebKitCSSKeyframeRule*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->keyText());
    return result;
}


JSValue jsWebKitCSSKeyframeRuleStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitCSSKeyframeRule* castedThis = jsCast<JSWebKitCSSKeyframeRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSKeyframeRule* impl = static_cast<WebKitCSSKeyframeRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsWebKitCSSKeyframeRuleConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitCSSKeyframeRule* domObject = jsCast<JSWebKitCSSKeyframeRule*>(asObject(slotBase));
    return JSWebKitCSSKeyframeRule::getConstructor(exec, domObject->globalObject());
}

void JSWebKitCSSKeyframeRule::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSWebKitCSSKeyframeRule* thisObject = jsCast<JSWebKitCSSKeyframeRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSWebKitCSSKeyframeRule, Base>(exec, propertyName, value, &JSWebKitCSSKeyframeRuleTable, thisObject, slot);
}

void setJSWebKitCSSKeyframeRuleKeyText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSWebKitCSSKeyframeRule* castedThis = jsCast<JSWebKitCSSKeyframeRule*>(thisObject);
    WebKitCSSKeyframeRule* impl = static_cast<WebKitCSSKeyframeRule*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setKeyText(nativeValue);
}


JSValue JSWebKitCSSKeyframeRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitCSSKeyframeRuleConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
