/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLShaderPrecisionFormat.h"

#include "WebGLShaderPrecisionFormat.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebGLShaderPrecisionFormatTableValues[] =
{
    { "rangeMin", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatRangeMin), (intptr_t)0, NoIntrinsic },
    { "rangeMax", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatRangeMax), (intptr_t)0, NoIntrinsic },
    { "precision", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatPrecision), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderPrecisionFormatConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLShaderPrecisionFormatTable = { 9, 7, JSWebGLShaderPrecisionFormatTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebGLShaderPrecisionFormatConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLShaderPrecisionFormatConstructorTable = { 1, 0, JSWebGLShaderPrecisionFormatConstructorTableValues, 0 };
const ClassInfo JSWebGLShaderPrecisionFormatConstructor::s_info = { "WebGLShaderPrecisionFormatConstructor", &Base::s_info, &JSWebGLShaderPrecisionFormatConstructorTable, 0, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormatConstructor) };

JSWebGLShaderPrecisionFormatConstructor::JSWebGLShaderPrecisionFormatConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLShaderPrecisionFormatConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSWebGLShaderPrecisionFormatPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSWebGLShaderPrecisionFormatConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLShaderPrecisionFormatConstructor, JSDOMWrapper>(exec, &JSWebGLShaderPrecisionFormatConstructorTable, jsCast<JSWebGLShaderPrecisionFormatConstructor*>(cell), propertyName, slot);
}

bool JSWebGLShaderPrecisionFormatConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLShaderPrecisionFormatConstructor, JSDOMWrapper>(exec, &JSWebGLShaderPrecisionFormatConstructorTable, jsCast<JSWebGLShaderPrecisionFormatConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLShaderPrecisionFormatPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLShaderPrecisionFormatPrototypeTable = { 1, 0, JSWebGLShaderPrecisionFormatPrototypeTableValues, 0 };
const ClassInfo JSWebGLShaderPrecisionFormatPrototype::s_info = { "WebGLShaderPrecisionFormatPrototype", &Base::s_info, &JSWebGLShaderPrecisionFormatPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormatPrototype) };

JSObject* JSWebGLShaderPrecisionFormatPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLShaderPrecisionFormat>(exec, globalObject);
}

const ClassInfo JSWebGLShaderPrecisionFormat::s_info = { "WebGLShaderPrecisionFormat", &Base::s_info, &JSWebGLShaderPrecisionFormatTable, 0 , CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormat) };

JSWebGLShaderPrecisionFormat::JSWebGLShaderPrecisionFormat(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLShaderPrecisionFormat> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebGLShaderPrecisionFormat::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLShaderPrecisionFormat::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLShaderPrecisionFormatPrototype::create(exec->vm(), globalObject, JSWebGLShaderPrecisionFormatPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSWebGLShaderPrecisionFormat::destroy(JSC::JSCell* cell)
{
    JSWebGLShaderPrecisionFormat* thisObject = static_cast<JSWebGLShaderPrecisionFormat*>(cell);
    thisObject->JSWebGLShaderPrecisionFormat::~JSWebGLShaderPrecisionFormat();
}

JSWebGLShaderPrecisionFormat::~JSWebGLShaderPrecisionFormat()
{
    releaseImplIfNotNull();
}

bool JSWebGLShaderPrecisionFormat::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLShaderPrecisionFormat* thisObject = jsCast<JSWebGLShaderPrecisionFormat*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebGLShaderPrecisionFormat, Base>(exec, &JSWebGLShaderPrecisionFormatTable, thisObject, propertyName, slot);
}

bool JSWebGLShaderPrecisionFormat::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLShaderPrecisionFormat* thisObject = jsCast<JSWebGLShaderPrecisionFormat*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebGLShaderPrecisionFormat, Base>(exec, &JSWebGLShaderPrecisionFormatTable, thisObject, propertyName, descriptor);
}

JSValue jsWebGLShaderPrecisionFormatRangeMin(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLShaderPrecisionFormat* castedThis = jsCast<JSWebGLShaderPrecisionFormat*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLShaderPrecisionFormat* impl = static_cast<WebGLShaderPrecisionFormat*>(castedThis->impl());
    JSValue result = jsNumber(impl->rangeMin());
    return result;
}


JSValue jsWebGLShaderPrecisionFormatRangeMax(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLShaderPrecisionFormat* castedThis = jsCast<JSWebGLShaderPrecisionFormat*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLShaderPrecisionFormat* impl = static_cast<WebGLShaderPrecisionFormat*>(castedThis->impl());
    JSValue result = jsNumber(impl->rangeMax());
    return result;
}


JSValue jsWebGLShaderPrecisionFormatPrecision(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLShaderPrecisionFormat* castedThis = jsCast<JSWebGLShaderPrecisionFormat*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLShaderPrecisionFormat* impl = static_cast<WebGLShaderPrecisionFormat*>(castedThis->impl());
    JSValue result = jsNumber(impl->precision());
    return result;
}


JSValue jsWebGLShaderPrecisionFormatConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLShaderPrecisionFormat* domObject = jsCast<JSWebGLShaderPrecisionFormat*>(asObject(slotBase));
    return JSWebGLShaderPrecisionFormat::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLShaderPrecisionFormat::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLShaderPrecisionFormatConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSWebGLShaderPrecisionFormat* jsWebGLShaderPrecisionFormat)
{
    if (jsWebGLShaderPrecisionFormat->hasCustomProperties())
        return true;
    return false;
}

bool JSWebGLShaderPrecisionFormatOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebGLShaderPrecisionFormat* jsWebGLShaderPrecisionFormat = jsCast<JSWebGLShaderPrecisionFormat*>(handle.get().asCell());
    if (!isObservable(jsWebGLShaderPrecisionFormat))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLShaderPrecisionFormatOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebGLShaderPrecisionFormat* jsWebGLShaderPrecisionFormat = jsCast<JSWebGLShaderPrecisionFormat*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLShaderPrecisionFormat->impl(), jsWebGLShaderPrecisionFormat);
    jsWebGLShaderPrecisionFormat->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLShaderPrecisionFormat* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLShaderPrecisionFormat>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WebGLShaderPrecisionFormat.
    COMPILE_ASSERT(!__is_polymorphic(WebGLShaderPrecisionFormat), WebGLShaderPrecisionFormat_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<WebGLShaderPrecisionFormat>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSWebGLShaderPrecisionFormat>(exec, globalObject, impl);
}

WebGLShaderPrecisionFormat* toWebGLShaderPrecisionFormat(JSC::JSValue value)
{
    return value.inherits(&JSWebGLShaderPrecisionFormat::s_info) ? jsCast<JSWebGLShaderPrecisionFormat*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
