/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLShader.h"

#include "WebGLShader.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebGLShaderTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLShaderConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLShaderTable = { 2, 1, JSWebGLShaderTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebGLShaderConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLShaderConstructorTable = { 1, 0, JSWebGLShaderConstructorTableValues, 0 };
const ClassInfo JSWebGLShaderConstructor::s_info = { "WebGLShaderConstructor", &Base::s_info, &JSWebGLShaderConstructorTable, 0, CREATE_METHOD_TABLE(JSWebGLShaderConstructor) };

JSWebGLShaderConstructor::JSWebGLShaderConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLShaderConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSWebGLShaderPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSWebGLShaderConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLShaderConstructor, JSDOMWrapper>(exec, &JSWebGLShaderConstructorTable, jsCast<JSWebGLShaderConstructor*>(cell), propertyName, slot);
}

bool JSWebGLShaderConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLShaderConstructor, JSDOMWrapper>(exec, &JSWebGLShaderConstructorTable, jsCast<JSWebGLShaderConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLShaderPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLShaderPrototypeTable = { 1, 0, JSWebGLShaderPrototypeTableValues, 0 };
const ClassInfo JSWebGLShaderPrototype::s_info = { "WebGLShaderPrototype", &Base::s_info, &JSWebGLShaderPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLShaderPrototype) };

JSObject* JSWebGLShaderPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLShader>(exec, globalObject);
}

const ClassInfo JSWebGLShader::s_info = { "WebGLShader", &Base::s_info, &JSWebGLShaderTable, 0 , CREATE_METHOD_TABLE(JSWebGLShader) };

JSWebGLShader::JSWebGLShader(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLShader> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebGLShader::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLShader::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLShaderPrototype::create(exec->vm(), globalObject, JSWebGLShaderPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSWebGLShader::destroy(JSC::JSCell* cell)
{
    JSWebGLShader* thisObject = static_cast<JSWebGLShader*>(cell);
    thisObject->JSWebGLShader::~JSWebGLShader();
}

JSWebGLShader::~JSWebGLShader()
{
    releaseImplIfNotNull();
}

bool JSWebGLShader::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLShader* thisObject = jsCast<JSWebGLShader*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebGLShader, Base>(exec, &JSWebGLShaderTable, thisObject, propertyName, slot);
}

bool JSWebGLShader::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLShader* thisObject = jsCast<JSWebGLShader*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebGLShader, Base>(exec, &JSWebGLShaderTable, thisObject, propertyName, descriptor);
}

JSValue jsWebGLShaderConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLShader* domObject = jsCast<JSWebGLShader*>(asObject(slotBase));
    return JSWebGLShader::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLShader::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLShaderConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSWebGLShader* jsWebGLShader)
{
    if (jsWebGLShader->hasCustomProperties())
        return true;
    return false;
}

bool JSWebGLShaderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebGLShader* jsWebGLShader = jsCast<JSWebGLShader*>(handle.get().asCell());
    if (!isObservable(jsWebGLShader))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLShaderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebGLShader* jsWebGLShader = jsCast<JSWebGLShader*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLShader->impl(), jsWebGLShader);
    jsWebGLShader->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLShader@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11WebGLShaderE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLShader* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLShader>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLShader@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11WebGLShaderE[2];
#if COMPILER(CLANG)
    // If this fails WebGLShader does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLShader), WebGLShader_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLShader has subclasses. If WebGLShader has subclasses that get passed
    // to toJS() we currently require WebGLShader you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<WebGLShader>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSWebGLShader>(exec, globalObject, impl);
}

WebGLShader* toWebGLShader(JSC::JSValue value)
{
    return value.inherits(&JSWebGLShader::s_info) ? jsCast<JSWebGLShader*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
