/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDebugRendererInfo.h"

#include "WebGLDebugRendererInfo.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSWebGLDebugRendererInfoPrototypeTableValues[] =
{
    { "UNMASKED_VENDOR_WEBGL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLDebugRendererInfoUNMASKED_VENDOR_WEBGL), (intptr_t)0, NoIntrinsic },
    { "UNMASKED_RENDERER_WEBGL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLDebugRendererInfoUNMASKED_RENDERER_WEBGL), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLDebugRendererInfoPrototypeTable = { 4, 3, JSWebGLDebugRendererInfoPrototypeTableValues, 0 };
const ClassInfo JSWebGLDebugRendererInfoPrototype::s_info = { "WebGLDebugRendererInfoPrototype", &Base::s_info, &JSWebGLDebugRendererInfoPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLDebugRendererInfoPrototype) };

JSObject* JSWebGLDebugRendererInfoPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLDebugRendererInfo>(exec, globalObject);
}

bool JSWebGLDebugRendererInfoPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLDebugRendererInfoPrototype* thisObject = jsCast<JSWebGLDebugRendererInfoPrototype*>(cell);
    return getStaticValueSlot<JSWebGLDebugRendererInfoPrototype, JSObject>(exec, &JSWebGLDebugRendererInfoPrototypeTable, thisObject, propertyName, slot);
}

bool JSWebGLDebugRendererInfoPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLDebugRendererInfoPrototype* thisObject = jsCast<JSWebGLDebugRendererInfoPrototype*>(object);
    return getStaticValueDescriptor<JSWebGLDebugRendererInfoPrototype, JSObject>(exec, &JSWebGLDebugRendererInfoPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSWebGLDebugRendererInfo::s_info = { "WebGLDebugRendererInfo", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSWebGLDebugRendererInfo) };

JSWebGLDebugRendererInfo::JSWebGLDebugRendererInfo(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLDebugRendererInfo> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebGLDebugRendererInfo::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLDebugRendererInfo::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLDebugRendererInfoPrototype::create(exec->vm(), globalObject, JSWebGLDebugRendererInfoPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSWebGLDebugRendererInfo::destroy(JSC::JSCell* cell)
{
    JSWebGLDebugRendererInfo* thisObject = static_cast<JSWebGLDebugRendererInfo*>(cell);
    thisObject->JSWebGLDebugRendererInfo::~JSWebGLDebugRendererInfo();
}

JSWebGLDebugRendererInfo::~JSWebGLDebugRendererInfo()
{
    releaseImplIfNotNull();
}

// Constant getters

JSValue jsWebGLDebugRendererInfoUNMASKED_VENDOR_WEBGL(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x9245));
}

JSValue jsWebGLDebugRendererInfoUNMASKED_RENDERER_WEBGL(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x9246));
}

static inline bool isObservable(JSWebGLDebugRendererInfo* jsWebGLDebugRendererInfo)
{
    if (jsWebGLDebugRendererInfo->hasCustomProperties())
        return true;
    return false;
}

bool JSWebGLDebugRendererInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebGLDebugRendererInfo* jsWebGLDebugRendererInfo = jsCast<JSWebGLDebugRendererInfo*>(handle.get().asCell());
    if (!isObservable(jsWebGLDebugRendererInfo))
        return false;
    WebGLRenderingContext* root = jsWebGLDebugRendererInfo->impl()->context();
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLDebugRendererInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebGLDebugRendererInfo* jsWebGLDebugRendererInfo = jsCast<JSWebGLDebugRendererInfo*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLDebugRendererInfo->impl(), jsWebGLDebugRendererInfo);
    jsWebGLDebugRendererInfo->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDebugRendererInfo@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22WebGLDebugRendererInfoE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLDebugRendererInfo* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLDebugRendererInfo>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLDebugRendererInfo@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22WebGLDebugRendererInfoE[2];
#if COMPILER(CLANG)
    // If this fails WebGLDebugRendererInfo does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLDebugRendererInfo), WebGLDebugRendererInfo_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLDebugRendererInfo has subclasses. If WebGLDebugRendererInfo has subclasses that get passed
    // to toJS() we currently require WebGLDebugRendererInfo you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<WebGLDebugRendererInfo>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSWebGLDebugRendererInfo>(exec, globalObject, impl);
}

WebGLDebugRendererInfo* toWebGLDebugRendererInfo(JSC::JSValue value)
{
    return value.inherits(&JSWebGLDebugRendererInfo::s_info) ? jsCast<JSWebGLDebugRendererInfo*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
