/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLBuffer.h"

#include "WebGLBuffer.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebGLBufferTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLBufferConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLBufferTable = { 2, 1, JSWebGLBufferTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebGLBufferConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLBufferConstructorTable = { 1, 0, JSWebGLBufferConstructorTableValues, 0 };
const ClassInfo JSWebGLBufferConstructor::s_info = { "WebGLBufferConstructor", &Base::s_info, &JSWebGLBufferConstructorTable, 0, CREATE_METHOD_TABLE(JSWebGLBufferConstructor) };

JSWebGLBufferConstructor::JSWebGLBufferConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLBufferConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSWebGLBufferPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSWebGLBufferConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLBufferConstructor, JSDOMWrapper>(exec, &JSWebGLBufferConstructorTable, jsCast<JSWebGLBufferConstructor*>(cell), propertyName, slot);
}

bool JSWebGLBufferConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLBufferConstructor, JSDOMWrapper>(exec, &JSWebGLBufferConstructorTable, jsCast<JSWebGLBufferConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLBufferPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLBufferPrototypeTable = { 1, 0, JSWebGLBufferPrototypeTableValues, 0 };
const ClassInfo JSWebGLBufferPrototype::s_info = { "WebGLBufferPrototype", &Base::s_info, &JSWebGLBufferPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLBufferPrototype) };

JSObject* JSWebGLBufferPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLBuffer>(exec, globalObject);
}

const ClassInfo JSWebGLBuffer::s_info = { "WebGLBuffer", &Base::s_info, &JSWebGLBufferTable, 0 , CREATE_METHOD_TABLE(JSWebGLBuffer) };

JSWebGLBuffer::JSWebGLBuffer(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLBuffer> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebGLBuffer::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLBuffer::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLBufferPrototype::create(exec->vm(), globalObject, JSWebGLBufferPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSWebGLBuffer::destroy(JSC::JSCell* cell)
{
    JSWebGLBuffer* thisObject = static_cast<JSWebGLBuffer*>(cell);
    thisObject->JSWebGLBuffer::~JSWebGLBuffer();
}

JSWebGLBuffer::~JSWebGLBuffer()
{
    releaseImplIfNotNull();
}

bool JSWebGLBuffer::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLBuffer* thisObject = jsCast<JSWebGLBuffer*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebGLBuffer, Base>(exec, &JSWebGLBufferTable, thisObject, propertyName, slot);
}

bool JSWebGLBuffer::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLBuffer* thisObject = jsCast<JSWebGLBuffer*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebGLBuffer, Base>(exec, &JSWebGLBufferTable, thisObject, propertyName, descriptor);
}

JSValue jsWebGLBufferConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLBuffer* domObject = jsCast<JSWebGLBuffer*>(asObject(slotBase));
    return JSWebGLBuffer::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLBuffer::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLBufferConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSWebGLBuffer* jsWebGLBuffer)
{
    if (jsWebGLBuffer->hasCustomProperties())
        return true;
    return false;
}

bool JSWebGLBufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebGLBuffer* jsWebGLBuffer = jsCast<JSWebGLBuffer*>(handle.get().asCell());
    if (!isObservable(jsWebGLBuffer))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLBufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebGLBuffer* jsWebGLBuffer = jsCast<JSWebGLBuffer*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLBuffer->impl(), jsWebGLBuffer);
    jsWebGLBuffer->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLBuffer@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11WebGLBufferE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLBuffer* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLBuffer>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLBuffer@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11WebGLBufferE[2];
#if COMPILER(CLANG)
    // If this fails WebGLBuffer does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLBuffer), WebGLBuffer_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLBuffer has subclasses. If WebGLBuffer has subclasses that get passed
    // to toJS() we currently require WebGLBuffer you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<WebGLBuffer>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSWebGLBuffer>(exec, globalObject, impl);
}

WebGLBuffer* toWebGLBuffer(JSC::JSValue value)
{
    return value.inherits(&JSWebGLBuffer::s_info) ? jsCast<JSWebGLBuffer*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
