/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSWaveTable.h"

#include "WaveTable.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWaveTableTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWaveTableConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWaveTableTable = { 2, 1, JSWaveTableTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWaveTableConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWaveTableConstructorTable = { 1, 0, JSWaveTableConstructorTableValues, 0 };
const ClassInfo JSWaveTableConstructor::s_info = { "WaveTableConstructor", &Base::s_info, &JSWaveTableConstructorTable, 0, CREATE_METHOD_TABLE(JSWaveTableConstructor) };

JSWaveTableConstructor::JSWaveTableConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWaveTableConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSWaveTablePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSWaveTableConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWaveTableConstructor, JSDOMWrapper>(exec, &JSWaveTableConstructorTable, jsCast<JSWaveTableConstructor*>(cell), propertyName, slot);
}

bool JSWaveTableConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWaveTableConstructor, JSDOMWrapper>(exec, &JSWaveTableConstructorTable, jsCast<JSWaveTableConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWaveTablePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWaveTablePrototypeTable = { 1, 0, JSWaveTablePrototypeTableValues, 0 };
const ClassInfo JSWaveTablePrototype::s_info = { "WaveTablePrototype", &Base::s_info, &JSWaveTablePrototypeTable, 0, CREATE_METHOD_TABLE(JSWaveTablePrototype) };

JSObject* JSWaveTablePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWaveTable>(exec, globalObject);
}

const ClassInfo JSWaveTable::s_info = { "WaveTable", &Base::s_info, &JSWaveTableTable, 0 , CREATE_METHOD_TABLE(JSWaveTable) };

JSWaveTable::JSWaveTable(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WaveTable> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWaveTable::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSWaveTable::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWaveTablePrototype::create(exec->vm(), globalObject, JSWaveTablePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSWaveTable::destroy(JSC::JSCell* cell)
{
    JSWaveTable* thisObject = static_cast<JSWaveTable*>(cell);
    thisObject->JSWaveTable::~JSWaveTable();
}

JSWaveTable::~JSWaveTable()
{
    releaseImplIfNotNull();
}

bool JSWaveTable::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWaveTable* thisObject = jsCast<JSWaveTable*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWaveTable, Base>(exec, &JSWaveTableTable, thisObject, propertyName, slot);
}

bool JSWaveTable::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWaveTable* thisObject = jsCast<JSWaveTable*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWaveTable, Base>(exec, &JSWaveTableTable, thisObject, propertyName, descriptor);
}

JSValue jsWaveTableConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWaveTable* domObject = jsCast<JSWaveTable*>(asObject(slotBase));
    return JSWaveTable::getConstructor(exec, domObject->globalObject());
}

JSValue JSWaveTable::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWaveTableConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSWaveTable* jsWaveTable)
{
    if (jsWaveTable->hasCustomProperties())
        return true;
    return false;
}

bool JSWaveTableOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWaveTable* jsWaveTable = jsCast<JSWaveTable*>(handle.get().asCell());
    if (!isObservable(jsWaveTable))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWaveTableOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWaveTable* jsWaveTable = jsCast<JSWaveTable*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWaveTable->impl(), jsWaveTable);
    jsWaveTable->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WaveTable* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWaveTable>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WaveTable.
    COMPILE_ASSERT(!__is_polymorphic(WaveTable), WaveTable_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<WaveTable>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSWaveTable>(exec, globalObject, impl);
}

WaveTable* toWaveTable(JSC::JSValue value)
{
    return value.inherits(&JSWaveTable::s_info) ? jsCast<JSWaveTable*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_AUDIO)
