/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTreeWalker.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "Node.h"
#include "NodeFilter.h"
#include "TreeWalker.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTreeWalkerTableValues[] =
{
    { "root", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerRoot), (intptr_t)0, NoIntrinsic },
    { "whatToShow", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerWhatToShow), (intptr_t)0, NoIntrinsic },
    { "filter", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerFilter), (intptr_t)0, NoIntrinsic },
    { "expandEntityReferences", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerExpandEntityReferences), (intptr_t)0, NoIntrinsic },
    { "currentNode", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerCurrentNode), (intptr_t)setJSTreeWalkerCurrentNode, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTreeWalkerTable = { 18, 15, JSTreeWalkerTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTreeWalkerConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTreeWalkerConstructorTable = { 1, 0, JSTreeWalkerConstructorTableValues, 0 };
const ClassInfo JSTreeWalkerConstructor::s_info = { "TreeWalkerConstructor", &Base::s_info, &JSTreeWalkerConstructorTable, 0, CREATE_METHOD_TABLE(JSTreeWalkerConstructor) };

JSTreeWalkerConstructor::JSTreeWalkerConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTreeWalkerConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSTreeWalkerPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSTreeWalkerConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTreeWalkerConstructor, JSDOMWrapper>(exec, &JSTreeWalkerConstructorTable, jsCast<JSTreeWalkerConstructor*>(cell), propertyName, slot);
}

bool JSTreeWalkerConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTreeWalkerConstructor, JSDOMWrapper>(exec, &JSTreeWalkerConstructorTable, jsCast<JSTreeWalkerConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTreeWalkerPrototypeTableValues[] =
{
    { "parentNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionParentNode), (intptr_t)0, NoIntrinsic },
    { "firstChild", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionFirstChild), (intptr_t)0, NoIntrinsic },
    { "lastChild", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionLastChild), (intptr_t)0, NoIntrinsic },
    { "previousSibling", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionPreviousSibling), (intptr_t)0, NoIntrinsic },
    { "nextSibling", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionNextSibling), (intptr_t)0, NoIntrinsic },
    { "previousNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionPreviousNode), (intptr_t)0, NoIntrinsic },
    { "nextNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionNextNode), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTreeWalkerPrototypeTable = { 16, 15, JSTreeWalkerPrototypeTableValues, 0 };
const ClassInfo JSTreeWalkerPrototype::s_info = { "TreeWalkerPrototype", &Base::s_info, &JSTreeWalkerPrototypeTable, 0, CREATE_METHOD_TABLE(JSTreeWalkerPrototype) };

JSObject* JSTreeWalkerPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTreeWalker>(exec, globalObject);
}

bool JSTreeWalkerPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTreeWalkerPrototype* thisObject = jsCast<JSTreeWalkerPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSTreeWalkerPrototypeTable, thisObject, propertyName, slot);
}

bool JSTreeWalkerPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTreeWalkerPrototype* thisObject = jsCast<JSTreeWalkerPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTreeWalkerPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSTreeWalker::s_info = { "TreeWalker", &Base::s_info, &JSTreeWalkerTable, 0 , CREATE_METHOD_TABLE(JSTreeWalker) };

JSTreeWalker::JSTreeWalker(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TreeWalker> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSTreeWalker::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSTreeWalker::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTreeWalkerPrototype::create(exec->vm(), globalObject, JSTreeWalkerPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSTreeWalker::destroy(JSC::JSCell* cell)
{
    JSTreeWalker* thisObject = static_cast<JSTreeWalker*>(cell);
    thisObject->JSTreeWalker::~JSTreeWalker();
}

JSTreeWalker::~JSTreeWalker()
{
    releaseImplIfNotNull();
}

bool JSTreeWalker::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTreeWalker* thisObject = jsCast<JSTreeWalker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSTreeWalker, Base>(exec, &JSTreeWalkerTable, thisObject, propertyName, slot);
}

bool JSTreeWalker::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTreeWalker* thisObject = jsCast<JSTreeWalker*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSTreeWalker, Base>(exec, &JSTreeWalkerTable, thisObject, propertyName, descriptor);
}

JSValue jsTreeWalkerRoot(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->root()));
    return result;
}


JSValue jsTreeWalkerWhatToShow(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());
    JSValue result = jsNumber(impl->whatToShow());
    return result;
}


JSValue jsTreeWalkerFilter(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->filter()));
    return result;
}


JSValue jsTreeWalkerExpandEntityReferences(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());
    JSValue result = jsBoolean(impl->expandEntityReferences());
    return result;
}


JSValue jsTreeWalkerCurrentNode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->currentNode()));
    return result;
}


JSValue jsTreeWalkerConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTreeWalker* domObject = jsCast<JSTreeWalker*>(asObject(slotBase));
    return JSTreeWalker::getConstructor(exec, domObject->globalObject());
}

void JSTreeWalker::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSTreeWalker* thisObject = jsCast<JSTreeWalker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSTreeWalker, Base>(exec, propertyName, value, &JSTreeWalkerTable, thisObject, slot);
}

void setJSTreeWalkerCurrentNode(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(thisObject);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* nativeValue(toNode(value));
    if (exec->hadException())
        return;
    impl->setCurrentNode(nativeValue, ec);
    setDOMException(exec, ec);
}


JSValue JSTreeWalker::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTreeWalkerConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionParentNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTreeWalker::s_info))
        return throwVMTypeError(exec);
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTreeWalker::s_info);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->parentNode(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionFirstChild(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTreeWalker::s_info))
        return throwVMTypeError(exec);
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTreeWalker::s_info);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->firstChild(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionLastChild(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTreeWalker::s_info))
        return throwVMTypeError(exec);
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTreeWalker::s_info);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->lastChild(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionPreviousSibling(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTreeWalker::s_info))
        return throwVMTypeError(exec);
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTreeWalker::s_info);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->previousSibling(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionNextSibling(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTreeWalker::s_info))
        return throwVMTypeError(exec);
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTreeWalker::s_info);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nextSibling(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionPreviousNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTreeWalker::s_info))
        return throwVMTypeError(exec);
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTreeWalker::s_info);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->previousNode(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionNextNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTreeWalker::s_info))
        return throwVMTypeError(exec);
    JSTreeWalker* castedThis = jsCast<JSTreeWalker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTreeWalker::s_info);
    TreeWalker* impl = static_cast<TreeWalker*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nextNode(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

static inline bool isObservable(JSTreeWalker* jsTreeWalker)
{
    if (jsTreeWalker->hasCustomProperties())
        return true;
    return false;
}

bool JSTreeWalkerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSTreeWalker* jsTreeWalker = jsCast<JSTreeWalker*>(handle.get().asCell());
    if (!isObservable(jsTreeWalker))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSTreeWalkerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSTreeWalker* jsTreeWalker = jsCast<JSTreeWalker*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTreeWalker->impl(), jsTreeWalker);
    jsTreeWalker->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, TreeWalker* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTreeWalker>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TreeWalker.
    COMPILE_ASSERT(!__is_polymorphic(TreeWalker), TreeWalker_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<TreeWalker>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSTreeWalker>(exec, globalObject, impl);
}

TreeWalker* toTreeWalker(JSC::JSValue value)
{
    return value.inherits(&JSTreeWalker::s_info) ? jsCast<JSTreeWalker*>(asObject(value))->impl() : 0;
}

}
