/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSTimeRanges.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "TimeRanges.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTimeRangesTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimeRangesLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimeRangesConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTimeRangesTable = { 5, 3, JSTimeRangesTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTimeRangesConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTimeRangesConstructorTable = { 1, 0, JSTimeRangesConstructorTableValues, 0 };
const ClassInfo JSTimeRangesConstructor::s_info = { "TimeRangesConstructor", &Base::s_info, &JSTimeRangesConstructorTable, 0, CREATE_METHOD_TABLE(JSTimeRangesConstructor) };

JSTimeRangesConstructor::JSTimeRangesConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTimeRangesConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSTimeRangesPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSTimeRangesConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTimeRangesConstructor, JSDOMWrapper>(exec, &JSTimeRangesConstructorTable, jsCast<JSTimeRangesConstructor*>(cell), propertyName, slot);
}

bool JSTimeRangesConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTimeRangesConstructor, JSDOMWrapper>(exec, &JSTimeRangesConstructorTable, jsCast<JSTimeRangesConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTimeRangesPrototypeTableValues[] =
{
    { "start", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTimeRangesPrototypeFunctionStart), (intptr_t)1, NoIntrinsic },
    { "end", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTimeRangesPrototypeFunctionEnd), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTimeRangesPrototypeTable = { 5, 3, JSTimeRangesPrototypeTableValues, 0 };
const ClassInfo JSTimeRangesPrototype::s_info = { "TimeRangesPrototype", &Base::s_info, &JSTimeRangesPrototypeTable, 0, CREATE_METHOD_TABLE(JSTimeRangesPrototype) };

JSObject* JSTimeRangesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTimeRanges>(exec, globalObject);
}

bool JSTimeRangesPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTimeRangesPrototype* thisObject = jsCast<JSTimeRangesPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSTimeRangesPrototypeTable, thisObject, propertyName, slot);
}

bool JSTimeRangesPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTimeRangesPrototype* thisObject = jsCast<JSTimeRangesPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTimeRangesPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSTimeRanges::s_info = { "TimeRanges", &Base::s_info, &JSTimeRangesTable, 0 , CREATE_METHOD_TABLE(JSTimeRanges) };

JSTimeRanges::JSTimeRanges(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TimeRanges> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSTimeRanges::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSTimeRanges::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTimeRangesPrototype::create(exec->vm(), globalObject, JSTimeRangesPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSTimeRanges::destroy(JSC::JSCell* cell)
{
    JSTimeRanges* thisObject = static_cast<JSTimeRanges*>(cell);
    thisObject->JSTimeRanges::~JSTimeRanges();
}

JSTimeRanges::~JSTimeRanges()
{
    releaseImplIfNotNull();
}

bool JSTimeRanges::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTimeRanges* thisObject = jsCast<JSTimeRanges*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSTimeRanges, Base>(exec, &JSTimeRangesTable, thisObject, propertyName, slot);
}

bool JSTimeRanges::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTimeRanges* thisObject = jsCast<JSTimeRanges*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSTimeRanges, Base>(exec, &JSTimeRangesTable, thisObject, propertyName, descriptor);
}

JSValue jsTimeRangesLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTimeRanges* castedThis = jsCast<JSTimeRanges*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TimeRanges* impl = static_cast<TimeRanges*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsTimeRangesConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTimeRanges* domObject = jsCast<JSTimeRanges*>(asObject(slotBase));
    return JSTimeRanges::getConstructor(exec, domObject->globalObject());
}

JSValue JSTimeRanges::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTimeRangesConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTimeRangesPrototypeFunctionStart(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTimeRanges::s_info))
        return throwVMTypeError(exec);
    JSTimeRanges* castedThis = jsCast<JSTimeRanges*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTimeRanges::s_info);
    TimeRanges* impl = static_cast<TimeRanges*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->start(index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTimeRangesPrototypeFunctionEnd(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTimeRanges::s_info))
        return throwVMTypeError(exec);
    JSTimeRanges* castedThis = jsCast<JSTimeRanges*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTimeRanges::s_info);
    TimeRanges* impl = static_cast<TimeRanges*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->end(index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSTimeRanges* jsTimeRanges)
{
    if (jsTimeRanges->hasCustomProperties())
        return true;
    return false;
}

bool JSTimeRangesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSTimeRanges* jsTimeRanges = jsCast<JSTimeRanges*>(handle.get().asCell());
    if (!isObservable(jsTimeRanges))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSTimeRangesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSTimeRanges* jsTimeRanges = jsCast<JSTimeRanges*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTimeRanges->impl(), jsTimeRanges);
    jsTimeRanges->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, TimeRanges* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTimeRanges>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TimeRanges.
    COMPILE_ASSERT(!__is_polymorphic(TimeRanges), TimeRanges_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<TimeRanges>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSTimeRanges>(exec, globalObject, impl);
}

TimeRanges* toTimeRanges(JSC::JSValue value)
{
    return value.inherits(&JSTimeRanges::s_info) ? jsCast<JSTimeRanges*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO)
