/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSTextTrackList.h"

#include "Element.h"
#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSNodeCustom.h"
#include "JSTextTrack.h"
#include "TextTrack.h"
#include "TextTrackList.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTextTrackListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackListLength), (intptr_t)0, NoIntrinsic },
    { "onaddtrack", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackListOnaddtrack), (intptr_t)setJSTextTrackListOnaddtrack, NoIntrinsic },
    { "onremovetrack", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackListOnremovetrack), (intptr_t)setJSTextTrackListOnremovetrack, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextTrackListTable = { 10, 7, JSTextTrackListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTextTrackListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextTrackListConstructorTable = { 1, 0, JSTextTrackListConstructorTableValues, 0 };
const ClassInfo JSTextTrackListConstructor::s_info = { "TextTrackListConstructor", &Base::s_info, &JSTextTrackListConstructorTable, 0, CREATE_METHOD_TABLE(JSTextTrackListConstructor) };

JSTextTrackListConstructor::JSTextTrackListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTextTrackListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSTextTrackListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSTextTrackListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextTrackListConstructor, JSDOMWrapper>(exec, &JSTextTrackListConstructorTable, jsCast<JSTextTrackListConstructor*>(cell), propertyName, slot);
}

bool JSTextTrackListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTextTrackListConstructor, JSDOMWrapper>(exec, &JSTextTrackListConstructorTable, jsCast<JSTextTrackListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTextTrackListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTextTrackListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTextTrackListPrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTextTrackListPrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTextTrackListPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextTrackListPrototypeTable = { 8, 7, JSTextTrackListPrototypeTableValues, 0 };
const ClassInfo JSTextTrackListPrototype::s_info = { "TextTrackListPrototype", &Base::s_info, &JSTextTrackListPrototypeTable, 0, CREATE_METHOD_TABLE(JSTextTrackListPrototype) };

JSObject* JSTextTrackListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTextTrackList>(exec, globalObject);
}

bool JSTextTrackListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTextTrackListPrototype* thisObject = jsCast<JSTextTrackListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSTextTrackListPrototypeTable, thisObject, propertyName, slot);
}

bool JSTextTrackListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTextTrackListPrototype* thisObject = jsCast<JSTextTrackListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTextTrackListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSTextTrackList::s_info = { "TextTrackList", &Base::s_info, &JSTextTrackListTable, 0 , CREATE_METHOD_TABLE(JSTextTrackList) };

JSTextTrackList::JSTextTrackList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TextTrackList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSTextTrackList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSTextTrackList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTextTrackListPrototype::create(exec->vm(), globalObject, JSTextTrackListPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSTextTrackList::destroy(JSC::JSCell* cell)
{
    JSTextTrackList* thisObject = static_cast<JSTextTrackList*>(cell);
    thisObject->JSTextTrackList::~JSTextTrackList();
}

JSTextTrackList::~JSTextTrackList()
{
    releaseImplIfNotNull();
}

bool JSTextTrackList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTextTrackList* thisObject = jsCast<JSTextTrackList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSTextTrackList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<TextTrackList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSTextTrackList, Base>(exec, &JSTextTrackListTable, thisObject, propertyName, slot);
}

bool JSTextTrackList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTextTrackList* thisObject = jsCast<JSTextTrackList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSTextTrackListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<TextTrackList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSTextTrackList, Base>(exec, &JSTextTrackListTable, thisObject, propertyName, descriptor);
}

bool JSTextTrackList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSTextTrackList* thisObject = jsCast<JSTextTrackList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<TextTrackList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsTextTrackListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTextTrackList* castedThis = jsCast<JSTextTrackList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TextTrackList* impl = static_cast<TextTrackList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsTextTrackListOnaddtrack(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTextTrackList* castedThis = jsCast<JSTextTrackList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TextTrackList* impl = static_cast<TextTrackList*>(castedThis->impl());
    if (EventListener* listener = impl->onaddtrack()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsTextTrackListOnremovetrack(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTextTrackList* castedThis = jsCast<JSTextTrackList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TextTrackList* impl = static_cast<TextTrackList*>(castedThis->impl());
    if (EventListener* listener = impl->onremovetrack()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsTextTrackListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTextTrackList* domObject = jsCast<JSTextTrackList*>(asObject(slotBase));
    return JSTextTrackList::getConstructor(exec, domObject->globalObject());
}

void JSTextTrackList::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSTextTrackList* thisObject = jsCast<JSTextTrackList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSTextTrackList, Base>(exec, propertyName, value, &JSTextTrackListTable, thisObject, slot);
}

void setJSTextTrackListOnaddtrack(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSTextTrackList* castedThis = jsCast<JSTextTrackList*>(thisObject);
    TextTrackList* impl = static_cast<TextTrackList*>(castedThis->impl());
    impl->setOnaddtrack(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSTextTrackListOnremovetrack(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSTextTrackList* castedThis = jsCast<JSTextTrackList*>(thisObject);
    TextTrackList* impl = static_cast<TextTrackList*>(castedThis->impl());
    impl->setOnremovetrack(createJSAttributeEventListener(exec, value, thisObject));
}


void JSTextTrackList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSTextTrackList* thisObject = jsCast<JSTextTrackList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<TextTrackList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSTextTrackList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextTrackListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTextTrackListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTextTrackList::s_info))
        return throwVMTypeError(exec);
    JSTextTrackList* castedThis = jsCast<JSTextTrackList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTextTrackList::s_info);
    TextTrackList* impl = static_cast<TextTrackList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTextTrackListPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTextTrackList::s_info))
        return throwVMTypeError(exec);
    JSTextTrackList* castedThis = jsCast<JSTextTrackList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTextTrackList::s_info);
    TextTrackList* impl = static_cast<TextTrackList*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTextTrackListPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTextTrackList::s_info))
        return throwVMTypeError(exec);
    JSTextTrackList* castedThis = jsCast<JSTextTrackList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTextTrackList::s_info);
    TextTrackList* impl = static_cast<TextTrackList*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTextTrackListPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTextTrackList::s_info))
        return throwVMTypeError(exec);
    JSTextTrackList* castedThis = jsCast<JSTextTrackList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTextTrackList::s_info);
    TextTrackList* impl = static_cast<TextTrackList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


JSValue JSTextTrackList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSTextTrackList* thisObj = jsCast<JSTextTrackList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<TextTrackList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSTextTrackList* jsTextTrackList)
{
    if (jsTextTrackList->hasCustomProperties())
        return true;
    if (jsTextTrackList->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSTextTrackListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSTextTrackList* jsTextTrackList = jsCast<JSTextTrackList*>(handle.get().asCell());
    if (jsTextTrackList->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsTextTrackList))
        return false;
    Element* element = jsTextTrackList->impl()->element();
    if (!element)
        return false;
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSTextTrackListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSTextTrackList* jsTextTrackList = jsCast<JSTextTrackList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTextTrackList->impl(), jsTextTrackList);
    jsTextTrackList->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TextTrackList@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13TextTrackListE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, TextTrackList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTextTrackList>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7TextTrackList@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13TextTrackListE[2];
#if COMPILER(CLANG)
    // If this fails TextTrackList does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(TextTrackList), TextTrackList_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // TextTrackList has subclasses. If TextTrackList has subclasses that get passed
    // to toJS() we currently require TextTrackList you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<TextTrackList>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSTextTrackList>(exec, globalObject, impl);
}

TextTrackList* toTextTrackList(JSC::JSValue value)
{
    return value.inherits(&JSTextTrackList::s_info) ? jsCast<JSTextTrackList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO_TRACK)
