/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(QUOTA)

#include "JSStorageQuota.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSStorageErrorCallback.h"
#include "JSStorageQuotaCallback.h"
#include "JSStorageUsageCallback.h"
#include "StorageQuota.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSStorageQuotaPrototypeTableValues[] =
{
    { "queryUsageAndQuota", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStorageQuotaPrototypeFunctionQueryUsageAndQuota), (intptr_t)1, NoIntrinsic },
    { "requestQuota", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStorageQuotaPrototypeFunctionRequestQuota), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStorageQuotaPrototypeTable = { 5, 3, JSStorageQuotaPrototypeTableValues, 0 };
const ClassInfo JSStorageQuotaPrototype::s_info = { "StorageQuotaPrototype", &Base::s_info, &JSStorageQuotaPrototypeTable, 0, CREATE_METHOD_TABLE(JSStorageQuotaPrototype) };

JSObject* JSStorageQuotaPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStorageQuota>(exec, globalObject);
}

bool JSStorageQuotaPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSStorageQuotaPrototype* thisObject = jsCast<JSStorageQuotaPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSStorageQuotaPrototypeTable, thisObject, propertyName, slot);
}

bool JSStorageQuotaPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSStorageQuotaPrototype* thisObject = jsCast<JSStorageQuotaPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSStorageQuotaPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSStorageQuota::s_info = { "StorageQuota", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSStorageQuota) };

JSStorageQuota::JSStorageQuota(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<StorageQuota> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSStorageQuota::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSStorageQuota::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSStorageQuotaPrototype::create(exec->vm(), globalObject, JSStorageQuotaPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSStorageQuota::destroy(JSC::JSCell* cell)
{
    JSStorageQuota* thisObject = static_cast<JSStorageQuota*>(cell);
    thisObject->JSStorageQuota::~JSStorageQuota();
}

JSStorageQuota::~JSStorageQuota()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsStorageQuotaPrototypeFunctionQueryUsageAndQuota(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStorageQuota::s_info))
        return throwVMTypeError(exec);
    JSStorageQuota* castedThis = jsCast<JSStorageQuota*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStorageQuota::s_info);
    StorageQuota* impl = static_cast<StorageQuota*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    if (exec->argumentCount() <= 0 || !exec->argument(0).isFunction())
        return throwVMTypeError(exec);
    RefPtr<StorageUsageCallback> usageCallback = JSStorageUsageCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    RefPtr<StorageErrorCallback> errorCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSStorageErrorCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }
    impl->queryUsageAndQuota(scriptContext, usageCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsStorageQuotaPrototypeFunctionRequestQuota(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStorageQuota::s_info))
        return throwVMTypeError(exec);
    JSStorageQuota* castedThis = jsCast<JSStorageQuota*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStorageQuota::s_info);
    StorageQuota* impl = static_cast<StorageQuota*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    unsigned long long newQuotaInBytes(toUInt64(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<StorageQuotaCallback> quotaCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isFunction())
            return throwVMTypeError(exec);
        quotaCallback = JSStorageQuotaCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }
    RefPtr<StorageErrorCallback> errorCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSStorageErrorCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    impl->requestQuota(scriptContext, newQuotaInBytes, quotaCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSStorageQuota* jsStorageQuota)
{
    if (jsStorageQuota->hasCustomProperties())
        return true;
    return false;
}

bool JSStorageQuotaOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSStorageQuota* jsStorageQuota = jsCast<JSStorageQuota*>(handle.get().asCell());
    if (!isObservable(jsStorageQuota))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSStorageQuotaOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSStorageQuota* jsStorageQuota = jsCast<JSStorageQuota*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsStorageQuota->impl(), jsStorageQuota);
    jsStorageQuota->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, StorageQuota* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSStorageQuota>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to StorageQuota.
    COMPILE_ASSERT(!__is_polymorphic(StorageQuota), StorageQuota_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<StorageQuota>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSStorageQuota>(exec, globalObject, impl);
}

StorageQuota* toStorageQuota(JSC::JSValue value)
{
    return value.inherits(&JSStorageQuota::s_info) ? jsCast<JSStorageQuota*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(QUOTA)
