/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(QUOTA)

#include "JSStorageInfo.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSStorageErrorCallback.h"
#include "JSStorageQuotaCallback.h"
#include "JSStorageUsageCallback.h"
#include "StorageInfo.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSStorageInfoPrototypeTableValues[] =
{
    { "TEMPORARY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageInfoTEMPORARY), (intptr_t)0, NoIntrinsic },
    { "PERSISTENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageInfoPERSISTENT), (intptr_t)0, NoIntrinsic },
    { "queryUsageAndQuota", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStorageInfoPrototypeFunctionQueryUsageAndQuota), (intptr_t)1, NoIntrinsic },
    { "requestQuota", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStorageInfoPrototypeFunctionRequestQuota), (intptr_t)2, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStorageInfoPrototypeTable = { 9, 7, JSStorageInfoPrototypeTableValues, 0 };
const ClassInfo JSStorageInfoPrototype::s_info = { "StorageInfoPrototype", &Base::s_info, &JSStorageInfoPrototypeTable, 0, CREATE_METHOD_TABLE(JSStorageInfoPrototype) };

JSObject* JSStorageInfoPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStorageInfo>(exec, globalObject);
}

bool JSStorageInfoPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSStorageInfoPrototype* thisObject = jsCast<JSStorageInfoPrototype*>(cell);
    return getStaticPropertySlot<JSStorageInfoPrototype, JSObject>(exec, &JSStorageInfoPrototypeTable, thisObject, propertyName, slot);
}

bool JSStorageInfoPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSStorageInfoPrototype* thisObject = jsCast<JSStorageInfoPrototype*>(object);
    return getStaticPropertyDescriptor<JSStorageInfoPrototype, JSObject>(exec, &JSStorageInfoPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSStorageInfo::s_info = { "StorageInfo", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSStorageInfo) };

JSStorageInfo::JSStorageInfo(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<StorageInfo> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSStorageInfo::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSStorageInfo::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSStorageInfoPrototype::create(exec->vm(), globalObject, JSStorageInfoPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSStorageInfo::destroy(JSC::JSCell* cell)
{
    JSStorageInfo* thisObject = static_cast<JSStorageInfo*>(cell);
    thisObject->JSStorageInfo::~JSStorageInfo();
}

JSStorageInfo::~JSStorageInfo()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsStorageInfoPrototypeFunctionQueryUsageAndQuota(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStorageInfo::s_info))
        return throwVMTypeError(exec);
    JSStorageInfo* castedThis = jsCast<JSStorageInfo*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStorageInfo::s_info);
    StorageInfo* impl = static_cast<StorageInfo*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    unsigned short storageType(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<StorageUsageCallback> usageCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isFunction())
            return throwVMTypeError(exec);
        usageCallback = JSStorageUsageCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }
    RefPtr<StorageErrorCallback> errorCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSStorageErrorCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    impl->queryUsageAndQuota(scriptContext, storageType, usageCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsStorageInfoPrototypeFunctionRequestQuota(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStorageInfo::s_info))
        return throwVMTypeError(exec);
    JSStorageInfo* castedThis = jsCast<JSStorageInfo*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStorageInfo::s_info);
    StorageInfo* impl = static_cast<StorageInfo*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    unsigned short storageType(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned long long newQuotaInBytes(toUInt64(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<StorageQuotaCallback> quotaCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        quotaCallback = JSStorageQuotaCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    RefPtr<StorageErrorCallback> errorCallback;
    if (exec->argumentCount() > 3 && !exec->argument(3).isUndefinedOrNull()) {
        if (!exec->argument(3).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSStorageErrorCallback::create(asObject(exec->argument(3)), castedThis->globalObject());
    }
    impl->requestQuota(scriptContext, storageType, newQuotaInBytes, quotaCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsStorageInfoTEMPORARY(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsStorageInfoPERSISTENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

static inline bool isObservable(JSStorageInfo* jsStorageInfo)
{
    if (jsStorageInfo->hasCustomProperties())
        return true;
    return false;
}

bool JSStorageInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSStorageInfo* jsStorageInfo = jsCast<JSStorageInfo*>(handle.get().asCell());
    if (!isObservable(jsStorageInfo))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSStorageInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSStorageInfo* jsStorageInfo = jsCast<JSStorageInfo*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsStorageInfo->impl(), jsStorageInfo);
    jsStorageInfo->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, StorageInfo* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSStorageInfo>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to StorageInfo.
    COMPILE_ASSERT(!__is_polymorphic(StorageInfo), StorageInfo_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<StorageInfo>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSStorageInfo>(exec, globalObject, impl);
}

StorageInfo* toStorageInfo(JSC::JSValue value)
{
    return value.inherits(&JSStorageInfo::s_info) ? jsCast<JSStorageInfo*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(QUOTA)
