/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSSpeechSynthesisVoice.h"

#include "KURL.h"
#include "SpeechSynthesisVoice.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSpeechSynthesisVoiceTableValues[] =
{
    { "voiceURI", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisVoiceVoiceURI), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisVoiceName), (intptr_t)0, NoIntrinsic },
    { "lang", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisVoiceLang), (intptr_t)0, NoIntrinsic },
    { "localService", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisVoiceLocalService), (intptr_t)0, NoIntrinsic },
    { "default", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisVoiceDefault), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechSynthesisVoiceTable = { 16, 15, JSSpeechSynthesisVoiceTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSpeechSynthesisVoicePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechSynthesisVoicePrototypeTable = { 1, 0, JSSpeechSynthesisVoicePrototypeTableValues, 0 };
const ClassInfo JSSpeechSynthesisVoicePrototype::s_info = { "SpeechSynthesisVoicePrototype", &Base::s_info, &JSSpeechSynthesisVoicePrototypeTable, 0, CREATE_METHOD_TABLE(JSSpeechSynthesisVoicePrototype) };

JSObject* JSSpeechSynthesisVoicePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSpeechSynthesisVoice>(exec, globalObject);
}

const ClassInfo JSSpeechSynthesisVoice::s_info = { "SpeechSynthesisVoice", &Base::s_info, &JSSpeechSynthesisVoiceTable, 0 , CREATE_METHOD_TABLE(JSSpeechSynthesisVoice) };

JSSpeechSynthesisVoice::JSSpeechSynthesisVoice(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SpeechSynthesisVoice> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSpeechSynthesisVoice::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSpeechSynthesisVoice::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSpeechSynthesisVoicePrototype::create(exec->vm(), globalObject, JSSpeechSynthesisVoicePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSpeechSynthesisVoice::destroy(JSC::JSCell* cell)
{
    JSSpeechSynthesisVoice* thisObject = static_cast<JSSpeechSynthesisVoice*>(cell);
    thisObject->JSSpeechSynthesisVoice::~JSSpeechSynthesisVoice();
}

JSSpeechSynthesisVoice::~JSSpeechSynthesisVoice()
{
    releaseImplIfNotNull();
}

bool JSSpeechSynthesisVoice::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSpeechSynthesisVoice* thisObject = jsCast<JSSpeechSynthesisVoice*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSpeechSynthesisVoice, Base>(exec, &JSSpeechSynthesisVoiceTable, thisObject, propertyName, slot);
}

bool JSSpeechSynthesisVoice::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSpeechSynthesisVoice* thisObject = jsCast<JSSpeechSynthesisVoice*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSpeechSynthesisVoice, Base>(exec, &JSSpeechSynthesisVoiceTable, thisObject, propertyName, descriptor);
}

JSValue jsSpeechSynthesisVoiceVoiceURI(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisVoice* castedThis = jsCast<JSSpeechSynthesisVoice*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisVoice* impl = static_cast<SpeechSynthesisVoice*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->voiceURI());
    return result;
}


JSValue jsSpeechSynthesisVoiceName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisVoice* castedThis = jsCast<JSSpeechSynthesisVoice*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisVoice* impl = static_cast<SpeechSynthesisVoice*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsSpeechSynthesisVoiceLang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisVoice* castedThis = jsCast<JSSpeechSynthesisVoice*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisVoice* impl = static_cast<SpeechSynthesisVoice*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->lang());
    return result;
}


JSValue jsSpeechSynthesisVoiceLocalService(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisVoice* castedThis = jsCast<JSSpeechSynthesisVoice*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisVoice* impl = static_cast<SpeechSynthesisVoice*>(castedThis->impl());
    JSValue result = jsBoolean(impl->localService());
    return result;
}


JSValue jsSpeechSynthesisVoiceDefault(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisVoice* castedThis = jsCast<JSSpeechSynthesisVoice*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisVoice* impl = static_cast<SpeechSynthesisVoice*>(castedThis->impl());
    JSValue result = jsBoolean(impl->isDefault());
    return result;
}


static inline bool isObservable(JSSpeechSynthesisVoice* jsSpeechSynthesisVoice)
{
    if (jsSpeechSynthesisVoice->hasCustomProperties())
        return true;
    return false;
}

bool JSSpeechSynthesisVoiceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSpeechSynthesisVoice* jsSpeechSynthesisVoice = jsCast<JSSpeechSynthesisVoice*>(handle.get().asCell());
    if (!isObservable(jsSpeechSynthesisVoice))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSpeechSynthesisVoiceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSpeechSynthesisVoice* jsSpeechSynthesisVoice = jsCast<JSSpeechSynthesisVoice*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSpeechSynthesisVoice->impl(), jsSpeechSynthesisVoice);
    jsSpeechSynthesisVoice->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SpeechSynthesisVoice@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20SpeechSynthesisVoiceE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SpeechSynthesisVoice* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSpeechSynthesisVoice>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SpeechSynthesisVoice@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore20SpeechSynthesisVoiceE[2];
#if COMPILER(CLANG)
    // If this fails SpeechSynthesisVoice does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SpeechSynthesisVoice), SpeechSynthesisVoice_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SpeechSynthesisVoice has subclasses. If SpeechSynthesisVoice has subclasses that get passed
    // to toJS() we currently require SpeechSynthesisVoice you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<SpeechSynthesisVoice>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSpeechSynthesisVoice>(exec, globalObject, impl);
}

SpeechSynthesisVoice* toSpeechSynthesisVoice(JSC::JSValue value)
{
    return value.inherits(&JSSpeechSynthesisVoice::s_info) ? jsCast<JSSpeechSynthesisVoice*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SPEECH_SYNTHESIS)
