/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSSpeechSynthesisUtterance.h"

#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEventListener.h"
#include "JSSpeechSynthesisVoice.h"
#include "KURL.h"
#include "SpeechSynthesisUtterance.h"
#include "SpeechSynthesisVoice.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSpeechSynthesisUtteranceTableValues[] =
{
    { "text", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceText), (intptr_t)setJSSpeechSynthesisUtteranceText, NoIntrinsic },
    { "lang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceLang), (intptr_t)setJSSpeechSynthesisUtteranceLang, NoIntrinsic },
    { "voice", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceVoice), (intptr_t)setJSSpeechSynthesisUtteranceVoice, NoIntrinsic },
    { "volume", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceVolume), (intptr_t)setJSSpeechSynthesisUtteranceVolume, NoIntrinsic },
    { "rate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceRate), (intptr_t)setJSSpeechSynthesisUtteranceRate, NoIntrinsic },
    { "pitch", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtterancePitch), (intptr_t)setJSSpeechSynthesisUtterancePitch, NoIntrinsic },
    { "onstart", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnstart), (intptr_t)setJSSpeechSynthesisUtteranceOnstart, NoIntrinsic },
    { "onend", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnend), (intptr_t)setJSSpeechSynthesisUtteranceOnend, NoIntrinsic },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnerror), (intptr_t)setJSSpeechSynthesisUtteranceOnerror, NoIntrinsic },
    { "onpause", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnpause), (intptr_t)setJSSpeechSynthesisUtteranceOnpause, NoIntrinsic },
    { "onresume", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnresume), (intptr_t)setJSSpeechSynthesisUtteranceOnresume, NoIntrinsic },
    { "onmark", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnmark), (intptr_t)setJSSpeechSynthesisUtteranceOnmark, NoIntrinsic },
    { "onboundary", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceOnboundary), (intptr_t)setJSSpeechSynthesisUtteranceOnboundary, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisUtteranceConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechSynthesisUtteranceTable = { 35, 31, JSSpeechSynthesisUtteranceTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSpeechSynthesisUtteranceConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechSynthesisUtteranceConstructorTable = { 1, 0, JSSpeechSynthesisUtteranceConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSSpeechSynthesisUtteranceConstructor::constructJSSpeechSynthesisUtterance(ExecState* exec)
{
    JSSpeechSynthesisUtteranceConstructor* castedThis = jsCast<JSSpeechSynthesisUtteranceConstructor*>(exec->callee());
    const String& text(argumentOrNull(exec, 0).isEmpty() ? String() : argumentOrNull(exec, 0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwVMError(exec, createReferenceError(exec, "SpeechSynthesisUtterance constructor associated document is unavailable"));
    RefPtr<SpeechSynthesisUtterance> object = SpeechSynthesisUtterance::create(context, text);
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

const ClassInfo JSSpeechSynthesisUtteranceConstructor::s_info = { "SpeechSynthesisUtteranceConstructor", &Base::s_info, &JSSpeechSynthesisUtteranceConstructorTable, 0, CREATE_METHOD_TABLE(JSSpeechSynthesisUtteranceConstructor) };

JSSpeechSynthesisUtteranceConstructor::JSSpeechSynthesisUtteranceConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSpeechSynthesisUtteranceConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSpeechSynthesisUtterancePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSpeechSynthesisUtteranceConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSpeechSynthesisUtteranceConstructor, JSDOMWrapper>(exec, &JSSpeechSynthesisUtteranceConstructorTable, jsCast<JSSpeechSynthesisUtteranceConstructor*>(cell), propertyName, slot);
}

bool JSSpeechSynthesisUtteranceConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSpeechSynthesisUtteranceConstructor, JSDOMWrapper>(exec, &JSSpeechSynthesisUtteranceConstructorTable, jsCast<JSSpeechSynthesisUtteranceConstructor*>(object), propertyName, descriptor);
}

ConstructType JSSpeechSynthesisUtteranceConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSSpeechSynthesisUtterance;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSSpeechSynthesisUtterancePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechSynthesisUtterancePrototypeTable = { 1, 0, JSSpeechSynthesisUtterancePrototypeTableValues, 0 };
const ClassInfo JSSpeechSynthesisUtterancePrototype::s_info = { "SpeechSynthesisUtterancePrototype", &Base::s_info, &JSSpeechSynthesisUtterancePrototypeTable, 0, CREATE_METHOD_TABLE(JSSpeechSynthesisUtterancePrototype) };

JSObject* JSSpeechSynthesisUtterancePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSpeechSynthesisUtterance>(exec, globalObject);
}

const ClassInfo JSSpeechSynthesisUtterance::s_info = { "SpeechSynthesisUtterance", &Base::s_info, &JSSpeechSynthesisUtteranceTable, 0 , CREATE_METHOD_TABLE(JSSpeechSynthesisUtterance) };

JSSpeechSynthesisUtterance::JSSpeechSynthesisUtterance(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SpeechSynthesisUtterance> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSpeechSynthesisUtterance::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSpeechSynthesisUtterance::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSpeechSynthesisUtterancePrototype::create(exec->vm(), globalObject, JSSpeechSynthesisUtterancePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSpeechSynthesisUtterance::destroy(JSC::JSCell* cell)
{
    JSSpeechSynthesisUtterance* thisObject = static_cast<JSSpeechSynthesisUtterance*>(cell);
    thisObject->JSSpeechSynthesisUtterance::~JSSpeechSynthesisUtterance();
}

JSSpeechSynthesisUtterance::~JSSpeechSynthesisUtterance()
{
    releaseImplIfNotNull();
}

bool JSSpeechSynthesisUtterance::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSpeechSynthesisUtterance* thisObject = jsCast<JSSpeechSynthesisUtterance*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSpeechSynthesisUtterance, Base>(exec, &JSSpeechSynthesisUtteranceTable, thisObject, propertyName, slot);
}

bool JSSpeechSynthesisUtterance::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSpeechSynthesisUtterance* thisObject = jsCast<JSSpeechSynthesisUtterance*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSpeechSynthesisUtterance, Base>(exec, &JSSpeechSynthesisUtteranceTable, thisObject, propertyName, descriptor);
}

JSValue jsSpeechSynthesisUtteranceText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->text());
    return result;
}


JSValue jsSpeechSynthesisUtteranceLang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->lang());
    return result;
}


JSValue jsSpeechSynthesisUtteranceVoice(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->voice()));
    return result;
}


JSValue jsSpeechSynthesisUtteranceVolume(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    JSValue result = jsNumber(impl->volume());
    return result;
}


JSValue jsSpeechSynthesisUtteranceRate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    JSValue result = jsNumber(impl->rate());
    return result;
}


JSValue jsSpeechSynthesisUtterancePitch(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    JSValue result = jsNumber(impl->pitch());
    return result;
}


JSValue jsSpeechSynthesisUtteranceOnstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    if (EventListener* listener = impl->onstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSpeechSynthesisUtteranceOnend(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    if (EventListener* listener = impl->onend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSpeechSynthesisUtteranceOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSpeechSynthesisUtteranceOnpause(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    if (EventListener* listener = impl->onpause()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSpeechSynthesisUtteranceOnresume(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    if (EventListener* listener = impl->onresume()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSpeechSynthesisUtteranceOnmark(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    if (EventListener* listener = impl->onmark()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSpeechSynthesisUtteranceOnboundary(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    if (EventListener* listener = impl->onboundary()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSpeechSynthesisUtteranceConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisUtterance* domObject = jsCast<JSSpeechSynthesisUtterance*>(asObject(slotBase));
    return JSSpeechSynthesisUtterance::getConstructor(exec, domObject->globalObject());
}

void JSSpeechSynthesisUtterance::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSpeechSynthesisUtterance* thisObject = jsCast<JSSpeechSynthesisUtterance*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSpeechSynthesisUtterance, Base>(exec, propertyName, value, &JSSpeechSynthesisUtteranceTable, thisObject, slot);
}

void setJSSpeechSynthesisUtteranceText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setText(nativeValue);
}


void setJSSpeechSynthesisUtteranceLang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setLang(nativeValue);
}


void setJSSpeechSynthesisUtteranceVoice(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    SpeechSynthesisVoice* nativeValue(toSpeechSynthesisVoice(value));
    if (exec->hadException())
        return;
    impl->setVoice(nativeValue);
}


void setJSSpeechSynthesisUtteranceVolume(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setVolume(nativeValue);
}


void setJSSpeechSynthesisUtteranceRate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setRate(nativeValue);
}


void setJSSpeechSynthesisUtterancePitch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setPitch(nativeValue);
}


void setJSSpeechSynthesisUtteranceOnstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    impl->setOnstart(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSSpeechSynthesisUtteranceOnend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    impl->setOnend(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSSpeechSynthesisUtteranceOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSSpeechSynthesisUtteranceOnpause(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    impl->setOnpause(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSSpeechSynthesisUtteranceOnresume(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    impl->setOnresume(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSSpeechSynthesisUtteranceOnmark(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    impl->setOnmark(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSSpeechSynthesisUtteranceOnboundary(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSpeechSynthesisUtterance* castedThis = jsCast<JSSpeechSynthesisUtterance*>(thisObject);
    SpeechSynthesisUtterance* impl = static_cast<SpeechSynthesisUtterance*>(castedThis->impl());
    impl->setOnboundary(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSSpeechSynthesisUtterance::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSpeechSynthesisUtteranceConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

void JSSpeechSynthesisUtterance::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSSpeechSynthesisUtterance* thisObject = jsCast<JSSpeechSynthesisUtterance*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSSpeechSynthesisUtterance* jsSpeechSynthesisUtterance)
{
    if (jsSpeechSynthesisUtterance->hasCustomProperties())
        return true;
    if (jsSpeechSynthesisUtterance->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSSpeechSynthesisUtteranceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSpeechSynthesisUtterance* jsSpeechSynthesisUtterance = jsCast<JSSpeechSynthesisUtterance*>(handle.get().asCell());
    if (jsSpeechSynthesisUtterance->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsSpeechSynthesisUtterance))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSpeechSynthesisUtteranceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSpeechSynthesisUtterance* jsSpeechSynthesisUtterance = jsCast<JSSpeechSynthesisUtterance*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSpeechSynthesisUtterance->impl(), jsSpeechSynthesisUtterance);
    jsSpeechSynthesisUtterance->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SpeechSynthesisUtterance@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24SpeechSynthesisUtteranceE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SpeechSynthesisUtterance* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSpeechSynthesisUtterance>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SpeechSynthesisUtterance@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore24SpeechSynthesisUtteranceE[2];
#if COMPILER(CLANG)
    // If this fails SpeechSynthesisUtterance does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SpeechSynthesisUtterance), SpeechSynthesisUtterance_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SpeechSynthesisUtterance has subclasses. If SpeechSynthesisUtterance has subclasses that get passed
    // to toJS() we currently require SpeechSynthesisUtterance you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<SpeechSynthesisUtterance>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSpeechSynthesisUtterance>(exec, globalObject, impl);
}

SpeechSynthesisUtterance* toSpeechSynthesisUtterance(JSC::JSValue value)
{
    return value.inherits(&JSSpeechSynthesisUtterance::s_info) ? jsCast<JSSpeechSynthesisUtterance*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SPEECH_SYNTHESIS)
