/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSSpeechSynthesisEvent.h"

#include "KURL.h"
#include "SpeechSynthesisEvent.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSpeechSynthesisEventTableValues[] =
{
    { "charIndex", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisEventCharIndex), (intptr_t)0, NoIntrinsic },
    { "elapsedTime", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisEventElapsedTime), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisEventName), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechSynthesisEventTable = { 9, 7, JSSpeechSynthesisEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSpeechSynthesisEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechSynthesisEventConstructorTable = { 1, 0, JSSpeechSynthesisEventConstructorTableValues, 0 };
const ClassInfo JSSpeechSynthesisEventConstructor::s_info = { "SpeechSynthesisEventConstructor", &Base::s_info, &JSSpeechSynthesisEventConstructorTable, 0, CREATE_METHOD_TABLE(JSSpeechSynthesisEventConstructor) };

JSSpeechSynthesisEventConstructor::JSSpeechSynthesisEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSpeechSynthesisEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSpeechSynthesisEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSpeechSynthesisEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSpeechSynthesisEventConstructor, JSDOMWrapper>(exec, &JSSpeechSynthesisEventConstructorTable, jsCast<JSSpeechSynthesisEventConstructor*>(cell), propertyName, slot);
}

bool JSSpeechSynthesisEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSpeechSynthesisEventConstructor, JSDOMWrapper>(exec, &JSSpeechSynthesisEventConstructorTable, jsCast<JSSpeechSynthesisEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSpeechSynthesisEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechSynthesisEventPrototypeTable = { 1, 0, JSSpeechSynthesisEventPrototypeTableValues, 0 };
const ClassInfo JSSpeechSynthesisEventPrototype::s_info = { "SpeechSynthesisEventPrototype", &Base::s_info, &JSSpeechSynthesisEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSSpeechSynthesisEventPrototype) };

JSObject* JSSpeechSynthesisEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSpeechSynthesisEvent>(exec, globalObject);
}

const ClassInfo JSSpeechSynthesisEvent::s_info = { "SpeechSynthesisEvent", &Base::s_info, &JSSpeechSynthesisEventTable, 0 , CREATE_METHOD_TABLE(JSSpeechSynthesisEvent) };

JSSpeechSynthesisEvent::JSSpeechSynthesisEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SpeechSynthesisEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSSpeechSynthesisEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSpeechSynthesisEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSpeechSynthesisEventPrototype::create(exec->vm(), globalObject, JSSpeechSynthesisEventPrototype::createStructure(exec->vm(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSSpeechSynthesisEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSpeechSynthesisEvent* thisObject = jsCast<JSSpeechSynthesisEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSpeechSynthesisEvent, Base>(exec, &JSSpeechSynthesisEventTable, thisObject, propertyName, slot);
}

bool JSSpeechSynthesisEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSpeechSynthesisEvent* thisObject = jsCast<JSSpeechSynthesisEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSpeechSynthesisEvent, Base>(exec, &JSSpeechSynthesisEventTable, thisObject, propertyName, descriptor);
}

JSValue jsSpeechSynthesisEventCharIndex(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisEvent* castedThis = jsCast<JSSpeechSynthesisEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisEvent* impl = static_cast<SpeechSynthesisEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->charIndex());
    return result;
}


JSValue jsSpeechSynthesisEventElapsedTime(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisEvent* castedThis = jsCast<JSSpeechSynthesisEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisEvent* impl = static_cast<SpeechSynthesisEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->elapsedTime());
    return result;
}


JSValue jsSpeechSynthesisEventName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisEvent* castedThis = jsCast<JSSpeechSynthesisEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesisEvent* impl = static_cast<SpeechSynthesisEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsSpeechSynthesisEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesisEvent* domObject = jsCast<JSSpeechSynthesisEvent*>(asObject(slotBase));
    return JSSpeechSynthesisEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSSpeechSynthesisEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSpeechSynthesisEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SPEECH_SYNTHESIS)
