/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSSpeechSynthesis.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSpeechSynthesisUtterance.h"
#include "JSSpeechSynthesisVoice.h"
#include "SpeechSynthesis.h"
#include "SpeechSynthesisVoice.h"
#include <runtime/Error.h>
#include <runtime/JSArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSpeechSynthesisTableValues[] =
{
    { "pending", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisPending), (intptr_t)0, NoIntrinsic },
    { "speaking", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisSpeaking), (intptr_t)0, NoIntrinsic },
    { "paused", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechSynthesisPaused), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechSynthesisTable = { 8, 7, JSSpeechSynthesisTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSpeechSynthesisPrototypeTableValues[] =
{
    { "speak", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSpeechSynthesisPrototypeFunctionSpeak), (intptr_t)1, NoIntrinsic },
    { "cancel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSpeechSynthesisPrototypeFunctionCancel), (intptr_t)0, NoIntrinsic },
    { "pause", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSpeechSynthesisPrototypeFunctionPause), (intptr_t)0, NoIntrinsic },
    { "resume", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSpeechSynthesisPrototypeFunctionResume), (intptr_t)0, NoIntrinsic },
    { "getVoices", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSpeechSynthesisPrototypeFunctionGetVoices), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechSynthesisPrototypeTable = { 16, 15, JSSpeechSynthesisPrototypeTableValues, 0 };
const ClassInfo JSSpeechSynthesisPrototype::s_info = { "SpeechSynthesisPrototype", &Base::s_info, &JSSpeechSynthesisPrototypeTable, 0, CREATE_METHOD_TABLE(JSSpeechSynthesisPrototype) };

JSObject* JSSpeechSynthesisPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSpeechSynthesis>(exec, globalObject);
}

bool JSSpeechSynthesisPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSpeechSynthesisPrototype* thisObject = jsCast<JSSpeechSynthesisPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSpeechSynthesisPrototypeTable, thisObject, propertyName, slot);
}

bool JSSpeechSynthesisPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSpeechSynthesisPrototype* thisObject = jsCast<JSSpeechSynthesisPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSpeechSynthesisPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSpeechSynthesis::s_info = { "SpeechSynthesis", &Base::s_info, &JSSpeechSynthesisTable, 0 , CREATE_METHOD_TABLE(JSSpeechSynthesis) };

JSSpeechSynthesis::JSSpeechSynthesis(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SpeechSynthesis> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSpeechSynthesis::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSpeechSynthesis::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSpeechSynthesisPrototype::create(exec->vm(), globalObject, JSSpeechSynthesisPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSpeechSynthesis::destroy(JSC::JSCell* cell)
{
    JSSpeechSynthesis* thisObject = static_cast<JSSpeechSynthesis*>(cell);
    thisObject->JSSpeechSynthesis::~JSSpeechSynthesis();
}

JSSpeechSynthesis::~JSSpeechSynthesis()
{
    releaseImplIfNotNull();
}

bool JSSpeechSynthesis::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSpeechSynthesis* thisObject = jsCast<JSSpeechSynthesis*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSpeechSynthesis, Base>(exec, &JSSpeechSynthesisTable, thisObject, propertyName, slot);
}

bool JSSpeechSynthesis::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSpeechSynthesis* thisObject = jsCast<JSSpeechSynthesis*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSpeechSynthesis, Base>(exec, &JSSpeechSynthesisTable, thisObject, propertyName, descriptor);
}

JSValue jsSpeechSynthesisPending(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesis* castedThis = jsCast<JSSpeechSynthesis*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesis* impl = static_cast<SpeechSynthesis*>(castedThis->impl());
    JSValue result = jsBoolean(impl->pending());
    return result;
}


JSValue jsSpeechSynthesisSpeaking(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesis* castedThis = jsCast<JSSpeechSynthesis*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesis* impl = static_cast<SpeechSynthesis*>(castedThis->impl());
    JSValue result = jsBoolean(impl->speaking());
    return result;
}


JSValue jsSpeechSynthesisPaused(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechSynthesis* castedThis = jsCast<JSSpeechSynthesis*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechSynthesis* impl = static_cast<SpeechSynthesis*>(castedThis->impl());
    JSValue result = jsBoolean(impl->paused());
    return result;
}


EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionSpeak(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSpeechSynthesis::s_info))
        return throwVMTypeError(exec);
    JSSpeechSynthesis* castedThis = jsCast<JSSpeechSynthesis*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSpeechSynthesis::s_info);
    SpeechSynthesis* impl = static_cast<SpeechSynthesis*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    SpeechSynthesisUtterance* utterance(toSpeechSynthesisUtterance(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->speak(utterance);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionCancel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSpeechSynthesis::s_info))
        return throwVMTypeError(exec);
    JSSpeechSynthesis* castedThis = jsCast<JSSpeechSynthesis*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSpeechSynthesis::s_info);
    SpeechSynthesis* impl = static_cast<SpeechSynthesis*>(castedThis->impl());
    impl->cancel();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionPause(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSpeechSynthesis::s_info))
        return throwVMTypeError(exec);
    JSSpeechSynthesis* castedThis = jsCast<JSSpeechSynthesis*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSpeechSynthesis::s_info);
    SpeechSynthesis* impl = static_cast<SpeechSynthesis*>(castedThis->impl());
    impl->pause();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionResume(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSpeechSynthesis::s_info))
        return throwVMTypeError(exec);
    JSSpeechSynthesis* castedThis = jsCast<JSSpeechSynthesis*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSpeechSynthesis::s_info);
    SpeechSynthesis* impl = static_cast<SpeechSynthesis*>(castedThis->impl());
    impl->resume();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSpeechSynthesisPrototypeFunctionGetVoices(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSpeechSynthesis::s_info))
        return throwVMTypeError(exec);
    JSSpeechSynthesis* castedThis = jsCast<JSSpeechSynthesis*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSpeechSynthesis::s_info);
    SpeechSynthesis* impl = static_cast<SpeechSynthesis*>(castedThis->impl());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->getVoices());
    return JSValue::encode(result);
}

static inline bool isObservable(JSSpeechSynthesis* jsSpeechSynthesis)
{
    if (jsSpeechSynthesis->hasCustomProperties())
        return true;
    return false;
}

bool JSSpeechSynthesisOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSpeechSynthesis* jsSpeechSynthesis = jsCast<JSSpeechSynthesis*>(handle.get().asCell());
    if (!isObservable(jsSpeechSynthesis))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSpeechSynthesisOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSpeechSynthesis* jsSpeechSynthesis = jsCast<JSSpeechSynthesis*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSpeechSynthesis->impl(), jsSpeechSynthesis);
    jsSpeechSynthesis->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SpeechSynthesis@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15SpeechSynthesisE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SpeechSynthesis* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSpeechSynthesis>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SpeechSynthesis@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15SpeechSynthesisE[2];
#if COMPILER(CLANG)
    // If this fails SpeechSynthesis does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SpeechSynthesis), SpeechSynthesis_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SpeechSynthesis has subclasses. If SpeechSynthesis has subclasses that get passed
    // to toJS() we currently require SpeechSynthesis you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<SpeechSynthesis>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSpeechSynthesis>(exec, globalObject, impl);
}

SpeechSynthesis* toSpeechSynthesis(JSC::JSValue value)
{
    return value.inherits(&JSSpeechSynthesis::s_info) ? jsCast<JSSpeechSynthesis*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SPEECH_SYNTHESIS)
