/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INPUT_SPEECH)

#include "JSSpeechInputResultList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSpeechInputResult.h"
#include "SpeechInputResult.h"
#include "SpeechInputResultList.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSpeechInputResultListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechInputResultListLength), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechInputResultListTable = { 2, 1, JSSpeechInputResultListTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSpeechInputResultListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSpeechInputResultListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechInputResultListPrototypeTable = { 2, 1, JSSpeechInputResultListPrototypeTableValues, 0 };
const ClassInfo JSSpeechInputResultListPrototype::s_info = { "SpeechInputResultListPrototype", &Base::s_info, &JSSpeechInputResultListPrototypeTable, 0, CREATE_METHOD_TABLE(JSSpeechInputResultListPrototype) };

JSObject* JSSpeechInputResultListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSpeechInputResultList>(exec, globalObject);
}

bool JSSpeechInputResultListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSpeechInputResultListPrototype* thisObject = jsCast<JSSpeechInputResultListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSpeechInputResultListPrototypeTable, thisObject, propertyName, slot);
}

bool JSSpeechInputResultListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSpeechInputResultListPrototype* thisObject = jsCast<JSSpeechInputResultListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSpeechInputResultListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSpeechInputResultList::s_info = { "SpeechInputResultList", &Base::s_info, &JSSpeechInputResultListTable, 0 , CREATE_METHOD_TABLE(JSSpeechInputResultList) };

JSSpeechInputResultList::JSSpeechInputResultList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SpeechInputResultList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSpeechInputResultList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSpeechInputResultList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSpeechInputResultListPrototype::create(exec->vm(), globalObject, JSSpeechInputResultListPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSpeechInputResultList::destroy(JSC::JSCell* cell)
{
    JSSpeechInputResultList* thisObject = static_cast<JSSpeechInputResultList*>(cell);
    thisObject->JSSpeechInputResultList::~JSSpeechInputResultList();
}

JSSpeechInputResultList::~JSSpeechInputResultList()
{
    releaseImplIfNotNull();
}

bool JSSpeechInputResultList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSpeechInputResultList* thisObject = jsCast<JSSpeechInputResultList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSSpeechInputResultList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<SpeechInputResultList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSSpeechInputResultList, Base>(exec, &JSSpeechInputResultListTable, thisObject, propertyName, slot);
}

bool JSSpeechInputResultList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSpeechInputResultList* thisObject = jsCast<JSSpeechInputResultList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSSpeechInputResultListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<SpeechInputResultList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSSpeechInputResultList, Base>(exec, &JSSpeechInputResultListTable, thisObject, propertyName, descriptor);
}

bool JSSpeechInputResultList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSSpeechInputResultList* thisObject = jsCast<JSSpeechInputResultList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<SpeechInputResultList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsSpeechInputResultListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechInputResultList* castedThis = jsCast<JSSpeechInputResultList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechInputResultList* impl = static_cast<SpeechInputResultList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


void JSSpeechInputResultList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSSpeechInputResultList* thisObject = jsCast<JSSpeechInputResultList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<SpeechInputResultList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

EncodedJSValue JSC_HOST_CALL jsSpeechInputResultListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSpeechInputResultList::s_info))
        return throwVMTypeError(exec);
    JSSpeechInputResultList* castedThis = jsCast<JSSpeechInputResultList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSpeechInputResultList::s_info);
    SpeechInputResultList* impl = static_cast<SpeechInputResultList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSSpeechInputResultList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSSpeechInputResultList* thisObj = jsCast<JSSpeechInputResultList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<SpeechInputResultList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSSpeechInputResultList* jsSpeechInputResultList)
{
    if (jsSpeechInputResultList->hasCustomProperties())
        return true;
    return false;
}

bool JSSpeechInputResultListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSpeechInputResultList* jsSpeechInputResultList = jsCast<JSSpeechInputResultList*>(handle.get().asCell());
    if (!isObservable(jsSpeechInputResultList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSpeechInputResultListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSpeechInputResultList* jsSpeechInputResultList = jsCast<JSSpeechInputResultList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSpeechInputResultList->impl(), jsSpeechInputResultList);
    jsSpeechInputResultList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SpeechInputResultList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSpeechInputResultList>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SpeechInputResultList.
    COMPILE_ASSERT(!__is_polymorphic(SpeechInputResultList), SpeechInputResultList_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<SpeechInputResultList>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSpeechInputResultList>(exec, globalObject, impl);
}

SpeechInputResultList* toSpeechInputResultList(JSC::JSValue value)
{
    return value.inherits(&JSSpeechInputResultList::s_info) ? jsCast<JSSpeechInputResultList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INPUT_SPEECH)
