/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INPUT_SPEECH)

#include "JSSpeechInputResult.h"

#include "KURL.h"
#include "SpeechInputResult.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSpeechInputResultTableValues[] =
{
    { "utterance", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechInputResultUtterance), (intptr_t)0, NoIntrinsic },
    { "confidence", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSpeechInputResultConfidence), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechInputResultTable = { 4, 3, JSSpeechInputResultTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSpeechInputResultPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSpeechInputResultPrototypeTable = { 1, 0, JSSpeechInputResultPrototypeTableValues, 0 };
const ClassInfo JSSpeechInputResultPrototype::s_info = { "SpeechInputResultPrototype", &Base::s_info, &JSSpeechInputResultPrototypeTable, 0, CREATE_METHOD_TABLE(JSSpeechInputResultPrototype) };

JSObject* JSSpeechInputResultPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSpeechInputResult>(exec, globalObject);
}

const ClassInfo JSSpeechInputResult::s_info = { "SpeechInputResult", &Base::s_info, &JSSpeechInputResultTable, 0 , CREATE_METHOD_TABLE(JSSpeechInputResult) };

JSSpeechInputResult::JSSpeechInputResult(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SpeechInputResult> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSpeechInputResult::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSpeechInputResult::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSpeechInputResultPrototype::create(exec->vm(), globalObject, JSSpeechInputResultPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSpeechInputResult::destroy(JSC::JSCell* cell)
{
    JSSpeechInputResult* thisObject = static_cast<JSSpeechInputResult*>(cell);
    thisObject->JSSpeechInputResult::~JSSpeechInputResult();
}

JSSpeechInputResult::~JSSpeechInputResult()
{
    releaseImplIfNotNull();
}

bool JSSpeechInputResult::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSpeechInputResult* thisObject = jsCast<JSSpeechInputResult*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSpeechInputResult, Base>(exec, &JSSpeechInputResultTable, thisObject, propertyName, slot);
}

bool JSSpeechInputResult::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSpeechInputResult* thisObject = jsCast<JSSpeechInputResult*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSpeechInputResult, Base>(exec, &JSSpeechInputResultTable, thisObject, propertyName, descriptor);
}

JSValue jsSpeechInputResultUtterance(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechInputResult* castedThis = jsCast<JSSpeechInputResult*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechInputResult* impl = static_cast<SpeechInputResult*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->utterance());
    return result;
}


JSValue jsSpeechInputResultConfidence(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSpeechInputResult* castedThis = jsCast<JSSpeechInputResult*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SpeechInputResult* impl = static_cast<SpeechInputResult*>(castedThis->impl());
    JSValue result = jsNumber(impl->confidence());
    return result;
}


static inline bool isObservable(JSSpeechInputResult* jsSpeechInputResult)
{
    if (jsSpeechInputResult->hasCustomProperties())
        return true;
    return false;
}

bool JSSpeechInputResultOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSpeechInputResult* jsSpeechInputResult = jsCast<JSSpeechInputResult*>(handle.get().asCell());
    if (!isObservable(jsSpeechInputResult))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSpeechInputResultOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSpeechInputResult* jsSpeechInputResult = jsCast<JSSpeechInputResult*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSpeechInputResult->impl(), jsSpeechInputResult);
    jsSpeechInputResult->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SpeechInputResult* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSpeechInputResult>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SpeechInputResult.
    COMPILE_ASSERT(!__is_polymorphic(SpeechInputResult), SpeechInputResult_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<SpeechInputResult>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSpeechInputResult>(exec, globalObject, impl);
}

SpeechInputResult* toSpeechInputResult(JSC::JSValue value)
{
    return value.inherits(&JSSpeechInputResult::s_info) ? jsCast<JSSpeechInputResult*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INPUT_SPEECH)
