/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSSourceBufferList.h"

#include "Event.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSSourceBuffer.h"
#include "SourceBuffer.h"
#include "SourceBufferList.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSourceBufferListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSourceBufferListTable = { 5, 3, JSSourceBufferListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSourceBufferListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSourceBufferListConstructorTable = { 1, 0, JSSourceBufferListConstructorTableValues, 0 };
const ClassInfo JSSourceBufferListConstructor::s_info = { "WebKitSourceBufferListConstructor", &Base::s_info, &JSSourceBufferListConstructorTable, 0, CREATE_METHOD_TABLE(JSSourceBufferListConstructor) };

JSSourceBufferListConstructor::JSSourceBufferListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSourceBufferListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSourceBufferListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSourceBufferListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSourceBufferListConstructor, JSDOMWrapper>(exec, &JSSourceBufferListConstructorTable, jsCast<JSSourceBufferListConstructor*>(cell), propertyName, slot);
}

bool JSSourceBufferListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSourceBufferListConstructor, JSDOMWrapper>(exec, &JSSourceBufferListConstructorTable, jsCast<JSSourceBufferListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSourceBufferListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSourceBufferListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSourceBufferListPrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSourceBufferListPrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSourceBufferListPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSourceBufferListPrototypeTable = { 8, 7, JSSourceBufferListPrototypeTableValues, 0 };
const ClassInfo JSSourceBufferListPrototype::s_info = { "WebKitSourceBufferListPrototype", &Base::s_info, &JSSourceBufferListPrototypeTable, 0, CREATE_METHOD_TABLE(JSSourceBufferListPrototype) };

JSObject* JSSourceBufferListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSourceBufferList>(exec, globalObject);
}

bool JSSourceBufferListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSourceBufferListPrototype* thisObject = jsCast<JSSourceBufferListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSourceBufferListPrototypeTable, thisObject, propertyName, slot);
}

bool JSSourceBufferListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSourceBufferListPrototype* thisObject = jsCast<JSSourceBufferListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSourceBufferListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSourceBufferList::s_info = { "WebKitSourceBufferList", &Base::s_info, &JSSourceBufferListTable, 0 , CREATE_METHOD_TABLE(JSSourceBufferList) };

JSSourceBufferList::JSSourceBufferList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SourceBufferList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSourceBufferList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSourceBufferList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSourceBufferListPrototype::create(exec->vm(), globalObject, JSSourceBufferListPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSourceBufferList::destroy(JSC::JSCell* cell)
{
    JSSourceBufferList* thisObject = static_cast<JSSourceBufferList*>(cell);
    thisObject->JSSourceBufferList::~JSSourceBufferList();
}

JSSourceBufferList::~JSSourceBufferList()
{
    releaseImplIfNotNull();
}

bool JSSourceBufferList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSourceBufferList* thisObject = jsCast<JSSourceBufferList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSSourceBufferList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<SourceBufferList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSSourceBufferList, Base>(exec, &JSSourceBufferListTable, thisObject, propertyName, slot);
}

bool JSSourceBufferList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSourceBufferList* thisObject = jsCast<JSSourceBufferList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSSourceBufferListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<SourceBufferList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSSourceBufferList, Base>(exec, &JSSourceBufferListTable, thisObject, propertyName, descriptor);
}

bool JSSourceBufferList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSSourceBufferList* thisObject = jsCast<JSSourceBufferList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<SourceBufferList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsSourceBufferListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSourceBufferList* castedThis = jsCast<JSSourceBufferList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SourceBufferList* impl = static_cast<SourceBufferList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsSourceBufferListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSourceBufferList* domObject = jsCast<JSSourceBufferList*>(asObject(slotBase));
    return JSSourceBufferList::getConstructor(exec, domObject->globalObject());
}

void JSSourceBufferList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSSourceBufferList* thisObject = jsCast<JSSourceBufferList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<SourceBufferList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSSourceBufferList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSourceBufferListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSourceBufferList::s_info))
        return throwVMTypeError(exec);
    JSSourceBufferList* castedThis = jsCast<JSSourceBufferList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSourceBufferList::s_info);
    SourceBufferList* impl = static_cast<SourceBufferList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferListPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSourceBufferList::s_info))
        return throwVMTypeError(exec);
    JSSourceBufferList* castedThis = jsCast<JSSourceBufferList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSourceBufferList::s_info);
    SourceBufferList* impl = static_cast<SourceBufferList*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferListPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSourceBufferList::s_info))
        return throwVMTypeError(exec);
    JSSourceBufferList* castedThis = jsCast<JSSourceBufferList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSourceBufferList::s_info);
    SourceBufferList* impl = static_cast<SourceBufferList*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferListPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSourceBufferList::s_info))
        return throwVMTypeError(exec);
    JSSourceBufferList* castedThis = jsCast<JSSourceBufferList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSourceBufferList::s_info);
    SourceBufferList* impl = static_cast<SourceBufferList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* event(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(event, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSSourceBufferList::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSSourceBufferList* thisObject = jsCast<JSSourceBufferList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}


JSValue JSSourceBufferList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSSourceBufferList* thisObj = jsCast<JSSourceBufferList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<SourceBufferList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSSourceBufferList* jsSourceBufferList)
{
    if (jsSourceBufferList->hasCustomProperties())
        return true;
    if (jsSourceBufferList->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSSourceBufferListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSourceBufferList* jsSourceBufferList = jsCast<JSSourceBufferList*>(handle.get().asCell());
    if (jsSourceBufferList->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsSourceBufferList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSourceBufferListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSourceBufferList* jsSourceBufferList = jsCast<JSSourceBufferList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSourceBufferList->impl(), jsSourceBufferList);
    jsSourceBufferList->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SourceBufferList@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16SourceBufferListE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SourceBufferList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSourceBufferList>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SourceBufferList@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16SourceBufferListE[2];
#if COMPILER(CLANG)
    // If this fails SourceBufferList does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SourceBufferList), SourceBufferList_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SourceBufferList has subclasses. If SourceBufferList has subclasses that get passed
    // to toJS() we currently require SourceBufferList you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<SourceBufferList>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSourceBufferList>(exec, globalObject, impl);
}

SourceBufferList* toSourceBufferList(JSC::JSValue value)
{
    return value.inherits(&JSSourceBufferList::s_info) ? jsCast<JSSourceBufferList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(MEDIA_SOURCE)
