/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSSourceBuffer.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSTimeRanges.h"
#include "JSUint8Array.h"
#include "SourceBuffer.h"
#include "TimeRanges.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSourceBufferTableValues[] =
{
    { "buffered", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferBuffered), (intptr_t)0, NoIntrinsic },
    { "timestampOffset", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferTimestampOffset), (intptr_t)setJSSourceBufferTimestampOffset, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSourceBufferConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSourceBufferTable = { 8, 7, JSSourceBufferTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSourceBufferConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSourceBufferConstructorTable = { 1, 0, JSSourceBufferConstructorTableValues, 0 };
const ClassInfo JSSourceBufferConstructor::s_info = { "WebKitSourceBufferConstructor", &Base::s_info, &JSSourceBufferConstructorTable, 0, CREATE_METHOD_TABLE(JSSourceBufferConstructor) };

JSSourceBufferConstructor::JSSourceBufferConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSourceBufferConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSourceBufferPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSourceBufferConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSourceBufferConstructor, JSDOMWrapper>(exec, &JSSourceBufferConstructorTable, jsCast<JSSourceBufferConstructor*>(cell), propertyName, slot);
}

bool JSSourceBufferConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSourceBufferConstructor, JSDOMWrapper>(exec, &JSSourceBufferConstructorTable, jsCast<JSSourceBufferConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSourceBufferPrototypeTableValues[] =
{
    { "append", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSourceBufferPrototypeFunctionAppend), (intptr_t)1, NoIntrinsic },
    { "abort", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSourceBufferPrototypeFunctionAbort), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSourceBufferPrototypeTable = { 4, 3, JSSourceBufferPrototypeTableValues, 0 };
const ClassInfo JSSourceBufferPrototype::s_info = { "WebKitSourceBufferPrototype", &Base::s_info, &JSSourceBufferPrototypeTable, 0, CREATE_METHOD_TABLE(JSSourceBufferPrototype) };

JSObject* JSSourceBufferPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSourceBuffer>(exec, globalObject);
}

bool JSSourceBufferPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSourceBufferPrototype* thisObject = jsCast<JSSourceBufferPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSourceBufferPrototypeTable, thisObject, propertyName, slot);
}

bool JSSourceBufferPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSourceBufferPrototype* thisObject = jsCast<JSSourceBufferPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSourceBufferPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSourceBuffer::s_info = { "WebKitSourceBuffer", &Base::s_info, &JSSourceBufferTable, 0 , CREATE_METHOD_TABLE(JSSourceBuffer) };

JSSourceBuffer::JSSourceBuffer(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SourceBuffer> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSourceBuffer::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSourceBuffer::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSourceBufferPrototype::create(exec->vm(), globalObject, JSSourceBufferPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSourceBuffer::destroy(JSC::JSCell* cell)
{
    JSSourceBuffer* thisObject = static_cast<JSSourceBuffer*>(cell);
    thisObject->JSSourceBuffer::~JSSourceBuffer();
}

JSSourceBuffer::~JSSourceBuffer()
{
    releaseImplIfNotNull();
}

bool JSSourceBuffer::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSourceBuffer* thisObject = jsCast<JSSourceBuffer*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSourceBuffer, Base>(exec, &JSSourceBufferTable, thisObject, propertyName, slot);
}

bool JSSourceBuffer::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSourceBuffer* thisObject = jsCast<JSSourceBuffer*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSourceBuffer, Base>(exec, &JSSourceBufferTable, thisObject, propertyName, descriptor);
}

JSValue jsSourceBufferBuffered(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSourceBuffer* castedThis = jsCast<JSSourceBuffer*>(asObject(slotBase));
    ExceptionCode ec = 0;
    SourceBuffer* impl = static_cast<SourceBuffer*>(castedThis->impl());
    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->buffered(ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue jsSourceBufferTimestampOffset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSourceBuffer* castedThis = jsCast<JSSourceBuffer*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SourceBuffer* impl = static_cast<SourceBuffer*>(castedThis->impl());
    JSValue result = jsNumber(impl->timestampOffset());
    return result;
}


JSValue jsSourceBufferConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSourceBuffer* domObject = jsCast<JSSourceBuffer*>(asObject(slotBase));
    return JSSourceBuffer::getConstructor(exec, domObject->globalObject());
}

void JSSourceBuffer::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSourceBuffer* thisObject = jsCast<JSSourceBuffer*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSourceBuffer, Base>(exec, propertyName, value, &JSSourceBufferTable, thisObject, slot);
}

void setJSSourceBufferTimestampOffset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSourceBuffer* castedThis = jsCast<JSSourceBuffer*>(thisObject);
    SourceBuffer* impl = static_cast<SourceBuffer*>(castedThis->impl());
    ExceptionCode ec = 0;
    double nativeValue(value.toNumber(exec));
    if (exec->hadException())
        return;
    impl->setTimestampOffset(nativeValue, ec);
    setDOMException(exec, ec);
}


JSValue JSSourceBuffer::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSourceBufferConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAppend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSourceBuffer::s_info))
        return throwVMTypeError(exec);
    JSSourceBuffer* castedThis = jsCast<JSSourceBuffer*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSourceBuffer::s_info);
    SourceBuffer* impl = static_cast<SourceBuffer*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Uint8Array* data(toUint8Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->append(data, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSourceBufferPrototypeFunctionAbort(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSourceBuffer::s_info))
        return throwVMTypeError(exec);
    JSSourceBuffer* castedThis = jsCast<JSSourceBuffer*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSourceBuffer::s_info);
    SourceBuffer* impl = static_cast<SourceBuffer*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->abort(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSSourceBuffer* jsSourceBuffer)
{
    if (jsSourceBuffer->hasCustomProperties())
        return true;
    return false;
}

bool JSSourceBufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSourceBuffer* jsSourceBuffer = jsCast<JSSourceBuffer*>(handle.get().asCell());
    if (!isObservable(jsSourceBuffer))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSourceBufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSourceBuffer* jsSourceBuffer = jsCast<JSSourceBuffer*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSourceBuffer->impl(), jsSourceBuffer);
    jsSourceBuffer->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SourceBuffer@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12SourceBufferE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SourceBuffer* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSourceBuffer>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SourceBuffer@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12SourceBufferE[2];
#if COMPILER(CLANG)
    // If this fails SourceBuffer does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SourceBuffer), SourceBuffer_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SourceBuffer has subclasses. If SourceBuffer has subclasses that get passed
    // to toJS() we currently require SourceBuffer you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<SourceBuffer>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSourceBuffer>(exec, globalObject, impl);
}

SourceBuffer* toSourceBuffer(JSC::JSValue value)
{
    return value.inherits(&JSSourceBuffer::s_info) ? jsCast<JSSourceBuffer*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(MEDIA_SOURCE)
