/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSSharedWorkerContext_h
#define JSSharedWorkerContext_h

#if ENABLE(SHARED_WORKERS)

#include "JSWorkerContext.h"
#include "SharedWorkerContext.h"
#include <runtime/JSObject.h>

namespace WebCore {

class SharedWorkerContext;

class JSSharedWorkerContext : public JSWorkerContext {
public:
    typedef JSWorkerContext Base;
    static JSSharedWorkerContext* create(JSC::VM& vm, JSC::Structure* structure, PassRefPtr<SharedWorkerContext> impl)
    {
        JSSharedWorkerContext* ptr = new (NotNull, JSC::allocateCell<JSSharedWorkerContext>(vm.heap)) JSSharedWorkerContext(vm, structure, impl);
        ptr->finishCreation(vm);
        vm.heap.addFinalizer(ptr, destroy);
        return ptr;
    }

    static const bool needsDestruction = false;

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::GlobalObjectType, StructureFlags), &s_info);
    }

    SharedWorkerContext* impl() const
    {
        return static_cast<SharedWorkerContext*>(Base::impl());
    }
protected:
    JSSharedWorkerContext(JSC::VM&, JSC::Structure*, PassRefPtr<SharedWorkerContext>);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | Base::StructureFlags;
};

SharedWorkerContext* toSharedWorkerContext(JSC::JSValue);

class JSSharedWorkerContextPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSharedWorkerContextPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSharedWorkerContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSSharedWorkerContextPrototype>(vm.heap)) JSSharedWorkerContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSSharedWorkerContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = Base::StructureFlags;
};

// Attributes

JSC::JSValue jsSharedWorkerContextName(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsSharedWorkerContextOnconnect(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSSharedWorkerContextOnconnect(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);

} // namespace WebCore

#endif // ENABLE(SHARED_WORKERS)

#endif
