/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(JAVASCRIPT_DEBUGGER)

#include "JSScriptProfile.h"

#include "JSScriptProfileNode.h"
#include "KURL.h"
#include "ScriptProfile.h"
#include "ScriptProfileNode.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSScriptProfileTableValues[] =
{
    { "title", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProfileTitle), (intptr_t)0, NoIntrinsic },
    { "uid", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProfileUid), (intptr_t)0, NoIntrinsic },
    { "head", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProfileHead), (intptr_t)0, NoIntrinsic },
    { "idleTime", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProfileIdleTime), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSScriptProfileTable = { 9, 7, JSScriptProfileTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSScriptProfilePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSScriptProfilePrototypeTable = { 1, 0, JSScriptProfilePrototypeTableValues, 0 };
const ClassInfo JSScriptProfilePrototype::s_info = { "ScriptProfilePrototype", &Base::s_info, &JSScriptProfilePrototypeTable, 0, CREATE_METHOD_TABLE(JSScriptProfilePrototype) };

JSObject* JSScriptProfilePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSScriptProfile>(exec, globalObject);
}

const ClassInfo JSScriptProfile::s_info = { "ScriptProfile", &Base::s_info, &JSScriptProfileTable, 0 , CREATE_METHOD_TABLE(JSScriptProfile) };

JSScriptProfile::JSScriptProfile(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ScriptProfile> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSScriptProfile::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSScriptProfile::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSScriptProfilePrototype::create(exec->vm(), globalObject, JSScriptProfilePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSScriptProfile::destroy(JSC::JSCell* cell)
{
    JSScriptProfile* thisObject = static_cast<JSScriptProfile*>(cell);
    thisObject->JSScriptProfile::~JSScriptProfile();
}

JSScriptProfile::~JSScriptProfile()
{
    releaseImplIfNotNull();
}

bool JSScriptProfile::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSScriptProfile* thisObject = jsCast<JSScriptProfile*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSScriptProfile, Base>(exec, &JSScriptProfileTable, thisObject, propertyName, slot);
}

bool JSScriptProfile::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSScriptProfile* thisObject = jsCast<JSScriptProfile*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSScriptProfile, Base>(exec, &JSScriptProfileTable, thisObject, propertyName, descriptor);
}

JSValue jsScriptProfileTitle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScriptProfile* castedThis = jsCast<JSScriptProfile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ScriptProfile* impl = static_cast<ScriptProfile*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->title());
    return result;
}


JSValue jsScriptProfileUid(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScriptProfile* castedThis = jsCast<JSScriptProfile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ScriptProfile* impl = static_cast<ScriptProfile*>(castedThis->impl());
    JSValue result = jsNumber(impl->uid());
    return result;
}


JSValue jsScriptProfileHead(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScriptProfile* castedThis = jsCast<JSScriptProfile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ScriptProfile* impl = static_cast<ScriptProfile*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->head()));
    return result;
}


JSValue jsScriptProfileIdleTime(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScriptProfile* castedThis = jsCast<JSScriptProfile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ScriptProfile* impl = static_cast<ScriptProfile*>(castedThis->impl());
    JSValue result = jsNumber(impl->idleTime());
    return result;
}


static inline bool isObservable(JSScriptProfile* jsScriptProfile)
{
    if (jsScriptProfile->hasCustomProperties())
        return true;
    return false;
}

bool JSScriptProfileOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSScriptProfile* jsScriptProfile = jsCast<JSScriptProfile*>(handle.get().asCell());
    if (!isObservable(jsScriptProfile))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSScriptProfileOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSScriptProfile* jsScriptProfile = jsCast<JSScriptProfile*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsScriptProfile->impl(), jsScriptProfile);
    jsScriptProfile->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ScriptProfile@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13ScriptProfileE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ScriptProfile* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSScriptProfile>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7ScriptProfile@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13ScriptProfileE[2];
#if COMPILER(CLANG)
    // If this fails ScriptProfile does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(ScriptProfile), ScriptProfile_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // ScriptProfile has subclasses. If ScriptProfile has subclasses that get passed
    // to toJS() we currently require ScriptProfile you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<ScriptProfile>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSScriptProfile>(exec, globalObject, impl);
}

ScriptProfile* toScriptProfile(JSC::JSValue value)
{
    return value.inherits(&JSScriptProfile::s_info) ? jsCast<JSScriptProfile*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
