/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGZoomAndPan.h"

#include "SVGZoomAndPan.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGZoomAndPanTableValues[] =
{
    { "zoomAndPan", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomAndPanZoomAndPan), (intptr_t)setJSSVGZoomAndPanZoomAndPan, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomAndPanConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGZoomAndPanTable = { 4, 3, JSSVGZoomAndPanTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGZoomAndPanConstructorTableValues[] =
{
    { "SVG_ZOOMANDPAN_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomAndPanSVG_ZOOMANDPAN_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_ZOOMANDPAN_DISABLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomAndPanSVG_ZOOMANDPAN_DISABLE), (intptr_t)0, NoIntrinsic },
    { "SVG_ZOOMANDPAN_MAGNIFY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomAndPanSVG_ZOOMANDPAN_MAGNIFY), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGZoomAndPanConstructorTable = { 9, 7, JSSVGZoomAndPanConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGZoomAndPan::SVG_ZOOMANDPAN_UNKNOWN, SVGZoomAndPanEnumSVG_ZOOMANDPAN_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGZoomAndPan::SVG_ZOOMANDPAN_DISABLE, SVGZoomAndPanEnumSVG_ZOOMANDPAN_DISABLEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGZoomAndPan::SVG_ZOOMANDPAN_MAGNIFY, SVGZoomAndPanEnumSVG_ZOOMANDPAN_MAGNIFYIsWrongUseDoNotCheckConstants);

const ClassInfo JSSVGZoomAndPanConstructor::s_info = { "SVGZoomAndPanConstructor", &Base::s_info, &JSSVGZoomAndPanConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGZoomAndPanConstructor) };

JSSVGZoomAndPanConstructor::JSSVGZoomAndPanConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGZoomAndPanConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGZoomAndPanPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGZoomAndPanConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGZoomAndPanConstructor, JSDOMWrapper>(exec, &JSSVGZoomAndPanConstructorTable, jsCast<JSSVGZoomAndPanConstructor*>(cell), propertyName, slot);
}

bool JSSVGZoomAndPanConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGZoomAndPanConstructor, JSDOMWrapper>(exec, &JSSVGZoomAndPanConstructorTable, jsCast<JSSVGZoomAndPanConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGZoomAndPanPrototypeTableValues[] =
{
    { "SVG_ZOOMANDPAN_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomAndPanSVG_ZOOMANDPAN_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_ZOOMANDPAN_DISABLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomAndPanSVG_ZOOMANDPAN_DISABLE), (intptr_t)0, NoIntrinsic },
    { "SVG_ZOOMANDPAN_MAGNIFY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomAndPanSVG_ZOOMANDPAN_MAGNIFY), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGZoomAndPanPrototypeTable = { 9, 7, JSSVGZoomAndPanPrototypeTableValues, 0 };
const ClassInfo JSSVGZoomAndPanPrototype::s_info = { "SVGZoomAndPanPrototype", &Base::s_info, &JSSVGZoomAndPanPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGZoomAndPanPrototype) };

JSObject* JSSVGZoomAndPanPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGZoomAndPan>(exec, globalObject);
}

bool JSSVGZoomAndPanPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGZoomAndPanPrototype* thisObject = jsCast<JSSVGZoomAndPanPrototype*>(cell);
    return getStaticValueSlot<JSSVGZoomAndPanPrototype, JSObject>(exec, &JSSVGZoomAndPanPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGZoomAndPanPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGZoomAndPanPrototype* thisObject = jsCast<JSSVGZoomAndPanPrototype*>(object);
    return getStaticValueDescriptor<JSSVGZoomAndPanPrototype, JSObject>(exec, &JSSVGZoomAndPanPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGZoomAndPan::s_info = { "SVGZoomAndPan", &Base::s_info, &JSSVGZoomAndPanTable, 0 , CREATE_METHOD_TABLE(JSSVGZoomAndPan) };

JSSVGZoomAndPan::JSSVGZoomAndPan(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGZoomAndPan> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGZoomAndPan::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGZoomAndPan::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGZoomAndPanPrototype::create(exec->vm(), globalObject, JSSVGZoomAndPanPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGZoomAndPan::destroy(JSC::JSCell* cell)
{
    JSSVGZoomAndPan* thisObject = static_cast<JSSVGZoomAndPan*>(cell);
    thisObject->JSSVGZoomAndPan::~JSSVGZoomAndPan();
}

JSSVGZoomAndPan::~JSSVGZoomAndPan()
{
    releaseImplIfNotNull();
}

bool JSSVGZoomAndPan::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGZoomAndPan* thisObject = jsCast<JSSVGZoomAndPan*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGZoomAndPan, Base>(exec, &JSSVGZoomAndPanTable, thisObject, propertyName, slot);
}

bool JSSVGZoomAndPan::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGZoomAndPan* thisObject = jsCast<JSSVGZoomAndPan*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGZoomAndPan, Base>(exec, &JSSVGZoomAndPanTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGZoomAndPanZoomAndPan(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGZoomAndPan* castedThis = jsCast<JSSVGZoomAndPan*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGZoomAndPan* impl = static_cast<SVGZoomAndPan*>(castedThis->impl());
    JSValue result = jsNumber(impl->zoomAndPan());
    return result;
}


JSValue jsSVGZoomAndPanConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGZoomAndPan* domObject = jsCast<JSSVGZoomAndPan*>(asObject(slotBase));
    return JSSVGZoomAndPan::getConstructor(exec, domObject->globalObject());
}

void JSSVGZoomAndPan::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGZoomAndPan* thisObject = jsCast<JSSVGZoomAndPan*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGZoomAndPan, Base>(exec, propertyName, value, &JSSVGZoomAndPanTable, thisObject, slot);
}

void setJSSVGZoomAndPanZoomAndPan(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGZoomAndPan* castedThis = jsCast<JSSVGZoomAndPan*>(thisObject);
    SVGZoomAndPan* impl = static_cast<SVGZoomAndPan*>(castedThis->impl());
    unsigned short nativeValue(toUInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setZoomAndPan(nativeValue);
}


JSValue JSSVGZoomAndPan::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGZoomAndPanConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGZoomAndPanSVG_ZOOMANDPAN_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGZoomAndPanSVG_ZOOMANDPAN_DISABLE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGZoomAndPanSVG_ZOOMANDPAN_MAGNIFY(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

static inline bool isObservable(JSSVGZoomAndPan* jsSVGZoomAndPan)
{
    if (jsSVGZoomAndPan->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGZoomAndPanOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGZoomAndPan* jsSVGZoomAndPan = jsCast<JSSVGZoomAndPan*>(handle.get().asCell());
    if (!isObservable(jsSVGZoomAndPan))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGZoomAndPanOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGZoomAndPan* jsSVGZoomAndPan = jsCast<JSSVGZoomAndPan*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGZoomAndPan->impl(), jsSVGZoomAndPan);
    jsSVGZoomAndPan->releaseImpl();
}

SVGZoomAndPan* toSVGZoomAndPan(JSC::JSValue value)
{
    return value.inherits(&JSSVGZoomAndPan::s_info) ? jsCast<JSSVGZoomAndPan*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
