/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGUseElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGElementInstance.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGElementInstance.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include "SVGUseElement.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGUseElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementHeight), (intptr_t)0, NoIntrinsic },
    { "instanceRoot", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementInstanceRoot), (intptr_t)0, NoIntrinsic },
    { "animatedInstanceRoot", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementAnimatedInstanceRoot), (intptr_t)0, NoIntrinsic },
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementHref), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementXmllang), (intptr_t)setJSSVGUseElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementXmlspace), (intptr_t)setJSSVGUseElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGUseElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGUseElementTable = { 67, 63, JSSVGUseElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGUseElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGUseElementConstructorTable = { 1, 0, JSSVGUseElementConstructorTableValues, 0 };
const ClassInfo JSSVGUseElementConstructor::s_info = { "SVGUseElementConstructor", &Base::s_info, &JSSVGUseElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGUseElementConstructor) };

JSSVGUseElementConstructor::JSSVGUseElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGUseElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGUseElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGUseElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGUseElementConstructor, JSDOMWrapper>(exec, &JSSVGUseElementConstructorTable, jsCast<JSSVGUseElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGUseElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGUseElementConstructor, JSDOMWrapper>(exec, &JSSVGUseElementConstructorTable, jsCast<JSSVGUseElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGUseElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGUseElementPrototypeFunctionHasExtension), (intptr_t)0, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGUseElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGUseElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGUseElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGUseElementPrototypeFunctionGetTransformToElement), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGUseElementPrototypeTable = { 17, 15, JSSVGUseElementPrototypeTableValues, 0 };
const ClassInfo JSSVGUseElementPrototype::s_info = { "SVGUseElementPrototype", &Base::s_info, &JSSVGUseElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGUseElementPrototype) };

JSObject* JSSVGUseElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGUseElement>(exec, globalObject);
}

bool JSSVGUseElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGUseElementPrototype* thisObject = jsCast<JSSVGUseElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGUseElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGUseElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGUseElementPrototype* thisObject = jsCast<JSSVGUseElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGUseElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGUseElement::s_info = { "SVGUseElement", &Base::s_info, &JSSVGUseElementTable, 0 , CREATE_METHOD_TABLE(JSSVGUseElement) };

JSSVGUseElement::JSSVGUseElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGUseElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGUseElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGUseElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGUseElementPrototype::create(exec->vm(), globalObject, JSSVGUseElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGUseElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGUseElement* thisObject = jsCast<JSSVGUseElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGUseElement, Base>(exec, &JSSVGUseElementTable, thisObject, propertyName, slot);
}

bool JSSVGUseElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGUseElement* thisObject = jsCast<JSSVGUseElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGUseElement, Base>(exec, &JSSVGUseElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGUseElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGUseElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGUseElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGUseElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGUseElementInstanceRoot(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->instanceRoot()));
    return result;
}


JSValue jsSVGUseElementAnimatedInstanceRoot(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->animatedInstanceRoot()));
    return result;
}


JSValue jsSVGUseElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGUseElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGUseElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGUseElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGUseElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGUseElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGUseElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGUseElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGUseElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGUseElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGUseElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGUseElement* domObject = jsCast<JSSVGUseElement*>(asObject(slotBase));
    return JSSVGUseElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGUseElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGUseElement* thisObject = jsCast<JSSVGUseElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGUseElement, Base>(exec, propertyName, value, &JSSVGUseElementTable, thisObject, slot);
}

void setJSSVGUseElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(thisObject);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmllang(nativeValue);
}


void setJSSVGUseElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(thisObject);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmlspace(nativeValue);
}


JSValue JSSVGUseElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGUseElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGUseElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGUseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGUseElement::s_info);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGUseElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGUseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGUseElement::s_info);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGUseElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGUseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGUseElement::s_info);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGUseElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGUseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGUseElement::s_info);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGUseElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGUseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGUseElement* castedThis = jsCast<JSSVGUseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGUseElement::s_info);
    SVGUseElement* impl = static_cast<SVGUseElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
