/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGURIReference.h"

#include "JSSVGAnimatedString.h"
#include "SVGURIReference.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGURIReferenceTableValues[] =
{
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGURIReferenceHref), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGURIReferenceTable = { 2, 1, JSSVGURIReferenceTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSVGURIReferencePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGURIReferencePrototypeTable = { 1, 0, JSSVGURIReferencePrototypeTableValues, 0 };
const ClassInfo JSSVGURIReferencePrototype::s_info = { "SVGURIReferencePrototype", &Base::s_info, &JSSVGURIReferencePrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGURIReferencePrototype) };

JSObject* JSSVGURIReferencePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGURIReference>(exec, globalObject);
}

const ClassInfo JSSVGURIReference::s_info = { "SVGURIReference", &Base::s_info, &JSSVGURIReferenceTable, 0 , CREATE_METHOD_TABLE(JSSVGURIReference) };

JSSVGURIReference::JSSVGURIReference(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGURIReference> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGURIReference::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGURIReference::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGURIReferencePrototype::create(exec->vm(), globalObject, JSSVGURIReferencePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGURIReference::destroy(JSC::JSCell* cell)
{
    JSSVGURIReference* thisObject = static_cast<JSSVGURIReference*>(cell);
    thisObject->JSSVGURIReference::~JSSVGURIReference();
}

JSSVGURIReference::~JSSVGURIReference()
{
    releaseImplIfNotNull();
}

bool JSSVGURIReference::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGURIReference* thisObject = jsCast<JSSVGURIReference*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGURIReference, Base>(exec, &JSSVGURIReferenceTable, thisObject, propertyName, slot);
}

bool JSSVGURIReference::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGURIReference* thisObject = jsCast<JSSVGURIReference*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGURIReference, Base>(exec, &JSSVGURIReferenceTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGURIReferenceHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGURIReference* castedThis = jsCast<JSSVGURIReference*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGURIReference* impl = static_cast<SVGURIReference*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


static inline bool isObservable(JSSVGURIReference* jsSVGURIReference)
{
    if (jsSVGURIReference->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGURIReferenceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGURIReference* jsSVGURIReference = jsCast<JSSVGURIReference*>(handle.get().asCell());
    if (!isObservable(jsSVGURIReference))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGURIReferenceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGURIReference* jsSVGURIReference = jsCast<JSSVGURIReference*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGURIReference->impl(), jsSVGURIReference);
    jsSVGURIReference->releaseImpl();
}

SVGURIReference* toSVGURIReference(JSC::JSValue value)
{
    return value.inherits(&JSSVGURIReference::s_info) ? jsCast<JSSVGURIReference*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
