/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTransformable.h"

#include "JSSVGAnimatedTransformList.h"
#include "SVGTransformable.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGTransformableTableValues[] =
{
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformableTransform), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTransformableTable = { 2, 1, JSSVGTransformableTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSVGTransformablePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTransformablePrototypeTable = { 1, 0, JSSVGTransformablePrototypeTableValues, 0 };
const ClassInfo JSSVGTransformablePrototype::s_info = { "SVGTransformablePrototype", &Base::s_info, &JSSVGTransformablePrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGTransformablePrototype) };

JSObject* JSSVGTransformablePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTransformable>(exec, globalObject);
}

const ClassInfo JSSVGTransformable::s_info = { "SVGTransformable", &Base::s_info, &JSSVGTransformableTable, 0 , CREATE_METHOD_TABLE(JSSVGTransformable) };

JSSVGTransformable::JSSVGTransformable(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTransformable> impl)
    : JSSVGLocatable(structure, globalObject, impl)
{
}

void JSSVGTransformable::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTransformable::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTransformablePrototype::create(exec->vm(), globalObject, JSSVGTransformablePrototype::createStructure(exec->vm(), globalObject, JSSVGLocatablePrototype::self(exec, globalObject)));
}

bool JSSVGTransformable::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTransformable* thisObject = jsCast<JSSVGTransformable*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGTransformable, Base>(exec, &JSSVGTransformableTable, thisObject, propertyName, slot);
}

bool JSSVGTransformable::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTransformable* thisObject = jsCast<JSSVGTransformable*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGTransformable, Base>(exec, &JSSVGTransformableTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGTransformableTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTransformable* castedThis = jsCast<JSSVGTransformable*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTransformable* impl = static_cast<SVGTransformable*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}



}

#endif // ENABLE(SVG)
