/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTextContentElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include "SVGTextContentElement.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGTextContentElementTableValues[] =
{
    { "textLength", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementTextLength), (intptr_t)0, NoIntrinsic },
    { "lengthAdjust", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementLengthAdjust), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementXmllang), (intptr_t)setJSSVGTextContentElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementXmlspace), (intptr_t)setJSSVGTextContentElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextContentElementTable = { 34, 31, JSSVGTextContentElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGTextContentElementConstructorTableValues[] =
{
    { "LENGTHADJUST_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementLENGTHADJUST_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "LENGTHADJUST_SPACING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementLENGTHADJUST_SPACING), (intptr_t)0, NoIntrinsic },
    { "LENGTHADJUST_SPACINGANDGLYPHS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementLENGTHADJUST_SPACINGANDGLYPHS), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextContentElementConstructorTable = { 8, 7, JSSVGTextContentElementConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGTextContentElement::LENGTHADJUST_UNKNOWN, SVGTextContentElementEnumLENGTHADJUST_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGTextContentElement::LENGTHADJUST_SPACING, SVGTextContentElementEnumLENGTHADJUST_SPACINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGTextContentElement::LENGTHADJUST_SPACINGANDGLYPHS, SVGTextContentElementEnumLENGTHADJUST_SPACINGANDGLYPHSIsWrongUseDoNotCheckConstants);

const ClassInfo JSSVGTextContentElementConstructor::s_info = { "SVGTextContentElementConstructor", &Base::s_info, &JSSVGTextContentElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGTextContentElementConstructor) };

JSSVGTextContentElementConstructor::JSSVGTextContentElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGTextContentElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGTextContentElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGTextContentElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextContentElementConstructor, JSDOMWrapper>(exec, &JSSVGTextContentElementConstructorTable, jsCast<JSSVGTextContentElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGTextContentElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTextContentElementConstructor, JSDOMWrapper>(exec, &JSSVGTextContentElementConstructorTable, jsCast<JSSVGTextContentElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTextContentElementPrototypeTableValues[] =
{
    { "LENGTHADJUST_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementLENGTHADJUST_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "LENGTHADJUST_SPACING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementLENGTHADJUST_SPACING), (intptr_t)0, NoIntrinsic },
    { "LENGTHADJUST_SPACINGANDGLYPHS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextContentElementLENGTHADJUST_SPACINGANDGLYPHS), (intptr_t)0, NoIntrinsic },
    { "getNumberOfChars", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextContentElementPrototypeFunctionGetNumberOfChars), (intptr_t)0, NoIntrinsic },
    { "getComputedTextLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextContentElementPrototypeFunctionGetComputedTextLength), (intptr_t)0, NoIntrinsic },
    { "getSubStringLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextContentElementPrototypeFunctionGetSubStringLength), (intptr_t)0, NoIntrinsic },
    { "getStartPositionOfChar", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextContentElementPrototypeFunctionGetStartPositionOfChar), (intptr_t)0, NoIntrinsic },
    { "getEndPositionOfChar", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextContentElementPrototypeFunctionGetEndPositionOfChar), (intptr_t)0, NoIntrinsic },
    { "getExtentOfChar", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextContentElementPrototypeFunctionGetExtentOfChar), (intptr_t)0, NoIntrinsic },
    { "getRotationOfChar", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextContentElementPrototypeFunctionGetRotationOfChar), (intptr_t)0, NoIntrinsic },
    { "getCharNumAtPosition", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextContentElementPrototypeFunctionGetCharNumAtPosition), (intptr_t)0, NoIntrinsic },
    { "selectSubString", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextContentElementPrototypeFunctionSelectSubString), (intptr_t)0, NoIntrinsic },
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextContentElementPrototypeFunctionHasExtension), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextContentElementPrototypeTable = { 34, 31, JSSVGTextContentElementPrototypeTableValues, 0 };
const ClassInfo JSSVGTextContentElementPrototype::s_info = { "SVGTextContentElementPrototype", &Base::s_info, &JSSVGTextContentElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGTextContentElementPrototype) };

JSObject* JSSVGTextContentElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTextContentElement>(exec, globalObject);
}

bool JSSVGTextContentElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTextContentElementPrototype* thisObject = jsCast<JSSVGTextContentElementPrototype*>(cell);
    return getStaticPropertySlot<JSSVGTextContentElementPrototype, JSObject>(exec, &JSSVGTextContentElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGTextContentElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTextContentElementPrototype* thisObject = jsCast<JSSVGTextContentElementPrototype*>(object);
    return getStaticPropertyDescriptor<JSSVGTextContentElementPrototype, JSObject>(exec, &JSSVGTextContentElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGTextContentElement::s_info = { "SVGTextContentElement", &Base::s_info, &JSSVGTextContentElementTable, 0 , CREATE_METHOD_TABLE(JSSVGTextContentElement) };

JSSVGTextContentElement::JSSVGTextContentElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTextContentElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGTextContentElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTextContentElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTextContentElementPrototype::create(exec->vm(), globalObject, JSSVGTextContentElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGTextContentElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTextContentElement* thisObject = jsCast<JSSVGTextContentElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGTextContentElement, Base>(exec, &JSSVGTextContentElementTable, thisObject, propertyName, slot);
}

bool JSSVGTextContentElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTextContentElement* thisObject = jsCast<JSSVGTextContentElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGTextContentElement, Base>(exec, &JSSVGTextContentElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGTextContentElementTextLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->textLengthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextContentElementLengthAdjust(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->lengthAdjustAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextContentElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGTextContentElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGTextContentElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGTextContentElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGTextContentElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGTextContentElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextContentElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextContentElement* domObject = jsCast<JSSVGTextContentElement*>(asObject(slotBase));
    return JSSVGTextContentElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGTextContentElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGTextContentElement* thisObject = jsCast<JSSVGTextContentElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGTextContentElement, Base>(exec, propertyName, value, &JSSVGTextContentElementTable, thisObject, slot);
}

void setJSSVGTextContentElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(thisObject);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmllang(nativeValue);
}


void setJSSVGTextContentElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(thisObject);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmlspace(nativeValue);
}


JSValue JSSVGTextContentElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTextContentElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGTextContentElementPrototypeFunctionGetNumberOfChars(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextContentElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextContentElement::s_info);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->getNumberOfChars());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextContentElementPrototypeFunctionGetComputedTextLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextContentElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextContentElement::s_info);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->getComputedTextLength());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextContentElementPrototypeFunctionGetSubStringLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextContentElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextContentElement::s_info);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(toUInt32(exec, exec->argument(1), NormalConversion));
    if (length < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->getSubStringLength(offset, length, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextContentElementPrototypeFunctionGetStartPositionOfChar(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextContentElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextContentElement::s_info);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(impl->getStartPositionOfChar(offset, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextContentElementPrototypeFunctionGetEndPositionOfChar(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextContentElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextContentElement::s_info);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(impl->getEndPositionOfChar(offset, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextContentElementPrototypeFunctionGetExtentOfChar(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextContentElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextContentElement::s_info);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getExtentOfChar(offset, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextContentElementPrototypeFunctionGetRotationOfChar(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextContentElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextContentElement::s_info);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->getRotationOfChar(offset, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextContentElementPrototypeFunctionGetCharNumAtPosition(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextContentElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextContentElement::s_info);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    SVGPropertyTearOff<FloatPoint>* point(toSVGPoint(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!point) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }

    JSC::JSValue result = jsNumber(impl->getCharNumAtPosition(point->propertyReference()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextContentElementPrototypeFunctionSelectSubString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextContentElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextContentElement::s_info);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(toUInt32(exec, exec->argument(1), NormalConversion));
    if (length < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->selectSubString(offset, length, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTextContentElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextContentElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextContentElement* castedThis = jsCast<JSSVGTextContentElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextContentElement::s_info);
    SVGTextContentElement* impl = static_cast<SVGTextContentElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

// Constant getters

JSValue jsSVGTextContentElementLENGTHADJUST_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGTextContentElementLENGTHADJUST_SPACING(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGTextContentElementLENGTHADJUST_SPACINGANDGLYPHS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}


}

#endif // ENABLE(SVG)
