/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTests.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGStringList.h"
#include "SVGStringList.h"
#include "SVGTests.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGTestsTableValues[] =
{
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTestsRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTestsRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTestsSystemLanguage), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTestsTable = { 8, 7, JSSVGTestsTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSVGTestsPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTestsPrototypeFunctionHasExtension), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTestsPrototypeTable = { 2, 1, JSSVGTestsPrototypeTableValues, 0 };
const ClassInfo JSSVGTestsPrototype::s_info = { "SVGTestsPrototype", &Base::s_info, &JSSVGTestsPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGTestsPrototype) };

JSObject* JSSVGTestsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTests>(exec, globalObject);
}

bool JSSVGTestsPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTestsPrototype* thisObject = jsCast<JSSVGTestsPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGTestsPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGTestsPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTestsPrototype* thisObject = jsCast<JSSVGTestsPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGTestsPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGTests::s_info = { "SVGTests", &Base::s_info, &JSSVGTestsTable, 0 , CREATE_METHOD_TABLE(JSSVGTests) };

JSSVGTests::JSSVGTests(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTests> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGTests::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTests::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTestsPrototype::create(exec->vm(), globalObject, JSSVGTestsPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGTests::destroy(JSC::JSCell* cell)
{
    JSSVGTests* thisObject = static_cast<JSSVGTests*>(cell);
    thisObject->JSSVGTests::~JSSVGTests();
}

JSSVGTests::~JSSVGTests()
{
    releaseImplIfNotNull();
}

bool JSSVGTests::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTests* thisObject = jsCast<JSSVGTests*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGTests, Base>(exec, &JSSVGTestsTable, thisObject, propertyName, slot);
}

bool JSSVGTests::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTests* thisObject = jsCast<JSSVGTests*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGTests, Base>(exec, &JSSVGTestsTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGTestsRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTests* castedThis = jsCast<JSSVGTests*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTests* impl = static_cast<SVGTests*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGTestsRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTests* castedThis = jsCast<JSSVGTests*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTests* impl = static_cast<SVGTests*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGTestsSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTests* castedThis = jsCast<JSSVGTests*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTests* impl = static_cast<SVGTests*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


EncodedJSValue JSC_HOST_CALL jsSVGTestsPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTests::s_info))
        return throwVMTypeError(exec);
    JSSVGTests* castedThis = jsCast<JSSVGTests*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTests::s_info);
    SVGTests* impl = static_cast<SVGTests*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

static inline bool isObservable(JSSVGTests* jsSVGTests)
{
    if (jsSVGTests->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGTestsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGTests* jsSVGTests = jsCast<JSSVGTests*>(handle.get().asCell());
    if (!isObservable(jsSVGTests))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGTestsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGTests* jsSVGTests = jsCast<JSSVGTests*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGTests->impl(), jsSVGTests);
    jsSVGTests->releaseImpl();
}

SVGTests* toSVGTests(JSC::JSValue value)
{
    return value.inherits(&JSSVGTests::s_info) ? jsCast<JSSVGTests*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
