/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGSwitchElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include "SVGSwitchElement.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGSwitchElementTableValues[] =
{
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementXmllang), (intptr_t)setJSSVGSwitchElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementXmlspace), (intptr_t)setJSSVGSwitchElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSwitchElementTable = { 34, 31, JSSVGSwitchElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGSwitchElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSwitchElementConstructorTable = { 1, 0, JSSVGSwitchElementConstructorTableValues, 0 };
const ClassInfo JSSVGSwitchElementConstructor::s_info = { "SVGSwitchElementConstructor", &Base::s_info, &JSSVGSwitchElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGSwitchElementConstructor) };

JSSVGSwitchElementConstructor::JSSVGSwitchElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGSwitchElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGSwitchElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGSwitchElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSwitchElementConstructor, JSDOMWrapper>(exec, &JSSVGSwitchElementConstructorTable, jsCast<JSSVGSwitchElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGSwitchElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGSwitchElementConstructor, JSDOMWrapper>(exec, &JSSVGSwitchElementConstructorTable, jsCast<JSSVGSwitchElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGSwitchElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionHasExtension), (intptr_t)0, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSwitchElementPrototypeFunctionGetTransformToElement), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSwitchElementPrototypeTable = { 17, 15, JSSVGSwitchElementPrototypeTableValues, 0 };
const ClassInfo JSSVGSwitchElementPrototype::s_info = { "SVGSwitchElementPrototype", &Base::s_info, &JSSVGSwitchElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGSwitchElementPrototype) };

JSObject* JSSVGSwitchElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGSwitchElement>(exec, globalObject);
}

bool JSSVGSwitchElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGSwitchElementPrototype* thisObject = jsCast<JSSVGSwitchElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGSwitchElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGSwitchElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGSwitchElementPrototype* thisObject = jsCast<JSSVGSwitchElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGSwitchElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGSwitchElement::s_info = { "SVGSwitchElement", &Base::s_info, &JSSVGSwitchElementTable, 0 , CREATE_METHOD_TABLE(JSSVGSwitchElement) };

JSSVGSwitchElement::JSSVGSwitchElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGSwitchElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGSwitchElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGSwitchElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGSwitchElementPrototype::create(exec->vm(), globalObject, JSSVGSwitchElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGSwitchElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGSwitchElement* thisObject = jsCast<JSSVGSwitchElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGSwitchElement, Base>(exec, &JSSVGSwitchElementTable, thisObject, propertyName, slot);
}

bool JSSVGSwitchElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGSwitchElement* thisObject = jsCast<JSSVGSwitchElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGSwitchElement, Base>(exec, &JSSVGSwitchElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGSwitchElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGSwitchElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGSwitchElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGSwitchElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGSwitchElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGSwitchElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSwitchElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSwitchElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGSwitchElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGSwitchElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* domObject = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    return JSSVGSwitchElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGSwitchElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGSwitchElement* thisObject = jsCast<JSSVGSwitchElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGSwitchElement, Base>(exec, propertyName, value, &JSSVGSwitchElementTable, thisObject, slot);
}

void setJSSVGSwitchElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(thisObject);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmllang(nativeValue);
}


void setJSSVGSwitchElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(thisObject);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmlspace(nativeValue);
}


JSValue JSSVGSwitchElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGSwitchElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSwitchElement::s_info);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSwitchElement::s_info);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSwitchElement::s_info);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSwitchElement::s_info);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSwitchElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSwitchElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSwitchElement::s_info);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
