/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGStyledElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedString.h"
#include "SVGStyledElement.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGStyledElementTableValues[] =
{
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStyledElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStyledElementStyle), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGStyledElementTable = { 4, 3, JSSVGStyledElementTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSVGStyledElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGStyledElementPrototypeFunctionGetPresentationAttribute), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGStyledElementPrototypeTable = { 2, 1, JSSVGStyledElementPrototypeTableValues, 0 };
const ClassInfo JSSVGStyledElementPrototype::s_info = { "SVGStyledElementPrototype", &Base::s_info, &JSSVGStyledElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGStyledElementPrototype) };

JSObject* JSSVGStyledElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGStyledElement>(exec, globalObject);
}

bool JSSVGStyledElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGStyledElementPrototype* thisObject = jsCast<JSSVGStyledElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGStyledElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGStyledElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGStyledElementPrototype* thisObject = jsCast<JSSVGStyledElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGStyledElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGStyledElement::s_info = { "SVGStyledElement", &Base::s_info, &JSSVGStyledElementTable, 0 , CREATE_METHOD_TABLE(JSSVGStyledElement) };

JSSVGStyledElement::JSSVGStyledElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGStyledElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGStyledElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGStyledElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGStyledElementPrototype::create(exec->vm(), globalObject, JSSVGStyledElementPrototype::createStructure(exec->vm(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGStyledElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGStyledElement* thisObject = jsCast<JSSVGStyledElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGStyledElement, Base>(exec, &JSSVGStyledElementTable, thisObject, propertyName, slot);
}

bool JSSVGStyledElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGStyledElement* thisObject = jsCast<JSSVGStyledElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGStyledElement, Base>(exec, &JSSVGStyledElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGStyledElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGStyledElement* castedThis = jsCast<JSSVGStyledElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGStyledElement* impl = static_cast<SVGStyledElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGStyledElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGStyledElement* castedThis = jsCast<JSSVGStyledElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGStyledElement* impl = static_cast<SVGStyledElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


EncodedJSValue JSC_HOST_CALL jsSVGStyledElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGStyledElement::s_info))
        return throwVMTypeError(exec);
    JSSVGStyledElement* castedThis = jsCast<JSSVGStyledElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGStyledElement::s_info);
    SVGStyledElement* impl = static_cast<SVGStyledElement*>(castedThis->impl());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
