/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGSVGElement.h"

#include "Element.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSElement.h"
#include "JSNodeList.h"
#include "JSSVGAngle.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGLength.h"
#include "JSSVGMatrix.h"
#include "JSSVGNumber.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "JSSVGTransform.h"
#include "JSSVGViewSpec.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "SVGAngle.h"
#include "SVGElement.h"
#include "SVGLength.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGSVGElement.h"
#include "SVGStaticPropertyTearOff.h"
#include "SVGStringList.h"
#include "SVGTransform.h"
#include "SVGViewSpec.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGSVGElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementHeight), (intptr_t)0, NoIntrinsic },
    { "contentScriptType", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementContentScriptType), (intptr_t)setJSSVGSVGElementContentScriptType, NoIntrinsic },
    { "contentStyleType", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementContentStyleType), (intptr_t)setJSSVGSVGElementContentStyleType, NoIntrinsic },
    { "viewport", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementViewport), (intptr_t)0, NoIntrinsic },
    { "pixelUnitToMillimeterX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementPixelUnitToMillimeterX), (intptr_t)0, NoIntrinsic },
    { "pixelUnitToMillimeterY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementPixelUnitToMillimeterY), (intptr_t)0, NoIntrinsic },
    { "screenPixelToMillimeterX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementScreenPixelToMillimeterX), (intptr_t)0, NoIntrinsic },
    { "screenPixelToMillimeterY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementScreenPixelToMillimeterY), (intptr_t)0, NoIntrinsic },
    { "useCurrentView", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementUseCurrentView), (intptr_t)0, NoIntrinsic },
    { "currentView", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementCurrentView), (intptr_t)0, NoIntrinsic },
    { "currentScale", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementCurrentScale), (intptr_t)setJSSVGSVGElementCurrentScale, NoIntrinsic },
    { "currentTranslate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementCurrentTranslate), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementXmllang), (intptr_t)setJSSVGSVGElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementXmlspace), (intptr_t)setJSSVGSVGElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "viewBox", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementViewBox), (intptr_t)0, NoIntrinsic },
    { "preserveAspectRatio", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementPreserveAspectRatio), (intptr_t)0, NoIntrinsic },
    { "zoomAndPan", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementZoomAndPan), (intptr_t)setJSSVGSVGElementZoomAndPan, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSVGElementTable = { 69, 63, JSSVGSVGElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGSVGElementConstructorTableValues[] =
{
    { "SVG_ZOOMANDPAN_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_ZOOMANDPAN_DISABLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_DISABLE), (intptr_t)0, NoIntrinsic },
    { "SVG_ZOOMANDPAN_MAGNIFY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_MAGNIFY), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSVGElementConstructorTable = { 9, 7, JSSVGSVGElementConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGSVGElement::SVG_ZOOMANDPAN_UNKNOWN, SVGSVGElementEnumSVG_ZOOMANDPAN_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGSVGElement::SVG_ZOOMANDPAN_DISABLE, SVGSVGElementEnumSVG_ZOOMANDPAN_DISABLEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGSVGElement::SVG_ZOOMANDPAN_MAGNIFY, SVGSVGElementEnumSVG_ZOOMANDPAN_MAGNIFYIsWrongUseDoNotCheckConstants);

const ClassInfo JSSVGSVGElementConstructor::s_info = { "SVGSVGElementConstructor", &Base::s_info, &JSSVGSVGElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGSVGElementConstructor) };

JSSVGSVGElementConstructor::JSSVGSVGElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGSVGElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGSVGElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGSVGElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSVGElementConstructor, JSDOMWrapper>(exec, &JSSVGSVGElementConstructorTable, jsCast<JSSVGSVGElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGSVGElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGSVGElementConstructor, JSDOMWrapper>(exec, &JSSVGSVGElementConstructorTable, jsCast<JSSVGSVGElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGSVGElementPrototypeTableValues[] =
{
    { "SVG_ZOOMANDPAN_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_ZOOMANDPAN_DISABLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_DISABLE), (intptr_t)0, NoIntrinsic },
    { "SVG_ZOOMANDPAN_MAGNIFY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_MAGNIFY), (intptr_t)0, NoIntrinsic },
    { "suspendRedraw", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionSuspendRedraw), (intptr_t)0, NoIntrinsic },
    { "unsuspendRedraw", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionUnsuspendRedraw), (intptr_t)0, NoIntrinsic },
    { "unsuspendRedrawAll", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionUnsuspendRedrawAll), (intptr_t)0, NoIntrinsic },
    { "forceRedraw", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionForceRedraw), (intptr_t)0, NoIntrinsic },
    { "pauseAnimations", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionPauseAnimations), (intptr_t)0, NoIntrinsic },
    { "unpauseAnimations", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionUnpauseAnimations), (intptr_t)0, NoIntrinsic },
    { "animationsPaused", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionAnimationsPaused), (intptr_t)0, NoIntrinsic },
    { "getCurrentTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetCurrentTime), (intptr_t)0, NoIntrinsic },
    { "setCurrentTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionSetCurrentTime), (intptr_t)0, NoIntrinsic },
    { "getIntersectionList", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetIntersectionList), (intptr_t)0, NoIntrinsic },
    { "getEnclosureList", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetEnclosureList), (intptr_t)0, NoIntrinsic },
    { "checkIntersection", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCheckIntersection), (intptr_t)0, NoIntrinsic },
    { "checkEnclosure", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCheckEnclosure), (intptr_t)0, NoIntrinsic },
    { "deselectAll", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionDeselectAll), (intptr_t)0, NoIntrinsic },
    { "createSVGNumber", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGNumber), (intptr_t)0, NoIntrinsic },
    { "createSVGLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGLength), (intptr_t)0, NoIntrinsic },
    { "createSVGAngle", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGAngle), (intptr_t)0, NoIntrinsic },
    { "createSVGPoint", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGPoint), (intptr_t)0, NoIntrinsic },
    { "createSVGMatrix", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGMatrix), (intptr_t)0, NoIntrinsic },
    { "createSVGRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGRect), (intptr_t)0, NoIntrinsic },
    { "createSVGTransform", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGTransform), (intptr_t)0, NoIntrinsic },
    { "createSVGTransformFromMatrix", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGTransformFromMatrix), (intptr_t)0, NoIntrinsic },
    { "getElementById", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetElementById), (intptr_t)0, NoIntrinsic },
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionHasExtension), (intptr_t)0, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetTransformToElement), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSVGElementPrototypeTable = { 71, 63, JSSVGSVGElementPrototypeTableValues, 0 };
const ClassInfo JSSVGSVGElementPrototype::s_info = { "SVGSVGElementPrototype", &Base::s_info, &JSSVGSVGElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGSVGElementPrototype) };

JSObject* JSSVGSVGElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGSVGElement>(exec, globalObject);
}

bool JSSVGSVGElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGSVGElementPrototype* thisObject = jsCast<JSSVGSVGElementPrototype*>(cell);
    return getStaticPropertySlot<JSSVGSVGElementPrototype, JSObject>(exec, &JSSVGSVGElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGSVGElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGSVGElementPrototype* thisObject = jsCast<JSSVGSVGElementPrototype*>(object);
    return getStaticPropertyDescriptor<JSSVGSVGElementPrototype, JSObject>(exec, &JSSVGSVGElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGSVGElement::s_info = { "SVGSVGElement", &Base::s_info, &JSSVGSVGElementTable, 0 , CREATE_METHOD_TABLE(JSSVGSVGElement) };

JSSVGSVGElement::JSSVGSVGElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGSVGElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGSVGElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGSVGElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGSVGElementPrototype::create(exec->vm(), globalObject, JSSVGSVGElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGSVGElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGSVGElement* thisObject = jsCast<JSSVGSVGElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGSVGElement, Base>(exec, &JSSVGSVGElementTable, thisObject, propertyName, slot);
}

bool JSSVGSVGElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGSVGElement* thisObject = jsCast<JSSVGSVGElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGSVGElement, Base>(exec, &JSSVGSVGElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGSVGElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementContentScriptType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->contentScriptType());
    return result;
}


JSValue jsSVGSVGElementContentStyleType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->contentStyleType());
    return result;
}


JSValue jsSVGSVGElementViewport(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->viewport())));
    return result;
}


JSValue jsSVGSVGElementPixelUnitToMillimeterX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->pixelUnitToMillimeterX());
    return result;
}


JSValue jsSVGSVGElementPixelUnitToMillimeterY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->pixelUnitToMillimeterY());
    return result;
}


JSValue jsSVGSVGElementScreenPixelToMillimeterX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->screenPixelToMillimeterX());
    return result;
}


JSValue jsSVGSVGElementScreenPixelToMillimeterY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->screenPixelToMillimeterY());
    return result;
}


JSValue jsSVGSVGElementUseCurrentView(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->useCurrentView());
    return result;
}


JSValue jsSVGSVGElementCurrentView(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->currentView()));
    return result;
}


JSValue jsSVGSVGElementCurrentScale(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->currentScale());
    return result;
}


JSValue jsSVGSVGElementCurrentTranslate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticPropertyTearOff<SVGSVGElement, FloatPoint>::create(impl, impl->currentTranslate(), &SVGSVGElement::updateCurrentTranslate)));
    return result;
}


JSValue jsSVGSVGElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGSVGElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGSVGElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGSVGElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGSVGElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGSVGElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGSVGElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGSVGElementViewBox(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedRect> obj = impl->viewBoxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementPreserveAspectRatio(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = impl->preserveAspectRatioAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementZoomAndPan(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->zoomAndPan());
    return result;
}


JSValue jsSVGSVGElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* domObject = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    return JSSVGSVGElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGSVGElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGSVGElement* thisObject = jsCast<JSSVGSVGElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGSVGElement, Base>(exec, propertyName, value, &JSSVGSVGElementTable, thisObject, slot);
}

void setJSSVGSVGElementContentScriptType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(thisObject);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setContentScriptType(nativeValue);
}


void setJSSVGSVGElementContentStyleType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(thisObject);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setContentStyleType(nativeValue);
}


void setJSSVGSVGElementCurrentScale(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(thisObject);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setCurrentScale(nativeValue);
}


void setJSSVGSVGElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(thisObject);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmllang(nativeValue);
}


void setJSSVGSVGElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(thisObject);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setXmlspace(nativeValue);
}


void setJSSVGSVGElementZoomAndPan(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(thisObject);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    unsigned short nativeValue(toUInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setZoomAndPan(nativeValue);
}


JSValue JSSVGSVGElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGSVGElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionSuspendRedraw(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    unsigned maxWaitMilliseconds(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->suspendRedraw(maxWaitMilliseconds));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionUnsuspendRedraw(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    unsigned suspendHandleId(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->unsuspendRedraw(suspendHandleId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionUnsuspendRedrawAll(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    impl->unsuspendRedrawAll();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionForceRedraw(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    impl->forceRedraw();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionPauseAnimations(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    impl->pauseAnimations();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionUnpauseAnimations(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    impl->unpauseAnimations();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionAnimationsPaused(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->animationsPaused());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetCurrentTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->getCurrentTime());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionSetCurrentTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    float seconds(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCurrentTime(seconds);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetIntersectionList(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    SVGPropertyTearOff<FloatRect>* rect(toSVGRect(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!rect) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGElement* referenceElement(toSVGElement(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getIntersectionList(rect->propertyReference(), referenceElement)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetEnclosureList(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    SVGPropertyTearOff<FloatRect>* rect(toSVGRect(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!rect) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGElement* referenceElement(toSVGElement(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getEnclosureList(rect->propertyReference(), referenceElement)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCheckIntersection(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    SVGPropertyTearOff<FloatRect>* rect(toSVGRect(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!rect) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }

    JSC::JSValue result = jsBoolean(impl->checkIntersection(element, rect->propertyReference()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCheckEnclosure(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    SVGPropertyTearOff<FloatRect>* rect(toSVGRect(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!rect) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }

    JSC::JSValue result = jsBoolean(impl->checkEnclosure(element, rect->propertyReference()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionDeselectAll(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    impl->deselectAll();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGNumber(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<float>::create(impl->createSVGNumber())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGLength>::create(impl->createSVGLength())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGAngle(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGAngle>::create(impl->createSVGAngle())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGPoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(impl->createSVGPoint())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGMatrix(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->createSVGMatrix())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->createSVGRect())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGTransform(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGTransform>::create(impl->createSVGTransform())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGTransformFromMatrix(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    SVGPropertyTearOff<SVGMatrix>* matrix(toSVGMatrix(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!matrix) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGTransform>::create(impl->createSVGTransformFromMatrix(matrix->propertyReference()))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetElementById(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    const String& elementId(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementById(elementId)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

// Constant getters

JSValue jsSVGSVGElementSVG_ZOOMANDPAN_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGSVGElementSVG_ZOOMANDPAN_DISABLE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGSVGElementSVG_ZOOMANDPAN_MAGNIFY(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}


}

#endif // ENABLE(SVG)
