/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPoint.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGMatrix.h"
#include "JSSVGPoint.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPointTableValues[] =
{
    { "x", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPointX), (intptr_t)setJSSVGPointX, NoIntrinsic },
    { "y", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPointY), (intptr_t)setJSSVGPointY, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPointConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPointTable = { 9, 7, JSSVGPointTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPointConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPointConstructorTable = { 1, 0, JSSVGPointConstructorTableValues, 0 };
const ClassInfo JSSVGPointConstructor::s_info = { "SVGPointConstructor", &Base::s_info, &JSSVGPointConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPointConstructor) };

JSSVGPointConstructor::JSSVGPointConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPointConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGPointPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGPointConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPointConstructor, JSDOMWrapper>(exec, &JSSVGPointConstructorTable, jsCast<JSSVGPointConstructor*>(cell), propertyName, slot);
}

bool JSSVGPointConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPointConstructor, JSDOMWrapper>(exec, &JSSVGPointConstructorTable, jsCast<JSSVGPointConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPointPrototypeTableValues[] =
{
    { "matrixTransform", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPointPrototypeFunctionMatrixTransform), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPointPrototypeTable = { 2, 1, JSSVGPointPrototypeTableValues, 0 };
const ClassInfo JSSVGPointPrototype::s_info = { "SVGPointPrototype", &Base::s_info, &JSSVGPointPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPointPrototype) };

JSObject* JSSVGPointPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPoint>(exec, globalObject);
}

bool JSSVGPointPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPointPrototype* thisObject = jsCast<JSSVGPointPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPointPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGPointPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPointPrototype* thisObject = jsCast<JSSVGPointPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPointPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGPoint::s_info = { "SVGPoint", &Base::s_info, &JSSVGPointTable, 0 , CREATE_METHOD_TABLE(JSSVGPoint) };

JSSVGPoint::JSSVGPoint(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPropertyTearOff<FloatPoint> > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGPoint::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPoint::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPointPrototype::create(exec->vm(), globalObject, JSSVGPointPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGPoint::destroy(JSC::JSCell* cell)
{
    JSSVGPoint* thisObject = static_cast<JSSVGPoint*>(cell);
    thisObject->JSSVGPoint::~JSSVGPoint();
}

JSSVGPoint::~JSSVGPoint()
{
    releaseImplIfNotNull();
}

bool JSSVGPoint::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPoint* thisObject = jsCast<JSSVGPoint*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPoint, Base>(exec, &JSSVGPointTable, thisObject, propertyName, slot);
}

bool JSSVGPoint::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPoint* thisObject = jsCast<JSSVGPoint*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPoint, Base>(exec, &JSSVGPointTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPointX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPoint* castedThis = jsCast<JSSVGPoint*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FloatPoint& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.x());
    return result;
}


JSValue jsSVGPointY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPoint* castedThis = jsCast<JSSVGPoint*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FloatPoint& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.y());
    return result;
}


JSValue jsSVGPointConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPoint* domObject = jsCast<JSSVGPoint*>(asObject(slotBase));
    return JSSVGPoint::getConstructor(exec, domObject->globalObject());
}

void JSSVGPoint::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGPoint* thisObject = jsCast<JSSVGPoint*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGPoint, Base>(exec, propertyName, value, &JSSVGPointTable, thisObject, slot);
}

void setJSSVGPointX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPoint* castedThis = jsCast<JSSVGPoint*>(thisObject);
    SVGPropertyTearOff<FloatPoint> * impl = static_cast<SVGPropertyTearOff<FloatPoint> *>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    FloatPoint& podImpl = impl->propertyReference();
    podImpl.setX(nativeValue);
    impl->commitChange();
}


void setJSSVGPointY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPoint* castedThis = jsCast<JSSVGPoint*>(thisObject);
    SVGPropertyTearOff<FloatPoint> * impl = static_cast<SVGPropertyTearOff<FloatPoint> *>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    FloatPoint& podImpl = impl->propertyReference();
    podImpl.setY(nativeValue);
    impl->commitChange();
}


JSValue JSSVGPoint::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPointConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGPointPrototypeFunctionMatrixTransform(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPoint::s_info))
        return throwVMTypeError(exec);
    JSSVGPoint* castedThis = jsCast<JSSVGPoint*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPoint::s_info);
    SVGPropertyTearOff<FloatPoint> * impl = static_cast<SVGPropertyTearOff<FloatPoint> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    FloatPoint& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGMatrix>* matrix(toSVGMatrix(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!matrix) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(podImpl.matrixTransform(matrix->propertyReference()))));
    return JSValue::encode(result);
}

static inline bool isObservable(JSSVGPoint* jsSVGPoint)
{
    if (jsSVGPoint->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGPointOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGPoint* jsSVGPoint = jsCast<JSSVGPoint*>(handle.get().asCell());
    if (!isObservable(jsSVGPoint))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGPointOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGPoint* jsSVGPoint = jsCast<JSSVGPoint*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGPoint->impl(), jsSVGPoint);
    jsSVGPoint->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<FloatPoint> * impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGPoint, SVGPropertyTearOff<FloatPoint> >(exec, impl))
        return result;
    ReportMemoryCost<SVGPropertyTearOff<FloatPoint> >::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGPoint, SVGPropertyTearOff<FloatPoint> >(exec, globalObject, impl);
}

SVGPropertyTearOff<FloatPoint> * toSVGPoint(JSC::JSValue value)
{
    return value.inherits(&JSSVGPoint::s_info) ? jsCast<JSSVGPoint*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
