/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPathSegLinetoRel.h"

#include "SVGPathSegLineto.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPathSegLinetoRelTableValues[] =
{
    { "x", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegLinetoRelX), (intptr_t)setJSSVGPathSegLinetoRelX, NoIntrinsic },
    { "y", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegLinetoRelY), (intptr_t)setJSSVGPathSegLinetoRelY, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegLinetoRelConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegLinetoRelTable = { 9, 7, JSSVGPathSegLinetoRelTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPathSegLinetoRelConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegLinetoRelConstructorTable = { 1, 0, JSSVGPathSegLinetoRelConstructorTableValues, 0 };
const ClassInfo JSSVGPathSegLinetoRelConstructor::s_info = { "SVGPathSegLinetoRelConstructor", &Base::s_info, &JSSVGPathSegLinetoRelConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPathSegLinetoRelConstructor) };

JSSVGPathSegLinetoRelConstructor::JSSVGPathSegLinetoRelConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPathSegLinetoRelConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGPathSegLinetoRelPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGPathSegLinetoRelConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSegLinetoRelConstructor, JSDOMWrapper>(exec, &JSSVGPathSegLinetoRelConstructorTable, jsCast<JSSVGPathSegLinetoRelConstructor*>(cell), propertyName, slot);
}

bool JSSVGPathSegLinetoRelConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathSegLinetoRelConstructor, JSDOMWrapper>(exec, &JSSVGPathSegLinetoRelConstructorTable, jsCast<JSSVGPathSegLinetoRelConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegLinetoRelPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegLinetoRelPrototypeTable = { 1, 0, JSSVGPathSegLinetoRelPrototypeTableValues, 0 };
const ClassInfo JSSVGPathSegLinetoRelPrototype::s_info = { "SVGPathSegLinetoRelPrototype", &Base::s_info, &JSSVGPathSegLinetoRelPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPathSegLinetoRelPrototype) };

JSObject* JSSVGPathSegLinetoRelPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathSegLinetoRel>(exec, globalObject);
}

const ClassInfo JSSVGPathSegLinetoRel::s_info = { "SVGPathSegLinetoRel", &Base::s_info, &JSSVGPathSegLinetoRelTable, 0 , CREATE_METHOD_TABLE(JSSVGPathSegLinetoRel) };

JSSVGPathSegLinetoRel::JSSVGPathSegLinetoRel(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPathSegLinetoRel> impl)
    : JSSVGPathSeg(structure, globalObject, impl)
{
}

void JSSVGPathSegLinetoRel::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPathSegLinetoRel::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPathSegLinetoRelPrototype::create(exec->vm(), globalObject, JSSVGPathSegLinetoRelPrototype::createStructure(exec->vm(), globalObject, JSSVGPathSegPrototype::self(exec, globalObject)));
}

bool JSSVGPathSegLinetoRel::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPathSegLinetoRel* thisObject = jsCast<JSSVGPathSegLinetoRel*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPathSegLinetoRel, Base>(exec, &JSSVGPathSegLinetoRelTable, thisObject, propertyName, slot);
}

bool JSSVGPathSegLinetoRel::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPathSegLinetoRel* thisObject = jsCast<JSSVGPathSegLinetoRel*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPathSegLinetoRel, Base>(exec, &JSSVGPathSegLinetoRelTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPathSegLinetoRelX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegLinetoRel* castedThis = jsCast<JSSVGPathSegLinetoRel*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegLinetoRel* impl = static_cast<SVGPathSegLinetoRel*>(castedThis->impl());
    JSValue result = jsNumber(impl->x());
    return result;
}


JSValue jsSVGPathSegLinetoRelY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegLinetoRel* castedThis = jsCast<JSSVGPathSegLinetoRel*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathSegLinetoRel* impl = static_cast<SVGPathSegLinetoRel*>(castedThis->impl());
    JSValue result = jsNumber(impl->y());
    return result;
}


JSValue jsSVGPathSegLinetoRelConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegLinetoRel* domObject = jsCast<JSSVGPathSegLinetoRel*>(asObject(slotBase));
    return JSSVGPathSegLinetoRel::getConstructor(exec, domObject->globalObject());
}

void JSSVGPathSegLinetoRel::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGPathSegLinetoRel* thisObject = jsCast<JSSVGPathSegLinetoRel*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGPathSegLinetoRel, Base>(exec, propertyName, value, &JSSVGPathSegLinetoRelTable, thisObject, slot);
}

void setJSSVGPathSegLinetoRelX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegLinetoRel* castedThis = jsCast<JSSVGPathSegLinetoRel*>(thisObject);
    SVGPathSegLinetoRel* impl = static_cast<SVGPathSegLinetoRel*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setX(nativeValue);
}


void setJSSVGPathSegLinetoRelY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathSegLinetoRel* castedThis = jsCast<JSSVGPathSegLinetoRel*>(thisObject);
    SVGPathSegLinetoRel* impl = static_cast<SVGPathSegLinetoRel*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setY(nativeValue);
}


JSValue JSSVGPathSegLinetoRel::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegLinetoRelConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
